/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.plugin;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenVerifier;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.MemoryDataStoreFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.zip.ZipFile;
import javax.net.ssl.HostnameVerifier;
import jdk.security.jarsigner.JarSigner;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.jarsigner.JarSignerUtil;

@Mojo(name="jarsign", defaultPhase=LifecyclePhase.PACKAGE)
public class JarSign
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="input-jar")
    private File inputJar;
    @Parameter(property="output-signed-jar")
    private File outputSignedJar;
    @Parameter(defaultValue="${project.build.directory}/signingCert.pem", property="output-signing-cert", required=true)
    private File outputSigningCert;
    @Parameter(defaultValue="sigstore", property="signer-name", required=true)
    private String signerName;
    @Parameter(defaultValue="EC", property="signing-algorithm", required=true)
    private String signingAlgorithm;
    @Parameter(defaultValue="secp256r1", property="signing-algorithm-spec", required=true)
    private String signingAlgorithmSpec;
    @Parameter(defaultValue="true", property="ssl-verification", required=true)
    private boolean sslVerfication;
    @Parameter(defaultValue="https://fulcio.sigstore.dev", property="fulcio-instance-url", required=true)
    private URL fulcioInstanceURL;
    @Parameter(defaultValue="false", property="oidc-device-code", required=true)
    private boolean oidcDeviceCodeFlow;
    @Parameter(defaultValue="sigstore", property="oidc-client-id", required=true)
    private String oidcClientID;
    @Parameter(defaultValue="https://oauth2.sigstore.dev/auth/auth", property="oidc-auth-url", required=true)
    private URL oidcAuthURL;
    @Parameter(defaultValue="https://oauth2.sigstore.dev/auth/token", property="oidc-token-url", required=true)
    private URL oidcTokenURL;
    @Parameter(defaultValue="https://oauth2.sigstore.dev/auth/device/code", property="oidc-device-code-url", required=true)
    private URL oidcDeviceCodeURL;
    @Parameter(defaultValue="https://rekor.sigstore.dev", property="rekor-instance-url", required=true)
    private URL rekorInstanceURL;
    @Parameter(property="email-address")
    private String emailAddress;
    @Parameter(defaultValue="https://rekor.sigstore.dev/api/v1/timestamp", property="tsa-url", required=true)
    private URL tsaURL;

    public void execute() throws MojoExecutionException {
        KeyPair keypair = this.generateKeyPair(this.signingAlgorithm, this.signingAlgorithmSpec);
        String rawIdToken = this.getIDToken(this.emailAddress);
        String signedEmail = this.signEmailAddress(this.emailAddress, keypair.getPrivate());
        CertPath certs = this.getSigningCert(signedEmail, keypair.getPublic(), rawIdToken);
        byte[] signedJarBytes = this.signJarFile(keypair.getPrivate(), certs);
        this.writeSigningCertToFile(certs, this.outputSigningCert);
        this.submitToRekor(signedJarBytes);
    }

    public KeyPair generateKeyPair(String signingAlgorithm, String signingAlgorithmSpec) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("generating keypair using %s with %s parameters", signingAlgorithm, signingAlgorithmSpec));
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(signingAlgorithm);
            ECGenParameterSpec aps = null;
            switch (signingAlgorithm) {
                case "EC": {
                    aps = new ECGenParameterSpec(signingAlgorithmSpec);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("unable to create signing algorithm spec for signing algorithm %s", signingAlgorithm));
                }
            }
            kpg.initialize(aps, new SecureRandom());
            return kpg.generateKeyPair();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating keypair:", e);
        }
    }

    public String signEmailAddress(String emailAddress, PrivateKey privKey) throws MojoExecutionException {
        try {
            if (privKey == null) {
                throw new IllegalArgumentException("private key must be specified");
            }
            if (emailAddress == null) {
                throw new IllegalArgumentException("email address must not be null");
            }
            EmailValidator ev = EmailValidator.getInstance();
            if (!ev.isValid(emailAddress)) {
                throw new IllegalArgumentException(String.format("email address specified '%s' is invalid", emailAddress));
            }
            this.getLog().info((CharSequence)String.format("signing email address '%s' as proof of possession of private key", emailAddress));
            Signature sig = null;
            switch (privKey.getAlgorithm()) {
                case "EC": {
                    sig = Signature.getInstance("SHA256withECDSA");
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException(String.format("unable to generate signature for signing algorithm %s", this.signingAlgorithm));
                }
            }
            sig.initSign(privKey);
            sig.update(emailAddress.getBytes());
            return Base64.getEncoder().encodeToString(sig.sign());
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Error signing '%s': %s", emailAddress, e.getMessage()), e);
        }
    }

    public HttpTransport getHttpTransport() {
        HttpClientBuilder hcb = ApacheHttpTransport.newDefaultHttpClientBuilder();
        if (!this.sslVerfication) {
            hcb = hcb.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        return new ApacheHttpTransport((HttpClient)hcb.build());
    }

    public String getIDToken(String expectedEmailAddress) throws MojoExecutionException {
        try {
            String idTokenString;
            IdToken parsedIdToken;
            IdTokenVerifier idTokenVerifier;
            GsonFactory jsonFactory = new GsonFactory();
            HttpTransport httpTransport = this.getHttpTransport();
            MemoryDataStoreFactory memStoreFactory = new MemoryDataStoreFactory();
            String idTokenKey = "id_token";
            if (!this.oidcDeviceCodeFlow) {
                AuthorizationCodeFlow.Builder flowBuilder = new AuthorizationCodeFlow.Builder(BearerToken.authorizationHeaderAccessMethod(), httpTransport, (JsonFactory)jsonFactory, new GenericUrl(this.oidcTokenURL.toString()), (HttpExecuteInterceptor)new ClientParametersAuthentication(this.oidcClientID, null), this.oidcClientID, this.oidcAuthURL.toString()).enablePKCE().setScopes(List.of("openid", "email")).setCredentialCreatedListener(new AuthorizationCodeFlow.CredentialCreatedListener((DataStoreFactory)memStoreFactory){
                    final /* synthetic */ DataStoreFactory val$memStoreFactory;
                    {
                        this.val$memStoreFactory = dataStoreFactory;
                    }

                    public void onCredentialCreated(Credential credential, TokenResponse tokenResponse) throws IOException {
                        this.val$memStoreFactory.getDataStore("user").set("id_token", (Serializable)((Object)tokenResponse.get((Object)"id_token").toString()));
                    }
                });
                AuthorizationCodeInstalledApp app = new AuthorizationCodeInstalledApp(flowBuilder.build(), (VerificationCodeReceiver)new LocalServerReceiver());
                app.authorize("user");
            }
            if (!(idTokenVerifier = new IdTokenVerifier()).verify(parsedIdToken = IdToken.parse((JsonFactory)jsonFactory, (String)(idTokenString = (String)((Object)memStoreFactory.getDataStore("user").get("id_token")))))) {
                throw new InvalidObjectException("id token could not be verified");
            }
            String emailFromIDToken = (String)parsedIdToken.getPayload().get((Object)"email");
            Boolean emailVerified = (Boolean)parsedIdToken.getPayload().get((Object)"email_verified");
            if (expectedEmailAddress != null && !emailFromIDToken.equals(expectedEmailAddress)) {
                throw new InvalidObjectException(String.format("email in ID token '%s' does not match address specified to plugin '%s'", emailFromIDToken, this.emailAddress));
            }
            if (Boolean.FALSE.equals(emailVerified)) {
                throw new InvalidObjectException(String.format("identity provider '%s' reports email address '%s' has not been verified", parsedIdToken.getPayload().getIssuer(), this.emailAddress));
            }
            this.emailAddress = emailFromIDToken;
            return idTokenString;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error signing email address:", e);
        }
    }

    public CertPath getSigningCert(String signedEmail, PublicKey pubKey, String idToken) throws MojoExecutionException {
        try {
            PemReader.Section section;
            HttpTransport httpTransport = this.getHttpTransport();
            String publicKeyB64 = Base64.getEncoder().encodeToString(pubKey.getEncoded());
            HashMap<String, Object> fulcioPostContent = new HashMap<String, Object>();
            HashMap<String, String> publicKeyContent = new HashMap<String, String>();
            publicKeyContent.put("content", publicKeyB64);
            if (pubKey.getAlgorithm().equals("EC")) {
                publicKeyContent.put("algorithm", "ecdsa");
            }
            fulcioPostContent.put("signedEmailAddress", signedEmail);
            fulcioPostContent.put("publicKey", publicKeyContent);
            JsonHttpContent jsonContent = new JsonHttpContent((JsonFactory)new GsonFactory(), fulcioPostContent);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            jsonContent.writeTo((OutputStream)stream);
            GenericUrl fulcioPostUrl = new GenericUrl(this.fulcioInstanceURL + "/api/v1/signingCert");
            HttpRequest req = httpTransport.createRequestFactory().buildPostRequest(fulcioPostUrl, (HttpContent)jsonContent);
            req.getHeaders().set("Accept", (Object)"application/pem-certificate-chain");
            req.getHeaders().set("Authorization", (Object)("Bearer " + idToken));
            this.getLog().info((CharSequence)"requesting signing certificate");
            HttpResponse resp = req.execute();
            if (resp.getStatusCode() != 201) {
                throw new IOException(String.format("bad response from fulcio @ '%s' : %s", fulcioPostUrl, resp.parseAsString()));
            }
            this.getLog().info((CharSequence)"parsing signing certificate");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            PemReader pemReader = new PemReader((Reader)new InputStreamReader(resp.getContent()));
            while ((section = pemReader.readNextSection()) != null) {
                byte[] certBytes = section.getBase64DecodedBytes();
                certList.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes)));
            }
            if (certList.isEmpty()) {
                throw new IOException("no certificates were found in response from Fulcio instance");
            }
            return cf.generateCertPath(certList);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Error obtaining signing certificate from Fulcio @%s:", this.fulcioInstanceURL), e);
        }
    }

    public byte[] signJarFile(PrivateKey privKey, CertPath certs) throws MojoExecutionException {
        try {
            File outputJarFile;
            File jarToSign = this.inputJar != null ? this.inputJar : this.project.getArtifact().getFile();
            this.getLog().info((CharSequence)("signing (with jarsigner) JAR file " + jarToSign.getAbsolutePath()));
            boolean overwrite = true;
            if (this.outputSignedJar != null) {
                outputJarFile = this.outputSignedJar;
                overwrite = false;
            } else {
                outputJarFile = File.createTempFile("signingTemp", ".jar", jarToSign.getParentFile());
            }
            ByteArrayOutputStream memOut = new ByteArrayOutputStream();
            BiConsumer<String, String> progressLogger = (op, entryName) -> this.getLog().debug((CharSequence)String.format("%s %s", op, entryName));
            JarSigner.Builder jsb = new JarSigner.Builder(privKey, certs).digestAlgorithm("SHA-256").signatureAlgorithm("SHA256withECDSA").setProperty("internalsf", "true").signerName(this.signerName).eventHandler(progressLogger);
            if (this.tsaURL.toString().equals("")) {
                jsb = jsb.tsa(this.tsaURL.toURI());
            }
            JarSigner js = jsb.build();
            try (ZipFile in = new ZipFile(jarToSign);
                 FileOutputStream jarOut = new FileOutputStream(outputJarFile);
                 TeeOutputStream tee = new TeeOutputStream((OutputStream)jarOut, (OutputStream)memOut);){
                js.sign(in, (OutputStream)tee);
                if (overwrite) {
                    if (!outputJarFile.renameTo(jarToSign)) {
                        throw new IOException("error overwriting unsigned JAR");
                    }
                    outputJarFile = jarToSign;
                }
                this.getLog().info((CharSequence)("wrote signed JAR to " + outputJarFile.getAbsolutePath()));
                if (!JarSignerUtil.isArchiveSigned((File)outputJarFile)) {
                    throw new VerifyError("JAR signing verification failed: archive does not contain signature");
                }
            }
            return memOut.toByteArray();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error signing JAR file:", e);
        }
    }

    public void writeSigningCertToFile(CertPath certs, File outputSigningCert) throws MojoExecutionException {
        this.getLog().info((CharSequence)("writing signing certificate to " + outputSigningCert.getAbsolutePath()));
        try {
            String lineSeparator = System.getProperty("line.separator");
            Base64.Encoder encoder = Base64.getMimeEncoder(64, lineSeparator.getBytes());
            byte[] rawCrtText = certs.getCertificates().get(0).getEncoded();
            String encodedCertText = new String(encoder.encode(rawCrtText));
            String prettifiedCert = "-----BEGIN CERTIFICATE-----" + lineSeparator + encodedCertText + lineSeparator + "-----END CERTIFICATE-----";
            if (!outputSigningCert.createNewFile()) {
                throw new IOException(String.format("file at %s already exists; will not overwrite", outputSigningCert.getAbsolutePath()));
            }
            try (FileWriter fw = new FileWriter(outputSigningCert);){
                fw.write(prettifiedCert);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Error writing signing certificate to file '%s':", outputSigningCert.getAbsolutePath()), e);
        }
    }

    public URL submitToRekor(byte[] jarBytes) throws MojoExecutionException {
        try {
            HttpTransport httpTransport = this.getHttpTransport();
            String jarB64 = Base64.getEncoder().encodeToString(jarBytes);
            HashMap<String, Object> rekorPostContent = new HashMap<String, Object>();
            HashMap specContent = new HashMap();
            HashMap<String, String> archiveContent = new HashMap<String, String>();
            archiveContent.put("content", jarB64);
            specContent.put("archive", archiveContent);
            rekorPostContent.put("kind", "jar");
            rekorPostContent.put("apiVersion", "0.0.1");
            rekorPostContent.put("spec", specContent);
            JsonHttpContent rekorJsonContent = new JsonHttpContent((JsonFactory)new GsonFactory(), rekorPostContent);
            ByteArrayOutputStream rekorStream = new ByteArrayOutputStream();
            rekorJsonContent.writeTo((OutputStream)rekorStream);
            GenericUrl rekorPostUrl = new GenericUrl(this.rekorInstanceURL + "/api/v1/log/entries");
            HttpRequest rekorReq = httpTransport.createRequestFactory().buildPostRequest(rekorPostUrl, (HttpContent)rekorJsonContent);
            rekorReq.getHeaders().set("Accept", (Object)"application/json");
            rekorReq.getHeaders().set("Content-Type", (Object)"application/json");
            HttpResponse rekorResp = rekorReq.execute();
            if (rekorResp.getStatusCode() != 201) {
                throw new IOException("bad response from rekor: " + rekorResp.parseAsString());
            }
            URL rekorEntryUrl = new URL(this.rekorInstanceURL, rekorResp.getHeaders().getLocation());
            this.getLog().info((CharSequence)String.format("Created entry in transparency log for JAR @ '%s'", rekorEntryUrl));
            return rekorEntryUrl;
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Error in submitting entry to Rekor @ %s:", this.rekorInstanceURL), e);
        }
    }
}

