package com.gun0912.tedpermission;

import android.content.Context;
import android.os.Build;
import android.support.annotation.StringRes;
import com.gun0912.tedpermission.util.ObjectUtils;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.annotations.NonNull;
import java.util.ArrayList;

/**
 * Created by TedPark on 16. 2. 17..
 */
public class TedPermission {

  private TedInstance instance;

  public TedPermission(Context context) {
    instance = new TedInstance(context);
  }

  public TedPermission setPermissionListener(PermissionListener listener) {

    instance.listener = listener;

    return this;
  }


  public TedPermission setPermissions(String... permissions) {

    instance.permissions = permissions;
    return this;
  }

  public TedPermission setRationaleMessage(CharSequence rationaleMessage) {

    instance.rationaleMessage = rationaleMessage;
    return this;
  }


  public TedPermission setRationaleMessage(@StringRes int stringRes) {

    if (stringRes <= 0) {
      throw new IllegalArgumentException("Invalid value for RationaleMessage");
    }

    instance.rationaleMessage = instance.context.getText(stringRes);
    return this;
  }

  public TedPermission setRationaleTitle(CharSequence rationaleMessage) {

    instance.rationaleTitle = rationaleMessage;
    return this;
  }


  public TedPermission setRationaleTitle(@StringRes int stringRes) {

    if (stringRes <= 0) {
      throw new IllegalArgumentException("Invalid value for RationaleTitle");
    }

    instance.rationaleTitle = instance.context.getText(stringRes);
    return this;
  }

  public TedPermission setDeniedMessage(String denyMessage) {

    instance.denyMessage = denyMessage;
    return this;
  }


  public TedPermission setDeniedMessage(@StringRes int stringRes) {

    if (stringRes <= 0) {
      throw new IllegalArgumentException("Invalid value for DeniedMessage");
    }

    instance.denyMessage = instance.context.getText(stringRes);
    return this;
  }

  public TedPermission setDeniedTitle(String denyTitle) {

    instance.denyTitle = denyTitle;
    return this;
  }


  public TedPermission setDeniedTitle(@StringRes int stringRes) {

    if (stringRes <= 0) {
      throw new IllegalArgumentException("Invalid value for DeniedTitle");
    }

    instance.denyTitle = instance.context.getText(stringRes);
    return this;
  }

  public TedPermission setGotoSettingButton(boolean hasSettingBtn) {

    instance.hasSettingBtn = hasSettingBtn;
    return this;
  }


  public TedPermission setGotoSettingButtonText(String rationaleConfirmText) {

    instance.settingButtonText = rationaleConfirmText;
    return this;
  }


  public TedPermission setGotoSettingButtonText(@StringRes int stringRes) {

    if (stringRes <= 0) {
      throw new IllegalArgumentException("Invalid value for setGotoSettingButtonText");
    }

    instance.settingButtonText = instance.context.getString(stringRes);

    return this;
  }


  public TedPermission setRationaleConfirmText(String rationaleConfirmText) {

    instance.rationaleConfirmText = rationaleConfirmText;
    return this;
  }


  public TedPermission setRationaleConfirmText(@StringRes int stringRes) {

    if (stringRes <= 0) {
      throw new IllegalArgumentException("Invalid value for RationaleConfirmText");
    }

    instance.rationaleConfirmText = instance.context.getString(stringRes);

    return this;
  }


  public TedPermission setDeniedCloseButtonText(String deniedCloseButtonText) {

    instance.deniedCloseButtonText = deniedCloseButtonText;
    return this;
  }


  public TedPermission setDeniedCloseButtonText(@StringRes int stringRes) {

    if (stringRes <= 0) {
      throw new IllegalArgumentException("Invalid value for DeniedCloseButtonText");
    }

    instance.deniedCloseButtonText = instance.context.getString(stringRes);

    return this;
  }

  public Observable<TedPermissionResult> request() {
    return Observable.create(new ObservableOnSubscribe<TedPermissionResult>() {
      @Override
      public void subscribe(@NonNull final ObservableEmitter<TedPermissionResult> emitter) throws Exception {

        instance.listener = new PermissionListener() {
          @Override
          public void onPermissionGranted() {
            emitter.onNext(new TedPermissionResult(null));
            emitter.onComplete();
          }

          @Override
          public void onPermissionDenied(ArrayList<String> deniedPermissions) {
            emitter.onNext(new TedPermissionResult(deniedPermissions));
            emitter.onComplete();
          }
        };

        try {
          check();
        } catch (Exception exception) {
          emitter.onError(exception);
        }

      }
    });
  }


  public void check() {

    if (instance.listener == null) {
      throw new IllegalArgumentException("You must setPermissionListener() on TedPermission");
    } else if (ObjectUtils.isEmpty(instance.permissions)) {
      throw new IllegalArgumentException("You must setPermissions() on TedPermission");
    } else if (ObjectUtils.isEmpty(instance.permissions)) {
      throw new IllegalArgumentException("You must set permission");
    }

    if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
      instance.listener.onPermissionGranted();
    } else {
      instance.checkPermissions();
    }

  }


}
