package com.gun0912.tedpermission;

import android.content.Context;
import android.content.Intent;

/**
 * Created by TedPark on 16. 2. 17..
 */
public class TedInstance {

  private static final String TAG = TedInstance.class.getSimpleName();

  static PermissionListener listener;
  public String[] permissions;
  public CharSequence rationaleTitle;
  public CharSequence rationaleMessage;
  public CharSequence denyTitle;
  public CharSequence denyMessage;
  public String settingButtonText;
  public boolean hasSettingBtn = true;

  public String deniedCloseButtonText;
  public String rationaleConfirmText;
  Context context;

  public TedInstance(Context context) {

    this.context = context;

    deniedCloseButtonText = context.getString(R.string.tedpermission_close);
    rationaleConfirmText = context.getString(R.string.tedpermission_confirm);
  }


  public void checkPermissions() {


    Intent intent = new Intent(context, TedPermissionActivity.class);
    intent.putExtra(TedPermissionActivity.EXTRA_PERMISSIONS, permissions);

    intent.putExtra(TedPermissionActivity.EXTRA_RATIONALE_TITLE, rationaleTitle);
    intent.putExtra(TedPermissionActivity.EXTRA_RATIONALE_MESSAGE, rationaleMessage);
    intent.putExtra(TedPermissionActivity.EXTRA_DENY_TITLE, denyTitle);
    intent.putExtra(TedPermissionActivity.EXTRA_DENY_MESSAGE, denyMessage);
    intent.putExtra(TedPermissionActivity.EXTRA_PACKAGE_NAME, context.getPackageName());
    intent.putExtra(TedPermissionActivity.EXTRA_SETTING_BUTTON, hasSettingBtn);
    intent.putExtra(TedPermissionActivity.EXTRA_DENIED_DIALOG_CLOSE_TEXT, deniedCloseButtonText);
    intent.putExtra(TedPermissionActivity.EXTRA_RATIONALE_CONFIRM_TEXT, rationaleConfirmText);
    intent.putExtra(TedPermissionActivity.EXTRA_SETTING_BUTTON_TEXT, settingButtonText);

    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
    context.startActivity(intent);


  }




}
