package com.example.sdk;


import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/**
 * geetest封装的网络工具类，包含post与get请求，自动判断https与http
 */
public class GT3HttpUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String _GET = "GET"; //
    static final String _POST = "POST";// POST
    public static final int DEF_CONN_TIMEOUT = 30000;
    public static final int DEF_READ_TIMEOUT = 30000;
    /**
     * 初始化http请求参数
     *
     * @param url
     * @param method
     * @param headers
     * @return
     * @throws Exception
     */
    private static HttpURLConnection initHttp(String url, String method, final Map<String, String> headers) throws Exception {
        URL _url = new URL(url);
        final HttpURLConnection http = (HttpURLConnection) _url.openConnection();
        // 连接超时
        http.setConnectTimeout(DEF_CONN_TIMEOUT);
        // 读取超时 --服务器响应比较慢，增大时间
        http.setReadTimeout(DEF_READ_TIMEOUT);
        http.setUseCaches(false);
        http.setRequestMethod(method);
        if (null != headers && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                http.setRequestProperty(entry.getKey(), entry.getValue());

            }

        }
        http.connect();
        return http;

    }

    /**
     * 初始化http请求参数
     *
     * @param url
     * @param method
     * @return
     * @throws Exception
     */

    private static HttpsURLConnection initHttps(String url, String method, Map<String, String> headers) throws Exception {
        TrustManager[] tm = {new TrustAllManager()};
        System.setProperty("https.protocols", "TLSv1");
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tm, new java.security.SecureRandom());
        // 从上述SSLContext对象中得到SSLSocketFactory对象
        SSLSocketFactory ssf = sslContext.getSocketFactory();
        URL _url = new URL(url);
        final HttpsURLConnection http = (HttpsURLConnection) _url.openConnection();
        // 设置域名校验
        http.setHostnameVerifier(new GT3HttpUtils().new TrustAnyHostnameVerifier());
        // 连接超时
        http.setConnectTimeout(DEF_CONN_TIMEOUT);
        // 读取超时 --服务器响应比较慢，增大时间
        http.setReadTimeout(DEF_READ_TIMEOUT);
        http.setUseCaches(false);
        http.setRequestMethod(method);
        if (null != headers && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                http.setRequestProperty(entry.getKey(), entry.getValue());

            }

        }
        http.setSSLSocketFactory(ssf);
        http.connect();
        return http;

    }

    /**
     * @return 返回类型:
     * @throws Exception
     * @description 功能描述: get 请求
     */


    public static String get(String url, Map<String, String> params, Map<String, String> headers) throws Exception {
        HttpURLConnection http = null;
        if (isHttps(url)) {
            http = initHttps(initParams(url, params), _GET, headers);

        } else {
            http = initHttp(initParams(url, params), _GET, headers);

        }
        InputStream in = http.getInputStream();
        BufferedReader read = new BufferedReader(new InputStreamReader(in,
                DEFAULT_CHARSET));
        String valueString = null;
        StringBuffer bufferRes = new StringBuffer();
        while ((valueString = read.readLine()) != null) {
            bufferRes.append(valueString);

        }
        in.close();
        int responcode = http.getResponseCode();
        if (http != null) {
            http.disconnect();// 关闭连接

        }
        if (responcode == HttpURLConnection.HTTP_CLIENT_TIMEOUT || responcode == -1) {
            GT3Geetest.GeetestListener geetestListener = new GT3Geetest.GeetestListener() {
                @Override
                public void readContentTimeout() {

                }

                @Override
                public void submitPostDataTimeout() {

                }

                @Override
                public void receiveInvalidParameters() {

                }
            };
            if (geetestListener != null) {
                geetestListener.readContentTimeout();
            }
        }

        return bufferRes.toString();

    }


    public static String get(String url) throws Exception {
        return get(url, null);

    }


    public static String get(String url, Map<String, String> params) throws Exception

    {
        return get(url, params, null);

    }


    public static String post(String url, String params) throws Exception

    {
        HttpURLConnection http = null;
        if (isHttps(url)) {
            http = initHttps(url, _POST, null);
        } else {
            http = initHttp(url, _POST, null);
        }
        OutputStream out = http.getOutputStream();
        out.write(params.getBytes(DEFAULT_CHARSET));
        out.flush();
        out.close();
        InputStream in = http.getInputStream();
        BufferedReader read = new BufferedReader(new InputStreamReader(in,
                DEFAULT_CHARSET));
        String valueString = null;
        StringBuffer bufferRes = new StringBuffer();
        while ((valueString = read.readLine()) != null) {
            bufferRes.append(valueString);

        }
        in.close();
        int responcode = http.getResponseCode();
        if (http != null) {
            http.disconnect();// 关闭连接

        }
        if (responcode == HttpURLConnection.HTTP_CLIENT_TIMEOUT || responcode == -1) {
            GT3Geetest.GeetestListener geetestListener = new GT3Geetest.GeetestListener() {
                @Override
                public void readContentTimeout() {

                }

                @Override
                public void submitPostDataTimeout() {

                }

                @Override
                public void receiveInvalidParameters() {

                }
            };
            if (geetestListener != null) {
                geetestListener.submitPostDataTimeout();
            }
        }
        return bufferRes.toString();

    }

    /**
     * 功能描述: 构造请求参数
     *
     * @return 返回类型:
     */


    public static String initParams(String url, Map<String, String> params) throws Exception

    {
        if (null == params || params.isEmpty()) {
            return url;

        }
        StringBuilder sb = new StringBuilder(url);
        if (url.indexOf("?") == -1) {
            sb.append("?");

        }
        sb.append(map2Url(params));
        return sb.toString();

    }

    /**
     * map构造url
     *
     * @return 返回类型:
     * @throws Exception
     */


    public static String map2Url(Map<String, String> paramToMap)

            throws Exception

    {
        if (null == paramToMap || paramToMap.isEmpty()) {
            return null;

        }
        StringBuffer url = new StringBuffer();
        boolean isfist = true;
        for (Map.Entry<String, String> entry : paramToMap.entrySet()) {
            if (isfist) {
                isfist = false;

            } else {
                url.append("&");

            }
            url.append(entry.getKey()).append("=");
            String value = entry.getValue();

            if (!isEmpty(value)) {
                url.append(URLEncoder.encode(value, DEFAULT_CHARSET));

            }

        }
        return url.toString();

    }
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
    /**
     * 检测是否https
     *
     * @param url
     */


    private static boolean isHttps(String url) {
        return url.startsWith("https");

    }


    /**
     * https 域名校验
     *
     * @return
     */


    public class TrustAnyHostnameVerifier implements HostnameVerifier {

        public boolean verify(String hostname, SSLSession session) {
            return true;// 直接返回true

        }


    }

    /**
     * android的X509验证
     * 信任所有主机，对于任何证书都不做检查
     */
    public static class TrustAllManager implements X509TrustManager {

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1)
                throws CertificateException {
            // TODO Auto-generated method stub
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1)
                throws CertificateException {
            // TODO Auto-generated method stub
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            // TODO Auto-generated method stub
            return null;
        }
    }
}

