package com.example.sdk;

import java.lang.Runnable;
import java.lang.reflect.Field;

import android.animation.AnimatorSet;
import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup.LayoutParams;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.RotateAnimation;
import android.webkit.JavascriptInterface;
import android.telephony.TelephonyManager;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

/**
 * 验证对话框
 */
public class GT3GtDialog extends Dialog {
    private String baseURL = "https://static.geetest.com/static/appweb/app3-index.html";
    private String pathUrl;
    protected static final String ACTIVITY_TAG = "GtDialog";
    private TelephonyManager tm;
    private Context mContext;

    private String product = "embed";
    private String language = "zh-cn";
    private Boolean debug = false;

    private Dialog mDialog = this;
    private int mWidth;
    private int mHeight;
    private int mTimeout = 10000;//默认10000ms
    private GT3GtWebView webView;

    public Boolean isShowing = false;


    //支持"zh-cn","zh-hk","zh-tw","ko-kr","ja-jp","en-us".默认"zh-cn".
    public void setLanguage(String lang) {
        this.language = lang;
    }


    public void stopLoading() {
        webView.stopLoading();
    }

    private String gt, challenge, click, api_server, static_servers, static_servers2, result, slide;

    public GT3GtDialog(Context context, String a1, String a2, String a4, String a5, String a7, String a8) {
        super(context);
        mContext = context;
        tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        gt = a1;
        challenge = a2;
        if (a4.equals("") || a4.length() == 0) {
            api_server = "api.geetest.com";
        } else {
            api_server = a4;
        }
        String a=a5.replace("[","");
        static_servers = a.replace("]","");
        result = a7;
        slide = a8;
        init(context);
    }

    private void init(Context context) {
        webView = new GT3GtWebView(context);

        webView.setGtWebViewListener(new GT3GtWebView.GtWebViewListener() {
            @Override
            public void gtCallReady(Boolean status) {
                if (gtListener != null) {
                    gtListener.gtCallReady(status);
                }
            }

            @Override
            public void gtError() {
                if (gtListener != null) {
                    gtListener.gtError();
                }
            }
        });
        webView.addJavascriptInterface(new JSInterface(), "JSInterface");
        pathUrl = "?"
                + "&gt=" + gt
                + "&challenge=" + challenge
                + "&lang=" + this.language //支持"zh-cn","zh-hk","zh-tw","ko-kr","ja-jp","en-us".默认"zh-cn"
                + "&title=" + "" //验证标题，不宜过长
                + "&" + result + "=" + slide
                + "&type=" + result
                + "&api_server=" + api_server
                + "&static_servers=" + static_servers
                + "&width=100%"
                + "&timoout=15000";
//        if (result.equals("click")) {
//            pathUrl = "?"
//                    + "&gt=" + gt
//                    + "&challenge=" + challenge
//                    + "&lang=" + this.language //支持"zh-cn","zh-hk","zh-tw","ko-kr","ja-jp","en-us".默认"zh-cn"
//                    + "&title=" + "" //验证标题，不宜过长
//                    + "&click=" + click
//                    + "&type=" + result
//                    + "&api_server=" + api_server
//                    + "&static_servers=" + static_servers + "," + static_servers2;
//        } else if (result.equals("slide")) {
//            pathUrl = "?"
//                    + "&gt=" + gt
//                    + "&challenge=" + challenge
//                    + "&lang=" + this.language //支持"zh-cn","zh-hk","zh-tw","ko-kr","ja-jp","en-us".默认"zh-cn"
//                    + "&title=" + ""//验证标题，不宜过长
//                    + "&slide=" + slide
//                    + "&type=" + result
//                    + "&api_server=" + api_server
//                    + "&static_servers=" + static_servers + "," + static_servers2;
//        }
        mWidth = getDeviceWidth();
        mHeight = getDeviceHeight();
        String gt_mobile_req_url = baseURL + pathUrl;
        Log.i("GtDialog", "url: " + gt_mobile_req_url);
        webView.loadUrl(gt_mobile_req_url);
        webView.buildLayer();
    }

    @Override
    public boolean isShowing() {
        return super.isShowing();
    }

    private float getDeviceScale() {
        return getContext().getResources().getDisplayMetrics().density;
    }

    public int getDeviceWidth() {
        int height = GT3DimenTool.getHeightPx(getContext());
        int width = GT3DimenTool.getWidthPx(getContext());
        float scale = getDeviceScale();

        final int WIDTH = 290;

        if (height < width) {
            width = height * 3 / 4;
        }
        width = width * 4 / 5;
        if ((int) (width / scale + 0.5f) < WIDTH) {
            width = (int) ((WIDTH - 0.5f) * scale);
        }
        return width;
    }

    public int getDeviceHeight() {
        int height = GT3DimenTool.getHeightPx(getContext());
        int width = GT3DimenTool.getWidthPx(getContext());
        float scale = getContext().getResources().getDisplayMetrics().density;

        final int HEIGHT = 500;

        return (int) (HEIGHT * scale);
    }


    public interface GtListener {
        //通知native验证已准备完毕
        void gtCallReady(Boolean status); // true准备完成/false未准备完成

        //通知native关闭验证
        void gtCallClose();

        //通知javascript发生严重错误
        void gtError();

        //通知native验证结果，并准备二次验证
        void gtResult(boolean success, String result);
    }

    private GtListener gtListener;

    public void setGtListener(GtListener listener) {
        gtListener = listener;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        setContentView(webView);

        final LayoutParams layoutParams = webView.getLayoutParams();

        layoutParams.width = mWidth;
        layoutParams.height = LayoutParams.WRAP_CONTENT;
        webView.setLayoutParams(layoutParams);
    }


    @Override
    public void show() {
        isShowing = true;
        if (((Activity) mContext) != null && !((Activity) mContext).isFinishing()) {
            super.show();
        }

    }

    @Override
    public void dismiss() {
        isShowing = false;
        webView.stopLoading();
        webView.removeJavascriptInterface("JSInterface");
        webView.removeAllViews();
        webView.destroy();
        if (((Activity) mContext) != null && !((Activity) mContext).isFinishing()) {
            super.dismiss();
        }
    }

    public void shakeDialog() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat(webView, "translationX", 0f, 2f, 4f, 2f, 0f, -2f, -4f, -2f, 0f, 2f, 4f, 2f, 0f, -2f, -4f, -2f, 0f);

        objectAnimator.setDuration(500);
        objectAnimator.start();
    }

    public class JSInterface {

        @JavascriptInterface
        public void gtCallBack(String code, String result, final String message) {
            final int fCode;
            final String fResult = result;
            final String fMessage = message;
            try {
                fCode = Integer.parseInt(code);
                ((Activity) mContext).runOnUiThread(new Runnable() {
                    @Override
                    public void run() {

                        if (fCode == 1) {
                            dismiss();

                            if (gtListener != null) {
                                gtListener.gtResult(true, fResult);
                            }

                        } else {
                            if (gtListener != null) {
                                gtListener.gtResult(false, fResult);
                            }
                        }
                    }
                });
            } catch (NumberFormatException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }

        @JavascriptInterface
        public void gtClose() {
            ((Activity) mContext).runOnUiThread(new Runnable() {

                @Override
                public void run() {

                    dismiss();

                }
            });
            if (gtListener != null) {
                gtListener.gtCallClose();
            }
        }

        @JavascriptInterface
        public void gtReady() {

            ((Activity) mContext).runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    mDialog.show();

                }
            });

            if (gtListener != null) {
                gtListener.gtCallReady(true);
            }
        }

        @JavascriptInterface
        public void gtError() {
            ((Activity) mContext).runOnUiThread(new Runnable() {

                @Override
                public void run() {

                    dismiss();

                }
            });
            if (gtListener != null) {
                gtListener.gtError();
            }
        }

    }

}
