package com.example.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

/**
 * 根据状态自动改变的view
 */
public class GT3GeetestView extends View {
    //默认的灰色paint
    private Paint paint;
    //呼吸状态外环的paint
    private Paint mpaint;
    //扫描外环的paint
    private Paint mmpaint;
    //颜色加深的paint
    private Paint apaint;
    //呼吸状态内部的paint
    private Paint tpaint;
    //陀螺仪指示的paint
    private Paint spaint;
    //扫描上面点的paint
    private Paint dpaint;
    //扫描的paint
    private Paint hpaint;
    //成功加载的paint
    private Paint upaint;
    private Paint uupaint;
    //失败加载的paint
    private Paint fpaint;
    private float angle;
    private Path path;

    public GT3GeetestView(Context context) {
        super(context);
        initPaint(context);
    }

    public GT3GeetestView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initPaint(context);
    }

    public GT3GeetestView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initPaint(context);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        EventBus.getDefault().register(this);


    }

    private int externalRadius;
    private Context context2;

    private void initPaint(Context context) {
        context2= context;

    }

    @SuppressLint("DrawAllocation")
    @Override
    protected void onDraw(Canvas canvas) {
        int internalRadius = GT3DensityUtil.dip2px(context2, new Gt3GeetestViewPath().getInternalRadius());
        externalRadius =GT3DensityUtil.dip2px(context2, new Gt3GeetestViewPath().getExternalRadius());
        int breatheRadius = GT3DensityUtil.dip2px(context2, new Gt3GeetestViewPath().getBreatheRadius());
        int waitRadius = GT3DensityUtil.dip2px(context2, new Gt3GeetestViewPath().getWaitRadius());
        int successRadius = GT3DensityUtil.dip2px(context2, new Gt3GeetestViewPath().getSuccessRadius());
        int failRadius = GT3DensityUtil.dip2px(context2, new Gt3GeetestViewPath().getFailRadius());
        int failLine = GT3DensityUtil.dip2px(context2, new Gt3GeetestViewPath().getFailLine());
        path = new Path();
        paint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        paint.setAntiAlias(true);
        paint.setColor(new GT3ViewColor().getNormalColor());
        paint.setStrokeWidth(1);
        paint.setStyle(Paint.Style.FILL);

        fpaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        fpaint.setAntiAlias(true);
        fpaint.setColor(new GT3ViewColor().getFaliColor());
        fpaint.setStrokeWidth(1);
        fpaint.setStyle(Paint.Style.FILL);

        mpaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        mpaint.setAntiAlias(true);
        mpaint.setColor(new GT3ViewColor().getAddColor());
        mpaint.setStrokeWidth(GT3DensityUtil.dip2px(context2,1));
        mpaint.setStyle(Paint.Style.STROKE);

        mmpaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        mmpaint.setAntiAlias(true);
        mmpaint.setColor(new GT3ViewColor().getAddColor());
        mmpaint.setStrokeWidth(GT3DensityUtil.dip2px(context2,2));
        mmpaint.setStyle(Paint.Style.STROKE);

        apaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        apaint.setAntiAlias(true);
        apaint.setColor(new GT3ViewColor().getAddColor());
        apaint.setStrokeWidth(1);
        apaint.setStyle(Paint.Style.FILL);

        tpaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        tpaint.setAntiAlias(true);
        tpaint.setColor(new GT3ViewColor().getAddColor());
        tpaint.setStrokeWidth(1);
        tpaint.setStyle(Paint.Style.FILL);
        tpaint.setAlpha(25);

        hpaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        hpaint.setAntiAlias(true);
        hpaint.setColor(new GT3ViewColor().getScanningColor());
        hpaint.setStrokeWidth(GT3DensityUtil.dip2px(context2,2));
        hpaint.setStyle(Paint.Style.FILL);

        spaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        spaint.setAntiAlias(true);
        spaint.setColor(new GT3ViewColor().getAddColor());
        spaint.setStrokeWidth(GT3DensityUtil.dip2px(context2,1));
        spaint.setStyle(Paint.Style.FILL);
        spaint.setAlpha(50);

        dpaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        dpaint.setAntiAlias(true);
        dpaint.setColor(new GT3ViewColor().getWaitColor());
        dpaint.setStrokeWidth(GT3DensityUtil.dip2px(context2,2));
        dpaint.setStyle(Paint.Style.FILL);

        upaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        upaint.setAntiAlias(true);
        upaint.setColor(new GT3ViewColor().getSuccessColor());
        upaint.setStrokeWidth(GT3DensityUtil.dip2px(context2,2));
        upaint.setStyle(Paint.Style.STROKE);

        uupaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        uupaint.setAntiAlias(true);
        uupaint.setColor(new GT3ViewColor().getSuccessColor());
        uupaint.setStrokeWidth(GT3DensityUtil.dip2px(context2,3));
        uupaint.setStyle(Paint.Style.STROKE);
        postInvalidateDelayed(50);
        super.onDraw(canvas);
        //默认状态

        if (onnormal) {
            canvas.drawCircle(getWidth() / 2, getHeight() / 2, internalRadius, paint);
        }
        //颜色加深的默认状态
        if (onstart) {
            canvas.drawCircle(getWidth() / 2, getHeight() / 2, internalRadius, apaint);
        }
        //呼吸状态
        double radio;
        if (ondown) {
            radio = breatheRadius + (externalRadius - breatheRadius) * Math.abs(Math.sin(x));
            canvas.drawCircle(getWidth() / 2, getHeight() / 2, internalRadius, apaint);
            canvas.drawCircle(getWidth() / 2, getHeight() / 2, (float) radio, mpaint);
            canvas.drawCircle(getWidth() / 2, getHeight() / 2, (float) radio, tpaint);
            x += 0.1;
        }
        //陀螺仪指示状态
        if (oncircle) {
            canvas.drawCircle(getWidth() / 2, getHeight() / 2, internalRadius, apaint);
            canvas.drawCircle(getWidth() / 2, getHeight() / 2, externalRadius, mpaint);
            canvas.drawCircle(getWidth() / 2, getHeight() / 2, externalRadius, tpaint);
            canvas.translate(getWidth() / 2, getHeight() / 2);
            @SuppressLint("DrawAllocation") RectF rect = new RectF(-externalRadius, -externalRadius, externalRadius, externalRadius);
            canvas.drawArc(rect, angle - 90, 45, true, spaint);
        }
        //扫描状态
        if (onscanning) {
            if (f > 0) {
                canvas.drawCircle(getWidth() / 2, getHeight() / 2, internalRadius, apaint);
                canvas.drawCircle(getWidth() / 2, getHeight() / 2, f, mpaint);
            } else if (a < internalRadius) {
                canvas.drawCircle(getWidth() / 2, getHeight() / 2, internalRadius, apaint);
            } else if (a >= internalRadius && a <= externalRadius) {
                canvas.drawCircle(getWidth() / 2, getHeight() / 2, internalRadius, apaint);
                canvas.drawCircle(getWidth() / 2, getHeight() / 2, a, mpaint);
            } else {
                radio = 0 + externalRadius*2 * Math.abs(Math.sin(y));
                canvas.drawCircle(getWidth() / 2, getHeight() / 2, internalRadius, apaint);
                canvas.drawCircle(getWidth() / 2, getHeight() / 2, externalRadius, mmpaint);
                canvas.drawPoint((float) getWidth() / 2, (float) (getHeight() / 2 - externalRadius), dpaint);
                canvas.drawPoint((float) (getWidth() / 2 - externalRadius), (float) (getHeight() / 2), dpaint);
                canvas.drawPoint((float) getWidth() / 2 + externalRadius, (float) (getHeight() / 2), dpaint);
                canvas.drawPoint((float) getWidth() / 2, (float) (getHeight() / 2 + externalRadius), dpaint);
                if (radio <= externalRadius) {
                    canvas.drawLine((float) (getWidth() / 2 - Math.sqrt(Math.pow(externalRadius, 2) - Math.pow(externalRadius - radio, 2))), (float) (getHeight() / 2 - (externalRadius - radio)), (float) (getWidth() / 2 + Math.sqrt(Math.pow(externalRadius, 2) - Math.pow(externalRadius - radio, 2))), (float) (getHeight() / 2 - (externalRadius - radio)), hpaint);
                } else {
                    canvas.drawLine((float) (getWidth() / 2 - Math.sqrt(Math.pow(externalRadius, 2) - Math.pow(radio - externalRadius, 2))), (float) (getHeight() / 2 - (externalRadius - radio)), (float) (getWidth() / 2 + Math.sqrt(Math.pow(externalRadius, 2) - Math.pow(radio - externalRadius, 2))), (float) (getHeight() / 2 - (externalRadius - radio)), hpaint);
                }
                y += 0.1;
            }
            a += 3;
            f -= 5;

        }
        //验证码加载完成状态
        if (onfinish) {
            if (f >= 0) {
                canvas.drawCircle(getWidth() / 2, getHeight() / 2, f, mpaint);
                canvas.drawCircle(getWidth() / 2, getHeight() / 2, internalRadius, apaint);
            } else {
                canvas.drawCircle(getWidth() / 2, getHeight() / 2, waitRadius, paint);
                canvas.drawCircle(getWidth() / 2 - internalRadius, getHeight() / 2, waitRadius, paint);
                canvas.drawCircle(getWidth() / 2 + internalRadius, getHeight() / 2, waitRadius, paint);
            }
            f -= 10;
        }
        //验证成功状态
        if (onsuccess) {
            if (b <= 300) {
                canvas.translate(getWidth() / 2, getHeight() / 2);
                @SuppressLint("DrawAllocation") RectF rect = new RectF(-successRadius, -successRadius, successRadius, successRadius);
                canvas.drawArc(rect, 300, -b, false, upaint);
            } else {
                path.moveTo(getWidth() / 2 -  13* successRadius /22, getHeight() / 2- 2* successRadius /22);
                path.lineTo(getWidth() / 2 -  2* successRadius /22, getHeight() / 2 +  10* successRadius /22);
                path.lineTo(getWidth() / 2 + 26* successRadius /22, getHeight() / 2 - 16* successRadius /22);
                canvas.drawPath(path, uupaint);
                canvas.translate(getWidth() / 2, getHeight() / 2);
                @SuppressLint("DrawAllocation") RectF rect = new RectF(-successRadius, -successRadius, successRadius, successRadius);
                canvas.drawArc(rect, 300, -300, false, upaint);
            }
            b += 30;
        }
        //验证失败状态
        if (onfail) {
            canvas.drawCircle(getWidth() / 2, getHeight() / 2, failRadius, fpaint);
            canvas.drawLine(getWidth() / 2 - failLine, getHeight() / 2, getWidth() / 2 + failLine, getHeight() / 2, dpaint);
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void viewChange(GT3ViewChange viewChange) {
        angle = viewChange.getC();
        postInvalidate();
    }

    private boolean ondown = false, oncircle = false, onscanning = false, onfinish = false, onsuccess = false, onstart = false, onnormal = false, onfail = false;
    private double x;
    private double y;
    private int a;
    private int b;
    private int f;

    public void normal() {
        onnormal = true;
        onfail = false;
        onstart = false;
        ondown = false;
        oncircle = false;
        onscanning = false;
        onfinish = false;
        onsuccess = false;
    }

    public void start() {
        onstart = true;
        ondown = false;
        oncircle = false;
        onscanning = false;
        onfinish = false;
        onsuccess = false;
        onnormal = false;
        onfail = false;
    }

    public void startdown() {
        x = 0;
        ondown = true;
        oncircle = false;
        onscanning = false;
        onfinish = false;
        onsuccess = false;
        onstart = false;
        onnormal = false;
        onfail = false;

    }

    public void startcircle() {
        oncircle = true;
        ondown = false;
        onscanning = false;
        onfinish = false;
        onsuccess = false;
        onstart = false;
        onnormal = false;
        onfail = false;
    }

    public void startscanning() {
        y = 0;
        a = 0;
        f = externalRadius;
        oncircle = false;
        ondown = false;
        onscanning = true;
        onstart = false;
        onfinish = false;
        onsuccess = false;
        onnormal = false;
        onfail = false;
    }

    public void startfinish() {
        oncircle = false;
        ondown = false;
        onscanning = false;
        onstart = false;
        onfinish = true;
        onsuccess = false;
        onnormal = false;
        onfail = false;
        f = externalRadius;
    }

    public void startsuccess() {
        b = 0;
        oncircle = false;
        ondown = false;
        onscanning = false;
        onstart = false;
        onfinish = false;
        onnormal = false;
        onfail = false;
        onsuccess = true;
    }


    public void onfail() {
        oncircle = false;
        ondown = false;
        onscanning = false;
        onstart = false;
        onfinish = false;
        onnormal = false;
        onfail = true;
        onsuccess = false;
    }


    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

}
