package com.example.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * geetest的linearlayout的自定义viewGroup类
 */
public class GT3GeetestButton extends LinearLayout implements SensorEventListener {


    private GT3GeetestView geetestView;

    private TextView tvTestGeetest;
    private SensorManager sensorManager;

    private ImageView ivGeetestLogo;
    private Context context;
    // 将纳秒转化为秒
    private static final float NS2S = 1.0f / 1000000000.0f;
    private float timestamp;
    private final float[] angle = new float[3];
    private boolean sensorAvailable = false;

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        EventBus.getDefault().register(this);
    }

    public GT3GeetestButton(Context context) {
        super(context);
        init(context);
    }

    public GT3GeetestButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }


    public GT3GeetestButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(final Context context) {
        this.context = context;
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = inflater.inflate(R.layout.ll_geetest_sdk_view, this);
        geetestView = (GT3GeetestView) view.findViewById(R.id.geetest_view);
        tvTestGeetest = (TextView) view.findViewById(R.id.tv_test_geetest);
        ivGeetestLogo = (ImageView) view.findViewById(R.id.iv_geetest_logo);
        ivGeetestLogo.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                Uri uri = Uri.parse("http://www.geetest.com/first_page");
                Intent intent = new Intent(Intent.ACTION_VIEW, uri);
                context.startActivity(intent);
            }
        });

        sensorManager = (SensorManager) context.getSystemService(Context.SENSOR_SERVICE);
        List<Sensor> sensorList = sensorManager.getSensorList(Sensor.TYPE_ALL);
        for (int i = 0; i < sensorList.size(); i++) {

            if (sensorList.get(i).getType() == Sensor.TYPE_GYROSCOPE) {
                sensorAvailable = true;
            }
        }
        //noinspection StatementWithEmptyBody
        if (sensorAvailable) {
        } else {
        }

        geetestView.normal();
        //noinspection deprecation
        setBackground(getResources().getDrawable(R.drawable.lin_bg_shape));
    }

    private boolean downTime = false;

    /**
     * 网络是否可用
     */
    private static boolean isNetworkAvailable(Context context) {
        ConnectivityManager mgr = (ConnectivityManager) context
                .getSystemService(Context.CONNECTIVITY_SERVICE);
        @SuppressWarnings("deprecation") NetworkInfo[] info = mgr.getAllNetworkInfo();
        if (info != null) {
            for (NetworkInfo anInfo : info) {
                if (anInfo.getState() == NetworkInfo.State.CONNECTED) {
                    return true;
                }
            }
        }
        return false;
    }

    @SuppressLint("DrawAllocation")
    @Override
    protected void onDraw(Canvas canvas) {
        int downTimePath = GT3DensityUtil.dip2px(context, new Gt3GeetestViewPath().getDownTimePath());
        postInvalidateDelayed(50);
        super.onDraw(canvas);
        if (!isNetworkAvailable(context)) {
            gogogogo = false;
            geetestView.onfail();
            //noinspection deprecation
            setBackground(getResources().getDrawable(R.drawable.lin_file_shape));
            if (islogo) {
                ivGeetestLogo.setImageResource(R.mipmap.logored);
            }
            tvTestGeetest.setText(new Gt3GeetestTestMsg().getNetText());
            tvTestGeetest.setTextColor(0xffde391f);
            tvTestGeetest.setAlpha(1);
        } else {
            gogogogo = true;
        }
        //宕机右上角的角标
        if (downTime) {
            @SuppressLint("DrawAllocation") Path path = new Path();
            @SuppressLint("DrawAllocation") Paint paint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
            paint.setAntiAlias(true);
            paint.setColor(new GT3ViewColor().getDownColor());
            paint.setStrokeWidth(1);
            paint.setStyle(Paint.Style.FILL);
            path.moveTo(getWidth() - downTimePath, 0);
            path.lineTo(getWidth(), 0);
            path.lineTo(getWidth(), downTimePath);
            path.close();
            canvas.drawPath(path, paint);
        }

    }

    private int n;
    private final List<String> list = new ArrayList<>();
    private boolean canTouch = true;

    private boolean canDownTime = false;
    private boolean islogo;
    private boolean candodododo = false;
    private boolean gogogogo = true;

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN:
                if (Gt3GeetestTestMsg.isCandotouch()) {
                    if (gogogogo) {
                        if (candodododo) {
                            if (ajaxisfinish) {
                                if (!canDownTime) {
                                    if (canTouch) {
                                        GT3GeetestUtils.getInstance(context).canWork(list.toString(), context);
                                        list.clear();
                                    }
                                    if (!canTouch) {
                                        if (sensorAvailable) {
                                            GT3GeetestUtils.getInstance(context).canWork(list.toString(), context);
                                        } else {
                                            GT3GeetestUtils.getInstance(context).canWork("", context);
                                        }
                                        list.clear();
                                    }

                                } else {
                                    GT3GeetestUtils.getInstance(context).startDownTime();

                                }
                            }
                        }
                    }

                }
        }
        return super.onTouchEvent(event);
    }

    @SuppressLint("DefaultLocale")
    @Override
    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == Sensor.TYPE_GYROSCOPE) {
            if (timestamp != 0) {
                if (event.values[2] > 0.15 || event.values[2] < -0.15) {
                    final float dT = (event.timestamp - timestamp) * NS2S;
                    angle[0] += event.values[0] * dT;
                    angle[1] += event.values[1] * dT;
                    angle[2] += event.values[2] * dT;
                    float angleX = (float) Math.toDegrees(angle[0]);
                    float angleY = (float) Math.toDegrees(angle[1]);
                    float angleZ = (float) Math.toDegrees(angle[2]);
                    EventBus.getDefault().post(new GT3ViewChange(angleX, angleY, angleZ));
                    canTouch = true;
                    geetestView.startcircle();
                    list.add(new BigDecimal(dT * 1000).setScale(0, BigDecimal.ROUND_HALF_UP) + "");
                    list.add(new BigDecimal(angleX).setScale(0, BigDecimal.ROUND_HALF_UP) + "");
                    list.add(new BigDecimal(angleY).setScale(0, BigDecimal.ROUND_HALF_UP) + "");
                    list.add(new BigDecimal(angleZ).setScale(0, BigDecimal.ROUND_HALF_UP) + "");
                    n++;
                }
                if (n > 50) {
                    geetestView.startdown();
                    if (sensorAvailable) {
                        sensorManager.unregisterListener(this);
                    }
                    canTouch = false;
                }
            }
            timestamp = event.timestamp;

        }
    }


    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {

    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void test(String a) {
        if (a.equals("startfinish")) {
            geetestView.startfinish();
            //noinspection deprecation
            setBackground(getResources().getDrawable(R.drawable.lin_wait_shape));
            tvTestGeetest.setTextColor(0xff383838);
            tvTestGeetest.setText(new Gt3GeetestTestMsg().getWaitText());
            tvTestGeetest.setAlpha(0.5f);
        }
        if (a.equals("startsuccess")) {
            ajaxisfinish = true;
            geetestView.startsuccess();
            //noinspection deprecation
            setBackground(getResources().getDrawable(R.drawable.lin_success_shape));
            tvTestGeetest.setText(new Gt3GeetestTestMsg().getSuccessText());
            tvTestGeetest.setTextColor(0xff18a452);
            tvTestGeetest.setAlpha(1);
            if (islogo) {
                ivGeetestLogo.setImageResource(R.mipmap.logogreen);
            }
        }
        if (a.equals("startdowntime")) {
            candodododo = true;
            downTime = true;
            canDownTime = true;
        }
        if (a.equals("start")) {
            candodododo = true;
            if (sensorAvailable) {
                geetestView.start();
                downTime = false;
                n = 0;
                //noinspection deprecation
                setBackground(getResources().getDrawable(R.drawable.lin_click_shape));
                if (islogo) {
                    ivGeetestLogo.setImageResource(R.mipmap.logogray);
                }
                tvTestGeetest.setText(new Gt3GeetestTestMsg().getNormalText());
                tvTestGeetest.setTextColor(0xff383838);
                tvTestGeetest.setAlpha(1);
                Sensor gyroscopeSensor = sensorManager.getDefaultSensor(Sensor.TYPE_GYROSCOPE);
                sensorManager.registerListener(this, gyroscopeSensor,
                        SensorManager.SENSOR_DELAY_UI);
            } else {
                downTime = false;
                //noinspection deprecation
                setBackground(getResources().getDrawable(R.drawable.lin_click_shape));
                if (islogo) {
                    ivGeetestLogo.setImageResource(R.mipmap.logogray);
                }
                tvTestGeetest.setText(new Gt3GeetestTestMsg().getNormalText());
                tvTestGeetest.setTextColor(0xff383838);
                tvTestGeetest.setAlpha(1);
                geetestView.startdown();
            }
        }
        if (a.equals("startscanning")) {
            ajaxisfinish = false;
            if (sensorAvailable) {
                sensorManager.unregisterListener(this);
            }
            downTime = false;
            geetestView.startscanning();
            //noinspection deprecation
            setBackground(getResources().getDrawable(R.drawable.lin_bg_shape));
            if (islogo) {
                ivGeetestLogo.setImageResource(R.mipmap.logogray);
            }
            //noinspection AccessStaticViaInstance
            tvTestGeetest.setText(new Gt3GeetestTestMsg().getJianceText());
            tvTestGeetest.setTextColor(0xff383838);
            tvTestGeetest.setAlpha(1);
        }
        if (a.equals("starterror")) {
            geetestView.onfail();
            //noinspection deprecation
            setBackground(getResources().getDrawable(R.drawable.lin_file_shape));
            if (islogo) {
                ivGeetestLogo.setImageResource(R.mipmap.logored);
            }
            tvTestGeetest.setText(new Gt3GeetestTestMsg().getFailText());
            tvTestGeetest.setTextColor(0xffde391f);
            tvTestGeetest.setAlpha(1);
        }
        if (a.equals("startclose")) {
            geetestView.startdown();
            //noinspection deprecation
            setBackground(getResources().getDrawable(R.drawable.lin_click_shape));
            if (islogo) {
                ivGeetestLogo.setImageResource(R.mipmap.logogray);
            }
            tvTestGeetest.setText(new Gt3GeetestTestMsg().getNormalText());
            tvTestGeetest.setTextColor(0xff383838);
            tvTestGeetest.setAlpha(1);
        }
        if (a.equals("havelogo")) {
            islogo = true;
            ivGeetestLogo.setClickable(true);
        }
        if (a.equals("nologo")) {
            islogo = false;
            ivGeetestLogo.setClickable(false);
        }
        if (a.equals("ajaxisfinish")) {
            ajaxisfinish = true;
        }
        if (a.equals("gt3nonono")) {
            candodododo = false;
        }
    }

    private boolean ajaxisfinish = true;


    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }


}