package com.example.sdk;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class CoverFrameLayout extends FrameLayout {
    private final String TAG = this.getClass().getSimpleName();
    private Context context;

    public CoverFrameLayout(Context context, ViewGroup decorView) {
        super(context);
        this.context = context;
        View firstView = decorView.getChildAt(0);

        View focusView = firstView.findFocus();
        decorView.removeViewAt(0);
        /**
         * 把第一个view加到当前view之下去
         */

        addView(firstView);
        /**
         * 再把当前view加到decorview下面去
         */

        decorView.addView(this, 0);
        if (focusView != null) {
            focusView.requestFocus();
        }

    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {

        switch (ev.getAction()) {
            case MotionEvent.ACTION_UP:
                GT3LifecycleCallBacks.getInstance(context).touchAnyView(ev);


                break;
            case MotionEvent.ACTION_DOWN:
                GT3LifecycleCallBacks.getInstance(context).touchAnyView2(ev);


                break;
        }
        return super.onInterceptTouchEvent(ev);
    }
}
