package com.example.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Looper;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Toast;


import org.greenrobot.eventbus.EventBus;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/**
 * geetest加载的动画工具类
 */
public class GT3GeetestUtils {
    private final GT3GeetestMananger geetestMananger;
    private final Context context;

    public GT3GeetestUtils(Context context) {
        this.context = context;
        geetestMananger = new GT3GeetestMananger();
    }

    private static GT3GeetestUtils gt3SingleLenton;

    public static GT3GeetestUtils getInstance(Context context) {
        if (gt3SingleLenton == null) {
            gt3SingleLenton = new GT3GeetestUtils(context);
        }
        return gt3SingleLenton;
    }

    private GtAppDlgTask mGtAppDlgTask;
    private GttypDlgTask gttypDlgTask;
    private GtphpDlTask gtphpDlTask;
    private GtAppValidateTask mGtAppValidateTask;
    // 创建验证码网络管理器实例
    private final GT3Geetest captcha = new GT3Geetest(
            // 设置获取id，challenge，success的URL，需替换成自己的服务器URL
            new GT3GeetestUrl().getCaptchaURL(),
            // 设置二次验证的URL，需替换成自己的服务器URL
            new GT3GeetestUrl().getValidateURL()
    );

    public void getGeetest() {
        mGtAppDlgTask = new GtAppDlgTask();
        mGtAppDlgTask.execute();
        captcha.setTimeout(5000);
        EventBus.getDefault().post("gt3nonono");
        captcha.setGeetestListener(new GT3Geetest.GeetestListener() {
            @Override
            public void readContentTimeout() {
                mGtAppDlgTask.cancel(true);
                //TODO 获取验证参数超时
                //Looper.prepare() & Looper.loop(): 在当前线程并没有绑定Looper时返回为null, 可以与toastMsg()一同在正式版本移除
                Looper.prepare();
//                    toastMsg("read content time out");
                Looper.loop();
            }

            @Override
            public void submitPostDataTimeout() {
                mGtAppValidateTask.cancel(true);
                //TODO 提交二次验证超时
//                    toastMsg("submit error");

            }

            @Override
            public void receiveInvalidParameters() {
                //TODO 从API接收到无效的JSON参数
//                    toastMsg("Did recieve invalid parameters.");
            }
        });
    }


    private float checkBattery() {
        //通过粘性广播读取电量
        IntentFilter intentFilter = new IntentFilter(Intent.ACTION_BATTERY_CHANGED);
        Intent intentBattery = context.registerReceiver(null, intentFilter);//注意，粘性广播不需要广播接收器
        if (intentBattery != null) {
            //获取当前电量
            int batteryLevel = intentBattery.getIntExtra("level", 0);
            //电量的总刻度
            int batterySum = intentBattery.getIntExtra("scale", 100);
            float rotatio = 100 * (float) batteryLevel / (float) batterySum;
            return rotatio;
        }
        return 0;

    }


    public String getPhoneInfo() {
        StringBuffer mobinfo = new StringBuffer();
        PackageManager packageManager = context.getPackageManager();

        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        int versionCode = packageInfo.versionCode;

        String mtyb = android.os.Build.BRAND == null ? "unknown" : android.os.Build.BRAND;// 手机品牌
        String version = android.os.Build.VERSION.RELEASE == null ? "unknown" : android.os.Build.VERSION.RELEASE;//android

        try {
            mobinfo.append(java.net.URLEncoder.encode(String.valueOf(versionCode), "UTF-8") + "!!");
            mobinfo.append(java.net.URLEncoder.encode(String.valueOf(versionCode), "UTF-8") + "!!");
            mobinfo.append(java.net.URLEncoder.encode(String.valueOf(checkBattery()), "UTF-8") + "!!");
            mobinfo.append("unknown" + "!!");
            mobinfo.append("unknown" + "!!");
            mobinfo.append(java.net.URLEncoder.encode(new GT3DataUtils().networkType(context), "UTF-8") + "!!");
            mobinfo.append(java.net.URLEncoder.encode(Locale.getDefault().getCountry(), "UTF-8") + "!!");
            DisplayMetrics dm = context.getResources().getDisplayMetrics();
            mobinfo.append(dm.widthPixels + "!!");
            mobinfo.append(java.net.URLEncoder.encode(mtyb, "UTF-8") + "!!");
            mobinfo.append("unknown" + "!!");
            mobinfo.append(dm.heightPixels + "!!");
            mobinfo.append(android.os.Build.VERSION.SDK + "!!");

            TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            mobinfo.append(java.net.URLEncoder.encode(tm.getDeviceId(), "UTF-8") + "!!");
            mobinfo.append(java.net.URLEncoder.encode(Locale.getDefault().getLanguage(), "UTF-8") + "!!");
            mobinfo.append("unknown" + "!!");
            mobinfo.append(java.net.URLEncoder.encode(getTotalMemory(), "UTF-8") + "!!");
            mobinfo.append("android" + "!!");
            mobinfo.append(java.net.URLEncoder.encode(version, "UTF-8") + "!!");
            mobinfo.append(java.net.URLEncoder.encode(getMacAddress(context), "UTF-8") + "!!");
            mobinfo.append(getAddress(context) + "!!");
            mobinfo.append("unknown" + "!!");
            mobinfo.append(System.currentTimeMillis());
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return mobinfo.toString();

    }

    @SuppressWarnings("StatementWithEmptyBody")
    private static String getCpuName() {
        try {
            FileReader fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            String[] array = text.split(":\\s+", 2);
            //noinspection StatementWithEmptyBody
            for (String anArray : array) {
            }
            return array[1];
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getMacAddress(Context context) {
        String macAddress = null;
        WifiInfo wifiInfo = getWifiInfo(context);
        if (wifiInfo != null) {
            macAddress = wifiInfo.getMacAddress();
        }
        return macAddress;
    }

    public static String getAddress(Context context) {
        String macAddress = null;
        WifiInfo wifiInfo = getWifiInfo(context);
        if (wifiInfo != null) {
            macAddress = wifiInfo.getSSID();
        }
        return macAddress;
    }

    public static WifiInfo getWifiInfo(Context context) {
        WifiManager wifiManager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        WifiInfo info = null;
        if (null != wifiManager) {
            info = wifiManager.getConnectionInfo();
        }
        return info;
    }

    private String getTotalMemory() {
        String str1 = "/proc/meminfo";// 系统内存信息文件
        String str2;
        String[] arrayOfString;
        long initial_memory = 0;
        try {
            FileReader localFileReader;

            localFileReader = new FileReader(str1);

            BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
            str2 = localBufferedReader.readLine();// 读取meminfo第一行，系统总内存大小

            arrayOfString = str2.split("\\s+");
            //noinspection StatementWithEmptyBody
            for (String num : arrayOfString) {
            }

            initial_memory = Integer.valueOf(arrayOfString[1]) * 1024;// 获得系统总内存，单位是KB，乘以1024转换为Byte
            localBufferedReader.close();

        } catch (IOException ignored) {
        }
        return Formatter.formatFileSize(context, initial_memory);// Byte转换为KB或者MB，内存大小规格化
    }

    private class GtAppDlgTask extends AsyncTask<Void, Void, JSONObject> {

        @Override
        protected JSONObject doInBackground(Void... params) {
            return captcha.checkServer();
        }

        @Override
        protected void onPostExecute(JSONObject parmas) {
            if (parmas != null) {
                // 根据captcha.getSuccess()的返回值 自动推送正常或者离线验证
                if (captcha.getSuccess()) {
                    new GttypDlgTask().execute();
                } else {
                    // TODO 从API_1获得极验服务宕机或不可用通知, 宕机直接通过
                    geetestMananger.startdowntime();

                }

            } else {

            }
        }
    }


    private class GttypDlgTask extends AsyncTask<Void, Void, JSONObject> {

        @Override
        protected JSONObject doInBackground(Void... params) {
            return captcha.gettype2Server();
        }

        @Override
        protected void onPostExecute(JSONObject parmas) {
            if (parmas != null) {
                new GtphpDlTask().execute();
            } else {
            }
        }
    }

    private class GtphpDlTask extends AsyncTask<Void, Void, JSONObject> {

        @Override
        protected JSONObject doInBackground(Void... params) {
            return captcha.getphp2Server();
        }

        @Override
        protected void onPostExecute(JSONObject parmas) {
            if (parmas != null) {
                boolean islogo = captcha.getlogo();
                if (islogo) {
                    geetestMananger.havelogo();
                } else {
                    geetestMananger.nologo();
                }
                geetestMananger.start();
            } else {
            }
        }
    }


    public void startDownTime() {
        new GtdownTask().execute();
    }

    private String downTimeChallenge;

    private class GtdownTask extends AsyncTask<Void, Void, JSONObject> {

        @Override
        protected JSONObject doInBackground(Void... params) {
            return captcha.checkServer();
        }

        @Override
        protected void onPostExecute(JSONObject parmas) {
            downTimeChallenge = captcha.getDownTimeChallenge();
            new GtDownTimeValidateTask().execute();
        }
    }

    private String getTitle;
    private GtppDlgTask gtppDlgTask;
    private Context getContext;


    public void canWork(String angle, Context context) {
        this.getContext = context;
        getTitle = angle;
        gtppDlgTask = new GtppDlgTask();
        gtppDlgTask.execute();
        geetestMananger.startscanning();

    }

    private String gt;
    private String challenge;
    private GttypeDlgTas gttypeDlgTas;

    private class GtppDlgTask extends AsyncTask<Void, Void, JSONObject> {

        @Override
        protected JSONObject doInBackground(Void... params) {
            return captcha.checkRealServer();
        }

        @Override
        protected void onPostExecute(JSONObject parmas) {
            gtListener.gt3FirstResult(parmas);
            if (parmas != null) {
                gt = captcha.getGt();
                challenge = captcha.getChallenge();
                gttypeDlgTas = new GttypeDlgTas();
                gttypeDlgTas.execute();
            }
        }
    }

    private String slide;
    private GtphpDlgTask gtphpDlgTask;

    private class GttypeDlgTas extends AsyncTask<Void, Void, JSONObject> {

        @Override
        protected JSONObject doInBackground(Void... params) {
            return captcha.gettypeServer();
        }

        @Override
        protected void onPostExecute(JSONObject parmas) {
            if (parmas != null) {
//                click = captcha.getClick();
//                slide = captcha.getSlide();
                gtphpDlgTask = new GtphpDlgTask();
                gtphpDlgTask.execute();
            } else {
//                toastLongTimeMsg("get type is wrong");
            }
        }
    }

    private String api_server;
    private String static_servers;

    private class GtphpDlgTask extends AsyncTask<Void, Void, JSONObject> {

        @Override
        protected JSONObject doInBackground(Void... params) {
            return captcha.getphpServer();
        }

        @Override
        protected void onPostExecute(JSONObject parmas) {
            if (parmas != null) {
                api_server = captcha.getApi_server();
                static_servers = captcha.getStatic_servers();
                gtDlgTask = new GtDlgTask();
                gtDlgTask.execute();
            } else {
//                toastLongTimeMsg("get.php is wrong");
            }
        }
    }

    private String result;
    private String validate;
    private GtDlgTask gtDlgTask;

    private class GtDlgTask extends AsyncTask<Void, Void, JSONObject> {

        @Override
        protected JSONObject doInBackground(Void... params) {

            return captcha.getajaxServer(getTitle, getPhoneInfo());
        }

        @Override
        protected void onPostExecute(JSONObject parmas) {
            if (parmas != null) {
                result = captcha.getResult();
                slide = captcha.getSlide();
                if (result.equals("success")) {
                    validate = captcha.getValidate();
                    new GtOneValidateTask().execute();
                } else {
                    openGtTest();
                }

            } else {
//                toastLongTimeMsg("ajax is null");
            }
        }
    }


    private class GtAppValidateTask extends AsyncTask<String, Void, String> {
        @Override
        protected String doInBackground(String... params) {
            try {
                JSONObject res_json = new JSONObject(params[0]);

                Map<String, String> validateParams = new HashMap<>();

                validateParams.put("geetest_challenge", res_json.getString("geetest_challenge"));

                validateParams.put("geetest_validate", res_json.getString("geetest_validate"));

                validateParams.put("geetest_seccode", res_json.getString("geetest_seccode"));
                Map map = gtListener.gt3SecondResult();
                if (map != null) {
                    Set set = map.keySet();

                    for (Iterator iter = set.iterator(); iter.hasNext(); ) {
                        String key = (String) iter.next();
                        String value = (String) map.get(key);
                        validateParams.put(key, value);
                    }
                }
                //TODO 验证通过, 获取二次验证响应, 根据响应判断验证是否通过完整验证
                return captcha.submitPostData(validateParams, "utf-8");

            } catch (Exception e) {

                e.printStackTrace();
            }

            return "invalid result";
        }

        @Override
        protected void onPostExecute(String params) {
            //TODO 验证成功
            geetestMananger.startsuccess();
//            geetestMananger.dosuccess();
            gtListener.gt3DialogSuccessResult(params);
        }


    }


    private class GtOneValidateTask extends AsyncTask<String, Void, String> {

        @Override
        protected String doInBackground(String... params) {
            try {

                Map<String, String> validateParams = new HashMap<>();

                validateParams.put("geetest_challenge", challenge);

                validateParams.put("geetest_validate", validate);

                validateParams.put("geetest_seccode", validate + "|jordan");
                Map map = gtListener.gt3SecondResult();
                if (map != null) {
                    Set set = map.keySet();

                    for (Iterator iter = set.iterator(); iter.hasNext(); ) {
                        String key = (String) iter.next();
                        String value = (String) map.get(key);
                        validateParams.put(key, value);
                    }
                }
                //TODO 验证通过, 获取二次验证响应, 根据响应判断验证是否通过完整验证
                return captcha.submitPostData(validateParams, "utf-8");

            } catch (Exception e) {

                e.printStackTrace();
            }

            return "invalid result";
        }

        @Override
        protected void onPostExecute(String params) {
            //TODO 验证成功
            geetestMananger.startsuccess();
//            geetestMananger.dosuccess();
            gtListener.gt3DialogSuccessResult(params);
        }

    }

    private class GtDownTimeValidateTask extends AsyncTask<String, Void, String> {

        @Override
        protected String doInBackground(String... params) {
            try {

                Map<String, String> validateParams = new HashMap<>();
                String md5Challenge = md5(downTimeChallenge);
                validateParams.put("geetest_challenge", downTimeChallenge);

                validateParams.put("geetest_validate", md5Challenge);

                validateParams.put("geetest_seccode", md5Challenge + "|jordan");
                Map map = gtListener.gt3SecondResult();
                if (map != null) {
                    Set set = map.keySet();

                    for (Iterator iter = set.iterator(); iter.hasNext(); ) {
                        String key = (String) iter.next();
                        String value = (String) map.get(key);
                        validateParams.put(key, value);
                    }
                }
                //TODO 验证通过, 获取二次验证响应, 根据响应判断验证是否通过完整验证
                return captcha.submitPostData(validateParams, "utf-8");

            } catch (Exception e) {

                e.printStackTrace();
            }

            return "invalid result";
        }

        @Override
        protected void onPostExecute(String params) {
            //TODO 验证成功
            geetestMananger.startsuccess();
//            geetestMananger.dosuccess();
            gtListener.gt3DialogSuccessResult(params);
        }

    }

    private static GT3GtDialog dialog;

    private void openGtTest() {

        dialog = new GT3GtDialog(getContext, gt, challenge, api_server, static_servers, result, slide);

//        EventBus.getDefault().post(new GT3Bean(gt, challenge, api_server, result, static_servers, static_servers2, click, slide));
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener() {
            @Override
            public void onCancel(DialogInterface dialo) {
                geetestMananger.startclose();
//                toastMsg("user close the geetest");
            }
        });

        dialog.setGtListener(new GT3GtDialog.GtListener() {

            @Override
            public void gtResult(boolean success, String result) {
                gtListener.gt3GetDialogResult(result);
                if (success) {
                    mGtAppValidateTask = new GtAppValidateTask();
                    mGtAppValidateTask.execute(result);
                } else {
                    //TODO 验证失败
//                    toastMsg("client captcha failed:" + result);
                    dialog.shakeDialog();
                }
            }


            @Override
            public void gtCallReady(Boolean status) {
                EventBus.getDefault().post("ajaxisfinish");
                if (status) {
                    //TODO 验证加载完成
//                    toastMsg("geetest finish load");
                    geetestMananger.startfinish();

                } else {
                    //TODO 验证加载超时,未准备完成
//                    toastMsg("there's a network jam");
                }
            }

            @Override
            public void gtCallClose() {
                geetestMananger.starterror();
//                toastMsg("close the dialog");


            }

            @Override
            public void gtError() {
                geetestMananger.starterror();
//                toastMsg("Fatal Error Did Occur.");
            }

        });

    }

    private void toastMsg(String msg) {
        final String a = msg;
        new Thread() {

            public void run() {


                Looper.prepare();

                Toast.makeText(context, a, Toast.LENGTH_SHORT).show();

                Looper.loop();

            }
        }.start();


    }

    private void toastLongTimeMsg(String msg) {
        final String a = msg;
        new Thread() {

            public void run() {


                Looper.prepare();

                Toast.makeText(context, a, Toast.LENGTH_LONG).show();

                Looper.loop();

            }
        }.start();

    }


    private static String md5(String string) {
        if (TextUtils.isEmpty(string)) {
            return "";
        }
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(string.getBytes());
            String result = "";
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xff);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result += temp;
            }
            return result;
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

    public interface GT3Listener {


        void gt3GetDialogResult(String result);

        void gt3FirstResult(JSONObject jsonObject);//第一次请求得到的数据

        Map<String, String> gt3SecondResult();//第二次请求得到的数据

        void gt3DialogSuccessResult(String result);
    }

    private GT3Listener gtListener;

    public void setGtListener(GT3Listener listener) {
        gtListener = listener;
    }
}
