package com.example.sdk;

import android.text.TextUtils;
import android.util.Log;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/**
 * 整个sdk的核心类
 */
public class GT3Geetest {
    private final String captchaURL;
    private final String validateURL;
    private final GT3GeetestBean geetestbean = new GT3GeetestBean();

    public GT3Geetest(String captchaURL, String validateURL) {
        this.captchaURL = captchaURL;
        this.validateURL = validateURL;
    }

    public boolean getSuccess() {
        return geetestbean.getSuccess() == 1;
    }

    public boolean getlogo() {
        return geetestbean.isLogo();
    }

    public String getChallenge() {
        return geetestbean.getChallenge();
    }

    public String getDownTimeChallenge() {
        return geetestbean.getDowntimechallenge();
    }

    public String getGt() {
        return geetestbean.getGt();
    }

    public String getClick() {
        return geetestbean.getClick();
    }

    public String getSlide() {
        return geetestbean.getSlide();
    }

    public String getResult() {
        return geetestbean.getResult();
    }

    public String getApi_server() {
        return geetestbean.getApi_server();
    }

    public String getStatic_servers() {
        return geetestbean.getStatic_servers();
    }

    public String getStatic_servers2() {
        return geetestbean.getStatic_servers2();
    }

    public String getValidate() {
        return geetestbean.getValidate();
    }

    public void setTimeout(int timeout) {
    }


    public interface GeetestListener {
        void readContentTimeout();

        void submitPostDataTimeout();

        void receiveInvalidParameters();
    }

    private GeetestListener geetestListener;

    public void setGeetestListener(GeetestListener listener) {
        geetestListener = listener;
    }

    public JSONObject checkServer() {

        try {

            String info = readContentFromGet(captchaURL);

            if (info.length() > 0) {

                Log.i("Geetest", "checkServer: " + info);

                JSONObject config = new JSONObject(info);

                geetestbean.setSuccess(config.getInt("success"));
                geetestbean.setDowntimechallenge(config.getString("challenge"));

                geetestbean.setGtt(config.getString("gt"));
                return config;
            }

        } catch (Exception e) {
            if (geetestListener != null) {
                geetestListener.receiveInvalidParameters();
            }
            e.printStackTrace();
        }

        return null;
    }

    public JSONObject gettype2Server() {

        try {

            String info = readContentFromGet(GT3GeetestUrl.gettypebaseUrl + geetestbean.getGtt() + GT3GeetestUrl.getandroidURL);

            if (info.length() > 0) {
                String a = info.replace("(", "");
                String b = a.replace(")", "");


                return new JSONObject(b);
            }

        } catch (Exception e) {
            if (geetestListener != null) {
                geetestListener.receiveInvalidParameters();
            }
            e.printStackTrace();
        }

        return null;
    }

    public JSONObject getphp2Server() {

        try {

            String info = readContentFromGet(GT3GeetestUrl.getphpbaseUrl + geetestbean.getGtt() + GT3GeetestUrl.getphpbaURL + geetestbean.getDowntimechallenge() + GT3GeetestUrl.getphpURL + GT3GeetestUrl.getandroidURL);

            if (info.length() > 0) {
                String a = info.replace("(", "");
                String b = a.replace(")", "");
                JSONObject config = new JSONObject(b);
                JSONObject data = config.getJSONObject("data");
                geetestbean.setLogo(data.getBoolean("logo"));
                Log.i("SSSSSSSSSS",data.toString());
                return config;
            }

        } catch (Exception e) {
            if (geetestListener != null) {
                geetestListener.receiveInvalidParameters();
            }
            e.printStackTrace();
        }

        return null;
    }


    public JSONObject checkRealServer() {

        try {

            String info = readContentFromGet(captchaURL);

            if (info.length() > 0) {

                Log.i("Geetest", "checkServer: " + info);

                JSONObject config = new JSONObject(info);

                geetestbean.setGt(config.getString("gt"));
                geetestbean.setChallenge(config.getString("challenge"));

                return config;
            }

        } catch (Exception e) {
            if (geetestListener != null) {
                geetestListener.receiveInvalidParameters();
            }
            e.printStackTrace();
        }

        return null;
    }

    private List<JSONObject> list = new ArrayList();

    public JSONObject gettypeServer() {

        try {

            String info = readContentFromGet(GT3GeetestUrl.gettypebaseUrl + geetestbean.getGt() + GT3GeetestUrl.getandroidURL);

            if (info.length() > 0) {
                String a = info.replace("(", "");
                String b = a.replace(")", "");
                JSONObject config = new JSONObject(b);
                JSONObject data = config.getJSONObject("data");
                list.add(data);


//                if (data.has("slide") && data.has("click")) {
//                    geetestbean.setSlide(data.getString("slide"));
//                    geetestbean.setClick(data.getString("click"));
//                } else if (data.has("click")) {
//                    geetestbean.setClick(data.getString("click"));
//                } else if (data.has("slide")) {
//                    geetestbean.setSlide(data.getString("slide"));
//                }
                return config;
            }

        } catch (Exception e) {
            if (geetestListener != null) {
                geetestListener.receiveInvalidParameters();
            }
            e.printStackTrace();
        }

        return null;
    }
private List<String> list22=new ArrayList();
    public JSONObject getphpServer() {

        try {

            String info = readContentFromGet(GT3GeetestUrl.getphpbaseUrl + geetestbean.getGt() + GT3GeetestUrl.getphpbaURL + geetestbean.getChallenge() + GT3GeetestUrl.getphpURL + GT3GeetestUrl.getandroidURL);
            if (info.length() > 0) {
                String a = info.replace("(", "");
                String b = a.replace(")", "");
                JSONObject config = new JSONObject(b);
                JSONObject data = config.getJSONObject("data");
                geetestbean.setApi_server(data.getString("api_server"));
                geetestbean.setTheme(data.getString("theme"));
                JSONArray api = data.getJSONArray("static_servers");
                for (int i = 0; i <api.length() ; i++) {
                    list22.add(api.getString(i));
                }
                geetestbean.setStatic_servers(list22.toString());
                list22.clear();
                return config;
            }

        } catch (Exception e) {
            if (geetestListener != null) {
                geetestListener.receiveInvalidParameters();
            }
            e.printStackTrace();
        }

        return null;
    }

    public JSONObject getajaxServer(String title, String headers) {
        String aaaa = title.replace("[", "");
        String bbb = aaaa.replace("]", "");
        String aaa = GT3GeetestUrl.getajaxbaseURL + geetestbean.getApi_server() + GT3GeetestUrl.getajaxbURL + geetestbean.getGt() + GT3GeetestUrl.getajaxbaURL + geetestbean.getChallenge() + GT3GeetestUrl.getajaxURL + bbb + "&mi=" + headers + GT3GeetestUrl.getandroidURL;
        try {
            String info = readContentFromGet(aaa);
            if (info.length() > 0) {
                String a = info.replace("(", "");
                String b = a.replace(")", "");
                JSONObject config = new JSONObject(b);
                JSONObject data = config.getJSONObject("data");
                geetestbean.setResult(data.getString("result"));
                if (list.get(0).has(data.getString("result"))) {
                    geetestbean.setSlide(list.get(0).getString(data.getString("result")));
                } else {
                    geetestbean.setSlide("");
                }

                list.clear();
                if (data.has("validate")) {
                    geetestbean.setValidate(data.getString("validate"));
                }
                return config;
            }

        } catch (Exception e) {
            if (geetestListener != null) {
                geetestListener.receiveInvalidParameters();
            }
            e.printStackTrace();
        }

        return null;
    }

//    private String redContentFromGet(String getURL) {
//        try {
//            return GT3HttpUtils.get(getURL, null, null);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//
//        return "";
//    }
//
//    private URL geValidateURL(String urlString) {
//        try {
//            return new URL(urlString);
//        } catch (Exception ignored) {
//
//        }
//        return null;
//    }
//
//    public String sumitPostData(Map<String, String> params, String encode) {
//        try {
//            //noinspection ConstantConditions
//            return GT3HttpUtils.post(getValidateURL(validateURL).toString(), geRequestData(params, encode).toString());
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//        return "";
//    }
//
//
//    private StringBuffer geRequestData(Map<String, String> params,
//                                        String encode) {
//        StringBuffer stringBuffer = new StringBuffer();
//        try {
//            for (Map.Entry<String, String> entry : params.entrySet()) {
//                stringBuffer.append(entry.getKey()).append("=")
//                        .append(URLEncoder.encode(entry.getValue(), encode))
//                        .append("&");
//            }
//            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        return stringBuffer;
//    }

    //
    private CookieManager cookieManager;
    private HttpURLConnection mReadConnection;
    private HttpURLConnection mSubmitConneciton;
    private HttpsURLConnection mSSLReadConnection;
    private HttpsURLConnection mSSLSubmitConnection;
    private Timer timer;
    private int responseCode;
    private int mTimeout = 30000;//默认10000ms

    public Boolean isOperating;

    public void cancelReadConnection() {
        if (isOperating) {
            mReadConnection.disconnect();
            isOperating = false;
        }
    }

    private String readContentFromGet(String getURL) throws IOException {

        isOperating = true;

        URL url = new URL(getURL);

        if ("https".equals(url.getProtocol().toLowerCase())) {

            final StringBuffer sBuffer = new StringBuffer();

            timer = new Timer();
            TimerTask timerTask = new TimerTask() {
                @Override
                public void run() {
                    if (responseCode != HttpsURLConnection.HTTP_OK || sBuffer.toString().length() == 0) {
                        if (mSSLReadConnection != null) {
                            mSSLReadConnection.disconnect();
                        }
                        isOperating = false;
                        if (geetestListener != null) {
                            geetestListener.readContentTimeout();
                        }
                    }
                }
            };
            timer.schedule(timerTask, mTimeout, 1);

            try {

                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new TrustAllManager()}, null);

                HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {

                    @Override
                    public boolean verify(String arg0, SSLSession arg1) {
                        return true;
                    }
                });

                HttpsURLConnection sslReadConnection = (HttpsURLConnection) url.openConnection();
                mSSLReadConnection = sslReadConnection;

                cookieManager = new CookieManager();

                sslReadConnection.setDoInput(true);
                sslReadConnection.setDoOutput(false);
                sslReadConnection.setRequestMethod("GET");

                sslReadConnection.setConnectTimeout(mTimeout / 2);

                sslReadConnection.setReadTimeout(mTimeout / 2);

                sslReadConnection.connect();

                Map<String, List<String>> headerFields = sslReadConnection.getHeaderFields();
                if (headerFields.get("Set-Cookie") != null) {
                    List<String> cookiesHeader = headerFields.get("Set-Cookie");
                    if (cookiesHeader != null) {
                        for (String cookie : cookiesHeader) {
                            cookieManager.getCookieStore().add(null, HttpCookie.parse(cookie).get(0));
                        }
                    }
                }

                byte[] buf = new byte[1024];

                InputStream inStream = sslReadConnection.getInputStream();

                for (int n; (n = inStream.read(buf)) != -1; ) {

                    sBuffer.append(new String(buf, 0, n, "UTF-8"));

                }

                inStream.close();

                responseCode = sslReadConnection.getResponseCode();

                if (responseCode == HttpsURLConnection.HTTP_OK) {
                    timer.cancel();
                    timer.purge();

                    return sBuffer.toString();
                }

                if (responseCode == HttpsURLConnection.HTTP_CLIENT_TIMEOUT || responseCode == -1) {
                    if (geetestListener != null) {
                        geetestListener.readContentTimeout();
                    }
                }

            } catch (Exception e) {

                e.printStackTrace();

            } finally {
                mSSLReadConnection.disconnect();
                isOperating = false;
            }

        } else {

            final StringBuffer sBuffer = new StringBuffer();

            timer = new Timer();
            TimerTask timerTask = new TimerTask() {
                @Override
                public void run() {
                    if (responseCode != HttpURLConnection.HTTP_OK || sBuffer.toString().length() == 0) {
                        if (mReadConnection != null) {
                            mReadConnection.disconnect();
                        }
                        isOperating = false;
                        if (geetestListener != null) {
                            geetestListener.readContentTimeout();
                        }
                    }
                }
            };
            timer.schedule(timerTask, mTimeout, 1);

            HttpURLConnection readConnection = (HttpURLConnection) url.openConnection();
            mReadConnection = readConnection;

            cookieManager = new CookieManager();

            Map<String, List<String>> headerFields = readConnection.getHeaderFields();
            if (headerFields.get("Set-Cookie") != null) {
                List<String> cookiesHeader = headerFields.get("Set-Cookie");
                if (cookiesHeader != null) {
                    for (String cookie : cookiesHeader) {
                        cookieManager.getCookieStore().add(null, HttpCookie.parse(cookie).get(0));
                    }
                }
            }

            try {

                readConnection.setConnectTimeout((int) (mTimeout / 2));

                readConnection.setReadTimeout((int) (mTimeout / 2));

                readConnection.connect();

                byte[] buf = new byte[1024];

                InputStream inStream = readConnection.getInputStream();

                for (int n; (n = inStream.read(buf)) != -1; ) {

                    sBuffer.append(new String(buf, 0, n, "UTF-8"));

                }

                inStream.close();

                responseCode = readConnection.getResponseCode();

                if (responseCode == HttpURLConnection.HTTP_OK) {
                    timer.cancel();
                    timer.purge();
                    return sBuffer.toString();
                }

                if (responseCode == HttpURLConnection.HTTP_CLIENT_TIMEOUT || responseCode == -1) {
                    if (geetestListener != null) {
                        geetestListener.readContentTimeout();
                    }
                }

            } catch (EOFException e) {

                e.printStackTrace();

            } finally {
                mReadConnection.disconnect();
                isOperating = false;
            }
        }

        return "";
    }

    private URL getValidateURL(String urlString) {
        try {
            URL url = new URL(urlString);
            return url;
        } catch (Exception e) {

        }
        return null;
    }

    public String submitPostData(Map<String, String> params, String encode) {

        isOperating = true;

        URL url = getValidateURL(validateURL);

        if ("https".equals(url.getProtocol().toLowerCase())) {
            timer = new Timer();
            TimerTask timerTask = new TimerTask() {
                @Override
                public void run() {
                    if (responseCode != HttpsURLConnection.HTTP_OK) {
                        if (mSSLSubmitConnection != null) {
                            mSSLSubmitConnection.disconnect();
                        }
                        isOperating = false;
                        if (geetestListener != null) {
                            geetestListener.submitPostDataTimeout();
                        }
                    }
                }
            };
            timer.schedule(timerTask, mTimeout);

            byte[] data = getRequestData(params, encode).toString().getBytes();

            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new TrustAllManager()}, null);

                HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {

                    @Override
                    public boolean verify(String arg0, SSLSession arg1) {
                        return true;
                    }
                });

                HttpsURLConnection sslSubmitConnection = (HttpsURLConnection) url.openConnection();
                mSSLSubmitConnection = sslSubmitConnection;

                if (cookieManager.getCookieStore().getCookies().size() > 0) {
                    sslSubmitConnection.setRequestProperty("Cookie",
                            TextUtils.join(";", cookieManager.getCookieStore().getCookies()));
                }

                sslSubmitConnection.setConnectTimeout(mTimeout);
                sslSubmitConnection.setDoInput(true);
                sslSubmitConnection.setDoOutput(true);
                sslSubmitConnection.setRequestMethod("POST");
                sslSubmitConnection.setUseCaches(false);

                sslSubmitConnection.setRequestProperty("Content-Type",
                        "application/x-www-form-urlencoded");

                sslSubmitConnection.setRequestProperty("Content-Length",
                        String.valueOf(data.length));

                OutputStream outputStream = sslSubmitConnection.getOutputStream();
                outputStream.write(data);

                int response = sslSubmitConnection.getResponseCode();

                if (response == HttpsURLConnection.HTTP_OK) {
                    timer.cancel();
                    timer.purge();
                    InputStream inptStream = sslSubmitConnection.getInputStream();
                    return dealResponseResult(inptStream);
                }

                if (response == -1) {
                    if (geetestListener != null) {
                        geetestListener.submitPostDataTimeout();
                    }
                }

            } catch (Exception e) {

                e.printStackTrace();

            } finally {

                mSSLSubmitConnection.disconnect();

                isOperating = false;
            }

        } else {

            timer = new Timer();
            TimerTask timerTask = new TimerTask() {
                @Override
                public void run() {
                    if (responseCode != HttpURLConnection.HTTP_OK) {
                        if (mSubmitConneciton != null) {
                            mSubmitConneciton.disconnect();
                        }
                        isOperating = false;
                        if (geetestListener != null) {
                            geetestListener.submitPostDataTimeout();
                        }
                    }
                }
            };
            timer.schedule(timerTask, mTimeout);

            byte[] data = getRequestData(params, encode).toString().getBytes();

            try {
                HttpURLConnection submitConnection = (HttpURLConnection) url.openConnection();
                mSubmitConneciton = submitConnection;

                submitConnection.setConnectTimeout(mTimeout);
                submitConnection.setDoInput(true);
                submitConnection.setDoOutput(false);
                submitConnection.setRequestMethod("POST");
                submitConnection.setUseCaches(false);

                if (cookieManager.getCookieStore().getCookies().size() > 0) {
                    submitConnection.setRequestProperty("Cookie",
                            TextUtils.join(";", cookieManager.getCookieStore().getCookies()));
                }

                submitConnection.setRequestProperty("Content-Type",
                        "application/x-www-form-urlencoded");

                submitConnection.setRequestProperty("Content-Length",
                        String.valueOf(data.length));

                OutputStream outputStream = submitConnection.getOutputStream();
                outputStream.write(data);

                int response = submitConnection.getResponseCode();

                if (response == HttpURLConnection.HTTP_OK) {
                    timer.cancel();
                    timer.purge();
                    InputStream inptStream = submitConnection.getInputStream();
                    return dealResponseResult(inptStream);
                }

                if (response == -1) {
                    if (geetestListener != null) {
                        geetestListener.submitPostDataTimeout();
                    }
                }

            } catch (IOException e) {

                e.printStackTrace();

            } finally {

                mSubmitConneciton.disconnect();

                isOperating = false;
            }
        }
        return "";
    }

    private StringBuffer getRequestData(Map<String, String> params,
                                        String encode) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                stringBuffer.append(entry.getKey()).append("=")
                        .append(URLEncoder.encode(entry.getValue(), encode))
                        .append("&");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return stringBuffer;
    }

    private String dealResponseResult(InputStream inputStream) {
        String resultData;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        int len;
        try {
            while ((len = inputStream.read(data)) != -1) {
                byteArrayOutputStream.write(data, 0, len);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        resultData = new String(byteArrayOutputStream.toByteArray());
        return resultData;
    }

    public class TrustAllManager implements X509TrustManager {

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1)
                throws CertificateException {
            // TODO Auto-generated method stub
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1)
                throws CertificateException {
            // TODO Auto-generated method stub
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            // TODO Auto-generated method stub
            return null;
        }
    }
}