package com.example.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

import org.greenrobot.eventbus.EventBus;

/**
 * Created by 谷闹年 on 2017/4/18.
 */
public class GT3View extends View {
    public GT3View(Context context) {
        super(context);
        initPaint(context);
    }

    public GT3View(Context context, AttributeSet attrs) {
        super(context, attrs);
        initPaint(context);
    }

    public GT3View(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initPaint(context);
    }

    private int alphaLevel;
    private Paint upaint;
    private Paint uupaint;
    private Path path;
    private int successRadius;
    private Context context;

    private void initPaint(Context context) {
        this.context = context;
        path = new Path();
        upaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        upaint.setAntiAlias(true);
        upaint.setColor(0xff80d6ab);
        upaint.setStrokeWidth(GT3DensityUtil.dip2px(context, 2));
        upaint.setStyle(Paint.Style.STROKE);

        alphaLevel = 1;

        uupaint = new Paint(SYSTEM_UI_LAYOUT_FLAGS);
        uupaint.setAntiAlias(true);
        uupaint.setColor(0xff80d6ab);
        uupaint.setStrokeWidth(GT3DensityUtil.dip2px(context, 3));
        uupaint.setStyle(Paint.Style.STROKE);


    }

    @Override
    protected void onDraw(Canvas canvas) {
        successRadius = GT3DensityUtil.dip2px(context, 12);
        postInvalidateDelayed(50);
        super.onDraw(canvas);
        if (b <= 100) {
            alphaLevel += 30;
            uupaint.setAlpha(alphaLevel);
            path.moveTo(getWidth() / 2 - 13 * successRadius / 22, getHeight() / 2 - 2 * successRadius / 22);
            path.lineTo(getWidth() / 2 - 2 * successRadius / 22, getHeight() / 2 + 10 * successRadius / 22);
            path.lineTo(getWidth() / 2 + 22 * successRadius / 22, getHeight() / 2 - 16 * successRadius / 22);
            canvas.drawPath(path, uupaint);


            canvas.translate(getWidth() / 2, getHeight() / 2);
            @SuppressLint("DrawAllocation") RectF rect = new RectF(-successRadius, -successRadius, successRadius, successRadius);
            canvas.drawArc(rect, 300, -b, false, upaint);
            b += 80;
        } else if (b > 100 && b <= 200) {
            alphaLevel += 40;
            uupaint.setAlpha(alphaLevel);
            path.moveTo(getWidth() / 2 - 13 * successRadius / 22, getHeight() / 2 - 2 * successRadius / 22);
            path.lineTo(getWidth() / 2 - 2 * successRadius / 22, getHeight() / 2 + 10 * successRadius / 22);
            path.lineTo(getWidth() / 2 + 22 * successRadius / 22, getHeight() / 2 - 16 * successRadius / 22);
            canvas.drawPath(path, uupaint);


            canvas.translate(getWidth() / 2, getHeight() / 2);
            @SuppressLint("DrawAllocation") RectF rect = new RectF(-successRadius, -successRadius, successRadius, successRadius);
            canvas.drawArc(rect, 300, -b, false, upaint);
            b += 40;
        } else if (b > 200 && b <= 300) {
            alphaLevel += 30;
            uupaint.setAlpha(alphaLevel);
            path.moveTo(getWidth() / 2 - 13 * successRadius / 22, getHeight() / 2 - 2 * successRadius / 22);
            path.lineTo(getWidth() / 2 - 2 * successRadius / 22, getHeight() / 2 + 10 * successRadius / 22);
            path.lineTo(getWidth() / 2 + 22 * successRadius / 22, getHeight() / 2 - 16 * successRadius / 22);
            canvas.drawPath(path, uupaint);


            canvas.translate(getWidth() / 2, getHeight() / 2);
            @SuppressLint("DrawAllocation") RectF rect = new RectF(-successRadius, -successRadius, successRadius, successRadius);
            canvas.drawArc(rect, 300, -b, false, upaint);
            b += 80;
        } else if (b > 300 && b < 600) {
            alphaLevel = 255;
            uupaint.setAlpha(alphaLevel);

            path.moveTo(getWidth() / 2 - 13 * successRadius / 22, getHeight() / 2 - 2 * successRadius / 22);
            path.lineTo(getWidth() / 2 - 2 * successRadius / 22, getHeight() / 2 + 10 * successRadius / 22);
            path.lineTo(getWidth() / 2 + 22 * successRadius / 22, getHeight() / 2 - 16 * successRadius / 22);
            canvas.drawPath(path, uupaint);
            canvas.translate(getWidth() / 2, getHeight() / 2);
            @SuppressLint("DrawAllocation") RectF rect = new RectF(-successRadius, -successRadius, successRadius, successRadius);
            canvas.drawArc(rect, 300, -300, false, upaint);
            b += 60;
        } else {
            path.moveTo(getWidth() / 2 - 13 * successRadius / 22, getHeight() / 2 - 2 * successRadius / 22);
            path.lineTo(getWidth() / 2 - 2 * successRadius / 22, getHeight() / 2 + 10 * successRadius / 22);
            path.lineTo(getWidth() / 2 + 22 * successRadius / 22, getHeight() / 2 - 16 * successRadius / 22);
            canvas.drawPath(path, uupaint);
            canvas.translate(getWidth() / 2, getHeight() / 2);
            @SuppressLint("DrawAllocation") RectF rect = new RectF(-successRadius, -successRadius, successRadius, successRadius);
            canvas.drawArc(rect, 300, -300, false, upaint);
            EventBus.getDefault().post("tobesuccess");
        }

    }

    private int b;

    public void startsuccess() {
        b = 0;

    }

}
