package com.example.sdk;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by 谷闹年 on 2017/4/28.
 */
public class GT3AroundMsg implements SensorEventListener {
    private static final List<Object> senlist = new ArrayList<>();
    private SensorManager sensorManager;
    private static final float NS2S = 1.0f / 1000000000.0f;
    private float timestamp;
    private final float[] angle = new float[3];
    private boolean sensorAvailable = false;

    public GT3AroundMsg(Context context) {
        sensorManager = (SensorManager) context.getSystemService(Context.SENSOR_SERVICE);
        List<Sensor> sensorList = sensorManager.getSensorList(Sensor.TYPE_ALL);
        for (int i = 0; i < sensorList.size(); i++) {

            if (sensorList.get(i).getType() == Sensor.TYPE_GYROSCOPE) {
                sensorAvailable = true;
            }
        }
    }

    public void startSensor() {
        n = 0;
        if (sensorAvailable) {
            Sensor gyroscopeSensor = sensorManager.getDefaultSensor(Sensor.TYPE_GYROSCOPE);
            if (null != gyroscopeSensor) {
                sensorManager.registerListener(this, gyroscopeSensor,
                        SensorManager.SENSOR_DELAY_UI);
            }
        }
    }

    public String gt3SendSenMsg() {
        senlist.add(0, noTrueMsg());
        if (!sensorAvailable) {
            return noTrueMsg();
        } else if (senlist.size() == 1) {
            senlist.add(1, noTrueMsg());
        }else {
            return senlist.toString();
        }
        return senlist.toString();
    }

    private String noTrueMsg() {
        List list = new ArrayList();
        list.clear();
        list.add(0);
        list.add(0);
        list.add(0);
        list.add(0);
        return list.toString();
    }

    public void endSensor() {
        senlist.clear();
        if (sensorAvailable) {

            sensorManager.unregisterListener(this);
        }
    }

    private int n;

    @Override
    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == Sensor.TYPE_GYROSCOPE) {
            if (timestamp != 0) {
                if (event.values[2] > 0.15 || event.values[2] < -0.15) {
                    final float dT = (event.timestamp - timestamp) * NS2S;
                    angle[0] += event.values[0] * dT;
                    angle[1] += event.values[1] * dT;
                    angle[2] += event.values[2] * dT;
                    float angleX = (float) Math.toDegrees(angle[0]);
                    float angleY = (float) Math.toDegrees(angle[1]);
                    float angleZ = (float) Math.toDegrees(angle[2]);
                    List list2 = new ArrayList();
                    list2.clear();
                    list2.add(new BigDecimal(dT * 1000).setScale(0, BigDecimal.ROUND_HALF_UP));
                    list2.add(new BigDecimal(angleX).setScale(0, BigDecimal.ROUND_HALF_UP));
                    list2.add(new BigDecimal(angleY).setScale(0, BigDecimal.ROUND_HALF_UP));
                    list2.add(new BigDecimal(angleZ).setScale(0, BigDecimal.ROUND_HALF_UP));
                    senlist.add(list2.toString());
                    n++;
                }
                if (n > 48) {
                    if (sensorAvailable) {
                        sensorManager.unregisterListener(this);
                    }
                }
            }
            timestamp = event.timestamp;

        }
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {

    }
}
