package com.example.sdk;

import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

/**
 * Created by 谷闹年 on 2017/4/18.
 */
public class GT3Toast {
    public static void show(String msg, Context context) {
        show(msg, Toast.LENGTH_SHORT, context);
    }

    public static void showLong(String msg, Context context) {
        show(msg, Toast.LENGTH_LONG, context);
    }


    private static void show(String msg, int show_length, Context context) {

        //使用布局加载器，将编写的toast_layout布局加载进来
        View view = LayoutInflater.from(context).inflate(R.layout.gt3_fail_toast, null);
        LinearLayout relativeLayout = (LinearLayout) view.findViewById(R.id.ll);
        TextView textView = (TextView) view.findViewById(R.id.tvtoast);
        textView.setText(msg);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(GT3DensityUtil.dip2px(context, 280), GT3DensityUtil.dip2px(context, 140));
        relativeLayout.setLayoutParams(layoutParams);
        Toast toast = new Toast(context);
        //设置Toast要显示的位置，水平居中
        toast.setGravity(Gravity.CENTER, 0, 0);
        //设置显示时间
        toast.setDuration(show_length);

        toast.setView(view);
        toast.show();
    }

}
