package com.example.sdk;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.view.Window;
import android.webkit.JavascriptInterface;
import android.widget.RelativeLayout;

import com.example.sdk.hooklistener.GT3LifecycleCallBacks;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;


/**
 * 验证对话框
 */
public class GT3GtDialog extends Dialog {
    private String pathUrl;
    protected static final String ACTIVITY_TAG = "GtDialog";
    private TelephonyManager tm;
    private final Context mContext;

    private String product = "embed";
    private String language = "zh-cn";
    private Boolean debug = false;

    private Dialog mDialog = this;
    private int mWidth;
    private int mTimeout = 10000;//默认10000ms
    private final GT3GtWebView webView;

    private Boolean isShowing = false;


    //支持"zh-cn","zh-hk","zh-tw","ko-kr","ja-jp","en-us".默认"zh-cn".
    public void setLanguage(String lang) {
        this.language = lang;
    }

    public void stopLoading() {
        webView.stopLoading();
    }

    private String gt, challenge, api_server, static_servers, static_servers2, result, slide;

    public GT3GtDialog(Context context) {
        super(context);
        mContext = context;
        webView = new GT3GtWebView(context);
    }


    //    public GT3GtDialog(Context context, String a1, String a2, String a3, String a4, String a5, String a6, String a7, String a8) {
//        super(context);
//        mContext = context;
//        tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
//        gt = a1;
//        challenge = a2;
//        click = a3;
//        if (a4.equals("") || a4.length() == 0) {
//            api_server = "api.geetest.com";
//        } else {
//            api_server = a4;
//        }
//        if (a5.equals("") || a5.length() == 0) {
//            static_servers = "static.geetest.com";
//        } else {
//            static_servers = a5;
//        }
//        static_servers = a5;
//        static_servers2 = a6;
//        result = a7;
//        slide = a8;
//        init(context);
//    }


    private void init(Context context) {


        webView.setGtWebViewListener(new GT3GtWebView.GtWebViewListener() {
            @Override
            public void gtCallReady(Boolean status) {
                if (gtListener != null) {
                    gtListener.gtCallReady(status);
                }
            }

            @Override
            public void gtError() {
                if (gtListener != null) {
                    gtListener.gtError();
                }
            }
        });
        webView.addJavascriptInterface(new JSInterface(), "JSInterface");
        pathUrl = "?"
                + "&gt=" + gt
                + "&challenge=" + challenge
                + "&lang=" + this.language //支持"zh-cn","zh-hk","zh-tw","ko-kr","ja-jp","en-us".默认"zh-cn"
                + "&title=" + "" //验证标题，不宜过长
                + "&" + result + "=" + slide
                + "&type=" + result
                + "&api_server=" + api_server
                + "&static_servers=" + static_servers
                + "&width=100%"
                + "&timoout=15000";
//        if (result.equals("click")) {
//            pathUrl = "?"
//                    + "&gt=" + gt
//                    + "&challenge=" + challenge
//                    + "&lang=" + this.language //支持"zh-cn","zh-hk","zh-tw","ko-kr","ja-jp","en-us".默认"zh-cn"
//                    + "&title=" + "" //验证标题，不宜过长
//                    + "&click=" + click
//                    + "&type=" + result
//                    + "&api_server=" + api_server
//                    + "&static_servers=" + static_servers + "," + static_servers2;
//            webheight = 445.00 / 348.00;
//        } else if (result.equals("slide")) {
//            pathUrl = "?"
//                    + "&gt=" + gt
//                    + "&challenge=" + challenge
//                    + "&lang=" + this.language //支持"zh-cn","zh-hk","zh-tw","ko-kr","ja-jp","en-us".默认"zh-cn"
//                    + "&title=" + ""//验证标题，不宜过长
//                    + "&slide=" + slide
//                    + "&type=" + result
//                    + "&api_server=" + api_server
//                    + "&static_servers=" + static_servers + "," + static_servers2;
//            webheight = 286.00 / 278.00;
//        }
        mWidth = getDeviceWidth();
        int mHeight = getDeviceHeight();
        String baseURL = "https://static.geetest.com/static/appweb/app3-index.html";
        String gt_mobile_req_url = baseURL + pathUrl;
        Log.i("GtDialog", "url: " + gt_mobile_req_url);
        webView.loadUrl(gt_mobile_req_url);
        webView.buildLayer();
    }

    @Override
    public boolean isShowing() {
        return super.isShowing();
    }

    private float getDeviceScale() {
        return getContext().getResources().getDisplayMetrics().density;
    }

    private int getDeviceWidth() {
        int height = GT3DimenTool.getHeightPx(getContext());
        int width = GT3DimenTool.getWidthPx(getContext());
        float scale = getDeviceScale();

        final int WIDTH = 290;

        if (height < width) {
            width = height * 3 / 4;
        }
        width = width * 4 / 5;
        if ((int) (width / scale + 0.5f) < WIDTH) {
            width = (int) ((WIDTH - 0.5f) * scale);
        }
        return width;
    }

    private int getDeviceHeight() {
        int height = GT3DimenTool.getHeightPx(getContext());
        int width = GT3DimenTool.getWidthPx(getContext());
        float scale = getContext().getResources().getDisplayMetrics().density;

        final int HEIGHT = 500;

        return (int) (HEIGHT * scale);
    }


    public interface GtListener {
        //通知native验证已准备完毕
        void gtCallReady(Boolean status); // true准备完成/false未准备完成

        //通知native关闭验证
        void gtCallClose();

        //通知javascript发生严重错误
        void gtError();

        //通知native验证结果，并准备二次验证
        void gtResult(boolean success, String result);


        void success();
    }

    private GtListener gtListener;

    public void setGtListener(GtListener listener) {
        gtListener = listener;
    }


    private RelativeLayout relativeLayout;
    private RelativeLayout relativeLayout2;
    private RelativeLayout relativeLayout3;
    private View view1;
    private View view2;
    private View view3;


    private GT3GifView gt3GifView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.gt3_wait_progressdialog);
        relativeLayout = (RelativeLayout) findViewById(R.id.ll);
        gt3GifView = (GT3GifView) findViewById(R.id.iv);
        gt3GifView.play();
        gt3GifView.setGifResource(new GT3ReadyMsg().getLogoid());

        view1 = findViewById(R.id.view1);
        if (new GT3havelogo().isHavelogo()) {
            relativeLayout.setVisibility(View.VISIBLE);
            view1.setVisibility(View.VISIBLE);
        } else {
            relativeLayout.setVisibility(View.INVISIBLE);
            view1.setVisibility(View.INVISIBLE);
        }
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

    @Override
    protected void onStart() {
        super.onStart();
        EventBus.getDefault().register(this);
    }


    @Subscribe(threadMode = ThreadMode.MAIN)
    public void test(String a) {
        if (a.equals("startfinish")) {
            GT3LifecycleCallBacks.getInstance(mContext).canadd();
            setContentView(R.layout.gt3_success_progressdialog);
            view2 = findViewById(R.id.view2);
            relativeLayout2 = (RelativeLayout) findViewById(R.id.lll);
            if (new GT3havelogo().isHavelogo()) {
                relativeLayout2.setVisibility(View.VISIBLE);
                view2.setVisibility(View.VISIBLE);
            } else {
                relativeLayout2.setVisibility(View.INVISIBLE);
                view2.setVisibility(View.INVISIBLE);
            }
            GT3View gt3View = (GT3View) findViewById(R.id.iv);
            gt3View.startsuccess();

        }
        if (a.equals("tobesuccess")) {

            dismiss();
            if (gtListener != null) {
                gtListener.success();
            }
        }


    }

    private double webheight;

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void test2(GT3Bean gt3Bean) {
        gt = gt3Bean.getGt();
        challenge = gt3Bean.getChallenge();
        if (gt3Bean.getApi_server().equals("") || gt3Bean.getApi_server().length() == 0) {
            api_server = "api.geetest.com";
        } else {
            api_server = gt3Bean.getApi_server();
        }
        String a = gt3Bean.getStatic_servers().replace("[", "");
        static_servers = a.replace("]", "");
        result = gt3Bean.getResult();
        slide = gt3Bean.getSlide();
        init(mContext);
    }

    @Override
    public void show() {
        isShowing = true;
        super.show();
    }

    @Override
    public void dismiss() {
        isShowing = false;
        webView.stopLoading();
        webView.removeJavascriptInterface("JSInterface");
        webView.removeAllViews();
        webView.destroy();
        if (((Activity) mContext) != null && !((Activity) mContext).isFinishing()) {
            super.dismiss();
        }
    }

    @Override
    public void hide() {
        isShowing = false;
        super.hide();
    }

    public void shakeDialog() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat(webView, "translationX", 0f, 2f, 4f, 2f, 0f, -2f, -4f, -2f, 0f, 2f, 4f, 2f, 0f, -2f, -4f, -2f, 0f);

        objectAnimator.setDuration(500);
        objectAnimator.start();
    }

    private class JSInterface {

        @JavascriptInterface
        public void gtCallBack(String code, String result, final String message) {
            final int fCode;
            final String fResult = result;
            final String fMessage = message;
            try {
                fCode = Integer.parseInt(code);
                ((Activity) mContext).runOnUiThread(new Runnable() {
                    @Override
                    public void run() {

                        if (fCode == 1) {
//                            dismiss();

                            if (gtListener != null) {
                                gtListener.gtResult(true, fResult);
                            }

                        } else {
                            if (gtListener != null) {
                                gtListener.gtResult(false, fResult);
                            }
                        }
                    }
                });
            } catch (NumberFormatException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }

        @JavascriptInterface
        public void gtClose() {
            ((Activity) mContext).runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    dismiss();

                }
            });
            if (gtListener != null) {
                gtListener.gtCallClose();
            }
        }

        @JavascriptInterface
        public void gtReady() {

            ((Activity) mContext).runOnUiThread(new Runnable() {

                @Override
                public void run() {

//                    setContentView(webView, new LayoutParams(mWidth, (int) (webheight * mWidth)));
                    setContentView(webView, new LayoutParams(mWidth, LayoutParams.WRAP_CONTENT));


                }
            });

            if (gtListener != null) {
                gtListener.gtCallReady(true);
            }
        }

        @JavascriptInterface
        public void gtError() {
            ((Activity) mContext).runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    setContentView(R.layout.gt3_overtime_progressdialog);
                    view3 = findViewById(R.id.view3);
                    relativeLayout3 = (RelativeLayout) findViewById(R.id.llll);
                    if (new GT3havelogo().isHavelogo()) {
                        relativeLayout3.setVisibility(View.VISIBLE);
                        view3.setVisibility(View.VISIBLE);
                    } else {
                        relativeLayout3.setVisibility(View.INVISIBLE);
                        view3.setVisibility(View.INVISIBLE);
                    }
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000);
                                ((Activity) mContext).runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        dismiss();
                                    }
                                });
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
            });
            if (gtListener != null) {
                gtListener.gtError();
            }
        }

    }

}
