package com.example.sdk;


import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.MotionEvent;
import android.view.View;

import com.example.sdk.hooklistener.HookCore;
import com.example.sdk.hooklistener.HookListenerContract;
import com.example.sdk.hooklistener.ListenerManager;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;


/**
 * Created by 谷闹年 on 2017/4/13.
 */
public class GT3BaseActivity extends AppCompatActivity {
    private static final List<Object> list = new ArrayList<>();


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

    }


    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        ListenerManager.Builer builer = new ListenerManager.Builer();
        builer.buildOnClickListener(new HookListenerContract.OnClickListener() {
            @Override
            public void doInListener(View v) {
                v.setOnTouchListener(new View.OnTouchListener() {
                    @Override
                    public boolean onTouch(View v, MotionEvent event) {
                        if (b <= 200) {
                            list.add(snapshotView(v, event));
                        }
                        b++;
                        return false;
                    }
                });
            }
        });
        HookCore.getInstance().startHook(this, ListenerManager.create(builer));
    }

    @Override
    protected void onStart() {
        super.onStart();
        b = 0;

        ListenerManager.Builer builer = new ListenerManager.Builer();
        builer.buildOnClickListener(new HookListenerContract.OnClickListener() {
            @Override
            public void doInListener(View v) {
                v.setOnTouchListener(new View.OnTouchListener() {
                    @Override
                    public boolean onTouch(View v, MotionEvent event) {
                        if (b <= 200) {
                            list.add(snapshotView(v, event));
                        }
                        b++;
                        return false;
                    }
                });
            }
        });
        HookCore.getInstance().startHook(this, ListenerManager.create(builer));
    }

    private int b;


    private String snapshotView(View view, MotionEvent event) {
        List<Object> list = new ArrayList<>();
        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN:

                list.add(new BigDecimal(event.getRawX()).setScale(0, BigDecimal.ROUND_HALF_UP));
                list.add(new BigDecimal(event.getRawY()).setScale(0, BigDecimal.ROUND_HALF_UP));
                list.add(System.currentTimeMillis());
                break;
            case MotionEvent.ACTION_UP:
                list.add(new BigDecimal(event.getRawX()).setScale(0, BigDecimal.ROUND_HALF_UP));
                list.add(new BigDecimal(event.getRawY()).setScale(0, BigDecimal.ROUND_HALF_UP));
                list.add(System.currentTimeMillis());
                break;
        }

        list.add(view.getId());
        list.add(view.getTop() + "/" + view.getRight() + "/" + view.getBottom() + "/" + view.getLeft());
        list.add(view.getClass().getName());

        return list.toString();
    }

    private String noTrueMsg() {
        List<Object> list = new ArrayList<>();
        list.add(0);
        list.add(0);
        list.add(System.currentTimeMillis());
        list.add(0);
        list.add(System.currentTimeMillis());
        Random random = new Random();
        list.add(random.nextInt(10000));
        list.add(random.nextInt(10000));
        list.add("");
        return list.toString();
    }

    public String gt3SendMsg() {
        if (null == list.toString() || list.toString().equals("")) {
            return null;
        }
        return noTrueMsg() + list.toString();
    }

    public void clearAllMsg() {
        list.clear();

    }


    @Override
    protected void onStop() {
        super.onStop();
        list.clear();

    }


}
