/*
 * Decompiled with CFR 0.152.
 */
package graphics.scenery.spirvcrossj;

import graphics.scenery.spirvcrossj.CompilerGLSL;
import graphics.scenery.spirvcrossj.IntVec;
import graphics.scenery.spirvcrossj.Loader;
import graphics.scenery.spirvcrossj.ShaderResources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Test;

public class TestVulkanToGLSL {
    @Test
    public void convertVulkanToGLSL310() throws IOException, URISyntaxException {
        ByteBuffer data = ByteBuffer.wrap(Files.readAllBytes(Paths.get(TestVulkanToGLSL.class.getResource("fullscreen-quad.spv").toURI())));
        IntVec spirv = new IntVec();
        IntBuffer ib = data.asIntBuffer();
        while (ib.hasRemaining()) {
            spirv.add(Long.valueOf(ib.get()));
        }
        System.out.println("Read " + ib.position() + " opcodes from SPIR-V binary.\n");
        CompilerGLSL compiler = new CompilerGLSL(spirv);
        CompilerGLSL.Options options = new CompilerGLSL.Options();
        options.setVersion(310L);
        options.setEs(false);
        compiler.setCommonOptions(options);
        System.out.println("SPIR-V converted to GLSL 3.10:\n\n" + compiler.compile());
    }

    @Test
    public void listUniformBuffers() throws IOException, URISyntaxException {
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("spvFileList.txt")));
        List spvFileList = in.lines().collect(Collectors.toList());
        in.close();
        for (String filename : spvFileList) {
            ByteBuffer data = ByteBuffer.wrap(Files.readAllBytes(Paths.get(TestVulkanToGLSL.class.getResource(filename).toURI())));
            IntVec spirv = new IntVec();
            IntBuffer ib = data.asIntBuffer();
            while (ib.hasRemaining()) {
                spirv.add(Long.valueOf(ib.get()));
            }
            System.out.println("Read " + ib.position() + " opcodes from SPIR-V binary " + filename + ".\n");
            CompilerGLSL compiler = new CompilerGLSL(spirv);
            ShaderResources res = compiler.getShaderResources();
            int i = 0;
            while ((long)i < res.getUniformBuffers().capacity()) {
                System.err.println(compiler.getType(res.getUniformBuffers().get((long)i).getTypeId()).getBasetype() + ": " + res.getUniformBuffers().get((long)i).getName());
                ++i;
            }
            i = 0;
            while ((long)i < res.getSampledImages().capacity()) {
                System.err.println(compiler.getType(res.getSampledImages().get((long)i).getTypeId()).getBasetype() + ": " + res.getSampledImages().get((long)i).getName());
                ++i;
            }
        }
    }

    @Test(expected=RuntimeException.class)
    public void checkExceptionHandling() throws IOException, URISyntaxException {
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("spvFileList.txt")));
        List spvFileList = in.lines().collect(Collectors.toList());
        in.close();
        for (String filename : spvFileList) {
            ByteBuffer data = ByteBuffer.wrap(Files.readAllBytes(Paths.get(TestVulkanToGLSL.class.getResource(filename).toURI())));
            IntVec spirv = new IntVec();
            IntBuffer ib = data.asIntBuffer();
            while (ib.hasRemaining()) {
                spirv.add(Long.valueOf(ib.get()));
            }
            CompilerGLSL compiler = new CompilerGLSL(spirv);
            ShaderResources res = compiler.getShaderResources();
            int i = 0;
            while ((long)i < res.getUniformBuffers().capacity()) {
                compiler.getType(res.getUniformBuffers().get((long)i).getId());
                ++i;
            }
        }
    }

    static {
        try {
            Loader.loadNatives();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

