/*
 * Decompiled with CFR 0.152.
 */
package graphics.scenery.spirvcrossj;

import graphics.scenery.spirvcrossj.EShLanguage;
import graphics.scenery.spirvcrossj.EShMessages;
import graphics.scenery.spirvcrossj.IntVec;
import graphics.scenery.spirvcrossj.Loader;
import graphics.scenery.spirvcrossj.SWIGTYPE_p_TBuiltInResource;
import graphics.scenery.spirvcrossj.SWIGTYPE_p_glslang__TIntermediate;
import graphics.scenery.spirvcrossj.TProgram;
import graphics.scenery.spirvcrossj.TShader;
import graphics.scenery.spirvcrossj.libspirvcrossj;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Test;

public class TestGLSLToVulkan {
    @Test
    public void convertGLSLToVulkan() throws IOException, URISyntaxException, InterruptedException {
        Loader.loadNatives();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("shaderFileList.txt")));
        List spvFileList = in.lines().collect(Collectors.toList());
        in.close();
        if (!libspirvcrossj.initializeProcess()) {
            throw new RuntimeException("glslang failed to initialize.");
        }
        SWIGTYPE_p_TBuiltInResource resources = libspirvcrossj.getDefaultTBuiltInResource();
        block20: for (String filename : spvFileList) {
            String code;
            Boolean compileFail = false;
            Boolean linkFail = false;
            TProgram program = new TProgram();
            String[] names = new String[]{filename};
            try {
                BufferedReader spvReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
                code = spvReader.lines().collect(Collectors.joining("\n"));
                spvReader.close();
            }
            catch (NullPointerException e) {
                continue;
            }
            String[] dummyShader = new String[]{code};
            String extension = filename.substring(filename.lastIndexOf(46) + 1);
            int shaderType = 0;
            switch (extension) {
                case "vert": {
                    shaderType = EShLanguage.EShLangVertex;
                    break;
                }
                case "frag": {
                    shaderType = EShLanguage.EShLangFragment;
                    break;
                }
                case "geom": {
                    shaderType = EShLanguage.EShLangGeometry;
                    break;
                }
                case "tesc": {
                    shaderType = EShLanguage.EShLangTessControl;
                    break;
                }
                case "tese": {
                    shaderType = EShLanguage.EShLangTessEvaluation;
                    break;
                }
                case "comp": {
                    shaderType = EShLanguage.EShLangCompute;
                    break;
                }
                case "txt": {
                    continue block20;
                }
                default: {
                    throw new RuntimeException("Unknown shader extension ." + extension);
                }
            }
            TShader shader = new TShader(shaderType);
            System.out.println(filename + ": Compiling shader code  (" + dummyShader[0].length() + " bytes)... ");
            Boolean shouldFail = code.contains("ERROR");
            if (shouldFail.booleanValue()) {
                System.out.println("This file is expected not to compile successfully.");
            }
            shader.setStrings(dummyShader, 1);
            shader.setAutoMapBindings(true);
            int messages = EShMessages.EShMsgDefault;
            messages |= EShMessages.EShMsgVulkanRules;
            if (!shader.parse(resources, 450, false, messages |= EShMessages.EShMsgSpvRules)) {
                compileFail = true;
            }
            if (compileFail.booleanValue() && !shouldFail.booleanValue()) {
                System.out.println("Info log: " + shader.getInfoLog());
                System.out.println("Debug log: " + shader.getInfoDebugLog());
                throw new RuntimeException("Compilation of " + filename + " failed");
            }
            if (compileFail.booleanValue() && shouldFail.booleanValue()) {
                System.out.println("Linking skipped as compilation was expected to fail...");
                continue;
            }
            program.addShader(shader);
            if (!program.link(EShMessages.EShMsgDefault)) {
                linkFail = true;
            }
            if (!program.mapIO()) {
                linkFail = true;
            }
            if (linkFail.booleanValue() && !shouldFail.booleanValue()) {
                System.err.println(program.getInfoLog());
                System.err.println(program.getInfoDebugLog());
                throw new RuntimeException("Linking of program " + filename + " failed!");
            }
            if (linkFail.booleanValue() || compileFail.booleanValue() || shouldFail.booleanValue()) continue;
            IntVec spirv = new IntVec();
            libspirvcrossj.glslangToSpv((SWIGTYPE_p_glslang__TIntermediate)program.getIntermediate(shaderType), (IntVec)spirv);
            System.out.println("Generated " + spirv.capacity() + " bytes of SPIRV bytecode.");
        }
        libspirvcrossj.finalizeProcess();
    }
}

