/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif



#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13




#include <typeinfo>
#include <stdexcept>


#include <vector>
#include <stdexcept>


#include <stdint.h>		// Use the C99 official header


#include <string>


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <typeinfo>
#include <stdexcept>


static int *new_IntPointer() { 
  return new int(); 
}

static int *copy_IntPointer(int value) { 
  return new int(value); 
}

static void delete_IntPointer(int *obj) { 
  if (obj) delete obj; 
}

static void IntPointer_assign(int *obj, int value) {
  *obj = value;
}

static int IntPointer_value(int *obj) {
  return *obj;
}


static std::string *new_StringPointer() { 
  return new std::string(); 
}

static std::string *copy_StringPointer(std::string value) { 
  return new std::string(value); 
}

static void delete_StringPointer(std::string *obj) { 
  if (obj) delete obj; 
}

static void StringPointer_assign(std::string *obj, std::string value) {
  *obj = value;
}

static std::string StringPointer_value(std::string *obj) {
  return *obj;
}


    #include <stdexcept>
    #include "spirv.hpp"
    #include "spirv_cfg.hpp"
    #include "spirv_cross.hpp"
    #include "spirv_cross_util.hpp"
    #include "spirv_parser.hpp"
    #include "spirv_cross_parsed_ir.hpp"
    #include "spirv_common.hpp"
    #include "spirv_glsl.hpp"
    #include "spirv_cpp.hpp"
    #include "spirv_msl.hpp"
    #include "spirv_reflect.hpp"

    #include "ShHandle.h" 
    #include "revision.h" 
    #include "ShaderLang.h" 
    #include "../../StandAlone/ResourceLimits.h"
    #include "../MachineIndependent/Versions.h"
    #include "GlslangToSpv.h" 
    #include "GLSL.std.450.h" 
    #include "disassemble.h"
    #include "SPVRemapper.h"

    using namespace spirv_cross;
    using namespace glslang;

SWIGINTERN std::vector< std::string >::const_reference std_vector_Sl_std_string_Sg__get(std::vector< std::string > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_std_string_Sg__set(std::vector< std::string > *self,int i,std::vector< std::string >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< unsigned int >::const_reference std_vector_Sl_uint32_t_Sg__get(std::vector< uint32_t > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_uint32_t_Sg__set(std::vector< uint32_t > *self,int i,std::vector< unsigned int >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< spirv_cross::Resource >::const_reference std_vector_Sl_spirv_cross_Resource_Sg__get(std::vector< spirv_cross::Resource > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_spirv_cross_Resource_Sg__set(std::vector< spirv_cross::Resource > *self,int i,std::vector< spirv_cross::Resource >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< spirv_cross::BufferRange >::const_reference std_vector_Sl_spirv_cross_BufferRange_Sg__get(std::vector< spirv_cross::BufferRange > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_spirv_cross_BufferRange_Sg__set(std::vector< spirv_cross::BufferRange > *self,int i,std::vector< spirv_cross::BufferRange >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< spirv_cross::CombinedImageSampler >::const_reference std_vector_Sl_spirv_cross_CombinedImageSampler_Sg__get(std::vector< spirv_cross::CombinedImageSampler > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_spirv_cross_CombinedImageSampler_Sg__set(std::vector< spirv_cross::CombinedImageSampler > *self,int i,std::vector< spirv_cross::CombinedImageSampler >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< spirv_cross::MSLResourceBinding >::const_reference std_vector_Sl_spirv_cross_MSLResourceBinding_Sg__get(std::vector< spirv_cross::MSLResourceBinding > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_spirv_cross_MSLResourceBinding_Sg__set(std::vector< spirv_cross::MSLResourceBinding > *self,int i,std::vector< spirv_cross::MSLResourceBinding >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< spirv_cross::MSLVertexAttr >::const_reference std_vector_Sl_spirv_cross_MSLVertexAttr_Sg__get(std::vector< spirv_cross::MSLVertexAttr > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_spirv_cross_MSLVertexAttr_Sg__set(std::vector< spirv_cross::MSLVertexAttr > *self,int i,std::vector< spirv_cross::MSLVertexAttr >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< spirv_cross::SpecializationConstant >::const_reference std_vector_Sl_spirv_cross_SpecializationConstant_Sg__get(std::vector< spirv_cross::SpecializationConstant > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_spirv_cross_SpecializationConstant_Sg__set(std::vector< spirv_cross::SpecializationConstant > *self,int i,std::vector< spirv_cross::SpecializationConstant >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN std::vector< spirv_cross::PlsRemap >::const_reference std_vector_Sl_spirv_cross_PlsRemap_Sg__get(std::vector< spirv_cross::PlsRemap > *self,int i){
                int size = int(self->size());
                if (i>=0 && i<size)
                    return (*self)[i];
                else
                    throw std::out_of_range("vector index out of range");
            }
SWIGINTERN void std_vector_Sl_spirv_cross_PlsRemap_Sg__set(std::vector< spirv_cross::PlsRemap > *self,int i,std::vector< spirv_cross::PlsRemap >::value_type const &val){
                int size = int(self->size());
                if (i>=0 && i<size)
                    (*self)[i] = val;
                else
                    throw std::out_of_range("vector index out of range");
            }

#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_newIntPointer(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (int *)new_IntPointer();
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_copyIntPointer(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int *)copy_IntPointer(arg1);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_deleteIntPointer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  int *arg1 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  delete_IntPointer(arg1);
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_intPointerAssign(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  int *arg1 = (int *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  arg2 = (int)jarg2; 
  IntPointer_assign(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_intPointerValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  int *arg1 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  result = (int)IntPointer_value(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_newStringPointer(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (std::string *)new_StringPointer();
  *(std::string **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_copyStringPointer(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string arg1 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  (&arg1)->assign(arg1_pstr);
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  result = (std::string *)copy_StringPointer(arg1);
  *(std::string **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_deleteStringPointer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::string *arg1 = (std::string *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::string **)&jarg1; 
  delete_StringPointer(arg1);
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_stringPointerAssign(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  std::string *arg1 = (std::string *) 0 ;
  std::string arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::string **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  StringPointer_assign(arg1,arg2);
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_stringPointerValue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  std::string *arg1 = (std::string *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::string **)&jarg1; 
  result = StringPointer_value(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_magicNumber_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(unsigned int)spv::MagicNumber;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_version_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(unsigned int)spv::Version;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_revision_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(unsigned int)spv::Revision;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_opCodeMask_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(unsigned int)spv::OpCodeMask;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_wordCountShift_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  result = (unsigned int)(unsigned int)spv::WordCountShift;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_op_1or_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jint jresult = 0 ;
  spv::ImageOperandsMask arg1 ;
  spv::ImageOperandsMask arg2 ;
  spv::ImageOperandsMask result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (spv::ImageOperandsMask)jarg1; 
  arg2 = (spv::ImageOperandsMask)jarg2; 
  {
    try {
      result = (spv::ImageOperandsMask)spv::operator |(arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spv::operator |(spv::ImageOperandsMask,spv::ImageOperandsMask)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerError(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  spirv_cross::CompilerError *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (spirv_cross::CompilerError *)new spirv_cross::CompilerError((std::string const &)*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerError::CompilerError(std::string const &)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerError **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1CompilerError(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::CompilerError *arg1 = (spirv_cross::CompilerError *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::CompilerError **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerError::~CompilerError()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1Bitset_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::Bitset *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::Bitset *)new spirv_cross::Bitset();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::Bitset()"); return 0; 
      };
    }
  }
  *(spirv_cross::Bitset **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1Bitset_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  uint64_t arg1 ;
  spirv_cross::Bitset *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg1);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg1, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg1 = 0;
    if (sz > 0) {
      arg1 = (uint64_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg1 = (arg1 << 8) | (uint64_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  {
    try {
      result = (spirv_cross::Bitset *)new spirv_cross::Bitset(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::Bitset(uint64_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::Bitset **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Bitset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  spirv_cross::Bitset *arg1 = (spirv_cross::Bitset *) 0 ;
  uint32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Bitset **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (bool)((spirv_cross::Bitset const *)arg1)->get(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::get(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Bitset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::Bitset *arg1 = (spirv_cross::Bitset *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Bitset **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      (arg1)->set(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::set(uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Bitset_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::Bitset *arg1 = (spirv_cross::Bitset *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Bitset **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      (arg1)->clear(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::clear(uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT jobject JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Bitset_1getLower(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  spirv_cross::Bitset *arg1 = (spirv_cross::Bitset *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Bitset **)&jarg1; 
  {
    try {
      result = (uint64_t)((spirv_cross::Bitset const *)arg1)->get_lower();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::get_lower() const"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Bitset_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  spirv_cross::Bitset *arg1 = (spirv_cross::Bitset *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Bitset **)&jarg1; 
  {
    try {
      (arg1)->reset();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::reset()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Bitset_1mergeAnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::Bitset *arg1 = (spirv_cross::Bitset *) 0 ;
  spirv_cross::Bitset *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::Bitset **)&jarg1; 
  arg2 = *(spirv_cross::Bitset **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::Bitset const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->merge_and((spirv_cross::Bitset const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::merge_and(spirv_cross::Bitset const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Bitset_1mergeOr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::Bitset *arg1 = (spirv_cross::Bitset *) 0 ;
  spirv_cross::Bitset *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::Bitset **)&jarg1; 
  arg2 = *(spirv_cross::Bitset **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::Bitset const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->merge_or((spirv_cross::Bitset const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::merge_or(spirv_cross::Bitset const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Bitset_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  spirv_cross::Bitset *arg1 = (spirv_cross::Bitset *) 0 ;
  spirv_cross::Bitset *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::Bitset **)&jarg1; 
  arg2 = *(spirv_cross::Bitset **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::Bitset const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)((spirv_cross::Bitset const *)arg1)->operator ==((spirv_cross::Bitset const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::operator ==(spirv_cross::Bitset const &) const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Bitset_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::Bitset *arg1 = (spirv_cross::Bitset *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Bitset **)&jarg1; 
  {
    try {
      result = (bool)((spirv_cross::Bitset const *)arg1)->empty();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::empty() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1Bitset(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::Bitset *arg1 = (spirv_cross::Bitset *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::Bitset **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Bitset::~Bitset()"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_merge(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::string > const & reference is null");
    return 0;
  } 
  {
    try {
      result = spirv_cross::merge((std::vector< std::string > const &)*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::merge(std::vector< std::string > const &)"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_convertToString_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jstring jresult = 0 ;
  float arg1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (float)jarg1; 
  {
    try {
      result = spirv_cross::convert_to_string(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::convert_to_string(float)"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_convertToString_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jstring jresult = 0 ;
  double arg1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = spirv_cross::convert_to_string(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::convert_to_string(double)"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Instruction_1op_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::Instruction *arg1 = (spirv_cross::Instruction *) 0 ;
  uint16_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Instruction **)&jarg1; 
  arg2 = (uint16_t)jarg2; 
  if (arg1) (arg1)->op = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Instruction_1op_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::Instruction *arg1 = (spirv_cross::Instruction *) 0 ;
  uint16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Instruction **)&jarg1; 
  result = (uint16_t) ((arg1)->op);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Instruction_1count_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::Instruction *arg1 = (spirv_cross::Instruction *) 0 ;
  uint16_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Instruction **)&jarg1; 
  arg2 = (uint16_t)jarg2; 
  if (arg1) (arg1)->count = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Instruction_1count_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::Instruction *arg1 = (spirv_cross::Instruction *) 0 ;
  uint16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Instruction **)&jarg1; 
  result = (uint16_t) ((arg1)->count);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Instruction_1offset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::Instruction *arg1 = (spirv_cross::Instruction *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Instruction **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->offset = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Instruction_1offset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Instruction *arg1 = (spirv_cross::Instruction *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Instruction **)&jarg1; 
  result = (uint32_t) ((arg1)->offset);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Instruction_1length_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::Instruction *arg1 = (spirv_cross::Instruction *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Instruction **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->length = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Instruction_1length_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Instruction *arg1 = (spirv_cross::Instruction *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Instruction **)&jarg1; 
  result = (uint32_t) ((arg1)->length);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1Instruction(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::Instruction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::Instruction *)new spirv_cross::Instruction();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Instruction::Instruction()"); return 0; 
      };
    }
  }
  *(spirv_cross::Instruction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1Instruction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::Instruction *arg1 = (spirv_cross::Instruction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::Instruction **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Instruction::~Instruction()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRUndef(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  spirv_cross::SPIRUndef *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  {
    try {
      result = (spirv_cross::SPIRUndef *)new spirv_cross::SPIRUndef(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRUndef::SPIRUndef(uint32_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRUndef **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRUndef_1basetype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRUndef *arg1 = (spirv_cross::SPIRUndef *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRUndef **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->basetype = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRUndef_1basetype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRUndef *arg1 = (spirv_cross::SPIRUndef *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRUndef **)&jarg1; 
  result = (uint32_t) ((arg1)->basetype);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRUndef(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRUndef *arg1 = (spirv_cross::SPIRUndef *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRUndef **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRUndef::~SPIRUndef()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRCombinedImageSampler(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spirv_cross::SPIRCombinedImageSampler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (spirv_cross::SPIRCombinedImageSampler *)new spirv_cross::SPIRCombinedImageSampler(arg1,arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRCombinedImageSampler::SPIRCombinedImageSampler(uint32_t,uint32_t,uint32_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRCombinedImageSampler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRCombinedImageSampler_1combinedType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRCombinedImageSampler *arg1 = (spirv_cross::SPIRCombinedImageSampler *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRCombinedImageSampler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->combined_type = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRCombinedImageSampler_1combinedType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRCombinedImageSampler *arg1 = (spirv_cross::SPIRCombinedImageSampler *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRCombinedImageSampler **)&jarg1; 
  result = (uint32_t) ((arg1)->combined_type);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRCombinedImageSampler_1image_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRCombinedImageSampler *arg1 = (spirv_cross::SPIRCombinedImageSampler *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRCombinedImageSampler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->image = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRCombinedImageSampler_1image_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRCombinedImageSampler *arg1 = (spirv_cross::SPIRCombinedImageSampler *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRCombinedImageSampler **)&jarg1; 
  result = (uint32_t) ((arg1)->image);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRCombinedImageSampler_1sampler_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRCombinedImageSampler *arg1 = (spirv_cross::SPIRCombinedImageSampler *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRCombinedImageSampler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->sampler = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRCombinedImageSampler_1sampler_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRCombinedImageSampler *arg1 = (spirv_cross::SPIRCombinedImageSampler *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRCombinedImageSampler **)&jarg1; 
  result = (uint32_t) ((arg1)->sampler);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRCombinedImageSampler(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRCombinedImageSampler *arg1 = (spirv_cross::SPIRCombinedImageSampler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRCombinedImageSampler **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRCombinedImageSampler::~SPIRCombinedImageSampler()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRConstantOp(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  spv::Op arg2 ;
  uint32_t *arg3 = (uint32_t *) 0 ;
  uint32_t arg4 ;
  spirv_cross::SPIRConstantOp *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (spv::Op)jarg2; 
  arg3 = *(uint32_t **)&jarg3; 
  arg4 = (uint32_t)jarg4; 
  {
    try {
      result = (spirv_cross::SPIRConstantOp *)new spirv_cross::SPIRConstantOp(arg1,arg2,(uint32_t const *)arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstantOp::SPIRConstantOp(uint32_t,spv::Op,uint32_t const *,uint32_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstantOp **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstantOp_1opcode_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::SPIRConstantOp *arg1 = (spirv_cross::SPIRConstantOp *) 0 ;
  spv::Op arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstantOp **)&jarg1; 
  arg2 = (spv::Op)jarg2; 
  if (arg1) (arg1)->opcode = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstantOp_1opcode_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIRConstantOp *arg1 = (spirv_cross::SPIRConstantOp *) 0 ;
  spv::Op result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstantOp **)&jarg1; 
  result = (spv::Op) ((arg1)->opcode);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstantOp_1arguments_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRConstantOp *arg1 = (spirv_cross::SPIRConstantOp *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRConstantOp **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->arguments = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstantOp_1arguments_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstantOp *arg1 = (spirv_cross::SPIRConstantOp *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstantOp **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->arguments);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstantOp_1basetype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRConstantOp *arg1 = (spirv_cross::SPIRConstantOp *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstantOp **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->basetype = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstantOp_1basetype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstantOp *arg1 = (spirv_cross::SPIRConstantOp *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstantOp **)&jarg1; 
  result = (uint32_t) ((arg1)->basetype);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRConstantOp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRConstantOp *arg1 = (spirv_cross::SPIRConstantOp *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRConstantOp **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstantOp::~SPIRConstantOp()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1basetype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  spirv_cross::SPIRType::BaseType arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = (spirv_cross::SPIRType::BaseType)jarg2; 
  if (arg1) (arg1)->basetype = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1basetype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  spirv_cross::SPIRType::BaseType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (spirv_cross::SPIRType::BaseType) ((arg1)->basetype);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1width_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->width = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1width_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (uint32_t) ((arg1)->width);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1vecsize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->vecsize = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1vecsize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (uint32_t) ((arg1)->vecsize);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1columns_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->columns = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1columns_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (uint32_t) ((arg1)->columns);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1array_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->array = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1array_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->array);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1arraySizeLiteral_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  std::vector< bool > *arg2 = (std::vector< bool > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = *(std::vector< bool > **)&jarg2; 
  if (arg1) (arg1)->array_size_literal = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1arraySizeLiteral_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  std::vector< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (std::vector< bool > *)& ((arg1)->array_size_literal);
  *(std::vector< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1pointerDepth_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->pointer_depth = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1pointerDepth_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (uint32_t) ((arg1)->pointer_depth);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1pointer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->pointer = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1pointer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (bool) ((arg1)->pointer);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1storage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  spv::StorageClass arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = (spv::StorageClass)jarg2; 
  if (arg1) (arg1)->storage = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1storage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  spv::StorageClass result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (spv::StorageClass) ((arg1)->storage);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1memberTypes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->member_types = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1memberTypes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->member_types);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  result = (uint32_t) ((arg1)->type);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1dim_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  spv::Dim arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  arg2 = (spv::Dim)jarg2; 
  if (arg1) (arg1)->dim = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1dim_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  spv::Dim result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  result = (spv::Dim) ((arg1)->dim);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1depth_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->depth = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1depth_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  result = (bool) ((arg1)->depth);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1arrayed_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->arrayed = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1arrayed_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  result = (bool) ((arg1)->arrayed);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1ms_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->ms = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1ms_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  result = (bool) ((arg1)->ms);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1sampled_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->sampled = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1sampled_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  result = (uint32_t) ((arg1)->sampled);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1format_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  spv::ImageFormat arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  arg2 = (spv::ImageFormat)jarg2; 
  if (arg1) (arg1)->format = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  spv::ImageFormat result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  result = (spv::ImageFormat) ((arg1)->format);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1access_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  spv::AccessQualifier arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  arg2 = (spv::AccessQualifier)jarg2; 
  if (arg1) (arg1)->access = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1ImageType_1access_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  spv::AccessQualifier result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  result = (spv::AccessQualifier) ((arg1)->access);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRType_1ImageType(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType::ImageType *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::SPIRType::ImageType *)new spirv_cross::SPIRType::ImageType();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRType::ImageType::ImageType()"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRType::ImageType **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRType_1ImageType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRType::ImageType *arg1 = (spirv_cross::SPIRType::ImageType *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRType::ImageType **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRType::ImageType::~ImageType()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1image_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  spirv_cross::SPIRType::ImageType *arg2 = (spirv_cross::SPIRType::ImageType *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = *(spirv_cross::SPIRType::ImageType **)&jarg2; 
  if (arg1) (arg1)->image = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1image_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  spirv_cross::SPIRType::ImageType *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (spirv_cross::SPIRType::ImageType *)& ((arg1)->image);
  *(spirv_cross::SPIRType::ImageType **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1typeAlias_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->type_alias = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1typeAlias_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (uint32_t) ((arg1)->type_alias);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1parentType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->parent_type = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1parentType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (uint32_t) ((arg1)->parent_type);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1memberNameCache_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  std::unordered_set< std::string > *arg2 = (std::unordered_set< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  arg2 = *(std::unordered_set< std::string > **)&jarg2; 
  if (arg1) (arg1)->member_name_cache = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRType_1memberNameCache_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  std::unordered_set< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  result = (std::unordered_set< std::string > *)& ((arg1)->member_name_cache);
  *(std::unordered_set< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRType(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::SPIRType *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::SPIRType *)new spirv_cross::SPIRType();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRType::SPIRType()"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRType **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRType *arg1 = (spirv_cross::SPIRType *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRType **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRType::~SPIRType()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRExtension(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  spirv_cross::SPIRExtension::Extension arg1 ;
  spirv_cross::SPIRExtension *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (spirv_cross::SPIRExtension::Extension)jarg1; 
  {
    try {
      result = (spirv_cross::SPIRExtension *)new spirv_cross::SPIRExtension(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRExtension::SPIRExtension(spirv_cross::SPIRExtension::Extension)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRExtension **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExtension_1ext_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::SPIRExtension *arg1 = (spirv_cross::SPIRExtension *) 0 ;
  spirv_cross::SPIRExtension::Extension arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExtension **)&jarg1; 
  arg2 = (spirv_cross::SPIRExtension::Extension)jarg2; 
  if (arg1) (arg1)->ext = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExtension_1ext_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIRExtension *arg1 = (spirv_cross::SPIRExtension *) 0 ;
  spirv_cross::SPIRExtension::Extension result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExtension **)&jarg1; 
  result = (spirv_cross::SPIRExtension::Extension) ((arg1)->ext);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRExtension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRExtension *arg1 = (spirv_cross::SPIRExtension *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRExtension **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRExtension::~SPIRExtension()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIREntryPoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  spv::ExecutionModel arg2 ;
  std::string *arg3 = 0 ;
  spirv_cross::SPIREntryPoint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (spv::ExecutionModel)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = (spirv_cross::SPIREntryPoint *)new spirv_cross::SPIREntryPoint(arg1,arg2,(std::string const &)*arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIREntryPoint::SPIREntryPoint(uint32_t,spv::ExecutionModel,std::string const &)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIREntryPoint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIREntryPoint_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::SPIREntryPoint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::SPIREntryPoint *)new spirv_cross::SPIREntryPoint();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIREntryPoint::SPIREntryPoint()"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIREntryPoint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1self_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->self = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1self_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  result = (uint32_t) ((arg1)->self);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->name = *arg2;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  result = (std::string *) & ((arg1)->name);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1origName_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->orig_name = *arg2;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1origName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  result = (std::string *) & ((arg1)->orig_name);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1interfaceVariables_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->interface_variables = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1interfaceVariables_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->interface_variables);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1flags_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  spirv_cross::Bitset *arg2 = (spirv_cross::Bitset *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  arg2 = *(spirv_cross::Bitset **)&jarg2; 
  if (arg1) (arg1)->flags = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1flags_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  spirv_cross::Bitset *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  result = (spirv_cross::Bitset *)& ((arg1)->flags);
  *(spirv_cross::Bitset **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1invocations_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->invocations = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1invocations_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  result = (uint32_t) ((arg1)->invocations);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1outputVertices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->output_vertices = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1outputVertices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  result = (uint32_t) ((arg1)->output_vertices);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1model_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  spv::ExecutionModel arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  arg2 = (spv::ExecutionModel)jarg2; 
  if (arg1) (arg1)->model = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIREntryPoint_1model_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  spv::ExecutionModel result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  result = (spv::ExecutionModel) ((arg1)->model);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIREntryPoint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIREntryPoint *arg1 = (spirv_cross::SPIREntryPoint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIREntryPoint **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIREntryPoint::~SPIREntryPoint()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRExpression(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  std::string arg1 ;
  uint32_t arg2 ;
  bool arg3 ;
  spirv_cross::SPIRExpression *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  } 
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  (&arg1)->assign(arg1_pstr);
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (uint32_t)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (spirv_cross::SPIRExpression *)new spirv_cross::SPIRExpression(arg1,arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRExpression::SPIRExpression(std::string,uint32_t,bool)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRExpression **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1baseExpression_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->base_expression = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1baseExpression_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  result = (uint32_t) ((arg1)->base_expression);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1expression_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->expression = *arg2;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1expression_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  result = (std::string *) & ((arg1)->expression);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1expressionType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->expression_type = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1expressionType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  result = (uint32_t) ((arg1)->expression_type);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1loadedFrom_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->loaded_from = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1loadedFrom_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  result = (uint32_t) ((arg1)->loaded_from);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1immutable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->immutable = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1immutable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  result = (bool) ((arg1)->immutable);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1needTranspose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->need_transpose = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1needTranspose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  result = (bool) ((arg1)->need_transpose);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1accessChain_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->access_chain = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1accessChain_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  result = (bool) ((arg1)->access_chain);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1expressionDependencies_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->expression_dependencies = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1expressionDependencies_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->expression_dependencies);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1impliedReadExpressions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->implied_read_expressions = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRExpression_1impliedReadExpressions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->implied_read_expressions);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRExpression(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRExpression *arg1 = (spirv_cross::SPIRExpression *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRExpression **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRExpression::~SPIRExpression()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRFunctionPrototype(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  spirv_cross::SPIRFunctionPrototype *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  {
    try {
      result = (spirv_cross::SPIRFunctionPrototype *)new spirv_cross::SPIRFunctionPrototype(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRFunctionPrototype::SPIRFunctionPrototype(uint32_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRFunctionPrototype **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunctionPrototype_1returnType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunctionPrototype *arg1 = (spirv_cross::SPIRFunctionPrototype *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunctionPrototype **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->return_type = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunctionPrototype_1returnType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunctionPrototype *arg1 = (spirv_cross::SPIRFunctionPrototype *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunctionPrototype **)&jarg1; 
  result = (uint32_t) ((arg1)->return_type);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunctionPrototype_1parameterTypes_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRFunctionPrototype *arg1 = (spirv_cross::SPIRFunctionPrototype *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRFunctionPrototype **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->parameter_types = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunctionPrototype_1parameterTypes_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunctionPrototype *arg1 = (spirv_cross::SPIRFunctionPrototype *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunctionPrototype **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->parameter_types);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRFunctionPrototype(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRFunctionPrototype *arg1 = (spirv_cross::SPIRFunctionPrototype *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRFunctionPrototype **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRFunctionPrototype::~SPIRFunctionPrototype()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint32_t arg2 ;
  spirv_cross::SPIRFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (spirv_cross::SPIRFunction *)new spirv_cross::SPIRFunction(arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRFunction::SPIRFunction(uint32_t,uint32_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1Parameter_1type_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction::Parameter *arg1 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::Parameter **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->type = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1Parameter_1type_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction::Parameter *arg1 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::Parameter **)&jarg1; 
  result = (uint32_t) ((arg1)->type);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1Parameter_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction::Parameter *arg1 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::Parameter **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1Parameter_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction::Parameter *arg1 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::Parameter **)&jarg1; 
  result = (uint32_t) ((arg1)->id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1Parameter_1readCount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction::Parameter *arg1 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::Parameter **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->read_count = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1Parameter_1readCount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction::Parameter *arg1 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::Parameter **)&jarg1; 
  result = (uint32_t) ((arg1)->read_count);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1Parameter_1writeCount_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction::Parameter *arg1 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::Parameter **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->write_count = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1Parameter_1writeCount_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction::Parameter *arg1 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::Parameter **)&jarg1; 
  result = (uint32_t) ((arg1)->write_count);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1Parameter_1aliasGlobalVariable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRFunction::Parameter *arg1 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::Parameter **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->alias_global_variable = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1Parameter_1aliasGlobalVariable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRFunction::Parameter *arg1 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::Parameter **)&jarg1; 
  result = (bool) ((arg1)->alias_global_variable);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRFunction_1Parameter(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction::Parameter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::SPIRFunction::Parameter *)new spirv_cross::SPIRFunction::Parameter();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRFunction::Parameter::Parameter()"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRFunction::Parameter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRFunction_1Parameter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRFunction::Parameter *arg1 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRFunction::Parameter **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRFunction::Parameter::~Parameter()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  result = (uint32_t) ((arg1)->id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1imageId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->image_id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1imageId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  result = (uint32_t) ((arg1)->image_id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1samplerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->sampler_id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1samplerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  result = (uint32_t) ((arg1)->sampler_id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1globalImage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->global_image = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1globalImage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  result = (bool) ((arg1)->global_image);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1globalSampler_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->global_sampler = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1globalSampler_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  result = (bool) ((arg1)->global_sampler);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1depth_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->depth = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1CombinedImageSamplerParameter_1depth_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  result = (bool) ((arg1)->depth);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRFunction_1CombinedImageSamplerParameter(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *)new spirv_cross::SPIRFunction::CombinedImageSamplerParameter();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRFunction::CombinedImageSamplerParameter::CombinedImageSamplerParameter()"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRFunction_1CombinedImageSamplerParameter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRFunction::CombinedImageSamplerParameter *arg1 = (spirv_cross::SPIRFunction::CombinedImageSamplerParameter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRFunction::CombinedImageSamplerParameter **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRFunction::CombinedImageSamplerParameter::~CombinedImageSamplerParameter()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1returnType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->return_type = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1returnType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (uint32_t) ((arg1)->return_type);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1functionType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->function_type = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1functionType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (uint32_t) ((arg1)->function_type);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1arguments_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< spirv_cross::SPIRFunction::Parameter > *arg2 = (std::vector< spirv_cross::SPIRFunction::Parameter > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::SPIRFunction::Parameter > **)&jarg2; 
  if (arg1) (arg1)->arguments = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1arguments_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< spirv_cross::SPIRFunction::Parameter > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (std::vector< spirv_cross::SPIRFunction::Parameter > *)& ((arg1)->arguments);
  *(std::vector< spirv_cross::SPIRFunction::Parameter > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1shadowArguments_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< spirv_cross::SPIRFunction::Parameter > *arg2 = (std::vector< spirv_cross::SPIRFunction::Parameter > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::SPIRFunction::Parameter > **)&jarg2; 
  if (arg1) (arg1)->shadow_arguments = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1shadowArguments_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< spirv_cross::SPIRFunction::Parameter > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (std::vector< spirv_cross::SPIRFunction::Parameter > *)& ((arg1)->shadow_arguments);
  *(std::vector< spirv_cross::SPIRFunction::Parameter > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1localVariables_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->local_variables = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1localVariables_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->local_variables);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1entryBlock_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->entry_block = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1entryBlock_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (uint32_t) ((arg1)->entry_block);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1blocks_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->blocks = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1blocks_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->blocks);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1combinedParameters_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< spirv_cross::SPIRFunction::CombinedImageSamplerParameter > *arg2 = (std::vector< spirv_cross::SPIRFunction::CombinedImageSamplerParameter > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::SPIRFunction::CombinedImageSamplerParameter > **)&jarg2; 
  if (arg1) (arg1)->combined_parameters = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1combinedParameters_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< spirv_cross::SPIRFunction::CombinedImageSamplerParameter > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (std::vector< spirv_cross::SPIRFunction::CombinedImageSamplerParameter > *)& ((arg1)->combined_parameters);
  *(std::vector< spirv_cross::SPIRFunction::CombinedImageSamplerParameter > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1addLocalVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      (arg1)->add_local_variable(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRFunction::add_local_variable(uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1addParameter_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jboolean jarg4) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      (arg1)->add_parameter(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRFunction::add_parameter(uint32_t,uint32_t,bool)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1addParameter_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      (arg1)->add_parameter(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRFunction::add_parameter(uint32_t,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1fixupHooksOut_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< std::function< void () > > *arg2 = (std::vector< std::function< void () > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = *(std::vector< std::function< void () > > **)&jarg2; 
  if (arg1) (arg1)->fixup_hooks_out = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1fixupHooksOut_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< std::function< void () > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (std::vector< std::function< void () > > *)& ((arg1)->fixup_hooks_out);
  *(std::vector< std::function< void () > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1fixupHooksIn_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< std::function< void () > > *arg2 = (std::vector< std::function< void () > > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = *(std::vector< std::function< void () > > **)&jarg2; 
  if (arg1) (arg1)->fixup_hooks_in = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1fixupHooksIn_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< std::function< void () > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (std::vector< std::function< void () > > *)& ((arg1)->fixup_hooks_in);
  *(std::vector< std::function< void () > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1constantArraysNeededOnStack_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->constant_arrays_needed_on_stack = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1constantArraysNeededOnStack_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->constant_arrays_needed_on_stack);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1active_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->active = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1active_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (bool) ((arg1)->active);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1flushUndeclared_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->flush_undeclared = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1flushUndeclared_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (bool) ((arg1)->flush_undeclared);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1doCombinedParameters_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->do_combined_parameters = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRFunction_1doCombinedParameters_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  result = (bool) ((arg1)->do_combined_parameters);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRFunction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRFunction *arg1 = (spirv_cross::SPIRFunction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRFunction **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRFunction::~SPIRFunction()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRVariable_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::SPIRVariable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::SPIRVariable *)new spirv_cross::SPIRVariable();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRVariable::SPIRVariable()"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRVariable **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRVariable_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  spv::StorageClass arg2 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  spirv_cross::SPIRVariable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (spv::StorageClass)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  {
    try {
      result = (spirv_cross::SPIRVariable *)new spirv_cross::SPIRVariable(arg1,arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRVariable::SPIRVariable(uint32_t,spv::StorageClass,uint32_t,uint32_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRVariable **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRVariable_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  spv::StorageClass arg2 ;
  uint32_t arg3 ;
  spirv_cross::SPIRVariable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (spv::StorageClass)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (spirv_cross::SPIRVariable *)new spirv_cross::SPIRVariable(arg1,arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRVariable::SPIRVariable(uint32_t,spv::StorageClass,uint32_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRVariable **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRVariable_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  spv::StorageClass arg2 ;
  spirv_cross::SPIRVariable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (spv::StorageClass)jarg2; 
  {
    try {
      result = (spirv_cross::SPIRVariable *)new spirv_cross::SPIRVariable(arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRVariable::SPIRVariable(uint32_t,spv::StorageClass)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRVariable **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1basetype_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->basetype = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1basetype_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (uint32_t) ((arg1)->basetype);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1storage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  spv::StorageClass arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = (spv::StorageClass)jarg2; 
  if (arg1) (arg1)->storage = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1storage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  spv::StorageClass result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (spv::StorageClass) ((arg1)->storage);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1decoration_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->decoration = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1decoration_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (uint32_t) ((arg1)->decoration);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1initializer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->initializer = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1initializer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (uint32_t) ((arg1)->initializer);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1basevariable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->basevariable = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1basevariable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (uint32_t) ((arg1)->basevariable);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1dereferenceChain_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->dereference_chain = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1dereferenceChain_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->dereference_chain);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1compatBuiltin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->compat_builtin = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1compatBuiltin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (bool) ((arg1)->compat_builtin);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1staticallyAssigned_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->statically_assigned = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1staticallyAssigned_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (bool) ((arg1)->statically_assigned);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1staticExpression_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->static_expression = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1staticExpression_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (uint32_t) ((arg1)->static_expression);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1dependees_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->dependees = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1dependees_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->dependees);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1forwardable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->forwardable = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1forwardable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (bool) ((arg1)->forwardable);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1deferredDeclaration_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->deferred_declaration = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1deferredDeclaration_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (bool) ((arg1)->deferred_declaration);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1phiVariable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->phi_variable = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1phiVariable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (bool) ((arg1)->phi_variable);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1allocateTemporaryCopy_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->allocate_temporary_copy = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1allocateTemporaryCopy_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (bool) ((arg1)->allocate_temporary_copy);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1remappedVariable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->remapped_variable = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1remappedVariable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (bool) ((arg1)->remapped_variable);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1remappedComponents_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->remapped_components = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1remappedComponents_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (uint32_t) ((arg1)->remapped_components);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1dominator_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->dominator = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1dominator_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (uint32_t) ((arg1)->dominator);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1loopVariable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->loop_variable = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1loopVariable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (bool) ((arg1)->loop_variable);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1loopVariableEnable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->loop_variable_enable = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1loopVariableEnable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (bool) ((arg1)->loop_variable_enable);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1parameter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  spirv_cross::SPIRFunction::Parameter *arg2 = (spirv_cross::SPIRFunction::Parameter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  arg2 = *(spirv_cross::SPIRFunction::Parameter **)&jarg2; 
  if (arg1) (arg1)->parameter = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRVariable_1parameter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  spirv_cross::SPIRFunction::Parameter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  result = (spirv_cross::SPIRFunction::Parameter *) ((arg1)->parameter);
  *(spirv_cross::SPIRFunction::Parameter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRVariable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRVariable *arg1 = (spirv_cross::SPIRVariable *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRVariable **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRVariable::~SPIRVariable()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1u32_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->u32 = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1u32_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  result = (uint32_t) ((arg1)->u32);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1i32_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  int32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  arg2 = (int32_t)jarg2; 
  if (arg1) (arg1)->i32 = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1i32_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  result = (int32_t) ((arg1)->i32);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1f32_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->f32 = arg2;
}


SWIGEXPORT jfloat JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1f32_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  result = (float) ((arg1)->f32);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1u64_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  uint64_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (uint64_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  if (arg1) (arg1)->u64 = arg2;
}


SWIGEXPORT jobject JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1u64_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  result = (uint64_t) ((arg1)->u64);
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1i64_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  int64_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  if (arg1) (arg1)->i64 = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1i64_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  result = (int64_t) ((arg1)->i64);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1f64_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->f64 = arg2;
}


SWIGEXPORT jdouble JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1Constant_1f64_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  result = (double) ((arg1)->f64);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRConstant_1Constant(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant::Constant *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::SPIRConstant::Constant *)new spirv_cross::SPIRConstant::Constant();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::Constant::Constant()"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstant::Constant **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRConstant_1Constant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRConstant::Constant *arg1 = (spirv_cross::SPIRConstant::Constant *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRConstant::Constant **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::Constant::~Constant()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantVector_1r_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRConstant::ConstantVector *arg1 = (spirv_cross::SPIRConstant::ConstantVector *) 0 ;
  spirv_cross::SPIRConstant::Constant *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantVector **)&jarg1; 
  arg2 = *(spirv_cross::SPIRConstant::Constant **)&jarg2; 
  {
    size_t ii;
    spirv_cross::SPIRConstant::Constant *b = (spirv_cross::SPIRConstant::Constant *) arg1->r;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((spirv_cross::SPIRConstant::Constant *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantVector_1r_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant::ConstantVector *arg1 = (spirv_cross::SPIRConstant::ConstantVector *) 0 ;
  spirv_cross::SPIRConstant::Constant *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantVector **)&jarg1; 
  result = (spirv_cross::SPIRConstant::Constant *)(spirv_cross::SPIRConstant::Constant *) ((arg1)->r);
  *(spirv_cross::SPIRConstant::Constant **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantVector_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  spirv_cross::SPIRConstant::ConstantVector *arg1 = (spirv_cross::SPIRConstant::ConstantVector *) 0 ;
  uint32_t *arg2 ;
  jlong *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantVector **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr2, (unsigned int **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    uint32_t *b = (uint32_t *) arg1->id;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((uint32_t *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUint(jenv, jarr2, (unsigned int *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jlongArray JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantVector_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlongArray jresult = 0 ;
  spirv_cross::SPIRConstant::ConstantVector *arg1 = (spirv_cross::SPIRConstant::ConstantVector *) 0 ;
  uint32_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantVector **)&jarg1; 
  result = (uint32_t *)(uint32_t *) ((arg1)->id);
  jresult = SWIG_JavaArrayOutUint(jenv, (unsigned int *)result, 4); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantVector_1vecsize_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRConstant::ConstantVector *arg1 = (spirv_cross::SPIRConstant::ConstantVector *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantVector **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->vecsize = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantVector_1vecsize_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant::ConstantVector *arg1 = (spirv_cross::SPIRConstant::ConstantVector *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantVector **)&jarg1; 
  result = (uint32_t) ((arg1)->vecsize);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRConstant_1ConstantVector(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant::ConstantVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::SPIRConstant::ConstantVector *)new spirv_cross::SPIRConstant::ConstantVector();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::ConstantVector::ConstantVector()"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstant::ConstantVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRConstant_1ConstantVector(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRConstant::ConstantVector *arg1 = (spirv_cross::SPIRConstant::ConstantVector *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRConstant::ConstantVector **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::ConstantVector::~ConstantVector()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantMatrix_1c_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRConstant::ConstantMatrix *arg1 = (spirv_cross::SPIRConstant::ConstantMatrix *) 0 ;
  spirv_cross::SPIRConstant::ConstantVector *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantMatrix **)&jarg1; 
  arg2 = *(spirv_cross::SPIRConstant::ConstantVector **)&jarg2; 
  {
    size_t ii;
    spirv_cross::SPIRConstant::ConstantVector *b = (spirv_cross::SPIRConstant::ConstantVector *) arg1->c;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((spirv_cross::SPIRConstant::ConstantVector *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantMatrix_1c_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant::ConstantMatrix *arg1 = (spirv_cross::SPIRConstant::ConstantMatrix *) 0 ;
  spirv_cross::SPIRConstant::ConstantVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantMatrix **)&jarg1; 
  result = (spirv_cross::SPIRConstant::ConstantVector *)(spirv_cross::SPIRConstant::ConstantVector *) ((arg1)->c);
  *(spirv_cross::SPIRConstant::ConstantVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantMatrix_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlongArray jarg2) {
  spirv_cross::SPIRConstant::ConstantMatrix *arg1 = (spirv_cross::SPIRConstant::ConstantMatrix *) 0 ;
  uint32_t *arg2 ;
  jlong *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantMatrix **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInUint(jenv, &jarr2, (unsigned int **)&arg2, jarg2)) return ; 
  {
    size_t ii;
    uint32_t *b = (uint32_t *) arg1->id;
    for (ii = 0; ii < (size_t)4; ii++) b[ii] = *((uint32_t *) arg2 + ii);
  }
  SWIG_JavaArrayArgoutUint(jenv, jarr2, (unsigned int *)arg2, jarg2); 
  delete [] arg2; 
}


SWIGEXPORT jlongArray JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantMatrix_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlongArray jresult = 0 ;
  spirv_cross::SPIRConstant::ConstantMatrix *arg1 = (spirv_cross::SPIRConstant::ConstantMatrix *) 0 ;
  uint32_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantMatrix **)&jarg1; 
  result = (uint32_t *)(uint32_t *) ((arg1)->id);
  jresult = SWIG_JavaArrayOutUint(jenv, (unsigned int *)result, 4); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantMatrix_1columns_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRConstant::ConstantMatrix *arg1 = (spirv_cross::SPIRConstant::ConstantMatrix *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantMatrix **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->columns = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1ConstantMatrix_1columns_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant::ConstantMatrix *arg1 = (spirv_cross::SPIRConstant::ConstantMatrix *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant::ConstantMatrix **)&jarg1; 
  result = (uint32_t) ((arg1)->columns);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRConstant_1ConstantMatrix(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant::ConstantMatrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::SPIRConstant::ConstantMatrix *)new spirv_cross::SPIRConstant::ConstantMatrix();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::ConstantMatrix::ConstantMatrix()"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstant::ConstantMatrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRConstant_1ConstantMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRConstant::ConstantMatrix *arg1 = (spirv_cross::SPIRConstant::ConstantMatrix *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRConstant::ConstantMatrix **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::ConstantMatrix::~ConstantMatrix()"); return ; 
      };
    }
  }
}


SWIGEXPORT jfloat JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1f16ToF32(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jfloat jresult = 0 ;
  uint16_t arg1 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint16_t)jarg1; 
  {
    try {
      result = (float)spirv_cross::SPIRConstant::f16_to_f32(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::f16_to_f32(uint16_t)"); return 0; 
      };
    }
  }
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1specializationConstantId_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint32_t)((spirv_cross::SPIRConstant const *)arg1)->specialization_constant_id(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::specialization_constant_id(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1specializationConstantId_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (uint32_t)((spirv_cross::SPIRConstant const *)arg1)->specialization_constant_id(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::specialization_constant_id(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalar_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint32_t)((spirv_cross::SPIRConstant const *)arg1)->scalar(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalar_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (uint32_t)((spirv_cross::SPIRConstant const *)arg1)->scalar(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalar_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (uint32_t)((spirv_cross::SPIRConstant const *)arg1)->scalar();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI16_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jshort jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  int16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (int16_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i16(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i16(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI16_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jshort jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  int16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (int16_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i16(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i16(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI16_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  int16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (int16_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i16();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i16() const"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarU16_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  uint16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint16_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_u16(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_u16(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarU16_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (uint16_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_u16(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_u16(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarU16_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (uint16_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_u16();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_u16() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jbyte JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI8_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jbyte jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  int8_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (int8_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i8(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i8(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jbyte)result; 
  return jresult;
}


SWIGEXPORT jbyte JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI8_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jbyte jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  int8_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (int8_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i8(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i8(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jbyte)result; 
  return jresult;
}


SWIGEXPORT jbyte JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI8_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyte jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  int8_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (int8_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i8();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i8() const"); return 0; 
      };
    }
  }
  jresult = (jbyte)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarU8_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jshort jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint8_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_u8(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_u8(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarU8_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jshort jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (uint8_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_u8(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_u8(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarU8_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jshort jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (uint8_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_u8();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_u8() const"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarF16_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jfloat jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (float)((spirv_cross::SPIRConstant const *)arg1)->scalar_f16(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_f16(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarF16_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jfloat jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (float)((spirv_cross::SPIRConstant const *)arg1)->scalar_f16(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_f16(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarF16_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (float)((spirv_cross::SPIRConstant const *)arg1)->scalar_f16();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_f16() const"); return 0; 
      };
    }
  }
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarF32_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jfloat jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (float)((spirv_cross::SPIRConstant const *)arg1)->scalar_f32(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_f32(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarF32_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jfloat jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (float)((spirv_cross::SPIRConstant const *)arg1)->scalar_f32(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_f32(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarF32_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (float)((spirv_cross::SPIRConstant const *)arg1)->scalar_f32();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_f32() const"); return 0; 
      };
    }
  }
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI32_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (int32_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i32(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i32(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI32_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (int32_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i32(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i32(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI32_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (int32_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i32();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i32() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarF64_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (double)((spirv_cross::SPIRConstant const *)arg1)->scalar_f64(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_f64(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarF64_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jdouble jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (double)((spirv_cross::SPIRConstant const *)arg1)->scalar_f64(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_f64(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarF64_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (double)((spirv_cross::SPIRConstant const *)arg1)->scalar_f64();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_f64() const"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI64_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (int64_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i64(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i64(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI64_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (int64_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i64(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i64(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarI64_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (int64_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_i64();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_i64() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarU64_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jobject jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint64_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_u64(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_u64(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarU64_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jobject jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (uint64_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_u64(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_u64(uint32_t) const"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1scalarU64_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (uint64_t)((spirv_cross::SPIRConstant const *)arg1)->scalar_u64();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::scalar_u64() const"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1vector(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  spirv_cross::SPIRConstant::ConstantVector *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (spirv_cross::SPIRConstant::ConstantVector *) &((spirv_cross::SPIRConstant const *)arg1)->vector();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::vector() const"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstant::ConstantVector **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1vectorSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (uint32_t)((spirv_cross::SPIRConstant const *)arg1)->vector_size();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::vector_size() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1columns(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (uint32_t)((spirv_cross::SPIRConstant const *)arg1)->columns();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::columns() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1makeNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  spirv_cross::SPIRType *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = *(spirv_cross::SPIRType **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SPIRType const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->make_null((spirv_cross::SPIRType const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::make_null(spirv_cross::SPIRType const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1constantIsNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      result = (bool)((spirv_cross::SPIRConstant const *)arg1)->constant_is_null();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::constant_is_null() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRConstant_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  spirv_cross::SPIRConstant *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  {
    try {
      result = (spirv_cross::SPIRConstant *)new spirv_cross::SPIRConstant(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::SPIRConstant(uint32_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstant **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRConstant_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::SPIRConstant *)new spirv_cross::SPIRConstant();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::SPIRConstant()"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstant **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRConstant_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint32_t *arg2 = (uint32_t *) 0 ;
  uint32_t arg3 ;
  bool arg4 ;
  spirv_cross::SPIRConstant *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = *(uint32_t **)&jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (spirv_cross::SPIRConstant *)new spirv_cross::SPIRConstant(arg1,(uint32_t const *)arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::SPIRConstant(uint32_t,uint32_t const *,uint32_t,bool)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstant **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRConstant_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint32_t arg2 ;
  bool arg3 ;
  spirv_cross::SPIRConstant *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (spirv_cross::SPIRConstant *)new spirv_cross::SPIRConstant(arg1,arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::SPIRConstant(uint32_t,uint32_t,bool)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstant **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRConstant_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint64_t arg2 ;
  bool arg3 ;
  spirv_cross::SPIRConstant *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = 0;
    if (sz > 0) {
      arg2 = (uint64_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg2 = (arg2 << 8) | (uint64_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (spirv_cross::SPIRConstant *)new spirv_cross::SPIRConstant(arg1,arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::SPIRConstant(uint32_t,uint64_t,bool)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstant **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SPIRConstant_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  spirv_cross::SPIRConstant **arg2 = (spirv_cross::SPIRConstant **) 0 ;
  uint32_t arg3 ;
  bool arg4 ;
  spirv_cross::SPIRConstant *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = *(spirv_cross::SPIRConstant ***)&jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (spirv_cross::SPIRConstant *)new spirv_cross::SPIRConstant(arg1,(spirv_cross::SPIRConstant const *const *)arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::SPIRConstant(uint32_t,spirv_cross::SPIRConstant const *const *,uint32_t,bool)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstant **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1constantType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->constant_type = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1constantType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  result = (uint32_t) ((arg1)->constant_type);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1m_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  spirv_cross::SPIRConstant::ConstantMatrix *arg2 = (spirv_cross::SPIRConstant::ConstantMatrix *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = *(spirv_cross::SPIRConstant::ConstantMatrix **)&jarg2; 
  if (arg1) (arg1)->m = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1m_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  spirv_cross::SPIRConstant::ConstantMatrix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  result = (spirv_cross::SPIRConstant::ConstantMatrix *)& ((arg1)->m);
  *(spirv_cross::SPIRConstant::ConstantMatrix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1specialization_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->specialization = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1specialization_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  result = (bool) ((arg1)->specialization);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1isUsedAsArrayLength_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->is_used_as_array_length = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1isUsedAsArrayLength_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  result = (bool) ((arg1)->is_used_as_array_length);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1isUsedAsLut_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->is_used_as_lut = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1isUsedAsLut_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  result = (bool) ((arg1)->is_used_as_lut);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1subconstants_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->subconstants = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1subconstants_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->subconstants);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1specializationConstantMacroName_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->specialization_constant_macro_name = *arg2;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SPIRConstant_1specializationConstantMacroName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  result = (std::string *) & ((arg1)->specialization_constant_macro_name);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SPIRConstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SPIRConstant *arg1 = (spirv_cross::SPIRConstant *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SPIRConstant **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SPIRConstant::~SPIRConstant()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_AccessChainMeta_1storagePackedType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::AccessChainMeta *arg1 = (spirv_cross::AccessChainMeta *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::AccessChainMeta **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->storage_packed_type = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_AccessChainMeta_1storagePackedType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::AccessChainMeta *arg1 = (spirv_cross::AccessChainMeta *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::AccessChainMeta **)&jarg1; 
  result = (uint32_t) ((arg1)->storage_packed_type);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_AccessChainMeta_1needTranspose_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::AccessChainMeta *arg1 = (spirv_cross::AccessChainMeta *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::AccessChainMeta **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->need_transpose = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_AccessChainMeta_1needTranspose_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::AccessChainMeta *arg1 = (spirv_cross::AccessChainMeta *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::AccessChainMeta **)&jarg1; 
  result = (bool) ((arg1)->need_transpose);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_AccessChainMeta_1storageIsPacked_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::AccessChainMeta *arg1 = (spirv_cross::AccessChainMeta *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::AccessChainMeta **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->storage_is_packed = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_AccessChainMeta_1storageIsPacked_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::AccessChainMeta *arg1 = (spirv_cross::AccessChainMeta *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::AccessChainMeta **)&jarg1; 
  result = (bool) ((arg1)->storage_is_packed);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_AccessChainMeta_1storageIsInvariant_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::AccessChainMeta *arg1 = (spirv_cross::AccessChainMeta *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::AccessChainMeta **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->storage_is_invariant = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_AccessChainMeta_1storageIsInvariant_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::AccessChainMeta *arg1 = (spirv_cross::AccessChainMeta *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::AccessChainMeta **)&jarg1; 
  result = (bool) ((arg1)->storage_is_invariant);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1AccessChainMeta(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::AccessChainMeta *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::AccessChainMeta *)new spirv_cross::AccessChainMeta();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::AccessChainMeta::AccessChainMeta()"); return 0; 
      };
    }
  }
  *(spirv_cross::AccessChainMeta **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1AccessChainMeta(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::AccessChainMeta *arg1 = (spirv_cross::AccessChainMeta *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::AccessChainMeta **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::AccessChainMeta::~AccessChainMeta()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1ClassicLocale(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::ClassicLocale *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::ClassicLocale *)new spirv_cross::ClassicLocale();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ClassicLocale::ClassicLocale()"); return 0; 
      };
    }
  }
  *(spirv_cross::ClassicLocale **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1ClassicLocale(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::ClassicLocale *arg1 = (spirv_cross::ClassicLocale *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::ClassicLocale **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ClassicLocale::~ClassicLocale()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Hasher_1u32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::Hasher *arg1 = (spirv_cross::Hasher *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Hasher **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      (arg1)->u32(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Hasher::u32(uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT jobject JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Hasher_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  spirv_cross::Hasher *arg1 = (spirv_cross::Hasher *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Hasher **)&jarg1; 
  {
    try {
      result = (uint64_t)((spirv_cross::Hasher const *)arg1)->get();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Hasher::get() const"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1Hasher(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::Hasher *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::Hasher *)new spirv_cross::Hasher();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Hasher::Hasher()"); return 0; 
      };
    }
  }
  *(spirv_cross::Hasher **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1Hasher(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::Hasher *arg1 = (spirv_cross::Hasher *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::Hasher **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Hasher::~Hasher()"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_typeIsFloatingPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRType *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SPIRType const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)spirv_cross::type_is_floating_point((spirv_cross::SPIRType const &)*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::type_is_floating_point(spirv_cross::SPIRType const &)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_typeIsIntegral(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::SPIRType *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SPIRType **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SPIRType const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)spirv_cross::type_is_integral((spirv_cross::SPIRType const &)*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::type_is_integral(spirv_cross::SPIRType const &)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_toSignedBasetype(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  uint32_t arg1 ;
  spirv_cross::SPIRType::BaseType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  {
    try {
      result = (spirv_cross::SPIRType::BaseType)spirv_cross::to_signed_basetype(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::to_signed_basetype(uint32_t)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_toUnsignedBasetype(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  uint32_t arg1 ;
  spirv_cross::SPIRType::BaseType result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  {
    try {
      result = (spirv_cross::SPIRType::BaseType)spirv_cross::to_unsigned_basetype(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::to_unsigned_basetype(uint32_t)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_opcodeIsSignInvariant(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jboolean jresult = 0 ;
  spv::Op arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (spv::Op)jarg1; 
  {
    try {
      result = (bool)spirv_cross::opcode_is_sign_invariant(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::opcode_is_sign_invariant(spv::Op)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CFG(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = 0 ;
  spirv_cross::SPIRFunction *arg2 = 0 ;
  spirv_cross::CFG *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::Compiler **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::Compiler & reference is null");
    return 0;
  } 
  arg2 = *(spirv_cross::SPIRFunction **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SPIRFunction const & reference is null");
    return 0;
  } 
  {
    try {
      result = (spirv_cross::CFG *)new spirv_cross::CFG(*arg1,(spirv_cross::SPIRFunction const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CFG::CFG(spirv_cross::Compiler &,spirv_cross::SPIRFunction const &)"); return 0; 
      };
    }
  }
  *(spirv_cross::CFG **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CFG_1getCompiler_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CFG *arg1 = (spirv_cross::CFG *) 0 ;
  spirv_cross::Compiler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CFG **)&jarg1; 
  {
    try {
      result = (spirv_cross::Compiler *) &(arg1)->get_compiler();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CFG::get_compiler()"); return 0; 
      };
    }
  }
  *(spirv_cross::Compiler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CFG_1getFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CFG *arg1 = (spirv_cross::CFG *) 0 ;
  spirv_cross::SPIRFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CFG **)&jarg1; 
  {
    try {
      result = (spirv_cross::SPIRFunction *) &((spirv_cross::CFG const *)arg1)->get_function();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CFG::get_function() const"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CFG_1getImmediateDominator(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::CFG *arg1 = (spirv_cross::CFG *) 0 ;
  uint32_t arg2 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CFG **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (uint32_t)((spirv_cross::CFG const *)arg1)->get_immediate_dominator(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CFG::get_immediate_dominator(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CFG_1getVisitOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::CFG *arg1 = (spirv_cross::CFG *) 0 ;
  uint32_t arg2 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CFG **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (uint32_t)((spirv_cross::CFG const *)arg1)->get_visit_order(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CFG::get_visit_order(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CFG_1findCommonDominator(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::CFG *arg1 = (spirv_cross::CFG *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CFG **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint32_t)((spirv_cross::CFG const *)arg1)->find_common_dominator(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CFG::find_common_dominator(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CFG_1getPrecedingEdges(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::CFG *arg1 = (spirv_cross::CFG *) 0 ;
  uint32_t arg2 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CFG **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (std::vector< uint32_t > *) &((spirv_cross::CFG const *)arg1)->get_preceding_edges(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CFG::get_preceding_edges(uint32_t) const"); return 0; 
      };
    }
  }
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CFG_1getSucceedingEdges(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::CFG *arg1 = (spirv_cross::CFG *) 0 ;
  uint32_t arg2 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CFG **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (std::vector< uint32_t > *) &((spirv_cross::CFG const *)arg1)->get_succeeding_edges(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CFG::get_succeeding_edges(uint32_t) const"); return 0; 
      };
    }
  }
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1CFG(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::CFG *arg1 = (spirv_cross::CFG *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::CFG **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CFG::~CFG()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1DominatorBuilder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CFG *arg1 = 0 ;
  spirv_cross::DominatorBuilder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CFG **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::CFG const & reference is null");
    return 0;
  } 
  {
    try {
      result = (spirv_cross::DominatorBuilder *)new spirv_cross::DominatorBuilder((spirv_cross::CFG const &)*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::DominatorBuilder::DominatorBuilder(spirv_cross::CFG const &)"); return 0; 
      };
    }
  }
  *(spirv_cross::DominatorBuilder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_DominatorBuilder_1addBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::DominatorBuilder *arg1 = (spirv_cross::DominatorBuilder *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::DominatorBuilder **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      (arg1)->add_block(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::DominatorBuilder::add_block(uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_DominatorBuilder_1getDominator(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::DominatorBuilder *arg1 = (spirv_cross::DominatorBuilder *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::DominatorBuilder **)&jarg1; 
  {
    try {
      result = (uint32_t)((spirv_cross::DominatorBuilder const *)arg1)->get_dominator();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::DominatorBuilder::get_dominator() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_DominatorBuilder_1liftContinueBlockDominator(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  spirv_cross::DominatorBuilder *arg1 = (spirv_cross::DominatorBuilder *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::DominatorBuilder **)&jarg1; 
  {
    try {
      (arg1)->lift_continue_block_dominator();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::DominatorBuilder::lift_continue_block_dominator()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1DominatorBuilder(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::DominatorBuilder *arg1 = (spirv_cross::DominatorBuilder *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::DominatorBuilder **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::DominatorBuilder::~DominatorBuilder()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Resource_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::Resource *arg1 = (spirv_cross::Resource *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Resource **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Resource_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Resource *arg1 = (spirv_cross::Resource *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Resource **)&jarg1; 
  result = (uint32_t) ((arg1)->id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Resource_1typeId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::Resource *arg1 = (spirv_cross::Resource *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Resource **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->type_id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Resource_1typeId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Resource *arg1 = (spirv_cross::Resource *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Resource **)&jarg1; 
  result = (uint32_t) ((arg1)->type_id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Resource_1baseTypeId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::Resource *arg1 = (spirv_cross::Resource *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Resource **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->base_type_id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Resource_1baseTypeId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Resource *arg1 = (spirv_cross::Resource *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Resource **)&jarg1; 
  result = (uint32_t) ((arg1)->base_type_id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Resource_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  spirv_cross::Resource *arg1 = (spirv_cross::Resource *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Resource **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->name = *arg2;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Resource_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::Resource *arg1 = (spirv_cross::Resource *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Resource **)&jarg1; 
  result = (std::string *) & ((arg1)->name);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1Resource(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::Resource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::Resource *)new spirv_cross::Resource();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Resource::Resource()"); return 0; 
      };
    }
  }
  *(spirv_cross::Resource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1Resource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::Resource *arg1 = (spirv_cross::Resource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::Resource **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Resource::~Resource()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1uniformBuffers_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *arg2 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2; 
  if (arg1) (arg1)->uniform_buffers = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1uniformBuffers_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  result = (std::vector< spirv_cross::Resource > *)& ((arg1)->uniform_buffers);
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1storageBuffers_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *arg2 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2; 
  if (arg1) (arg1)->storage_buffers = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1storageBuffers_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  result = (std::vector< spirv_cross::Resource > *)& ((arg1)->storage_buffers);
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1stageInputs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *arg2 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2; 
  if (arg1) (arg1)->stage_inputs = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1stageInputs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  result = (std::vector< spirv_cross::Resource > *)& ((arg1)->stage_inputs);
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1stageOutputs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *arg2 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2; 
  if (arg1) (arg1)->stage_outputs = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1stageOutputs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  result = (std::vector< spirv_cross::Resource > *)& ((arg1)->stage_outputs);
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1subpassInputs_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *arg2 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2; 
  if (arg1) (arg1)->subpass_inputs = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1subpassInputs_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  result = (std::vector< spirv_cross::Resource > *)& ((arg1)->subpass_inputs);
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1storageImages_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *arg2 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2; 
  if (arg1) (arg1)->storage_images = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1storageImages_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  result = (std::vector< spirv_cross::Resource > *)& ((arg1)->storage_images);
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1sampledImages_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *arg2 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2; 
  if (arg1) (arg1)->sampled_images = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1sampledImages_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  result = (std::vector< spirv_cross::Resource > *)& ((arg1)->sampled_images);
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1atomicCounters_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *arg2 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2; 
  if (arg1) (arg1)->atomic_counters = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1atomicCounters_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  result = (std::vector< spirv_cross::Resource > *)& ((arg1)->atomic_counters);
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1pushConstantBuffers_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *arg2 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2; 
  if (arg1) (arg1)->push_constant_buffers = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1pushConstantBuffers_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  result = (std::vector< spirv_cross::Resource > *)& ((arg1)->push_constant_buffers);
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1separateImages_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *arg2 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2; 
  if (arg1) (arg1)->separate_images = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1separateImages_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  result = (std::vector< spirv_cross::Resource > *)& ((arg1)->separate_images);
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1separateSamplers_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *arg2 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2; 
  if (arg1) (arg1)->separate_samplers = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShaderResources_1separateSamplers_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  result = (std::vector< spirv_cross::Resource > *)& ((arg1)->separate_samplers);
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1ShaderResources(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::ShaderResources *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::ShaderResources *)new spirv_cross::ShaderResources();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ShaderResources::ShaderResources()"); return 0; 
      };
    }
  }
  *(spirv_cross::ShaderResources **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1ShaderResources(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::ShaderResources *arg1 = (spirv_cross::ShaderResources *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::ShaderResources **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ShaderResources::~ShaderResources()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSampler_1combinedId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CombinedImageSampler *arg1 = (spirv_cross::CombinedImageSampler *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CombinedImageSampler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->combined_id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSampler_1combinedId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CombinedImageSampler *arg1 = (spirv_cross::CombinedImageSampler *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CombinedImageSampler **)&jarg1; 
  result = (uint32_t) ((arg1)->combined_id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSampler_1imageId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CombinedImageSampler *arg1 = (spirv_cross::CombinedImageSampler *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CombinedImageSampler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->image_id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSampler_1imageId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CombinedImageSampler *arg1 = (spirv_cross::CombinedImageSampler *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CombinedImageSampler **)&jarg1; 
  result = (uint32_t) ((arg1)->image_id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSampler_1samplerId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CombinedImageSampler *arg1 = (spirv_cross::CombinedImageSampler *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CombinedImageSampler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->sampler_id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSampler_1samplerId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CombinedImageSampler *arg1 = (spirv_cross::CombinedImageSampler *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CombinedImageSampler **)&jarg1; 
  result = (uint32_t) ((arg1)->sampler_id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CombinedImageSampler(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::CombinedImageSampler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::CombinedImageSampler *)new spirv_cross::CombinedImageSampler();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CombinedImageSampler::CombinedImageSampler()"); return 0; 
      };
    }
  }
  *(spirv_cross::CombinedImageSampler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1CombinedImageSampler(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::CombinedImageSampler *arg1 = (spirv_cross::CombinedImageSampler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::CombinedImageSampler **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CombinedImageSampler::~CombinedImageSampler()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstant_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SpecializationConstant *arg1 = (spirv_cross::SpecializationConstant *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SpecializationConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstant_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SpecializationConstant *arg1 = (spirv_cross::SpecializationConstant *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SpecializationConstant **)&jarg1; 
  result = (uint32_t) ((arg1)->id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstant_1constantId_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::SpecializationConstant *arg1 = (spirv_cross::SpecializationConstant *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SpecializationConstant **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->constant_id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstant_1constantId_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::SpecializationConstant *arg1 = (spirv_cross::SpecializationConstant *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::SpecializationConstant **)&jarg1; 
  result = (uint32_t) ((arg1)->constant_id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SpecializationConstant(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::SpecializationConstant *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::SpecializationConstant *)new spirv_cross::SpecializationConstant();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SpecializationConstant::SpecializationConstant()"); return 0; 
      };
    }
  }
  *(spirv_cross::SpecializationConstant **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SpecializationConstant(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::SpecializationConstant *arg1 = (spirv_cross::SpecializationConstant *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::SpecializationConstant **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::SpecializationConstant::~SpecializationConstant()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRange_1index_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::BufferRange *arg1 = (spirv_cross::BufferRange *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::BufferRange **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->index = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRange_1index_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::BufferRange *arg1 = (spirv_cross::BufferRange *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::BufferRange **)&jarg1; 
  result = (unsigned int) ((arg1)->index);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRange_1offset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::BufferRange *arg1 = (spirv_cross::BufferRange *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::BufferRange **)&jarg1; 
  arg2 = (size_t)jarg2; 
  if (arg1) (arg1)->offset = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRange_1offset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::BufferRange *arg1 = (spirv_cross::BufferRange *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::BufferRange **)&jarg1; 
  result =  ((arg1)->offset);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRange_1range_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::BufferRange *arg1 = (spirv_cross::BufferRange *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::BufferRange **)&jarg1; 
  arg2 = (size_t)jarg2; 
  if (arg1) (arg1)->range = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRange_1range_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::BufferRange *arg1 = (spirv_cross::BufferRange *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::BufferRange **)&jarg1; 
  result =  ((arg1)->range);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1BufferRange(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::BufferRange *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::BufferRange *)new spirv_cross::BufferRange();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::BufferRange::BufferRange()"); return 0; 
      };
    }
  }
  *(spirv_cross::BufferRange **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1BufferRange(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::BufferRange *arg1 = (spirv_cross::BufferRange *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::BufferRange **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::BufferRange::~BufferRange()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_EntryPoint_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  spirv_cross::EntryPoint *arg1 = (spirv_cross::EntryPoint *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::EntryPoint **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->name = *arg2;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_EntryPoint_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::EntryPoint *arg1 = (spirv_cross::EntryPoint *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::EntryPoint **)&jarg1; 
  result = (std::string *) & ((arg1)->name);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_EntryPoint_1executionModel_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::EntryPoint *arg1 = (spirv_cross::EntryPoint *) 0 ;
  spv::ExecutionModel arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::EntryPoint **)&jarg1; 
  arg2 = (spv::ExecutionModel)jarg2; 
  if (arg1) (arg1)->execution_model = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_EntryPoint_1executionModel_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::EntryPoint *arg1 = (spirv_cross::EntryPoint *) 0 ;
  spv::ExecutionModel result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::EntryPoint **)&jarg1; 
  result = (spv::ExecutionModel) ((arg1)->execution_model);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1EntryPoint(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::EntryPoint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::EntryPoint *)new spirv_cross::EntryPoint();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::EntryPoint::EntryPoint()"); return 0; 
      };
    }
  }
  *(spirv_cross::EntryPoint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1EntryPoint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::EntryPoint *arg1 = (spirv_cross::EntryPoint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::EntryPoint **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::EntryPoint::~EntryPoint()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1Compiler_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > arg1 ;
  std::vector< uint32_t > *argp1 ;
  spirv_cross::Compiler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(std::vector< uint32_t > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< uint32_t >");
    return 0;
  }
  arg1 = *argp1; 
  {
    try {
      result = (spirv_cross::Compiler *)new spirv_cross::Compiler(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::Compiler(std::vector< uint32_t >)"); return 0; 
      };
    }
  }
  *(spirv_cross::Compiler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1Compiler_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  uint32_t *arg1 = (uint32_t *) 0 ;
  size_t arg2 ;
  spirv_cross::Compiler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uint32_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try {
      result = (spirv_cross::Compiler *)new spirv_cross::Compiler((uint32_t const *)arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::Compiler(uint32_t const *,size_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::Compiler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1Compiler_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ParsedIR *arg1 = 0 ;
  spirv_cross::Compiler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ParsedIR **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "ParsedIR const & reference is null");
    return 0;
  } 
  {
    try {
      result = (spirv_cross::Compiler *)new spirv_cross::Compiler((ParsedIR const &)*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::Compiler(ParsedIR const &)"); return 0; 
      };
    }
  }
  *(spirv_cross::Compiler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1Compiler(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::~Compiler()"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1compile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = (arg1)->compile();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::compile()"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (std::string *) &((spirv_cross::Compiler const *)arg1)->get_name(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_name(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setDecoration_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jlong jarg4) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  uint32_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  arg4 = (uint32_t)jarg4; 
  {
    try {
      (arg1)->set_decoration(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_decoration(uint32_t,spv::Decoration,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setDecoration_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  {
    try {
      (arg1)->set_decoration(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_decoration(uint32_t,spv::Decoration)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setDecorationString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jstring jarg4) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      (arg1)->set_decoration_string(arg2,arg3,(std::string const &)*arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_decoration_string(uint32_t,spv::Decoration,std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jstring jarg3) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->set_name(arg2,(std::string const &)*arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_name(uint32_t,std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jobject JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getDecorationMask(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jobject jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (uint64_t)((spirv_cross::Compiler const *)arg1)->get_decoration_mask(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_decoration_mask(uint32_t) const"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getDecorationBitset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spirv_cross::Bitset *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (spirv_cross::Bitset *) &((spirv_cross::Compiler const *)arg1)->get_decoration_bitset(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_decoration_bitset(uint32_t) const"); return 0; 
      };
    }
  }
  *(spirv_cross::Bitset **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1hasDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  {
    try {
      result = (bool)((spirv_cross::Compiler const *)arg1)->has_decoration(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::has_decoration(uint32_t,spv::Decoration) const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  {
    try {
      result = (uint32_t)((spirv_cross::Compiler const *)arg1)->get_decoration(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_decoration(uint32_t,spv::Decoration) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getDecorationString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jstring jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  {
    try {
      result = (std::string *) &((spirv_cross::Compiler const *)arg1)->get_decoration_string(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_decoration_string(uint32_t,spv::Decoration) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1unsetDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  {
    try {
      (arg1)->unset_decoration(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::unset_decoration(uint32_t,spv::Decoration)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spirv_cross::SPIRType *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (spirv_cross::SPIRType *) &((spirv_cross::Compiler const *)arg1)->get_type(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_type(uint32_t) const"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRType **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getTypeFromVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spirv_cross::SPIRType *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (spirv_cross::SPIRType *) &((spirv_cross::Compiler const *)arg1)->get_type_from_variable(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_type_from_variable(uint32_t) const"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRType **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getStorageClass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spv::StorageClass result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (spv::StorageClass)((spirv_cross::Compiler const *)arg1)->get_storage_class(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_storage_class(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getFallbackName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_fallback_name(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_fallback_name(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getBlockFallbackName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_block_fallback_name(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_block_fallback_name(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getMemberName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (std::string *) &((spirv_cross::Compiler const *)arg1)->get_member_name(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_member_name(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getMemberDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  {
    try {
      result = (uint32_t)((spirv_cross::Compiler const *)arg1)->get_member_decoration(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_member_decoration(uint32_t,uint32_t,spv::Decoration) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setMemberName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jstring jarg4) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      (arg1)->set_member_name(arg2,arg3,(std::string const &)*arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_member_name(uint32_t,uint32_t,std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getMemberQualifiedName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (std::string *) &((spirv_cross::Compiler const *)arg1)->get_member_qualified_name(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_member_qualified_name(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setMemberQualifiedName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jstring jarg4) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      (arg1)->set_member_qualified_name(arg2,arg3,(std::string const &)*arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_member_qualified_name(uint32_t,uint32_t,std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jobject JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getMemberDecorationMask(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jobject jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint64_t)((spirv_cross::Compiler const *)arg1)->get_member_decoration_mask(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_member_decoration_mask(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getMemberDecorationBitset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spirv_cross::Bitset *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (spirv_cross::Bitset *) &((spirv_cross::Compiler const *)arg1)->get_member_decoration_bitset(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_member_decoration_bitset(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  *(spirv_cross::Bitset **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1hasMemberDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  {
    try {
      result = (bool)((spirv_cross::Compiler const *)arg1)->has_member_decoration(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::has_member_decoration(uint32_t,uint32_t,spv::Decoration) const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setMemberDecoration_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4, jlong jarg5) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  uint32_t arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  arg5 = (uint32_t)jarg5; 
  {
    try {
      (arg1)->set_member_decoration(arg2,arg3,arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_member_decoration(uint32_t,uint32_t,spv::Decoration,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setMemberDecoration_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  {
    try {
      (arg1)->set_member_decoration(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_member_decoration(uint32_t,uint32_t,spv::Decoration)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setMemberDecorationString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4, jstring jarg5) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  std::string *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return ;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  {
    try {
      (arg1)->set_member_decoration_string(arg2,arg3,arg4,(std::string const &)*arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_member_decoration_string(uint32_t,uint32_t,spv::Decoration,std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1unsetMemberDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  {
    try {
      (arg1)->unset_member_decoration(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::unset_member_decoration(uint32_t,uint32_t,spv::Decoration)"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getFallbackMemberName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_fallback_member_name(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_fallback_member_name(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getActiveBufferRanges(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  std::vector< spirv_cross::BufferRange > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_active_buffer_ranges(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_active_buffer_ranges(uint32_t) const"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::BufferRange > **)&jresult = new std::vector< spirv_cross::BufferRange >((const std::vector< spirv_cross::BufferRange > &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getDeclaredStructSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spirv_cross::SPIRType *arg2 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = *(spirv_cross::SPIRType **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SPIRType const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_declared_struct_size((spirv_cross::SPIRType const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_declared_struct_size(spirv_cross::SPIRType const &) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getDeclaredStructSizeRuntimeArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spirv_cross::SPIRType *arg2 = 0 ;
  size_t arg3 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = *(spirv_cross::SPIRType **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SPIRType const & reference is null");
    return 0;
  } 
  arg3 = (size_t)jarg3; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_declared_struct_size_runtime_array((spirv_cross::SPIRType const &)*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_declared_struct_size_runtime_array(spirv_cross::SPIRType const &,size_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getDeclaredStructMemberSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spirv_cross::SPIRType *arg2 = 0 ;
  uint32_t arg3 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = *(spirv_cross::SPIRType **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SPIRType const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_declared_struct_member_size((spirv_cross::SPIRType const &)*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_declared_struct_member_size(spirv_cross::SPIRType const &,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1flattenInterfaceBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      (arg1)->flatten_interface_block(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::flatten_interface_block(uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getActiveInterfaceVariables(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::unordered_set< uint32_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_active_interface_variables();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_active_interface_variables() const"); return 0; 
      };
    }
  }
  *(std::unordered_set< uint32_t > **)&jresult = new std::unordered_set< uint32_t >((const std::unordered_set< uint32_t > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setEnabledInterfaceVariables(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::unordered_set< uint32_t > arg2 ;
  std::unordered_set< uint32_t > *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  argp2 = *(std::unordered_set< uint32_t > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::unordered_set< uint32_t >");
    return ;
  }
  arg2 = *argp2; 
  {
    try {
      (arg1)->set_enabled_interface_variables(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_enabled_interface_variables(std::unordered_set< uint32_t >)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getShaderResources_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spirv_cross::ShaderResources result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_shader_resources();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_shader_resources() const"); return 0; 
      };
    }
  }
  *(spirv_cross::ShaderResources **)&jresult = new spirv_cross::ShaderResources((const spirv_cross::ShaderResources &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getShaderResources_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::unordered_set< uint32_t > *arg2 = 0 ;
  spirv_cross::ShaderResources result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = *(std::unordered_set< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::unordered_set< uint32_t > const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_shader_resources((std::unordered_set< uint32_t > const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_shader_resources(std::unordered_set< uint32_t > const &) const"); return 0; 
      };
    }
  }
  *(spirv_cross::ShaderResources **)&jresult = new spirv_cross::ShaderResources((const spirv_cross::ShaderResources &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setRemappedVariableState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_remapped_variable_state(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_remapped_variable_state(uint32_t,bool)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getRemappedVariableState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (bool)((spirv_cross::Compiler const *)arg1)->get_remapped_variable_state(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_remapped_variable_state(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setSubpassInputRemappedComponents(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      (arg1)->set_subpass_input_remapped_components(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_subpass_input_remapped_components(uint32_t,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getSubpassInputRemappedComponents(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (uint32_t)((spirv_cross::Compiler const *)arg1)->get_subpass_input_remapped_components(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_subpass_input_remapped_components(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getEntryPoints(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::vector< std::string > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_entry_points();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_entry_points() const"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = new std::vector< std::string >((const std::vector< std::string > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setEntryPoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->set_entry_point((std::string const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_entry_point(std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1renameEntryPoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->rename_entry_point((std::string const &)*arg2,(std::string const &)*arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::rename_entry_point(std::string const &,std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getEntryPoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::string *arg2 = 0 ;
  spirv_cross::SPIREntryPoint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (spirv_cross::SPIREntryPoint *) &((spirv_cross::Compiler const *)arg1)->get_entry_point((std::string const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_entry_point(std::string const &) const"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIREntryPoint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getCleansedEntryPointName_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::string *arg2 = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (std::string *) &((spirv_cross::Compiler const *)arg1)->get_cleansed_entry_point_name((std::string const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_cleansed_entry_point_name(std::string const &) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getEntryPointsAndStages(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  SwigValueWrapper< std::vector< spirv_cross::EntryPoint > > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_entry_points_and_stages();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_entry_points_and_stages() const"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::EntryPoint > **)&jresult = new std::vector< spirv_cross::EntryPoint >((const std::vector< spirv_cross::EntryPoint > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setEntryPoint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::string *arg2 = 0 ;
  spv::ExecutionModel arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (spv::ExecutionModel)jarg3; 
  {
    try {
      (arg1)->set_entry_point((std::string const &)*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_entry_point(std::string const &,spv::ExecutionModel)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1renameEntryPoint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  spv::ExecutionModel arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  arg4 = (spv::ExecutionModel)jarg4; 
  {
    try {
      (arg1)->rename_entry_point((std::string const &)*arg2,(std::string const &)*arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::rename_entry_point(std::string const &,std::string const &,spv::ExecutionModel)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getEntryPoint_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::string *arg2 = 0 ;
  spv::ExecutionModel arg3 ;
  spirv_cross::SPIREntryPoint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (spv::ExecutionModel)jarg3; 
  {
    try {
      result = (spirv_cross::SPIREntryPoint *) &((spirv_cross::Compiler const *)arg1)->get_entry_point((std::string const &)*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_entry_point(std::string const &,spv::ExecutionModel) const"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIREntryPoint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getCleansedEntryPointName_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jstring jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::string *arg2 = 0 ;
  spv::ExecutionModel arg3 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (spv::ExecutionModel)jarg3; 
  {
    try {
      result = (std::string *) &((spirv_cross::Compiler const *)arg1)->get_cleansed_entry_point_name((std::string const &)*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_cleansed_entry_point_name(std::string const &,spv::ExecutionModel) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getExecutionModeMask(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = (uint64_t)((spirv_cross::Compiler const *)arg1)->get_execution_mode_mask();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_execution_mode_mask() const"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getExecutionModeBitset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spirv_cross::Bitset *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = (spirv_cross::Bitset *) &((spirv_cross::Compiler const *)arg1)->get_execution_mode_bitset();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_execution_mode_bitset() const"); return 0; 
      };
    }
  }
  *(spirv_cross::Bitset **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1unsetExecutionMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spv::ExecutionMode arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (spv::ExecutionMode)jarg2; 
  {
    try {
      (arg1)->unset_execution_mode(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::unset_execution_mode(spv::ExecutionMode)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setExecutionMode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spv::ExecutionMode arg2 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  uint32_t arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (spv::ExecutionMode)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  arg5 = (uint32_t)jarg5; 
  {
    try {
      (arg1)->set_execution_mode(arg2,arg3,arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_execution_mode(spv::ExecutionMode,uint32_t,uint32_t,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setExecutionMode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jlong jarg4) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spv::ExecutionMode arg2 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (spv::ExecutionMode)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  {
    try {
      (arg1)->set_execution_mode(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_execution_mode(spv::ExecutionMode,uint32_t,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setExecutionMode_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spv::ExecutionMode arg2 ;
  uint32_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (spv::ExecutionMode)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      (arg1)->set_execution_mode(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_execution_mode(spv::ExecutionMode,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setExecutionMode_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spv::ExecutionMode arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (spv::ExecutionMode)jarg2; 
  {
    try {
      (arg1)->set_execution_mode(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_execution_mode(spv::ExecutionMode)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getExecutionModeArgument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spv::ExecutionMode arg2 ;
  uint32_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (spv::ExecutionMode)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint32_t)((spirv_cross::Compiler const *)arg1)->get_execution_mode_argument(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_execution_mode_argument(spv::ExecutionMode,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getExecutionModeArgument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spv::ExecutionMode arg2 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (spv::ExecutionMode)jarg2; 
  {
    try {
      result = (uint32_t)((spirv_cross::Compiler const *)arg1)->get_execution_mode_argument(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_execution_mode_argument(spv::ExecutionMode) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getExecutionModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spv::ExecutionModel result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = (spv::ExecutionModel)((spirv_cross::Compiler const *)arg1)->get_execution_model();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_execution_model() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1isTessellationShader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = (bool)((spirv_cross::Compiler const *)arg1)->is_tessellation_shader();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::is_tessellation_shader() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getWorkGroupSizeSpecializationConstants(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spirv_cross::SpecializationConstant *arg2 = 0 ;
  spirv_cross::SpecializationConstant *arg3 = 0 ;
  spirv_cross::SpecializationConstant *arg4 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = *(spirv_cross::SpecializationConstant **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SpecializationConstant & reference is null");
    return 0;
  } 
  arg3 = *(spirv_cross::SpecializationConstant **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SpecializationConstant & reference is null");
    return 0;
  } 
  arg4 = *(spirv_cross::SpecializationConstant **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SpecializationConstant & reference is null");
    return 0;
  } 
  {
    try {
      result = (uint32_t)((spirv_cross::Compiler const *)arg1)->get_work_group_size_specialization_constants(*arg2,*arg3,*arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_work_group_size_specialization_constants(spirv_cross::SpecializationConstant &,spirv_cross::SpecializationConstant &,spirv_cross::SpecializationConstant &) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1buildDummySamplerForCombinedImages(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = (uint32_t)(arg1)->build_dummy_sampler_for_combined_images();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::build_dummy_sampler_for_combined_images()"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1buildCombinedImageSamplers(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      (arg1)->build_combined_image_samplers();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::build_combined_image_samplers()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getCombinedImageSamplers(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::vector< spirv_cross::CombinedImageSampler > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = (std::vector< spirv_cross::CombinedImageSampler > *) &((spirv_cross::Compiler const *)arg1)->get_combined_image_samplers();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_combined_image_samplers() const"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::CombinedImageSampler > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1setVariableTypeRemapCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  SwigValueWrapper< std::function< void (spirv_cross::SPIRType const &,std::string const &,std::string &) > > arg2 ;
  spirv_cross::VariableTypeRemapCallback *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  argp2 = *(spirv_cross::VariableTypeRemapCallback **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null spirv_cross::VariableTypeRemapCallback");
    return ;
  }
  arg2 = *argp2; 
  {
    try {
      (arg1)->set_variable_type_remap_callback(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::set_variable_type_remap_callback(spirv_cross::VariableTypeRemapCallback)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getSpecializationConstants(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::vector< spirv_cross::SpecializationConstant > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_specialization_constants();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_specialization_constants() const"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::SpecializationConstant > **)&jresult = new std::vector< spirv_cross::SpecializationConstant >((const std::vector< spirv_cross::SpecializationConstant > &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getConstant_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spirv_cross::SPIRConstant *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (spirv_cross::SPIRConstant *) &(arg1)->get_constant(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_constant(uint32_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::SPIRConstant **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getCurrentIdBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = (uint32_t)((spirv_cross::Compiler const *)arg1)->get_current_id_bound();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_current_id_bound() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1typeStructMemberOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spirv_cross::SPIRType *arg2 = 0 ;
  uint32_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = *(spirv_cross::SPIRType **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SPIRType const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint32_t)((spirv_cross::Compiler const *)arg1)->type_struct_member_offset((spirv_cross::SPIRType const &)*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::type_struct_member_offset(spirv_cross::SPIRType const &,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1typeStructMemberArrayStride(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spirv_cross::SPIRType *arg2 = 0 ;
  uint32_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = *(spirv_cross::SPIRType **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SPIRType const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint32_t)((spirv_cross::Compiler const *)arg1)->type_struct_member_array_stride((spirv_cross::SPIRType const &)*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::type_struct_member_array_stride(spirv_cross::SPIRType const &,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1typeStructMemberMatrixStride(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  spirv_cross::SPIRType *arg2 = 0 ;
  uint32_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = *(spirv_cross::SPIRType **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SPIRType const & reference is null");
    return 0;
  } 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint32_t)((spirv_cross::Compiler const *)arg1)->type_struct_member_matrix_stride((spirv_cross::SPIRType const &)*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::type_struct_member_matrix_stride(spirv_cross::SPIRType const &,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getBinaryOffsetForDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  uint32_t *arg4 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  arg4 = *(uint32_t **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "uint32_t & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)((spirv_cross::Compiler const *)arg1)->get_binary_offset_for_decoration(arg2,arg3,*arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_binary_offset_for_decoration(uint32_t,spv::Decoration,uint32_t &) const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1bufferIsHlslCounterBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (bool)((spirv_cross::Compiler const *)arg1)->buffer_is_hlsl_counter_buffer(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::buffer_is_hlsl_counter_buffer(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1bufferGetHlslCounterBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  uint32_t *arg3 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(uint32_t **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "uint32_t & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)((spirv_cross::Compiler const *)arg1)->buffer_get_hlsl_counter_buffer(arg2,*arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::buffer_get_hlsl_counter_buffer(uint32_t,uint32_t &) const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getDeclaredCapabilities(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::vector< spv::Capability > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = (std::vector< spv::Capability > *) &((spirv_cross::Compiler const *)arg1)->get_declared_capabilities();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_declared_capabilities() const"); return 0; 
      };
    }
  }
  *(std::vector< spv::Capability > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getDeclaredExtensions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  {
    try {
      result = (std::vector< std::string > *) &((spirv_cross::Compiler const *)arg1)->get_declared_extensions();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_declared_extensions() const"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getRemappedDeclaredBlockName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_remapped_declared_block_name(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_remapped_declared_block_name(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Compiler_1getBufferBlockFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::Compiler *arg1 = (spirv_cross::Compiler *) 0 ;
  uint32_t arg2 ;
  spirv_cross::Bitset result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = ((spirv_cross::Compiler const *)arg1)->get_buffer_block_flags(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Compiler::get_buffer_block_flags(uint32_t) const"); return 0; 
      };
    }
  }
  *(spirv_cross::Bitset **)&jresult = new spirv_cross::Bitset((const spirv_cross::Bitset &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_renameInterfaceVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jstring jarg4) {
  spirv_cross::Compiler *arg1 = 0 ;
  std::vector< spirv_cross::Resource > *arg2 = 0 ;
  uint32_t arg3 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::Compiler **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::Compiler & reference is null");
    return ;
  } 
  arg2 = *(std::vector< spirv_cross::Resource > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::Resource > const & reference is null");
    return ;
  } 
  arg3 = (uint32_t)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      spirv_cross_util::rename_interface_variable(*arg1,(std::vector< spirv_cross::Resource > const &)*arg2,arg3,(std::string const &)*arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross_util::rename_interface_variable(spirv_cross::Compiler &,std::vector< spirv_cross::Resource > const &,uint32_t,std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_inheritCombinedSamplerBindings(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  spirv_cross::Compiler *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Compiler **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::Compiler & reference is null");
    return ;
  } 
  {
    try {
      spirv_cross_util::inherit_combined_sampler_bindings(*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross_util::inherit_combined_sampler_bindings(spirv_cross::Compiler &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemap_1id_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::PlsRemap *arg1 = (spirv_cross::PlsRemap *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::PlsRemap **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->id = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemap_1id_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::PlsRemap *arg1 = (spirv_cross::PlsRemap *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::PlsRemap **)&jarg1; 
  result = (uint32_t) ((arg1)->id);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemap_1format_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::PlsRemap *arg1 = (spirv_cross::PlsRemap *) 0 ;
  spirv_cross::PlsFormat arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::PlsRemap **)&jarg1; 
  arg2 = (spirv_cross::PlsFormat)jarg2; 
  if (arg1) (arg1)->format = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemap_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::PlsRemap *arg1 = (spirv_cross::PlsRemap *) 0 ;
  spirv_cross::PlsFormat result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::PlsRemap **)&jarg1; 
  result = (spirv_cross::PlsFormat) ((arg1)->format);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1PlsRemap(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::PlsRemap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::PlsRemap *)new spirv_cross::PlsRemap();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::PlsRemap::PlsRemap()"); return 0; 
      };
    }
  }
  *(spirv_cross::PlsRemap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1PlsRemap(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::PlsRemap *arg1 = (spirv_cross::PlsRemap *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::PlsRemap **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::PlsRemap::~PlsRemap()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->version = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  result = (uint32_t) ((arg1)->version);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1es_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->es = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1es_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  result = (bool) ((arg1)->es);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1forceTemporary_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->force_temporary = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1forceTemporary_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  result = (bool) ((arg1)->force_temporary);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1vulkanSemantics_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->vulkan_semantics = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1vulkanSemantics_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  result = (bool) ((arg1)->vulkan_semantics);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1separateShaderObjects_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->separate_shader_objects = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1separateShaderObjects_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  result = (bool) ((arg1)->separate_shader_objects);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1flattenMultidimensionalArrays_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->flatten_multidimensional_arrays = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1flattenMultidimensionalArrays_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  result = (bool) ((arg1)->flatten_multidimensional_arrays);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1enable420packExtension_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->enable_420pack_extension = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1Options_1enable420packExtension_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  result = (bool) ((arg1)->enable_420pack_extension);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerGLSL_1Options(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::CompilerGLSL::Options *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::CompilerGLSL::Options *)new spirv_cross::CompilerGLSL::Options();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::Options::Options()"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerGLSL::Options **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1CompilerGLSL_1Options(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::CompilerGLSL::Options *arg1 = (spirv_cross::CompilerGLSL::Options *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::CompilerGLSL::Options **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::Options::~Options()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1remapPixelLocalStorage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  spirv_cross::CompilerGLSL *arg1 = (spirv_cross::CompilerGLSL *) 0 ;
  std::vector< spirv_cross::PlsRemap > arg2 ;
  std::vector< spirv_cross::PlsRemap > arg3 ;
  std::vector< spirv_cross::PlsRemap > *argp2 ;
  std::vector< spirv_cross::PlsRemap > *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(spirv_cross::CompilerGLSL **)&jarg1; 
  argp2 = *(std::vector< spirv_cross::PlsRemap > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< spirv_cross::PlsRemap >");
    return ;
  }
  arg2 = *argp2; 
  argp3 = *(std::vector< spirv_cross::PlsRemap > **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< spirv_cross::PlsRemap >");
    return ;
  }
  arg3 = *argp3; 
  {
    try {
      (arg1)->remap_pixel_local_storage(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::remap_pixel_local_storage(std::vector< spirv_cross::PlsRemap >,std::vector< spirv_cross::PlsRemap >)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerGLSL_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > arg1 ;
  std::vector< uint32_t > *argp1 ;
  spirv_cross::CompilerGLSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(std::vector< uint32_t > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< uint32_t >");
    return 0;
  }
  arg1 = *argp1; 
  {
    try {
      result = (spirv_cross::CompilerGLSL *)new spirv_cross::CompilerGLSL(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::CompilerGLSL(std::vector< uint32_t >)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerGLSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerGLSL_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  uint32_t *arg1 = (uint32_t *) 0 ;
  size_t arg2 ;
  spirv_cross::CompilerGLSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uint32_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try {
      result = (spirv_cross::CompilerGLSL *)new spirv_cross::CompilerGLSL((uint32_t const *)arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::CompilerGLSL(uint32_t const *,size_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerGLSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerGLSL_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ParsedIR *arg1 = 0 ;
  spirv_cross::CompilerGLSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ParsedIR **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "ParsedIR const & reference is null");
    return 0;
  } 
  {
    try {
      result = (spirv_cross::CompilerGLSL *)new spirv_cross::CompilerGLSL((ParsedIR const &)*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::CompilerGLSL(ParsedIR const &)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerGLSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1getOptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerGLSL *arg1 = (spirv_cross::CompilerGLSL *) 0 ;
  spirv_cross::CompilerGLSL::Options *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL **)&jarg1; 
  {
    try {
      result = (spirv_cross::CompilerGLSL::Options *) &((spirv_cross::CompilerGLSL const *)arg1)->get_options();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::get_options() const"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerGLSL::Options **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1getCommonOptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerGLSL *arg1 = (spirv_cross::CompilerGLSL *) 0 ;
  spirv_cross::CompilerGLSL::Options *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL **)&jarg1; 
  {
    try {
      result = (spirv_cross::CompilerGLSL::Options *) &((spirv_cross::CompilerGLSL const *)arg1)->get_common_options();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::get_common_options() const"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerGLSL::Options **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1setOptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::CompilerGLSL *arg1 = (spirv_cross::CompilerGLSL *) 0 ;
  spirv_cross::CompilerGLSL::Options *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::CompilerGLSL **)&jarg1; 
  arg2 = *(spirv_cross::CompilerGLSL::Options **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::CompilerGLSL::Options & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_options(*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::set_options(spirv_cross::CompilerGLSL::Options &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1setCommonOptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::CompilerGLSL *arg1 = (spirv_cross::CompilerGLSL *) 0 ;
  spirv_cross::CompilerGLSL::Options *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::CompilerGLSL **)&jarg1; 
  arg2 = *(spirv_cross::CompilerGLSL::Options **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::CompilerGLSL::Options const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_common_options((spirv_cross::CompilerGLSL::Options const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::set_common_options(spirv_cross::CompilerGLSL::Options const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1compile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::CompilerGLSL *arg1 = (spirv_cross::CompilerGLSL *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL **)&jarg1; 
  {
    try {
      result = (arg1)->compile();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::compile()"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1getPartialSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::CompilerGLSL *arg1 = (spirv_cross::CompilerGLSL *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL **)&jarg1; 
  {
    try {
      result = (arg1)->get_partial_source();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::get_partial_source()"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1addHeaderLine(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  spirv_cross::CompilerGLSL *arg1 = (spirv_cross::CompilerGLSL *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->add_header_line((std::string const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::add_header_line(std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1requireExtension(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  spirv_cross::CompilerGLSL *arg1 = (spirv_cross::CompilerGLSL *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->require_extension((std::string const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::require_extension(std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1flattenBufferBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CompilerGLSL *arg1 = (spirv_cross::CompilerGLSL *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerGLSL **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      (arg1)->flatten_buffer_block(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::flatten_buffer_block(uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1CompilerGLSL(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::CompilerGLSL *arg1 = (spirv_cross::CompilerGLSL *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::CompilerGLSL **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerGLSL::~CompilerGLSL()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerCPP_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > arg1 ;
  std::vector< uint32_t > *argp1 ;
  spirv_cross::CompilerCPP *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(std::vector< uint32_t > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< uint32_t >");
    return 0;
  }
  arg1 = *argp1; 
  {
    try {
      result = (spirv_cross::CompilerCPP *)new spirv_cross::CompilerCPP(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerCPP::CompilerCPP(std::vector< uint32_t >)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerCPP **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerCPP_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  uint32_t *arg1 = (uint32_t *) 0 ;
  size_t arg2 ;
  spirv_cross::CompilerCPP *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uint32_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try {
      result = (spirv_cross::CompilerCPP *)new spirv_cross::CompilerCPP((uint32_t const *)arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerCPP::CompilerCPP(uint32_t const *,size_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerCPP **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerCPP_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ParsedIR *arg1 = 0 ;
  spirv_cross::CompilerCPP *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ParsedIR **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "ParsedIR const & reference is null");
    return 0;
  } 
  {
    try {
      result = (spirv_cross::CompilerCPP *)new spirv_cross::CompilerCPP((ParsedIR const &)*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerCPP::CompilerCPP(ParsedIR const &)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerCPP **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerCPP_1compile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::CompilerCPP *arg1 = (spirv_cross::CompilerCPP *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerCPP **)&jarg1; 
  {
    try {
      result = (arg1)->compile();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerCPP::compile()"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerCPP_1setInterfaceName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  spirv_cross::CompilerCPP *arg1 = (spirv_cross::CompilerCPP *) 0 ;
  std::string arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerCPP **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  } 
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  (&arg2)->assign(arg2_pstr);
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->set_interface_name(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerCPP::set_interface_name(std::string)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1CompilerCPP(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::CompilerCPP *arg1 = (spirv_cross::CompilerCPP *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::CompilerCPP **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerCPP::~CompilerCPP()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1Parser_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  uint32_t *arg1 = (uint32_t *) 0 ;
  size_t arg2 ;
  spirv_cross::Parser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uint32_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try {
      result = (spirv_cross::Parser *)new spirv_cross::Parser((uint32_t const *)arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Parser::Parser(uint32_t const *,size_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::Parser **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1Parser_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > arg1 ;
  std::vector< uint32_t > *argp1 ;
  spirv_cross::Parser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(std::vector< uint32_t > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< uint32_t >");
    return 0;
  }
  arg1 = *argp1; 
  {
    try {
      result = (spirv_cross::Parser *)new spirv_cross::Parser(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Parser::Parser(std::vector< uint32_t >)"); return 0; 
      };
    }
  }
  *(spirv_cross::Parser **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Parser_1parse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  spirv_cross::Parser *arg1 = (spirv_cross::Parser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Parser **)&jarg1; 
  {
    try {
      (arg1)->parse();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Parser::parse()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_Parser_1getParsedIr(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::Parser *arg1 = (spirv_cross::Parser *) 0 ;
  ParsedIR *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::Parser **)&jarg1; 
  {
    try {
      result = (ParsedIR *) &(arg1)->get_parsed_ir();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Parser::get_parsed_ir()"); return 0; 
      };
    }
  }
  *(ParsedIR **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1Parser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::Parser *arg1 = (spirv_cross::Parser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::Parser **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::Parser::~Parser()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1setIdBounds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      (arg1)->set_id_bounds(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::set_id_bounds(uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1spirv_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->spirv = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1spirv_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->spirv);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1ids_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< spirv_cross::Variant > *arg2 = (std::vector< spirv_cross::Variant > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Variant > **)&jarg2; 
  if (arg1) (arg1)->ids = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1ids_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< spirv_cross::Variant > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (std::vector< spirv_cross::Variant > *)& ((arg1)->ids);
  *(std::vector< spirv_cross::Variant > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1meta_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::unordered_map< uint32_t,spirv_cross::Meta > *arg2 = (std::unordered_map< uint32_t,spirv_cross::Meta > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(std::unordered_map< uint32_t,spirv_cross::Meta > **)&jarg2; 
  if (arg1) (arg1)->meta = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1meta_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::unordered_map< uint32_t,spirv_cross::Meta > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (std::unordered_map< uint32_t,spirv_cross::Meta > *)& ((arg1)->meta);
  *(std::unordered_map< uint32_t,spirv_cross::Meta > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1idsForType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< uint32_t > *arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  {
    size_t ii;
    std::vector< uint32_t > *b = (std::vector< uint32_t > *) arg1->ids_for_type;
    for (ii = 0; ii < (size_t)spirv_cross::TypeCount; ii++) b[ii] = *((std::vector< uint32_t > *) arg2 + ii);
  }
  
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1idsForType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (std::vector< uint32_t > *)(std::vector< uint32_t > *) ((arg1)->ids_for_type);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1idsForConstantOrType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->ids_for_constant_or_type = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1idsForConstantOrType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->ids_for_constant_or_type);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1idsForConstantOrVariable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< uint32_t > *arg2 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2; 
  if (arg1) (arg1)->ids_for_constant_or_variable = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1idsForConstantOrVariable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (std::vector< uint32_t > *)& ((arg1)->ids_for_constant_or_variable);
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1declaredCapabilities_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< spv::Capability > *arg2 = (std::vector< spv::Capability > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(std::vector< spv::Capability > **)&jarg2; 
  if (arg1) (arg1)->declared_capabilities = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1declaredCapabilities_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< spv::Capability > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (std::vector< spv::Capability > *)& ((arg1)->declared_capabilities);
  *(std::vector< spv::Capability > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1declaredExtensions_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< std::string > *arg2 = (std::vector< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(std::vector< std::string > **)&jarg2; 
  if (arg1) (arg1)->declared_extensions = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1declaredExtensions_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (std::vector< std::string > *)& ((arg1)->declared_extensions);
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1blockMeta_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< spirv_cross::ParsedIR::BlockMetaFlags > *arg2 = (std::vector< spirv_cross::ParsedIR::BlockMetaFlags > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::ParsedIR::BlockMetaFlags > **)&jarg2; 
  if (arg1) (arg1)->block_meta = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1blockMeta_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::vector< spirv_cross::ParsedIR::BlockMetaFlags > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (std::vector< spirv_cross::ParsedIR::BlockMetaFlags > *)& ((arg1)->block_meta);
  *(std::vector< spirv_cross::ParsedIR::BlockMetaFlags > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1continueBlockToLoopHeader_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::unordered_map< uint32_t,uint32_t > arg2 ;
  std::unordered_map< uint32_t,uint32_t > *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  argp2 = *(std::unordered_map< uint32_t,uint32_t > **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::unordered_map< uint32_t,uint32_t >");
    return ;
  }
  arg2 = *argp2; 
  if (arg1) (arg1)->continue_block_to_loop_header = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1continueBlockToLoopHeader_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::unordered_map< uint32_t,uint32_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result =  ((arg1)->continue_block_to_loop_header);
  *(std::unordered_map< uint32_t,uint32_t > **)&jresult = new std::unordered_map< uint32_t,uint32_t >((const std::unordered_map< uint32_t,uint32_t > &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1entryPoints_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::unordered_map< uint32_t,spirv_cross::SPIREntryPoint > *arg2 = (std::unordered_map< uint32_t,spirv_cross::SPIREntryPoint > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(std::unordered_map< uint32_t,spirv_cross::SPIREntryPoint > **)&jarg2; 
  if (arg1) (arg1)->entry_points = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1entryPoints_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::unordered_map< uint32_t,spirv_cross::SPIREntryPoint > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (std::unordered_map< uint32_t,spirv_cross::SPIREntryPoint > *)& ((arg1)->entry_points);
  *(std::unordered_map< uint32_t,spirv_cross::SPIREntryPoint > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1defaultEntryPoint_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->default_entry_point = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1defaultEntryPoint_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (uint32_t) ((arg1)->default_entry_point);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1Source_1version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::ParsedIR::Source *arg1 = (spirv_cross::ParsedIR::Source *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR::Source **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->version = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1Source_1version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR::Source *arg1 = (spirv_cross::ParsedIR::Source *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR::Source **)&jarg1; 
  result = (uint32_t) ((arg1)->version);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1Source_1es_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::ParsedIR::Source *arg1 = (spirv_cross::ParsedIR::Source *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR::Source **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->es = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1Source_1es_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::ParsedIR::Source *arg1 = (spirv_cross::ParsedIR::Source *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR::Source **)&jarg1; 
  result = (bool) ((arg1)->es);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1Source_1known_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::ParsedIR::Source *arg1 = (spirv_cross::ParsedIR::Source *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR::Source **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->known = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1Source_1known_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::ParsedIR::Source *arg1 = (spirv_cross::ParsedIR::Source *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR::Source **)&jarg1; 
  result = (bool) ((arg1)->known);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1Source_1hlsl_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::ParsedIR::Source *arg1 = (spirv_cross::ParsedIR::Source *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR::Source **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->hlsl = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1Source_1hlsl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::ParsedIR::Source *arg1 = (spirv_cross::ParsedIR::Source *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR::Source **)&jarg1; 
  result = (bool) ((arg1)->hlsl);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1ParsedIR_1Source(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR::Source *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::ParsedIR::Source *)new spirv_cross::ParsedIR::Source();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::Source::Source()"); return 0; 
      };
    }
  }
  *(spirv_cross::ParsedIR::Source **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1ParsedIR_1Source(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::ParsedIR::Source *arg1 = (spirv_cross::ParsedIR::Source *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::ParsedIR::Source **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::Source::~Source()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1source_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  spirv_cross::ParsedIR::Source *arg2 = (spirv_cross::ParsedIR::Source *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(spirv_cross::ParsedIR::Source **)&jarg2; 
  if (arg1) (arg1)->source = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1source_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  spirv_cross::ParsedIR::Source *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  result = (spirv_cross::ParsedIR::Source *)& ((arg1)->source);
  *(spirv_cross::ParsedIR::Source **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1setName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jstring jarg3) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->set_name(arg2,(std::string const &)*arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::set_name(uint32_t,std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jstring jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (std::string *) &((spirv_cross::ParsedIR const *)arg1)->get_name(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::get_name(uint32_t) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1setDecoration_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jlong jarg4) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  uint32_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  arg4 = (uint32_t)jarg4; 
  {
    try {
      (arg1)->set_decoration(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::set_decoration(uint32_t,spv::Decoration,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1setDecoration_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  {
    try {
      (arg1)->set_decoration(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::set_decoration(uint32_t,spv::Decoration)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1setDecorationString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jstring jarg4) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      (arg1)->set_decoration_string(arg2,arg3,(std::string const &)*arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::set_decoration_string(uint32_t,spv::Decoration,std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1hasDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  {
    try {
      result = (bool)((spirv_cross::ParsedIR const *)arg1)->has_decoration(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::has_decoration(uint32_t,spv::Decoration) const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1getDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  {
    try {
      result = (uint32_t)((spirv_cross::ParsedIR const *)arg1)->get_decoration(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::get_decoration(uint32_t,spv::Decoration) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1getDecorationString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jstring jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  {
    try {
      result = (std::string *) &((spirv_cross::ParsedIR const *)arg1)->get_decoration_string(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::get_decoration_string(uint32_t,spv::Decoration) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1getDecorationBitset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  spirv_cross::Bitset *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (spirv_cross::Bitset *) &((spirv_cross::ParsedIR const *)arg1)->get_decoration_bitset(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::get_decoration_bitset(uint32_t) const"); return 0; 
      };
    }
  }
  *(spirv_cross::Bitset **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1unsetDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  spv::Decoration arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (spv::Decoration)jarg3; 
  {
    try {
      (arg1)->unset_decoration(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::unset_decoration(uint32_t,spv::Decoration)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1setMemberName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jstring jarg4) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      (arg1)->set_member_name(arg2,arg3,(std::string const &)*arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::set_member_name(uint32_t,uint32_t,std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1getMemberName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (std::string *) &((spirv_cross::ParsedIR const *)arg1)->get_member_name(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::get_member_name(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1setMemberDecoration_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4, jlong jarg5) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  uint32_t arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  arg5 = (uint32_t)jarg5; 
  {
    try {
      (arg1)->set_member_decoration(arg2,arg3,arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::set_member_decoration(uint32_t,uint32_t,spv::Decoration,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1setMemberDecoration_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  {
    try {
      (arg1)->set_member_decoration(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::set_member_decoration(uint32_t,uint32_t,spv::Decoration)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1setMemberDecorationString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4, jstring jarg5) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  std::string *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  if(!jarg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0); 
  if (!arg5_pstr) return ;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  jenv->ReleaseStringUTFChars(jarg5, arg5_pstr); 
  {
    try {
      (arg1)->set_member_decoration_string(arg2,arg3,arg4,(std::string const &)*arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::set_member_decoration_string(uint32_t,uint32_t,spv::Decoration,std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1getMemberDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  {
    try {
      result = (uint32_t)((spirv_cross::ParsedIR const *)arg1)->get_member_decoration(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::get_member_decoration(uint32_t,uint32_t,spv::Decoration) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1getMemberDecorationString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  jstring jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  {
    try {
      result = (std::string *) &((spirv_cross::ParsedIR const *)arg1)->get_member_decoration_string(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::get_member_decoration_string(uint32_t,uint32_t,spv::Decoration) const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1hasMemberDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  {
    try {
      result = (bool)((spirv_cross::ParsedIR const *)arg1)->has_member_decoration(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::has_member_decoration(uint32_t,uint32_t,spv::Decoration) const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1getMemberDecorationBitset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spirv_cross::Bitset *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (spirv_cross::Bitset *) &((spirv_cross::ParsedIR const *)arg1)->get_member_decoration_bitset(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::get_member_decoration_bitset(uint32_t,uint32_t) const"); return 0; 
      };
    }
  }
  *(spirv_cross::Bitset **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1unsetMemberDecoration(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  spv::Decoration arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (spv::Decoration)jarg4; 
  {
    try {
      (arg1)->unset_member_decoration(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::unset_member_decoration(uint32_t,uint32_t,spv::Decoration)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1markUsedAsArrayLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      (arg1)->mark_used_as_array_length(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::mark_used_as_array_length(uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1increaseBoundBy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (uint32_t)(arg1)->increase_bound_by(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::increase_bound_by(uint32_t)"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1getBufferBlockFlags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  spirv_cross::SPIRVariable *arg2 = 0 ;
  spirv_cross::Bitset result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = *(spirv_cross::SPIRVariable **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::SPIRVariable const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((spirv_cross::ParsedIR const *)arg1)->get_buffer_block_flags((spirv_cross::SPIRVariable const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::get_buffer_block_flags(spirv_cross::SPIRVariable const &) const"); return 0; 
      };
    }
  }
  *(spirv_cross::Bitset **)&jresult = new spirv_cross::Bitset((const spirv_cross::Bitset &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1addTypedId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  spirv_cross::Types arg2 ;
  uint32_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (spirv_cross::Types)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      (arg1)->add_typed_id(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::add_typed_id(spirv_cross::Types,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1removeTypedId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  spirv_cross::Types arg2 ;
  uint32_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (spirv_cross::Types)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      (arg1)->remove_typed_id(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::remove_typed_id(spirv_cross::Types,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1resetAllOfType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  spirv_cross::Types arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (spirv_cross::Types)jarg2; 
  {
    try {
      (arg1)->reset_all_of_type(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::reset_all_of_type(spirv_cross::Types)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1findMeta_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  uint32_t arg2 ;
  spirv_cross::Meta *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (spirv_cross::Meta *)(arg1)->find_meta(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::find_meta(uint32_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::Meta **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ParsedIR_1getEmptyString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  {
    try {
      result = (std::string *) &((spirv_cross::ParsedIR const *)arg1)->get_empty_string();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::get_empty_string() const"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1ParsedIR(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::ParsedIR *)new spirv_cross::ParsedIR();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::ParsedIR()"); return 0; 
      };
    }
  }
  *(spirv_cross::ParsedIR **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1ParsedIR(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::ParsedIR *arg1 = (spirv_cross::ParsedIR *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::ParsedIR::~ParsedIR()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1location_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->location = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1location_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  result = (uint32_t) ((arg1)->location);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1mslBuffer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->msl_buffer = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1mslBuffer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  result = (uint32_t) ((arg1)->msl_buffer);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1mslOffset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->msl_offset = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1mslOffset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  result = (uint32_t) ((arg1)->msl_offset);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1mslStride_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->msl_stride = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1mslStride_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  result = (uint32_t) ((arg1)->msl_stride);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1perInstance_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->per_instance = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1perInstance_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  result = (bool) ((arg1)->per_instance);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1format_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  spirv_cross::MSLVertexFormat arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  arg2 = (spirv_cross::MSLVertexFormat)jarg2; 
  if (arg1) (arg1)->format = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  spirv_cross::MSLVertexFormat result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  result = (spirv_cross::MSLVertexFormat) ((arg1)->format);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1builtin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  spv::BuiltIn arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  arg2 = (spv::BuiltIn)jarg2; 
  if (arg1) (arg1)->builtin = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1builtin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  spv::BuiltIn result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  result = (spv::BuiltIn) ((arg1)->builtin);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1usedByShader_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->used_by_shader = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttr_1usedByShader_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  result = (bool) ((arg1)->used_by_shader);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1MSLVertexAttr(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::MSLVertexAttr *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::MSLVertexAttr *)new spirv_cross::MSLVertexAttr();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::MSLVertexAttr::MSLVertexAttr()"); return 0; 
      };
    }
  }
  *(spirv_cross::MSLVertexAttr **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1MSLVertexAttr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::MSLVertexAttr *arg1 = (spirv_cross::MSLVertexAttr *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::MSLVertexAttr **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::MSLVertexAttr::~MSLVertexAttr()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1stage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  spv::ExecutionModel arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  arg2 = (spv::ExecutionModel)jarg2; 
  if (arg1) (arg1)->stage = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1stage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  spv::ExecutionModel result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  result = (spv::ExecutionModel) ((arg1)->stage);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1descSet_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->desc_set = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1descSet_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  result = (uint32_t) ((arg1)->desc_set);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1binding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->binding = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1binding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  result = (uint32_t) ((arg1)->binding);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1mslBuffer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->msl_buffer = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1mslBuffer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  result = (uint32_t) ((arg1)->msl_buffer);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1mslTexture_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->msl_texture = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1mslTexture_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  result = (uint32_t) ((arg1)->msl_texture);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1mslSampler_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->msl_sampler = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1mslSampler_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  result = (uint32_t) ((arg1)->msl_sampler);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1usedByShader_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->used_by_shader = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBinding_1usedByShader_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  result = (bool) ((arg1)->used_by_shader);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1MSLResourceBinding(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::MSLResourceBinding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::MSLResourceBinding *)new spirv_cross::MSLResourceBinding();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::MSLResourceBinding::MSLResourceBinding()"); return 0; 
      };
    }
  }
  *(spirv_cross::MSLResourceBinding **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1MSLResourceBinding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::MSLResourceBinding *arg1 = (spirv_cross::MSLResourceBinding *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::MSLResourceBinding **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::MSLResourceBinding::~MSLResourceBinding()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1coord_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerCoord arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (spirv_cross::MSLSamplerCoord)jarg2; 
  if (arg1) (arg1)->coord = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1coord_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerCoord result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (spirv_cross::MSLSamplerCoord) ((arg1)->coord);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1minFilter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerFilter arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (spirv_cross::MSLSamplerFilter)jarg2; 
  if (arg1) (arg1)->min_filter = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1minFilter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerFilter result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (spirv_cross::MSLSamplerFilter) ((arg1)->min_filter);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1magFilter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerFilter arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (spirv_cross::MSLSamplerFilter)jarg2; 
  if (arg1) (arg1)->mag_filter = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1magFilter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerFilter result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (spirv_cross::MSLSamplerFilter) ((arg1)->mag_filter);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1mipFilter_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerMipFilter arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (spirv_cross::MSLSamplerMipFilter)jarg2; 
  if (arg1) (arg1)->mip_filter = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1mipFilter_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerMipFilter result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (spirv_cross::MSLSamplerMipFilter) ((arg1)->mip_filter);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1sAddress_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerAddress arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (spirv_cross::MSLSamplerAddress)jarg2; 
  if (arg1) (arg1)->s_address = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1sAddress_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (spirv_cross::MSLSamplerAddress) ((arg1)->s_address);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1tAddress_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerAddress arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (spirv_cross::MSLSamplerAddress)jarg2; 
  if (arg1) (arg1)->t_address = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1tAddress_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (spirv_cross::MSLSamplerAddress) ((arg1)->t_address);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1rAddress_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerAddress arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (spirv_cross::MSLSamplerAddress)jarg2; 
  if (arg1) (arg1)->r_address = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1rAddress_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerAddress result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (spirv_cross::MSLSamplerAddress) ((arg1)->r_address);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1compareFunc_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerCompareFunc arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (spirv_cross::MSLSamplerCompareFunc)jarg2; 
  if (arg1) (arg1)->compare_func = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1compareFunc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerCompareFunc result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (spirv_cross::MSLSamplerCompareFunc) ((arg1)->compare_func);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1borderColor_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerBorderColor arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (spirv_cross::MSLSamplerBorderColor)jarg2; 
  if (arg1) (arg1)->border_color = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1borderColor_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  spirv_cross::MSLSamplerBorderColor result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (spirv_cross::MSLSamplerBorderColor) ((arg1)->border_color);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1lodClampMin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->lod_clamp_min = arg2;
}


SWIGEXPORT jfloat JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1lodClampMin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (float) ((arg1)->lod_clamp_min);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1lodClampMax_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (float)jarg2; 
  if (arg1) (arg1)->lod_clamp_max = arg2;
}


SWIGEXPORT jfloat JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1lodClampMax_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jfloat jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (float) ((arg1)->lod_clamp_max);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1maxAnisotropy_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->max_anisotropy = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1maxAnisotropy_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (int) ((arg1)->max_anisotropy);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1compareEnable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->compare_enable = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1compareEnable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (bool) ((arg1)->compare_enable);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1lodClampEnable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->lod_clamp_enable = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1lodClampEnable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (bool) ((arg1)->lod_clamp_enable);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1anisotropyEnable_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->anisotropy_enable = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLConstexprSampler_1anisotropyEnable_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  result = (bool) ((arg1)->anisotropy_enable);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1MSLConstexprSampler(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::MSLConstexprSampler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::MSLConstexprSampler *)new spirv_cross::MSLConstexprSampler();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::MSLConstexprSampler::MSLConstexprSampler()"); return 0; 
      };
    }
  }
  *(spirv_cross::MSLConstexprSampler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1MSLConstexprSampler(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::MSLConstexprSampler *arg1 = (spirv_cross::MSLConstexprSampler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::MSLConstexprSampler **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::MSLConstexprSampler::~MSLConstexprSampler()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_kPushConstDescSet_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)spirv_cross::kPushConstDescSet;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_kPushConstBinding_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  result = (uint32_t)(uint32_t)spirv_cross::kPushConstBinding;
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1platform_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  spirv_cross::CompilerMSL::Options::Platform arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (spirv_cross::CompilerMSL::Options::Platform)jarg2; 
  if (arg1) (arg1)->platform = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1platform_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  spirv_cross::CompilerMSL::Options::Platform result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (spirv_cross::CompilerMSL::Options::Platform) ((arg1)->platform);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1mslVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->msl_version = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1mslVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (uint32_t) ((arg1)->msl_version);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1texelBufferTextureWidth_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->texel_buffer_texture_width = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1texelBufferTextureWidth_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (uint32_t) ((arg1)->texel_buffer_texture_width);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1auxBufferIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->aux_buffer_index = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1auxBufferIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (uint32_t) ((arg1)->aux_buffer_index);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1indirectParamsBufferIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->indirect_params_buffer_index = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1indirectParamsBufferIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (uint32_t) ((arg1)->indirect_params_buffer_index);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1shaderOutputBufferIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->shader_output_buffer_index = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1shaderOutputBufferIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (uint32_t) ((arg1)->shader_output_buffer_index);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1shaderPatchOutputBufferIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->shader_patch_output_buffer_index = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1shaderPatchOutputBufferIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (uint32_t) ((arg1)->shader_patch_output_buffer_index);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1shaderTessFactorBufferIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->shader_tess_factor_buffer_index = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1shaderTessFactorBufferIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (uint32_t) ((arg1)->shader_tess_factor_buffer_index);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1shaderInputWgIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  if (arg1) (arg1)->shader_input_wg_index = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1shaderInputWgIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (uint32_t) ((arg1)->shader_input_wg_index);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1enablePointSizeBuiltin_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->enable_point_size_builtin = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1enablePointSizeBuiltin_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (bool) ((arg1)->enable_point_size_builtin);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1disableRasterization_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->disable_rasterization = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1disableRasterization_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (bool) ((arg1)->disable_rasterization);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1captureOutputToBuffer_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->capture_output_to_buffer = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1captureOutputToBuffer_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (bool) ((arg1)->capture_output_to_buffer);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1swizzleTextureSamples_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->swizzle_texture_samples = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1swizzleTextureSamples_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (bool) ((arg1)->swizzle_texture_samples);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1tessDomainOriginLowerLeft_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->tess_domain_origin_lower_left = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1tessDomainOriginLowerLeft_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (bool) ((arg1)->tess_domain_origin_lower_left);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1padFragmentOutputComponents_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->pad_fragment_output_components = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1padFragmentOutputComponents_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  result = (bool) ((arg1)->pad_fragment_output_components);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1isIos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->is_ios();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::Options::is_ios()"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1isMacos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->is_macos();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::Options::is_macos()"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1supportsMslVersion_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  uint32_t arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  arg4 = (uint32_t)jarg4; 
  {
    try {
      result = (bool)(arg1)->supports_msl_version(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::Options::supports_msl_version(uint32_t,uint32_t,uint32_t)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1supportsMslVersion_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (bool)(arg1)->supports_msl_version(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::Options::supports_msl_version(uint32_t,uint32_t)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1supportsMslVersion_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  uint32_t arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (bool)(arg1)->supports_msl_version(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::Options::supports_msl_version(uint32_t)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1makeMslVersion_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      result = (uint32_t)spirv_cross::CompilerMSL::Options::make_msl_version(arg1,arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::Options::make_msl_version(uint32_t,uint32_t,uint32_t)"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1makeMslVersion_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint32_t arg2 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  arg2 = (uint32_t)jarg2; 
  {
    try {
      result = (uint32_t)spirv_cross::CompilerMSL::Options::make_msl_version(arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::Options::make_msl_version(uint32_t,uint32_t)"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1Options_1makeMslVersion_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  uint32_t arg1 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (uint32_t)jarg1; 
  {
    try {
      result = (uint32_t)spirv_cross::CompilerMSL::Options::make_msl_version(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::Options::make_msl_version(uint32_t)"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1Options(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spirv_cross::CompilerMSL::Options *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spirv_cross::CompilerMSL::Options *)new spirv_cross::CompilerMSL::Options();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::Options::Options()"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL::Options **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1CompilerMSL_1Options(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::CompilerMSL::Options *arg1 = (spirv_cross::CompilerMSL::Options *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::CompilerMSL::Options **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::Options::~Options()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1getMslOptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  spirv_cross::CompilerMSL::Options *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  {
    try {
      result = (spirv_cross::CompilerMSL::Options *) &((spirv_cross::CompilerMSL const *)arg1)->get_msl_options();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::get_msl_options() const"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL::Options **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1setOptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  spirv_cross::CompilerMSL::Options *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  arg2 = *(spirv_cross::CompilerMSL::Options **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::CompilerMSL::Options & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_options(*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::set_options(spirv_cross::CompilerMSL::Options &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1setMslOptions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  spirv_cross::CompilerMSL::Options *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  arg2 = *(spirv_cross::CompilerMSL::Options **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::CompilerMSL::Options const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_msl_options((spirv_cross::CompilerMSL::Options const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::set_msl_options(spirv_cross::CompilerMSL::Options const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1getIsRasterizationDisabled(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  {
    try {
      result = (bool)((spirv_cross::CompilerMSL const *)arg1)->get_is_rasterization_disabled();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::get_is_rasterization_disabled() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1needsAuxBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  {
    try {
      result = (bool)((spirv_cross::CompilerMSL const *)arg1)->needs_aux_buffer();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::needs_aux_buffer() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1needsOutputBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  {
    try {
      result = (bool)((spirv_cross::CompilerMSL const *)arg1)->needs_output_buffer();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::needs_output_buffer() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1needsPatchOutputBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  {
    try {
      result = (bool)((spirv_cross::CompilerMSL const *)arg1)->needs_patch_output_buffer();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::needs_patch_output_buffer() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1needsInputThreadgroupMem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  {
    try {
      result = (bool)((spirv_cross::CompilerMSL const *)arg1)->needs_input_threadgroup_mem();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::needs_input_threadgroup_mem() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > arg1 ;
  std::vector< spirv_cross::MSLVertexAttr > *arg2 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  std::vector< spirv_cross::MSLResourceBinding > *arg3 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  std::vector< uint32_t > *argp1 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  argp1 = *(std::vector< uint32_t > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< uint32_t >");
    return 0;
  }
  arg1 = *argp1; 
  arg2 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg2; 
  arg3 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg3; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL(arg1,arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(std::vector< uint32_t >,std::vector< spirv_cross::MSLVertexAttr > *,std::vector< spirv_cross::MSLResourceBinding > *)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > arg1 ;
  std::vector< spirv_cross::MSLVertexAttr > *arg2 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  std::vector< uint32_t > *argp1 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  argp1 = *(std::vector< uint32_t > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< uint32_t >");
    return 0;
  }
  arg1 = *argp1; 
  arg2 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg2; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL(arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(std::vector< uint32_t >,std::vector< spirv_cross::MSLVertexAttr > *)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > arg1 ;
  std::vector< uint32_t > *argp1 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(std::vector< uint32_t > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< uint32_t >");
    return 0;
  }
  arg1 = *argp1; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(std::vector< uint32_t >)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jlong jarg5, jobject jarg5_, jlong jarg6) {
  jlong jresult = 0 ;
  uint32_t *arg1 = (uint32_t *) 0 ;
  size_t arg2 ;
  spirv_cross::MSLVertexAttr *arg3 = (spirv_cross::MSLVertexAttr *) 0 ;
  size_t arg4 ;
  spirv_cross::MSLResourceBinding *arg5 = (spirv_cross::MSLResourceBinding *) 0 ;
  size_t arg6 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg5_;
  arg1 = *(uint32_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = *(spirv_cross::MSLVertexAttr **)&jarg3; 
  arg4 = (size_t)jarg4; 
  arg5 = *(spirv_cross::MSLResourceBinding **)&jarg5; 
  arg6 = (size_t)jarg6; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL((uint32_t const *)arg1,arg2,arg3,arg4,arg5,arg6);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(uint32_t const *,size_t,spirv_cross::MSLVertexAttr *,size_t,spirv_cross::MSLResourceBinding *,size_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  uint32_t *arg1 = (uint32_t *) 0 ;
  size_t arg2 ;
  spirv_cross::MSLVertexAttr *arg3 = (spirv_cross::MSLVertexAttr *) 0 ;
  size_t arg4 ;
  spirv_cross::MSLResourceBinding *arg5 = (spirv_cross::MSLResourceBinding *) 0 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg5_;
  arg1 = *(uint32_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = *(spirv_cross::MSLVertexAttr **)&jarg3; 
  arg4 = (size_t)jarg4; 
  arg5 = *(spirv_cross::MSLResourceBinding **)&jarg5; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL((uint32_t const *)arg1,arg2,arg3,arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(uint32_t const *,size_t,spirv_cross::MSLVertexAttr *,size_t,spirv_cross::MSLResourceBinding *)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4) {
  jlong jresult = 0 ;
  uint32_t *arg1 = (uint32_t *) 0 ;
  size_t arg2 ;
  spirv_cross::MSLVertexAttr *arg3 = (spirv_cross::MSLVertexAttr *) 0 ;
  size_t arg4 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = *(uint32_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = *(spirv_cross::MSLVertexAttr **)&jarg3; 
  arg4 = (size_t)jarg4; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL((uint32_t const *)arg1,arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(uint32_t const *,size_t,spirv_cross::MSLVertexAttr *,size_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  uint32_t *arg1 = (uint32_t *) 0 ;
  size_t arg2 ;
  spirv_cross::MSLVertexAttr *arg3 = (spirv_cross::MSLVertexAttr *) 0 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = *(uint32_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = *(spirv_cross::MSLVertexAttr **)&jarg3; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL((uint32_t const *)arg1,arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(uint32_t const *,size_t,spirv_cross::MSLVertexAttr *)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  uint32_t *arg1 = (uint32_t *) 0 ;
  size_t arg2 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uint32_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL((uint32_t const *)arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(uint32_t const *,size_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_, jlong jarg5) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = 0 ;
  spirv_cross::MSLVertexAttr *arg2 = (spirv_cross::MSLVertexAttr *) 0 ;
  size_t arg3 ;
  spirv_cross::MSLResourceBinding *arg4 = (spirv_cross::MSLResourceBinding *) 0 ;
  size_t arg5 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::ParsedIR const & reference is null");
    return 0;
  } 
  arg2 = *(spirv_cross::MSLVertexAttr **)&jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = *(spirv_cross::MSLResourceBinding **)&jarg4; 
  arg5 = (size_t)jarg5; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL((spirv_cross::ParsedIR const &)*arg1,arg2,arg3,arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(spirv_cross::ParsedIR const &,spirv_cross::MSLVertexAttr *,size_t,spirv_cross::MSLResourceBinding *,size_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = 0 ;
  spirv_cross::MSLVertexAttr *arg2 = (spirv_cross::MSLVertexAttr *) 0 ;
  size_t arg3 ;
  spirv_cross::MSLResourceBinding *arg4 = (spirv_cross::MSLResourceBinding *) 0 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::ParsedIR const & reference is null");
    return 0;
  } 
  arg2 = *(spirv_cross::MSLVertexAttr **)&jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = *(spirv_cross::MSLResourceBinding **)&jarg4; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL((spirv_cross::ParsedIR const &)*arg1,arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(spirv_cross::ParsedIR const &,spirv_cross::MSLVertexAttr *,size_t,spirv_cross::MSLResourceBinding *)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_110(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = 0 ;
  spirv_cross::MSLVertexAttr *arg2 = (spirv_cross::MSLVertexAttr *) 0 ;
  size_t arg3 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::ParsedIR const & reference is null");
    return 0;
  } 
  arg2 = *(spirv_cross::MSLVertexAttr **)&jarg2; 
  arg3 = (size_t)jarg3; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL((spirv_cross::ParsedIR const &)*arg1,arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(spirv_cross::ParsedIR const &,spirv_cross::MSLVertexAttr *,size_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_111(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = 0 ;
  spirv_cross::MSLVertexAttr *arg2 = (spirv_cross::MSLVertexAttr *) 0 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::ParsedIR const & reference is null");
    return 0;
  } 
  arg2 = *(spirv_cross::MSLVertexAttr **)&jarg2; 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL((spirv_cross::ParsedIR const &)*arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(spirv_cross::ParsedIR const &,spirv_cross::MSLVertexAttr *)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerMSL_1_1SWIG_112(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = 0 ;
  spirv_cross::CompilerMSL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::ParsedIR const & reference is null");
    return 0;
  } 
  {
    try {
      result = (spirv_cross::CompilerMSL *)new spirv_cross::CompilerMSL((spirv_cross::ParsedIR const &)*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::CompilerMSL(spirv_cross::ParsedIR const &)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerMSL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1compile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  {
    try {
      result = (arg1)->compile();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::compile()"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1compile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jstring jresult = 0 ;
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  std::vector< spirv_cross::MSLVertexAttr > *arg2 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  std::vector< spirv_cross::MSLResourceBinding > *arg3 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg2; 
  arg3 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg3; 
  {
    try {
      result = (arg1)->compile(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::compile(std::vector< spirv_cross::MSLVertexAttr > *,std::vector< spirv_cross::MSLResourceBinding > *)"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1compile_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jstring jresult = 0 ;
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  spirv_cross::CompilerMSL::MSLConfiguration *arg2 = 0 ;
  std::vector< spirv_cross::MSLVertexAttr > *arg3 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  std::vector< spirv_cross::MSLResourceBinding > *arg4 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  arg2 = *(spirv_cross::CompilerMSL::MSLConfiguration **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::CompilerMSL::MSLConfiguration & reference is null");
    return 0;
  } 
  arg3 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg3; 
  arg4 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg4; 
  {
    try {
      result = (arg1)->compile(*arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::compile(spirv_cross::CompilerMSL::MSLConfiguration &,std::vector< spirv_cross::MSLVertexAttr > *,std::vector< spirv_cross::MSLResourceBinding > *)"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1compile_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jstring jresult = 0 ;
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  spirv_cross::CompilerMSL::MSLConfiguration *arg2 = 0 ;
  std::vector< spirv_cross::MSLVertexAttr > *arg3 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  arg2 = *(spirv_cross::CompilerMSL::MSLConfiguration **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::CompilerMSL::MSLConfiguration & reference is null");
    return 0;
  } 
  arg3 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg3; 
  {
    try {
      result = (arg1)->compile(*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::compile(spirv_cross::CompilerMSL::MSLConfiguration &,std::vector< spirv_cross::MSLVertexAttr > *)"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1compile_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  spirv_cross::CompilerMSL::MSLConfiguration *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  arg2 = *(spirv_cross::CompilerMSL::MSLConfiguration **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::CompilerMSL::MSLConfiguration & reference is null");
    return 0;
  } 
  {
    try {
      result = (arg1)->compile(*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::compile(spirv_cross::CompilerMSL::MSLConfiguration &)"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1remapConstexprSampler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  uint32_t arg2 ;
  spirv_cross::MSLConstexprSampler *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = *(spirv_cross::MSLConstexprSampler **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::MSLConstexprSampler const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->remap_constexpr_sampler(arg2,(spirv_cross::MSLConstexprSampler const &)*arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::remap_constexpr_sampler(uint32_t,spirv_cross::MSLConstexprSampler const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1setFragmentOutputComponents(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  uint32_t arg2 ;
  uint32_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  arg2 = (uint32_t)jarg2; 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      (arg1)->set_fragment_output_components(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::set_fragment_output_components(uint32_t,uint32_t)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1CompilerMSL(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::CompilerMSL *arg1 = (spirv_cross::CompilerMSL *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::CompilerMSL **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerMSL::~CompilerMSL()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerReflection_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > arg1 ;
  std::vector< uint32_t > *argp1 ;
  spirv_cross::CompilerReflection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(std::vector< uint32_t > **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::vector< uint32_t >");
    return 0;
  }
  arg1 = *argp1; 
  {
    try {
      result = (spirv_cross::CompilerReflection *)new spirv_cross::CompilerReflection(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerReflection::CompilerReflection(std::vector< uint32_t >)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerReflection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerReflection_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  uint32_t *arg1 = (uint32_t *) 0 ;
  size_t arg2 ;
  spirv_cross::CompilerReflection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(uint32_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try {
      result = (spirv_cross::CompilerReflection *)new spirv_cross::CompilerReflection((uint32_t const *)arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerReflection::CompilerReflection(uint32_t const *,size_t)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerReflection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CompilerReflection_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  spirv_cross::ParsedIR *arg1 = 0 ;
  spirv_cross::CompilerReflection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::ParsedIR **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "spirv_cross::ParsedIR const & reference is null");
    return 0;
  } 
  {
    try {
      result = (spirv_cross::CompilerReflection *)new spirv_cross::CompilerReflection((spirv_cross::ParsedIR const &)*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerReflection::CompilerReflection(spirv_cross::ParsedIR const &)"); return 0; 
      };
    }
  }
  *(spirv_cross::CompilerReflection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerReflection_1setFormat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  spirv_cross::CompilerReflection *arg1 = (spirv_cross::CompilerReflection *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerReflection **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->set_format((std::string const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerReflection::set_format(std::string const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerReflection_1compile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  spirv_cross::CompilerReflection *arg1 = (spirv_cross::CompilerReflection *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(spirv_cross::CompilerReflection **)&jarg1; 
  {
    try {
      result = (arg1)->compile();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerReflection::compile()"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1CompilerReflection(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spirv_cross::CompilerReflection *arg1 = (spirv_cross::CompilerReflection *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spirv_cross::CompilerReflection **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spirv_cross::CompilerReflection::~CompilerReflection()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1TShHandleBase(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TShHandleBase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (TShHandleBase *)new TShHandleBase();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TShHandleBase::TShHandleBase()"); return 0; 
      };
    }
  }
  *(TShHandleBase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TShHandleBase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  TShHandleBase *arg1 = (TShHandleBase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TShHandleBase **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TShHandleBase::~TShHandleBase()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShHandleBase_1getAsCompiler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TShHandleBase *arg1 = (TShHandleBase *) 0 ;
  TCompiler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TShHandleBase **)&jarg1; 
  {
    try {
      result = (TCompiler *)(arg1)->getAsCompiler();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TShHandleBase::getAsCompiler()"); return 0; 
      };
    }
  }
  *(TCompiler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShHandleBase_1getAsLinker(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TShHandleBase *arg1 = (TShHandleBase *) 0 ;
  TLinker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TShHandleBase **)&jarg1; 
  {
    try {
      result = (TLinker *)(arg1)->getAsLinker();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TShHandleBase::getAsLinker()"); return 0; 
      };
    }
  }
  *(TLinker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShHandleBase_1getAsUniformMap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TShHandleBase *arg1 = (TShHandleBase *) 0 ;
  TUniformMap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TShHandleBase **)&jarg1; 
  {
    try {
      result = (TUniformMap *)(arg1)->getAsUniformMap();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TShHandleBase::getAsUniformMap()"); return 0; 
      };
    }
  }
  *(TUniformMap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShHandleBase_1getPool(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TShHandleBase *arg1 = (TShHandleBase *) 0 ;
  glslang::TPoolAllocator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TShHandleBase **)&jarg1; 
  {
    try {
      result = (glslang::TPoolAllocator *)((TShHandleBase const *)arg1)->getPool();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TShHandleBase::getPool() const"); return 0; 
      };
    }
  }
  *(glslang::TPoolAllocator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TUniformMap(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  TUniformMap *arg1 = (TUniformMap *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TUniformMap **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TUniformMap::~TUniformMap()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TUniformMap_1getAsUniformMap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TUniformMap *arg1 = (TUniformMap *) 0 ;
  TUniformMap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TUniformMap **)&jarg1; 
  {
    try {
      result = (TUniformMap *)(arg1)->getAsUniformMap();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TUniformMap::getAsUniformMap()"); return 0; 
      };
    }
  }
  *(TUniformMap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TUniformMap_1getLocation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  TUniformMap *arg1 = (TUniformMap *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TUniformMap **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = (int)(arg1)->getLocation((char const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TUniformMap::getLocation(char const *)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TUniformMap_1getInfoSink(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TUniformMap *arg1 = (TUniformMap *) 0 ;
  TInfoSink *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TUniformMap **)&jarg1; 
  {
    try {
      result = (TInfoSink *) &(arg1)->getInfoSink();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TUniformMap::getInfoSink()"); return 0; 
      };
    }
  }
  *(TInfoSink **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TCompiler(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  TCompiler *arg1 = (TCompiler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TCompiler **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TCompiler::~TCompiler()"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TCompiler_1getLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  TCompiler *arg1 = (TCompiler *) 0 ;
  EShLanguage result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TCompiler **)&jarg1; 
  {
    try {
      result = (EShLanguage)(arg1)->getLanguage();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TCompiler::getLanguage()"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TCompiler_1getInfoSink(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TCompiler *arg1 = (TCompiler *) 0 ;
  TInfoSink *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TCompiler **)&jarg1; 
  {
    try {
      result = (TInfoSink *) &(arg1)->getInfoSink();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TCompiler::getInfoSink()"); return 0; 
      };
    }
  }
  *(TInfoSink **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TCompiler_1compile_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4) {
  jboolean jresult = 0 ;
  TCompiler *arg1 = (TCompiler *) 0 ;
  TIntermNode *arg2 = (TIntermNode *) 0 ;
  int arg3 ;
  EProfile arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TCompiler **)&jarg1; 
  arg2 = *(TIntermNode **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (EProfile)jarg4; 
  {
    try {
      result = (bool)(arg1)->compile(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TCompiler::compile(TIntermNode *,int,EProfile)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TCompiler_1compile_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  TCompiler *arg1 = (TCompiler *) 0 ;
  TIntermNode *arg2 = (TIntermNode *) 0 ;
  int arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TCompiler **)&jarg1; 
  arg2 = *(TIntermNode **)&jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      result = (bool)(arg1)->compile(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TCompiler::compile(TIntermNode *,int)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TCompiler_1compile_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  TCompiler *arg1 = (TCompiler *) 0 ;
  TIntermNode *arg2 = (TIntermNode *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TCompiler **)&jarg1; 
  arg2 = *(TIntermNode **)&jarg2; 
  {
    try {
      result = (bool)(arg1)->compile(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TCompiler::compile(TIntermNode *)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TCompiler_1getAsCompiler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TCompiler *arg1 = (TCompiler *) 0 ;
  TCompiler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TCompiler **)&jarg1; 
  {
    try {
      result = (TCompiler *)(arg1)->getAsCompiler();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TCompiler::getAsCompiler()"); return 0; 
      };
    }
  }
  *(TCompiler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TCompiler_1linkable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  TCompiler *arg1 = (TCompiler *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TCompiler **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->linkable();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TCompiler::linkable()"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TLinker_1getAsLinker(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TLinker *arg1 = (TLinker *) 0 ;
  TLinker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TLinker **)&jarg1; 
  {
    try {
      result = (TLinker *)(arg1)->getAsLinker();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TLinker::getAsLinker()"); return 0; 
      };
    }
  }
  *(TLinker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TLinker(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  TLinker *arg1 = (TLinker *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TLinker **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TLinker::~TLinker()"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TLinker_1link_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jboolean jresult = 0 ;
  TLinker *arg1 = (TLinker *) 0 ;
  TCompilerList *arg2 = 0 ;
  TUniformMap *arg3 = (TUniformMap *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(TLinker **)&jarg1; 
  arg2 = *(TCompilerList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "TCompilerList & reference is null");
    return 0;
  } 
  arg3 = *(TUniformMap **)&jarg3; 
  {
    try {
      result = (bool)(arg1)->link(*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TLinker::link(TCompilerList &,TUniformMap *)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TLinker_1link_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  TLinker *arg1 = (TLinker *) 0 ;
  THandleList *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TLinker **)&jarg1; 
  arg2 = *(THandleList **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "THandleList & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->link(*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TLinker::link(THandleList &)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TLinker_1setAppAttributeBindings(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  TLinker *arg1 = (TLinker *) 0 ;
  ShBindingTable *arg2 = (ShBindingTable *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(TLinker **)&jarg1; 
  arg2 = *(ShBindingTable **)&jarg2; 
  {
    try {
      (arg1)->setAppAttributeBindings((ShBindingTable const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TLinker::setAppAttributeBindings(ShBindingTable const *)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TLinker_1setFixedAttributeBindings(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  TLinker *arg1 = (TLinker *) 0 ;
  ShBindingTable *arg2 = (ShBindingTable *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(TLinker **)&jarg1; 
  arg2 = *(ShBindingTable **)&jarg2; 
  {
    try {
      (arg1)->setFixedAttributeBindings((ShBindingTable const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TLinker::setFixedAttributeBindings(ShBindingTable const *)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TLinker_1getAttributeBindings(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  TLinker *arg1 = (TLinker *) 0 ;
  ShBindingTable **arg2 = (ShBindingTable **) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TLinker **)&jarg1; 
  arg2 = *(ShBindingTable ***)&jarg2; 
  {
    try {
      ((TLinker const *)arg1)->getAttributeBindings((ShBindingTable const **)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TLinker::getAttributeBindings(ShBindingTable const **) const"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TLinker_1setExcludedAttributes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  TLinker *arg1 = (TLinker *) 0 ;
  int *arg2 = (int *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TLinker **)&jarg1; 
  arg2 = *(int **)&jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      (arg1)->setExcludedAttributes((int const *)arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TLinker::setExcludedAttributes(int const *,int)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TLinker_1getUniformBindings(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TLinker *arg1 = (TLinker *) 0 ;
  ShBindingTable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TLinker **)&jarg1; 
  {
    try {
      result = (ShBindingTable *)((TLinker const *)arg1)->getUniformBindings();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TLinker::getUniformBindings() const"); return 0; 
      };
    }
  }
  *(ShBindingTable **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TLinker_1getObjectCode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TLinker *arg1 = (TLinker *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TLinker **)&jarg1; 
  {
    try {
      result = (void *)((TLinker const *)arg1)->getObjectCode();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TLinker::getObjectCode() const"); return 0; 
      };
    }
  }
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TLinker_1getInfoSink(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  TLinker *arg1 = (TLinker *) 0 ;
  TInfoSink *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TLinker **)&jarg1; 
  {
    try {
      result = (TInfoSink *) &(arg1)->getInfoSink();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in TLinker::getInfoSink()"); return 0; 
      };
    }
  }
  *(TInfoSink **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_constructCompiler(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  EShLanguage arg1 ;
  int arg2 ;
  TCompiler *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (EShLanguage)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (TCompiler *)ConstructCompiler(arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ConstructCompiler(EShLanguage,int)"); return 0; 
      };
    }
  }
  *(TCompiler **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_constructLinker(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  EShExecutable arg1 ;
  int arg2 ;
  TShHandleBase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (EShExecutable)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (TShHandleBase *)ConstructLinker(arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ConstructLinker(EShExecutable,int)"); return 0; 
      };
    }
  }
  *(TShHandleBase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_constructBindings(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TShHandleBase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (TShHandleBase *)ConstructBindings();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ConstructBindings()"); return 0; 
      };
    }
  }
  *(TShHandleBase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_deleteLinker(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  TShHandleBase *arg1 = (TShHandleBase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TShHandleBase **)&jarg1; 
  {
    try {
      DeleteLinker(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in DeleteLinker(TShHandleBase *)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_deleteBindingList(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  TShHandleBase *arg1 = (TShHandleBase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TShHandleBase **)&jarg1; 
  {
    try {
      DeleteBindingList(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in DeleteBindingList(TShHandleBase *)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_constructUniformMap(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TUniformMap *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (TUniformMap *)ConstructUniformMap();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ConstructUniformMap()"); return 0; 
      };
    }
  }
  *(TUniformMap **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_deleteCompiler(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  TCompiler *arg1 = (TCompiler *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TCompiler **)&jarg1; 
  {
    try {
      DeleteCompiler(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in DeleteCompiler(TCompiler *)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_deleteUniformMap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  TUniformMap *arg1 = (TUniformMap *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(TUniformMap **)&jarg1; 
  {
    try {
      DeleteUniformMap(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in DeleteUniformMap(TUniformMap *)"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shInitialize(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (int)ShInitialize();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShInitialize()"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shFinalize(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (int)ShFinalize();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShFinalize()"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TInputLanguage_1languageFamily_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TInputLanguage *arg1 = (glslang::TInputLanguage *) 0 ;
  glslang::EShSource arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TInputLanguage **)&jarg1; 
  arg2 = (glslang::EShSource)jarg2; 
  if (arg1) (arg1)->languageFamily = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TInputLanguage_1languageFamily_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TInputLanguage *arg1 = (glslang::TInputLanguage *) 0 ;
  glslang::EShSource result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TInputLanguage **)&jarg1; 
  result = (glslang::EShSource) ((arg1)->languageFamily);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TInputLanguage_1stage_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TInputLanguage *arg1 = (glslang::TInputLanguage *) 0 ;
  EShLanguage arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TInputLanguage **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  if (arg1) (arg1)->stage = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TInputLanguage_1stage_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TInputLanguage *arg1 = (glslang::TInputLanguage *) 0 ;
  EShLanguage result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TInputLanguage **)&jarg1; 
  result = (EShLanguage) ((arg1)->stage);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TInputLanguage_1dialect_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TInputLanguage *arg1 = (glslang::TInputLanguage *) 0 ;
  glslang::EShClient arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TInputLanguage **)&jarg1; 
  arg2 = (glslang::EShClient)jarg2; 
  if (arg1) (arg1)->dialect = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TInputLanguage_1dialect_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TInputLanguage *arg1 = (glslang::TInputLanguage *) 0 ;
  glslang::EShClient result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TInputLanguage **)&jarg1; 
  result = (glslang::EShClient) ((arg1)->dialect);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TInputLanguage_1dialectVersion_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TInputLanguage *arg1 = (glslang::TInputLanguage *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TInputLanguage **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->dialectVersion = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TInputLanguage_1dialectVersion_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TInputLanguage *arg1 = (glslang::TInputLanguage *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TInputLanguage **)&jarg1; 
  result = (int) ((arg1)->dialectVersion);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1TInputLanguage(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  glslang::TInputLanguage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (glslang::TInputLanguage *)new glslang::TInputLanguage();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TInputLanguage::TInputLanguage()"); return 0; 
      };
    }
  }
  *(glslang::TInputLanguage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TInputLanguage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::TInputLanguage *arg1 = (glslang::TInputLanguage *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::TInputLanguage **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TInputLanguage::~TInputLanguage()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TClient_1client_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TClient *arg1 = (glslang::TClient *) 0 ;
  glslang::EShClient arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TClient **)&jarg1; 
  arg2 = (glslang::EShClient)jarg2; 
  if (arg1) (arg1)->client = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TClient_1client_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TClient *arg1 = (glslang::TClient *) 0 ;
  glslang::EShClient result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TClient **)&jarg1; 
  result = (glslang::EShClient) ((arg1)->client);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TClient_1version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TClient *arg1 = (glslang::TClient *) 0 ;
  glslang::EShTargetClientVersion arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TClient **)&jarg1; 
  arg2 = (glslang::EShTargetClientVersion)jarg2; 
  if (arg1) (arg1)->version = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TClient_1version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TClient *arg1 = (glslang::TClient *) 0 ;
  glslang::EShTargetClientVersion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TClient **)&jarg1; 
  result = (glslang::EShTargetClientVersion) ((arg1)->version);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1TClient(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  glslang::TClient *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (glslang::TClient *)new glslang::TClient();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TClient::TClient()"); return 0; 
      };
    }
  }
  *(glslang::TClient **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TClient(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::TClient *arg1 = (glslang::TClient *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::TClient **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TClient::~TClient()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TTarget_1language_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TTarget *arg1 = (glslang::TTarget *) 0 ;
  glslang::EShTargetLanguage arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TTarget **)&jarg1; 
  arg2 = (glslang::EShTargetLanguage)jarg2; 
  if (arg1) (arg1)->language = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TTarget_1language_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TTarget *arg1 = (glslang::TTarget *) 0 ;
  glslang::EShTargetLanguage result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TTarget **)&jarg1; 
  result = (glslang::EShTargetLanguage) ((arg1)->language);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TTarget_1version_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TTarget *arg1 = (glslang::TTarget *) 0 ;
  glslang::EShTargetLanguageVersion arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TTarget **)&jarg1; 
  arg2 = (glslang::EShTargetLanguageVersion)jarg2; 
  if (arg1) (arg1)->version = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TTarget_1version_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TTarget *arg1 = (glslang::TTarget *) 0 ;
  glslang::EShTargetLanguageVersion result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TTarget **)&jarg1; 
  result = (glslang::EShTargetLanguageVersion) ((arg1)->version);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TTarget_1hlslFunctionality1_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  glslang::TTarget *arg1 = (glslang::TTarget *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TTarget **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  if (arg1) (arg1)->hlslFunctionality1 = arg2;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TTarget_1hlslFunctionality1_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  glslang::TTarget *arg1 = (glslang::TTarget *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TTarget **)&jarg1; 
  result = (bool) ((arg1)->hlslFunctionality1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1TTarget(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  glslang::TTarget *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (glslang::TTarget *)new glslang::TTarget();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TTarget::TTarget()"); return 0; 
      };
    }
  }
  *(glslang::TTarget **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TTarget(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::TTarget *arg1 = (glslang::TTarget *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::TTarget **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TTarget::~TTarget()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TEnvironment_1input_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  glslang::TEnvironment *arg1 = (glslang::TEnvironment *) 0 ;
  glslang::TInputLanguage *arg2 = (glslang::TInputLanguage *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(glslang::TEnvironment **)&jarg1; 
  arg2 = *(glslang::TInputLanguage **)&jarg2; 
  if (arg1) (arg1)->input = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TEnvironment_1input_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  glslang::TEnvironment *arg1 = (glslang::TEnvironment *) 0 ;
  glslang::TInputLanguage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TEnvironment **)&jarg1; 
  result = (glslang::TInputLanguage *)& ((arg1)->input);
  *(glslang::TInputLanguage **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TEnvironment_1client_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  glslang::TEnvironment *arg1 = (glslang::TEnvironment *) 0 ;
  glslang::TClient *arg2 = (glslang::TClient *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(glslang::TEnvironment **)&jarg1; 
  arg2 = *(glslang::TClient **)&jarg2; 
  if (arg1) (arg1)->client = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TEnvironment_1client_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  glslang::TEnvironment *arg1 = (glslang::TEnvironment *) 0 ;
  glslang::TClient *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TEnvironment **)&jarg1; 
  result = (glslang::TClient *)& ((arg1)->client);
  *(glslang::TClient **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TEnvironment_1target_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  glslang::TEnvironment *arg1 = (glslang::TEnvironment *) 0 ;
  glslang::TTarget *arg2 = (glslang::TTarget *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(glslang::TEnvironment **)&jarg1; 
  arg2 = *(glslang::TTarget **)&jarg2; 
  if (arg1) (arg1)->target = *arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TEnvironment_1target_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  glslang::TEnvironment *arg1 = (glslang::TEnvironment *) 0 ;
  glslang::TTarget *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TEnvironment **)&jarg1; 
  result = (glslang::TTarget *)& ((arg1)->target);
  *(glslang::TTarget **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1TEnvironment(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  glslang::TEnvironment *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (glslang::TEnvironment *)new glslang::TEnvironment();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TEnvironment::TEnvironment()"); return 0; 
      };
    }
  }
  *(glslang::TEnvironment **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TEnvironment(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::TEnvironment *arg1 = (glslang::TEnvironment *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::TEnvironment **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TEnvironment::~TEnvironment()"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_stageName(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  EShLanguage arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (EShLanguage)jarg1; 
  {
    try {
      result = (char *)glslang::StageName(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::StageName(EShLanguage)"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShBinding_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  ShBinding *arg1 = (ShBinding *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ShBinding **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    if (arg2) {
      arg1->name = (char const *) (new char[strlen((const char *)arg2)+1]);
      strcpy((char *)arg1->name, (const char *)arg2);
    } else {
      arg1->name = 0;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShBinding_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  ShBinding *arg1 = (ShBinding *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ShBinding **)&jarg1; 
  result = (char *) ((arg1)->name);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShBinding_1binding_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  ShBinding *arg1 = (ShBinding *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ShBinding **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->binding = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShBinding_1binding_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ShBinding *arg1 = (ShBinding *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ShBinding **)&jarg1; 
  result = (int) ((arg1)->binding);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1ShBinding(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ShBinding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (ShBinding *)new ShBinding();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShBinding::ShBinding()"); return 0; 
      };
    }
  }
  *(ShBinding **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1ShBinding(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ShBinding *arg1 = (ShBinding *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ShBinding **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShBinding::~ShBinding()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShBindingTable_1numBindings_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  ShBindingTable *arg1 = (ShBindingTable *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ShBindingTable **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->numBindings = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShBindingTable_1numBindings_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  ShBindingTable *arg1 = (ShBindingTable *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ShBindingTable **)&jarg1; 
  result = (int) ((arg1)->numBindings);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShBindingTable_1bindings_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  ShBindingTable *arg1 = (ShBindingTable *) 0 ;
  ShBinding *arg2 = (ShBinding *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(ShBindingTable **)&jarg1; 
  arg2 = *(ShBinding **)&jarg2; 
  if (arg1) (arg1)->bindings = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ShBindingTable_1bindings_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  ShBindingTable *arg1 = (ShBindingTable *) 0 ;
  ShBinding *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ShBindingTable **)&jarg1; 
  result = (ShBinding *) ((arg1)->bindings);
  *(ShBinding **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1ShBindingTable(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ShBindingTable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (ShBindingTable *)new ShBindingTable();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShBindingTable::ShBindingTable()"); return 0; 
      };
    }
  }
  *(ShBindingTable **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1ShBindingTable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ShBindingTable *arg1 = (ShBindingTable *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ShBindingTable **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShBindingTable::~ShBindingTable()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shConstructCompiler(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  EShLanguage arg1 ;
  int arg2 ;
  ShHandle result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (EShLanguage)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (ShHandle)ShConstructCompiler(arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShConstructCompiler(EShLanguage const,int)"); return 0; 
      };
    }
  }
  *(ShHandle *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shConstructLinker(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  EShExecutable arg1 ;
  int arg2 ;
  ShHandle result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (EShExecutable)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (ShHandle)ShConstructLinker(arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShConstructLinker(EShExecutable const,int)"); return 0; 
      };
    }
  }
  *(ShHandle *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shConstructUniformMap(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ShHandle result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (ShHandle)ShConstructUniformMap();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShConstructUniformMap()"); return 0; 
      };
    }
  }
  *(ShHandle *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shDestruct(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ShHandle arg1 = (ShHandle) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ShHandle *)&jarg1; 
  {
    try {
      ShDestruct(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShDestruct(ShHandle)"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shCompile(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4, jint jarg5, jlong jarg6, jint jarg7, jint jarg8, jboolean jarg9, jint jarg10) {
  jint jresult = 0 ;
  ShHandle arg1 = (ShHandle) (ShHandle)0 ;
  char **arg2 ;
  int arg3 ;
  int *arg4 = (int *) 0 ;
  EShOptimizationLevel arg5 ;
  TBuiltInResource *arg6 = (TBuiltInResource *) 0 ;
  int arg7 ;
  int arg8 = (int) 110 ;
  bool arg9 = (bool) false ;
  EShMessages arg10 = (EShMessages) EShMsgDefault ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ShHandle *)&jarg1; 
  arg2 = *(char ***)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(int **)&jarg4; 
  arg5 = (EShOptimizationLevel)jarg5; 
  arg6 = *(TBuiltInResource **)&jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = jarg9 ? true : false; 
  arg10 = (EShMessages)jarg10; 
  {
    try {
      result = (int)ShCompile(arg1,(char const *const (*))arg2,arg3,(int const *)arg4,arg5,(TBuiltInResource const *)arg6,arg7,arg8,arg9,arg10);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShCompile(ShHandle const,char const *const [],int const,int const *,EShOptimizationLevel const,TBuiltInResource const *,int,int,bool,EShMessages)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shSetEncryptionMethod(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ShHandle arg1 = (ShHandle) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ShHandle *)&jarg1; 
  {
    try {
      ShSetEncryptionMethod(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShSetEncryptionMethod(ShHandle)"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shGetInfoLog(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  ShHandle arg1 = (ShHandle) (ShHandle)0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ShHandle *)&jarg1; 
  {
    try {
      result = (char *)ShGetInfoLog(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShGetInfoLog(ShHandle const)"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shGetExecutable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ShHandle arg1 = (ShHandle) (ShHandle)0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ShHandle *)&jarg1; 
  {
    try {
      result = (void *)ShGetExecutable(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShGetExecutable(ShHandle const)"); return 0; 
      };
    }
  }
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shSetVirtualAttributeBindings(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  ShHandle arg1 = (ShHandle) (ShHandle)0 ;
  ShBindingTable *arg2 = (ShBindingTable *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(ShHandle *)&jarg1; 
  arg2 = *(ShBindingTable **)&jarg2; 
  {
    try {
      result = (int)ShSetVirtualAttributeBindings(arg1,(ShBindingTable const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShSetVirtualAttributeBindings(ShHandle const,ShBindingTable const *)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shSetFixedAttributeBindings(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  ShHandle arg1 = (ShHandle) (ShHandle)0 ;
  ShBindingTable *arg2 = (ShBindingTable *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(ShHandle *)&jarg1; 
  arg2 = *(ShBindingTable **)&jarg2; 
  {
    try {
      result = (int)ShSetFixedAttributeBindings(arg1,(ShBindingTable const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShSetFixedAttributeBindings(ShHandle const,ShBindingTable const *)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shExcludeAttributes(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  ShHandle arg1 = (ShHandle) (ShHandle)0 ;
  int *arg2 = (int *) 0 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ShHandle *)&jarg1; 
  arg2 = *(int **)&jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      result = (int)ShExcludeAttributes(arg1,arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShExcludeAttributes(ShHandle const,int *,int)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_shGetUniformLocation(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  ShHandle arg1 = (ShHandle) (ShHandle)0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ShHandle *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = (int)ShGetUniformLocation(arg1,(char const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in ShGetUniformLocation(ShHandle const,char const *)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_getEsslVersionString(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (char *)glslang::GetEsslVersionString();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::GetEsslVersionString()"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_getGlslVersionString(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (char *)glslang::GetGlslVersionString();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::GetGlslVersionString()"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_getKhronosToolId(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (int)glslang::GetKhronosToolId();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::GetKhronosToolId()"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_initializeProcess(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (bool)glslang::InitializeProcess();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::InitializeProcess()"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_finalizeProcess(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  {
    try {
      glslang::FinalizeProcess();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::FinalizeProcess()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1TShader(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  EShLanguage arg1 ;
  glslang::TShader *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (EShLanguage)jarg1; 
  {
    try {
      result = (glslang::TShader *)new glslang::TShader(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::TShader(EShLanguage)"); return 0; 
      };
    }
  }
  *(glslang::TShader **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TShader(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::TShader **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::~TShader()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setStrings(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  char **arg2 = (char **) 0 ;
  int arg3 ;
  jint size2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  {
    int i = 0;
    size2 = (*jenv).GetArrayLength(jarg2);
    arg2 = (char**)calloc(size2, sizeof(char*));
    //std::cout << "Array length: " << size2 << std::endl;
    /* make a copy of each string */
    for (i = 0; i < size2; ++i) {
      jstring j_string = (jstring)(*jenv).GetObjectArrayElement(jarg2, i);
      const char* c_string = (*jenv).GetStringUTFChars(j_string, NULL);
      //std::cout << "in (" << strlen(c_string) << "): >>>" << c_string  << "<<<" << std::endl;
      arg2[i] = (char*)calloc(strlen(c_string)+1, sizeof(char));
      strcpy(arg2[i], c_string);
      //std::cout << "putting null at " << strlen(c_string) << std::endl;
      //std::cout << "out: >>>" << arg2[i] << "<<<" << std::endl;
      (*jenv).ReleaseStringUTFChars(j_string, c_string);
      (*jenv).DeleteLocalRef(j_string);
    }
    //  std::cout << i << std::endl;
    //  arg2[i] = 0;
  }
  arg3 = (int)jarg3; 
  {
    try {
      (arg1)->setStrings((char const *const *)arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setStrings(char const *const *,int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setStringsWithLengths(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jint jarg4) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  char **arg2 = (char **) 0 ;
  int *arg3 = (int *) 0 ;
  int arg4 ;
  jint size2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  {
    int i = 0;
    size2 = (*jenv).GetArrayLength(jarg2);
    arg2 = (char**)calloc(size2, sizeof(char*));
    //std::cout << "Array length: " << size2 << std::endl;
    /* make a copy of each string */
    for (i = 0; i < size2; ++i) {
      jstring j_string = (jstring)(*jenv).GetObjectArrayElement(jarg2, i);
      const char* c_string = (*jenv).GetStringUTFChars(j_string, NULL);
      //std::cout << "in (" << strlen(c_string) << "): >>>" << c_string  << "<<<" << std::endl;
      arg2[i] = (char*)calloc(strlen(c_string)+1, sizeof(char));
      strcpy(arg2[i], c_string);
      //std::cout << "putting null at " << strlen(c_string) << std::endl;
      //std::cout << "out: >>>" << arg2[i] << "<<<" << std::endl;
      (*jenv).ReleaseStringUTFChars(j_string, c_string);
      (*jenv).DeleteLocalRef(j_string);
    }
    //  std::cout << i << std::endl;
    //  arg2[i] = 0;
  }
  {
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return ;
    }
    if (jenv->GetArrayLength(jarg3) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return ;
    }
    arg3 = (int *) jenv->GetIntArrayElements(jarg3, 0); 
  }
  arg4 = (int)jarg4; 
  {
    try {
      (arg1)->setStringsWithLengths((char const *const *)arg2,(int const *)arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setStringsWithLengths(char const *const *,int const *,int)"); return ; 
      };
    }
  }
  {
    jenv->ReleaseIntArrayElements(jarg3, (jint *)arg3, 0); 
  }
  
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setStringsWithLengthsAndNames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jintArray jarg3, jobjectArray jarg4, jint jarg5) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  char **arg2 = (char **) 0 ;
  int *arg3 = (int *) 0 ;
  char **arg4 = (char **) 0 ;
  int arg5 ;
  jint size2 ;
  jint size4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  {
    int i = 0;
    size2 = (*jenv).GetArrayLength(jarg2);
    arg2 = (char**)calloc(size2, sizeof(char*));
    //std::cout << "Array length: " << size2 << std::endl;
    /* make a copy of each string */
    for (i = 0; i < size2; ++i) {
      jstring j_string = (jstring)(*jenv).GetObjectArrayElement(jarg2, i);
      const char* c_string = (*jenv).GetStringUTFChars(j_string, NULL);
      //std::cout << "in (" << strlen(c_string) << "): >>>" << c_string  << "<<<" << std::endl;
      arg2[i] = (char*)calloc(strlen(c_string)+1, sizeof(char));
      strcpy(arg2[i], c_string);
      //std::cout << "putting null at " << strlen(c_string) << std::endl;
      //std::cout << "out: >>>" << arg2[i] << "<<<" << std::endl;
      (*jenv).ReleaseStringUTFChars(j_string, c_string);
      (*jenv).DeleteLocalRef(j_string);
    }
    //  std::cout << i << std::endl;
    //  arg2[i] = 0;
  }
  {
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return ;
    }
    if (jenv->GetArrayLength(jarg3) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return ;
    }
    arg3 = (int *) jenv->GetIntArrayElements(jarg3, 0); 
  }
  {
    int i = 0;
    size4 = (*jenv).GetArrayLength(jarg4);
    arg4 = (char**)calloc(size4, sizeof(char*));
    //std::cout << "Array length: " << size4 << std::endl;
    /* make a copy of each string */
    for (i = 0; i < size4; ++i) {
      jstring j_string = (jstring)(*jenv).GetObjectArrayElement(jarg4, i);
      const char* c_string = (*jenv).GetStringUTFChars(j_string, NULL);
      //std::cout << "in (" << strlen(c_string) << "): >>>" << c_string  << "<<<" << std::endl;
      arg4[i] = (char*)calloc(strlen(c_string)+1, sizeof(char));
      strcpy(arg4[i], c_string);
      //std::cout << "putting null at " << strlen(c_string) << std::endl;
      //std::cout << "out: >>>" << arg4[i] << "<<<" << std::endl;
      (*jenv).ReleaseStringUTFChars(j_string, c_string);
      (*jenv).DeleteLocalRef(j_string);
    }
    //  std::cout << i << std::endl;
    //  arg4[i] = 0;
  }
  arg5 = (int)jarg5; 
  {
    try {
      (arg1)->setStringsWithLengthsAndNames((char const *const *)arg2,(int const *)arg3,(char const *const *)arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setStringsWithLengthsAndNames(char const *const *,int const *,char const *const *,int)"); return ; 
      };
    }
  }
  {
    jenv->ReleaseIntArrayElements(jarg3, (jint *)arg3, 0); 
  }
  
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setPreamble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->setPreamble((char const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setPreamble(char const *)"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setEntryPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->setEntryPoint((char const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setEntryPoint(char const *)"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setSourceEntryPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->setSourceEntryPoint((char const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setSourceEntryPoint(char const *)"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1addProcesses(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  std::vector< std::string > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = *(std::vector< std::string > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::string > const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->addProcesses((std::vector< std::string > const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::addProcesses(std::vector< std::string > const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setShiftBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  glslang::TResourceType arg2 ;
  unsigned int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (glslang::TResourceType)jarg2; 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      (arg1)->setShiftBinding(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setShiftBinding(glslang::TResourceType,unsigned int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setShiftSamplerBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setShiftSamplerBinding(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setShiftSamplerBinding(unsigned int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setShiftTextureBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setShiftTextureBinding(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setShiftTextureBinding(unsigned int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setShiftImageBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setShiftImageBinding(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setShiftImageBinding(unsigned int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setShiftUboBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setShiftUboBinding(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setShiftUboBinding(unsigned int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setShiftUavBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setShiftUavBinding(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setShiftUavBinding(unsigned int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setShiftCbufferBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setShiftCbufferBinding(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setShiftCbufferBinding(unsigned int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setShiftSsboBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setShiftSsboBinding(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setShiftSsboBinding(unsigned int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setShiftBindingForSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jlong jarg4) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  glslang::TResourceType arg2 ;
  unsigned int arg3 ;
  unsigned int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (glslang::TResourceType)jarg2; 
  arg3 = (unsigned int)jarg3; 
  arg4 = (unsigned int)jarg4; 
  {
    try {
      (arg1)->setShiftBindingForSet(arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setShiftBindingForSet(glslang::TResourceType,unsigned int,unsigned int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setResourceSetBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  std::vector< std::string > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = *(std::vector< std::string > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::string > const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->setResourceSetBinding((std::vector< std::string > const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setResourceSetBinding(std::vector< std::string > const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setAutoMapBindings(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->setAutoMapBindings(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setAutoMapBindings(bool)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setAutoMapLocations(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->setAutoMapLocations(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setAutoMapLocations(bool)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1addUniformLocationOverride(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  {
    try {
      (arg1)->addUniformLocationOverride((char const *)arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::addUniformLocationOverride(char const *,int)"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setUniformLocationBase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      (arg1)->setUniformLocationBase(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setUniformLocationBase(int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setInvertY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->setInvertY(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setInvertY(bool)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setHlslIoMapping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->setHlslIoMapping(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setHlslIoMapping(bool)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setFlattenUniformArrays(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->setFlattenUniformArrays(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setFlattenUniformArrays(bool)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setNoStorageFormat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->setNoStorageFormat(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setNoStorageFormat(bool)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setTextureSamplerTransformMode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  EShTextureSamplerTransformMode arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (EShTextureSamplerTransformMode)jarg2; 
  {
    try {
      (arg1)->setTextureSamplerTransformMode(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setTextureSamplerTransformMode(EShTextureSamplerTransformMode)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setEnvInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4, jint jarg5) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  glslang::EShSource arg2 ;
  EShLanguage arg3 ;
  glslang::EShClient arg4 ;
  int arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (glslang::EShSource)jarg2; 
  arg3 = (EShLanguage)jarg3; 
  arg4 = (glslang::EShClient)jarg4; 
  arg5 = (int)jarg5; 
  {
    try {
      (arg1)->setEnvInput(arg2,arg3,arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setEnvInput(glslang::EShSource,EShLanguage,glslang::EShClient,int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setEnvClient(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  glslang::EShClient arg2 ;
  glslang::EShTargetClientVersion arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (glslang::EShClient)jarg2; 
  arg3 = (glslang::EShTargetClientVersion)jarg3; 
  {
    try {
      (arg1)->setEnvClient(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setEnvClient(glslang::EShClient,glslang::EShTargetClientVersion)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setEnvTarget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  glslang::EShTargetLanguage arg2 ;
  glslang::EShTargetLanguageVersion arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = (glslang::EShTargetLanguage)jarg2; 
  arg3 = (glslang::EShTargetLanguageVersion)jarg3; 
  {
    try {
      (arg1)->setEnvTarget(arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setEnvTarget(glslang::EShTargetLanguage,glslang::EShTargetLanguageVersion)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1setEnvTargetHlslFunctionality1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  {
    try {
      (arg1)->setEnvTargetHlslFunctionality1();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::setEnvTargetHlslFunctionality1()"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1getEnvTargetHlslFunctionality1(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  {
    try {
      result = (bool)((glslang::TShader const *)arg1)->getEnvTargetHlslFunctionality1();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::getEnvTargetHlslFunctionality1() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1TShader_1Includer_1IncludeResult(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  char *arg2 = (char *) (char *)0 ;
  size_t arg3 ;
  void *arg4 = (void *) 0 ;
  glslang::TShader::Includer::IncludeResult *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (size_t)jarg3; 
  arg4 = *(void **)&jarg4; 
  {
    try {
      result = (glslang::TShader::Includer::IncludeResult *)new glslang::TShader::Includer::IncludeResult((std::string const &)*arg1,(char const *)arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::Includer::IncludeResult::IncludeResult(std::string const &,char const *const,size_t const,void *)"); return 0; 
      };
    }
  }
  *(glslang::TShader::Includer::IncludeResult **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1Includer_1IncludeResult_1headerName_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  glslang::TShader::Includer::IncludeResult *arg1 = (glslang::TShader::Includer::IncludeResult *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader::Includer::IncludeResult **)&jarg1; 
  result = (std::string *) & ((arg1)->headerName);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1Includer_1IncludeResult_1headerData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  glslang::TShader::Includer::IncludeResult *arg1 = (glslang::TShader::Includer::IncludeResult *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader::Includer::IncludeResult **)&jarg1; 
  result = (char *)(char *) ((arg1)->headerData);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1Includer_1IncludeResult_1headerLength_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  glslang::TShader::Includer::IncludeResult *arg1 = (glslang::TShader::Includer::IncludeResult *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader::Includer::IncludeResult **)&jarg1; 
  result = (size_t) ((arg1)->headerLength);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1Includer_1IncludeResult_1userData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  glslang::TShader::Includer::IncludeResult *arg1 = (glslang::TShader::Includer::IncludeResult *) 0 ;
  void *arg2 = (void *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader::Includer::IncludeResult **)&jarg1; 
  arg2 = *(void **)&jarg2; 
  if (arg1) (arg1)->userData = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1Includer_1IncludeResult_1userData_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  glslang::TShader::Includer::IncludeResult *arg1 = (glslang::TShader::Includer::IncludeResult *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader::Includer::IncludeResult **)&jarg1; 
  result = (void *) ((arg1)->userData);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TShader_1Includer_1IncludeResult(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::TShader::Includer::IncludeResult *arg1 = (glslang::TShader::Includer::IncludeResult *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::TShader::Includer::IncludeResult **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::Includer::IncludeResult::~IncludeResult()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1Includer_1includeSystem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  glslang::TShader::Includer *arg1 = (glslang::TShader::Includer *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  glslang::TShader::Includer::IncludeResult *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader::Includer **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  {
    try {
      result = (glslang::TShader::Includer::IncludeResult *)(arg1)->includeSystem((char const *)arg2,(char const *)arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::Includer::includeSystem(char const *,char const *,size_t)"); return 0; 
      };
    }
  }
  *(glslang::TShader::Includer::IncludeResult **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1Includer_1includeLocal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  glslang::TShader::Includer *arg1 = (glslang::TShader::Includer *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  glslang::TShader::Includer::IncludeResult *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader::Includer **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  {
    try {
      result = (glslang::TShader::Includer::IncludeResult *)(arg1)->includeLocal((char const *)arg2,(char const *)arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::Includer::includeLocal(char const *,char const *,size_t)"); return 0; 
      };
    }
  }
  *(glslang::TShader::Includer::IncludeResult **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1Includer_1releaseInclude(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  glslang::TShader::Includer *arg1 = (glslang::TShader::Includer *) 0 ;
  glslang::TShader::Includer::IncludeResult *arg2 = (glslang::TShader::Includer::IncludeResult *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(glslang::TShader::Includer **)&jarg1; 
  arg2 = *(glslang::TShader::Includer::IncludeResult **)&jarg2; 
  {
    try {
      (arg1)->releaseInclude(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::Includer::releaseInclude(glslang::TShader::Includer::IncludeResult *)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TShader_1Includer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::TShader::Includer *arg1 = (glslang::TShader::Includer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::TShader::Includer **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::Includer::~Includer()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1ForbidIncluder_1releaseInclude(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  glslang::TShader::ForbidIncluder *arg1 = (glslang::TShader::ForbidIncluder *) 0 ;
  glslang::TShader::Includer::IncludeResult *arg2 = (glslang::TShader::Includer::IncludeResult *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(glslang::TShader::ForbidIncluder **)&jarg1; 
  arg2 = *(glslang::TShader::Includer::IncludeResult **)&jarg2; 
  {
    try {
      (arg1)->releaseInclude(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::ForbidIncluder::releaseInclude(glslang::TShader::Includer::IncludeResult *)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1TShader_1ForbidIncluder(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  glslang::TShader::ForbidIncluder *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (glslang::TShader::ForbidIncluder *)new glslang::TShader::ForbidIncluder();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::ForbidIncluder::ForbidIncluder()"); return 0; 
      };
    }
  }
  *(glslang::TShader::ForbidIncluder **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TShader_1ForbidIncluder(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::TShader::ForbidIncluder *arg1 = (glslang::TShader::ForbidIncluder *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::TShader::ForbidIncluder **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::ForbidIncluder::~ForbidIncluder()"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1parse_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jboolean jarg5, jboolean jarg6, jint jarg7, jlong jarg8, jobject jarg8_) {
  jboolean jresult = 0 ;
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  TBuiltInResource *arg2 = (TBuiltInResource *) 0 ;
  int arg3 ;
  EProfile arg4 ;
  bool arg5 ;
  bool arg6 ;
  EShMessages arg7 ;
  glslang::TShader::Includer *arg8 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg8_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = *(TBuiltInResource **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (EProfile)jarg4; 
  arg5 = jarg5 ? true : false; 
  arg6 = jarg6 ? true : false; 
  arg7 = (EShMessages)jarg7; 
  arg8 = *(glslang::TShader::Includer **)&jarg8;
  if (!arg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TShader::Includer & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->parse((TBuiltInResource const *)arg2,arg3,arg4,arg5,arg6,arg7,*arg8);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::parse(TBuiltInResource const *,int,EProfile,bool,bool,EShMessages,glslang::TShader::Includer &)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1parse_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jboolean jarg5, jboolean jarg6, jint jarg7) {
  jboolean jresult = 0 ;
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  TBuiltInResource *arg2 = (TBuiltInResource *) 0 ;
  int arg3 ;
  EProfile arg4 ;
  bool arg5 ;
  bool arg6 ;
  EShMessages arg7 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = *(TBuiltInResource **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (EProfile)jarg4; 
  arg5 = jarg5 ? true : false; 
  arg6 = jarg6 ? true : false; 
  arg7 = (EShMessages)jarg7; 
  {
    try {
      result = (bool)(arg1)->parse((TBuiltInResource const *)arg2,arg3,arg4,arg5,arg6,arg7);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::parse(TBuiltInResource const *,int,EProfile,bool,bool,EShMessages)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1parse_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jboolean jarg4, jint jarg5) {
  jboolean jresult = 0 ;
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  TBuiltInResource *arg2 = (TBuiltInResource *) 0 ;
  int arg3 ;
  bool arg4 ;
  EShMessages arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = *(TBuiltInResource **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = (EShMessages)jarg5; 
  {
    try {
      result = (bool)(arg1)->parse((TBuiltInResource const *)arg2,arg3,arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::parse(TBuiltInResource const *,int,bool,EShMessages)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1parse_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jboolean jarg4, jint jarg5, jlong jarg6, jobject jarg6_) {
  jboolean jresult = 0 ;
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  TBuiltInResource *arg2 = (TBuiltInResource *) 0 ;
  int arg3 ;
  bool arg4 ;
  EShMessages arg5 ;
  glslang::TShader::Includer *arg6 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg6_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = *(TBuiltInResource **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = jarg4 ? true : false; 
  arg5 = (EShMessages)jarg5; 
  arg6 = *(glslang::TShader::Includer **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TShader::Includer & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->parse((TBuiltInResource const *)arg2,arg3,arg4,arg5,*arg6);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::parse(TBuiltInResource const *,int,bool,EShMessages,glslang::TShader::Includer &)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1preprocess(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jint jarg4, jboolean jarg5, jboolean jarg6, jint jarg7, jobjectArray jarg8, jlong jarg9, jobject jarg9_) {
  jboolean jresult = 0 ;
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  TBuiltInResource *arg2 = (TBuiltInResource *) 0 ;
  int arg3 ;
  EProfile arg4 ;
  bool arg5 ;
  bool arg6 ;
  EShMessages arg7 ;
  std::string *arg8 = (std::string *) 0 ;
  glslang::TShader::Includer *arg9 = 0 ;
  std::string strTemp8 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg9_;
  arg1 = *(glslang::TShader **)&jarg1; 
  arg2 = *(TBuiltInResource **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (EProfile)jarg4; 
  arg5 = jarg5 ? true : false; 
  arg6 = jarg6 ? true : false; 
  arg7 = (EShMessages)jarg7; 
  {
    if (!jarg8) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg8) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    
    jobject oInput = jenv->GetObjectArrayElement(jarg8, 0); 
    if ( NULL != oInput ) {
      jstring sInput = static_cast<jstring>( oInput );
      
      const char * arg8_pstr = (const char *)jenv->GetStringUTFChars(sInput, 0); 
      if (!arg8_pstr) return 0;
      strTemp8.assign( arg8_pstr );
      jenv->ReleaseStringUTFChars( sInput, arg8_pstr);  
    }
    
    arg8 = &strTemp8;
  }
  arg9 = *(glslang::TShader::Includer **)&jarg9;
  if (!arg9) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TShader::Includer & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->preprocess((TBuiltInResource const *)arg2,arg3,arg4,arg5,arg6,arg7,arg8,*arg9);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::preprocess(TBuiltInResource const *,int,EProfile,bool,bool,EShMessages,std::string *,glslang::TShader::Includer &)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  {
    jstring jStrTemp = jenv->NewStringUTF( strTemp8.c_str() );
    jenv->SetObjectArrayElement(jarg8, 0, jStrTemp); 
  }
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1getInfoLog(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->getInfoLog();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::getInfoLog()"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1getInfoDebugLog(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->getInfoDebugLog();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::getInfoDebugLog()"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1getStage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  EShLanguage result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  {
    try {
      result = (EShLanguage)((glslang::TShader const *)arg1)->getStage();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::getStage() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1getIntermediate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  glslang::TShader *arg1 = (glslang::TShader *) 0 ;
  glslang::TIntermediate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TShader **)&jarg1; 
  {
    try {
      result = (glslang::TIntermediate *)((glslang::TShader const *)arg1)->getIntermediate();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TShader::getIntermediate() const"); return 0; 
      };
    }
  }
  *(glslang::TIntermediate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1TObjectReflection(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  glslang::TType *arg2 = 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  glslang::TObjectReflection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = *(glslang::TType **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TType const & reference is null");
    return 0;
  } 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  {
    try {
      result = (glslang::TObjectReflection *)new glslang::TObjectReflection((std::string const &)*arg1,(glslang::TType const &)*arg2,arg3,arg4,arg5,arg6);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TObjectReflection::TObjectReflection(std::string const &,glslang::TType const &,int,int,int,int)"); return 0; 
      };
    }
  }
  *(glslang::TObjectReflection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  glslang::TType *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  {
    try {
      result = (glslang::TType *)((glslang::TObjectReflection const *)arg1)->getType();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TObjectReflection::getType() const"); return 0; 
      };
    }
  }
  *(glslang::TType **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1getBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  {
    try {
      result = (int)((glslang::TObjectReflection const *)arg1)->getBinding();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TObjectReflection::getBinding() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1dump(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  {
    try {
      ((glslang::TObjectReflection const *)arg1)->dump();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TObjectReflection::dump() const"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1badReflection(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  SwigValueWrapper< glslang::TObjectReflection > result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = glslang::TObjectReflection::badReflection();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TObjectReflection::badReflection()"); return 0; 
      };
    }
  }
  *(glslang::TObjectReflection **)&jresult = new glslang::TObjectReflection((const glslang::TObjectReflection &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1name_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if (arg1) (arg1)->name = *arg2;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  result = (std::string *) & ((arg1)->name);
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1offset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->offset = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1offset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  result = (int) ((arg1)->offset);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1glDefineType_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->glDefineType = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1glDefineType_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  result = (int) ((arg1)->glDefineType);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->size = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  result = (int) ((arg1)->size);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1index_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->index = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1index_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  result = (int) ((arg1)->index);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1counterIndex_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->counterIndex = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1counterIndex_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  result = (int) ((arg1)->counterIndex);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1numMembers_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->numMembers = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1numMembers_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  result = (int) ((arg1)->numMembers);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1arrayStride_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->arrayStride = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1arrayStride_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  result = (int) ((arg1)->arrayStride);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1topLevelArrayStride_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->topLevelArrayStride = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1topLevelArrayStride_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  result = (int) ((arg1)->topLevelArrayStride);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1stages_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  EShLanguageMask arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  arg2 = (EShLanguageMask)jarg2; 
  if (arg1) (arg1)->stages = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TObjectReflection_1stages_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  EShLanguageMask result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  result = (EShLanguageMask) ((arg1)->stages);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TObjectReflection(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::TObjectReflection *arg1 = (glslang::TObjectReflection *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::TObjectReflection **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TObjectReflection::~TObjectReflection()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TIoMapResolver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::~TIoMapResolver()"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1validateBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4, jboolean jarg5) {
  jboolean jresult = 0 ;
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  char *arg3 = (char *) 0 ;
  glslang::TType *arg4 = 0 ;
  bool arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(glslang::TType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TType const & reference is null");
    return 0;
  } 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (bool)(arg1)->validateBinding(arg2,(char const *)arg3,(glslang::TType const &)*arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::validateBinding(EShLanguage,char const *,glslang::TType const &,bool)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1resolveBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4, jboolean jarg5) {
  jint jresult = 0 ;
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  char *arg3 = (char *) 0 ;
  glslang::TType *arg4 = 0 ;
  bool arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(glslang::TType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TType const & reference is null");
    return 0;
  } 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (int)(arg1)->resolveBinding(arg2,(char const *)arg3,(glslang::TType const &)*arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::resolveBinding(EShLanguage,char const *,glslang::TType const &,bool)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1resolveSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4, jboolean jarg5) {
  jint jresult = 0 ;
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  char *arg3 = (char *) 0 ;
  glslang::TType *arg4 = 0 ;
  bool arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(glslang::TType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TType const & reference is null");
    return 0;
  } 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (int)(arg1)->resolveSet(arg2,(char const *)arg3,(glslang::TType const &)*arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::resolveSet(EShLanguage,char const *,glslang::TType const &,bool)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1resolveUniformLocation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4, jboolean jarg5) {
  jint jresult = 0 ;
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  char *arg3 = (char *) 0 ;
  glslang::TType *arg4 = 0 ;
  bool arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(glslang::TType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TType const & reference is null");
    return 0;
  } 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (int)(arg1)->resolveUniformLocation(arg2,(char const *)arg3,(glslang::TType const &)*arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::resolveUniformLocation(EShLanguage,char const *,glslang::TType const &,bool)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1validateInOut(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4, jboolean jarg5) {
  jboolean jresult = 0 ;
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  char *arg3 = (char *) 0 ;
  glslang::TType *arg4 = 0 ;
  bool arg5 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(glslang::TType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TType const & reference is null");
    return 0;
  } 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (bool)(arg1)->validateInOut(arg2,(char const *)arg3,(glslang::TType const &)*arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::validateInOut(EShLanguage,char const *,glslang::TType const &,bool)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1resolveInOutLocation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4, jboolean jarg5) {
  jint jresult = 0 ;
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  char *arg3 = (char *) 0 ;
  glslang::TType *arg4 = 0 ;
  bool arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(glslang::TType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TType const & reference is null");
    return 0;
  } 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (int)(arg1)->resolveInOutLocation(arg2,(char const *)arg3,(glslang::TType const &)*arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::resolveInOutLocation(EShLanguage,char const *,glslang::TType const &,bool)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1resolveInOutComponent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4, jboolean jarg5) {
  jint jresult = 0 ;
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  char *arg3 = (char *) 0 ;
  glslang::TType *arg4 = 0 ;
  bool arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(glslang::TType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TType const & reference is null");
    return 0;
  } 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (int)(arg1)->resolveInOutComponent(arg2,(char const *)arg3,(glslang::TType const &)*arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::resolveInOutComponent(EShLanguage,char const *,glslang::TType const &,bool)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1resolveInOutIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4, jboolean jarg5) {
  jint jresult = 0 ;
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  char *arg3 = (char *) 0 ;
  glslang::TType *arg4 = 0 ;
  bool arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = *(glslang::TType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TType const & reference is null");
    return 0;
  } 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (int)(arg1)->resolveInOutIndex(arg2,(char const *)arg3,(glslang::TType const &)*arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::resolveInOutIndex(EShLanguage,char const *,glslang::TType const &,bool)"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1notifyBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4, jboolean jarg5) {
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  char *arg3 = (char *) 0 ;
  glslang::TType *arg4 = 0 ;
  bool arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = *(glslang::TType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TType const & reference is null");
    return ;
  } 
  arg5 = jarg5 ? true : false; 
  {
    try {
      (arg1)->notifyBinding(arg2,(char const *)arg3,(glslang::TType const &)*arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::notifyBinding(EShLanguage,char const *,glslang::TType const &,bool)"); return ; 
      };
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1notifyInOut(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jlong jarg4, jboolean jarg5) {
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  char *arg3 = (char *) 0 ;
  glslang::TType *arg4 = 0 ;
  bool arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = *(glslang::TType **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TType const & reference is null");
    return ;
  } 
  arg5 = jarg5 ? true : false; 
  {
    try {
      (arg1)->notifyInOut(arg2,(char const *)arg3,(glslang::TType const &)*arg4,arg5);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::notifyInOut(EShLanguage,char const *,glslang::TType const &,bool)"); return ; 
      };
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1endNotifications(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  {
    try {
      (arg1)->endNotifications(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::endNotifications(EShLanguage)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1beginNotifications(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  {
    try {
      (arg1)->beginNotifications(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::beginNotifications(EShLanguage)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1beginResolve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  {
    try {
      (arg1)->beginResolve(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::beginResolve(EShLanguage)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TIoMapResolver_1endResolve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::TIoMapResolver *arg1 = (glslang::TIoMapResolver *) 0 ;
  EShLanguage arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TIoMapResolver **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  {
    try {
      (arg1)->endResolve(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TIoMapResolver::endResolve(EShLanguage)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1TProgram(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  glslang::TProgram *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (glslang::TProgram *)new glslang::TProgram();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::TProgram()"); return 0; 
      };
    }
  }
  *(glslang::TProgram **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1TProgram(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::~TProgram()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1addShader(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  glslang::TShader *arg2 = (glslang::TShader *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = *(glslang::TShader **)&jarg2; 
  {
    try {
      (arg1)->addShader(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::addShader(glslang::TShader *)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1link(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  EShMessages arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (EShMessages)jarg2; 
  {
    try {
      result = (bool)(arg1)->link(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::link(EShMessages)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getInfoLog(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->getInfoLog();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getInfoLog()"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getInfoDebugLog(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (char *)(arg1)->getInfoDebugLog();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getInfoDebugLog()"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getIntermediate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  EShLanguage arg2 ;
  glslang::TIntermediate *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (EShLanguage)jarg2; 
  {
    try {
      result = (glslang::TIntermediate *)((glslang::TProgram const *)arg1)->getIntermediate(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getIntermediate(EShLanguage) const"); return 0; 
      };
    }
  }
  *(glslang::TIntermediate **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1buildReflection_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (bool)(arg1)->buildReflection(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::buildReflection(int)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1buildReflection_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->buildReflection();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::buildReflection()"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getLocalSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (unsigned int)((glslang::TProgram const *)arg1)->getLocalSize(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getLocalSize(int) const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getReflectionIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getReflectionIndex((char const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getReflectionIndex(char const *) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getNumUniformVariables(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getNumUniformVariables();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getNumUniformVariables() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  glslang::TObjectReflection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (glslang::TObjectReflection *) &((glslang::TProgram const *)arg1)->getUniform(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniform(int) const"); return 0; 
      };
    }
  }
  *(glslang::TObjectReflection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getNumUniformBlocks(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getNumUniformBlocks();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getNumUniformBlocks() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  glslang::TObjectReflection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (glslang::TObjectReflection *) &((glslang::TProgram const *)arg1)->getUniformBlock(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformBlock(int) const"); return 0; 
      };
    }
  }
  *(glslang::TObjectReflection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getNumPipeInputs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getNumPipeInputs();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getNumPipeInputs() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getPipeInput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  glslang::TObjectReflection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (glslang::TObjectReflection *) &((glslang::TProgram const *)arg1)->getPipeInput(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getPipeInput(int) const"); return 0; 
      };
    }
  }
  *(glslang::TObjectReflection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getNumPipeOutputs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getNumPipeOutputs();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getNumPipeOutputs() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getPipeOutput(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  glslang::TObjectReflection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (glslang::TObjectReflection *) &((glslang::TProgram const *)arg1)->getPipeOutput(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getPipeOutput(int) const"); return 0; 
      };
    }
  }
  *(glslang::TObjectReflection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getNumBufferVariables(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getNumBufferVariables();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getNumBufferVariables() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getBufferVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  glslang::TObjectReflection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (glslang::TObjectReflection *) &((glslang::TProgram const *)arg1)->getBufferVariable(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getBufferVariable(int) const"); return 0; 
      };
    }
  }
  *(glslang::TObjectReflection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getNumBufferBlocks(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getNumBufferBlocks();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getNumBufferBlocks() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getBufferBlock(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  glslang::TObjectReflection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (glslang::TObjectReflection *) &((glslang::TProgram const *)arg1)->getBufferBlock(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getBufferBlock(int) const"); return 0; 
      };
    }
  }
  *(glslang::TObjectReflection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getNumAtomicCounters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getNumAtomicCounters();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getNumAtomicCounters() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getAtomicCounter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  glslang::TObjectReflection *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (glslang::TObjectReflection *) &((glslang::TProgram const *)arg1)->getAtomicCounter(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getAtomicCounter(int) const"); return 0; 
      };
    }
  }
  *(glslang::TObjectReflection **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getNumLiveUniformVariables(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getNumLiveUniformVariables();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getNumLiveUniformVariables() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getNumLiveUniformBlocks(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getNumLiveUniformBlocks();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getNumLiveUniformBlocks() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getNumLiveAttributes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getNumLiveAttributes();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getNumLiveAttributes() const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getUniformIndex((char const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformIndex(char const *) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (char *)((glslang::TProgram const *)arg1)->getUniformName(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformName(int) const"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getUniformBinding(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformBinding(int) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformStages(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  EShLanguageMask result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (EShLanguageMask)((glslang::TProgram const *)arg1)->getUniformStages(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformStages(int) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformBlockIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getUniformBlockIndex(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformBlockIndex(int) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getUniformType(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformType(int) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformBufferOffset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getUniformBufferOffset(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformBufferOffset(int) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformArraySize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getUniformArraySize(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformArraySize(int) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformTType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  glslang::TType *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (glslang::TType *)((glslang::TProgram const *)arg1)->getUniformTType(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformTType(int) const"); return 0; 
      };
    }
  }
  *(glslang::TType **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformBlockName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (char *)((glslang::TProgram const *)arg1)->getUniformBlockName(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformBlockName(int) const"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformBlockSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getUniformBlockSize(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformBlockSize(int) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformBlockBinding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getUniformBlockBinding(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformBlockBinding(int) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformBlockCounterIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getUniformBlockCounterIndex(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformBlockCounterIndex(int) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getUniformBlockTType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  glslang::TType *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (glslang::TType *)((glslang::TProgram const *)arg1)->getUniformBlockTType(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getUniformBlockTType(int) const"); return 0; 
      };
    }
  }
  *(glslang::TType **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getAttributeName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (char *)((glslang::TProgram const *)arg1)->getAttributeName(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getAttributeName(int) const"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getAttributeType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (int)((glslang::TProgram const *)arg1)->getAttributeType(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getAttributeType(int) const"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1getAttributeTType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  int arg2 ;
  glslang::TType *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (glslang::TType *)((glslang::TProgram const *)arg1)->getAttributeTType(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::getAttributeTType(int) const"); return 0; 
      };
    }
  }
  *(glslang::TType **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1dumpReflection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      (arg1)->dumpReflection();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::dumpReflection()"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1mapIO_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  glslang::TIoMapResolver *arg2 = (glslang::TIoMapResolver *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  arg2 = *(glslang::TIoMapResolver **)&jarg2; 
  {
    try {
      result = (bool)(arg1)->mapIO(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::mapIO(glslang::TIoMapResolver *)"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TProgram_1mapIO_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  glslang::TProgram *arg1 = (glslang::TProgram *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::TProgram **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->mapIO();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::TProgram::mapIO()"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_profileName(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  EProfile arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (EProfile)jarg1; 
  {
    try {
      result = (char *)glslang::ProfileName(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::ProfileName(EProfile)"); return 0; 
      };
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SpvVersion(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  glslang::SpvVersion *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (glslang::SpvVersion *)new glslang::SpvVersion();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::SpvVersion::SpvVersion()"); return 0; 
      };
    }
  }
  *(glslang::SpvVersion **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpvVersion_1spv_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  glslang::SpvVersion *arg1 = (glslang::SpvVersion *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::SpvVersion **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  if (arg1) (arg1)->spv = arg2;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpvVersion_1spv_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  glslang::SpvVersion *arg1 = (glslang::SpvVersion *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::SpvVersion **)&jarg1; 
  result = (unsigned int) ((arg1)->spv);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpvVersion_1vulkanGlsl_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::SpvVersion *arg1 = (glslang::SpvVersion *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::SpvVersion **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->vulkanGlsl = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpvVersion_1vulkanGlsl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::SpvVersion *arg1 = (glslang::SpvVersion *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::SpvVersion **)&jarg1; 
  result = (int) ((arg1)->vulkanGlsl);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpvVersion_1vulkan_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::SpvVersion *arg1 = (glslang::SpvVersion *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::SpvVersion **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->vulkan = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpvVersion_1vulkan_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::SpvVersion *arg1 = (glslang::SpvVersion *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::SpvVersion **)&jarg1; 
  result = (int) ((arg1)->vulkan);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpvVersion_1openGl_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  glslang::SpvVersion *arg1 = (glslang::SpvVersion *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::SpvVersion **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->openGl = arg2;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpvVersion_1openGl_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  glslang::SpvVersion *arg1 = (glslang::SpvVersion *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(glslang::SpvVersion **)&jarg1; 
  result = (int) ((arg1)->openGl);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SpvVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  glslang::SpvVersion *arg1 = (glslang::SpvVersion *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(glslang::SpvVersion **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::SpvVersion::~SpvVersion()"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESTexture3D_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_texture_3D;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESStandardDerivatives_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_standard_derivatives;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTFragDepth_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_frag_depth;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESEGLImageExternal_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_EGL_image_external;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESEGLImageExternalEssl3_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_EGL_image_external_essl3;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTYUVTarget_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_YUV_target;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderTextureLod_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_texture_lod;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShadowSamplers_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shadow_samplers;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBTextureRectangle_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_texture_rectangle;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGL3DLArrayObjects_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_3DL_array_objects;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBShadingLanguage420pack_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_shading_language_420pack;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBTextureGather_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_texture_gather;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBGpuShader5_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_gpu_shader5;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBSeparateShaderObjects_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_separate_shader_objects;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBComputeShader_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_compute_shader;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBTessellationShader_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_tessellation_shader;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBEnhancedLayouts_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_enhanced_layouts;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBTextureCubeMapArray_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_texture_cube_map_array;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBShaderTextureLod_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_shader_texture_lod;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBExplicitAttribLocation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_explicit_attrib_location;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBShaderImageLoadStore_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_shader_image_load_store;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBShaderAtomicCounters_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_shader_atomic_counters;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBShaderDrawParameters_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_shader_draw_parameters;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBShaderGroupVote_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_shader_group_vote;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBDerivativeControl_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_derivative_control;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBShaderTextureImageSamples_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_shader_texture_image_samples;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBViewportArray_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_viewport_array;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBGpuShaderInt64_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_gpu_shader_int64;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBShaderBallot_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_shader_ballot;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBSparseTexture2_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_sparse_texture2;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBSparseTextureClamp_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_sparse_texture_clamp;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBShaderStencilExport_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_shader_stencil_export;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBPostDepthCoverage_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_post_depth_coverage;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLARBShaderViewportLayerArray_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ARB_shader_viewport_layer_array;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLKHRShaderSubgroupBasic_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_KHR_shader_subgroup_basic;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLKHRShaderSubgroupVote_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_KHR_shader_subgroup_vote;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLKHRShaderSubgroupArithmetic_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_KHR_shader_subgroup_arithmetic;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLKHRShaderSubgroupBallot_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_KHR_shader_subgroup_ballot;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLKHRShaderSubgroupShuffle_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_KHR_shader_subgroup_shuffle;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLKHRShaderSubgroupShuffleRelative_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_KHR_shader_subgroup_shuffle_relative;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLKHRShaderSubgroupClustered_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_KHR_shader_subgroup_clustered;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLKHRShaderSubgroupQuad_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_KHR_shader_subgroup_quad;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLKHRMemoryScopeSemantics_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_KHR_memory_scope_semantics;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderAtomicInt64_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_atomic_int64;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderNonConstantGlobalInitializers_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_non_constant_global_initializers;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderImageLoadFormatted_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_image_load_formatted;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShader16bitStorage_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_16bit_storage;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShader8bitStorage_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_8bit_storage;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTDeviceGroup_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_device_group;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTMultiview_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_multiview;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTPostDepthCoverage_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_post_depth_coverage;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTControlFlowAttributes_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_control_flow_attributes;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTNonuniformQualifier_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_nonuniform_qualifier;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTSamplerlessTextureFunctions_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_samplerless_texture_functions;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTScalarBlockLayout_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_scalar_block_layout;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTFragmentInvocationDensity_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_fragment_invocation_density;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTBufferReference_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_buffer_reference;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_postDepthCoverageEXTs_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char **)(char **)glslang::post_depth_coverageEXTs;
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_numPostDepthCoverageEXTs_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)glslang::Num_post_depth_coverageEXTs;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOVRMultiview_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OVR_multiview;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOVRMultiview2_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OVR_multiview2;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_oVRMultiviewEXTs_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char **)(char **)glslang::OVR_multiview_EXTs;
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_numOVRMultiviewEXTs_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)glslang::Num_OVR_multiview_EXTs;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLGOOGLECppStyleLineDirective_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_GOOGLE_cpp_style_line_directive;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLGOOGLEIncludeDirective_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_GOOGLE_include_directive;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLANDROIDExtensionPackEs31a_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_ANDROID_extension_pack_es31a;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLKHRBlendEquationAdvanced_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_KHR_blend_equation_advanced;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESSampleVariables_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_sample_variables;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESShaderImageAtomic_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_shader_image_atomic;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESShaderMultisampleInterpolation_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_shader_multisample_interpolation;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESTextureStorageMultisample2dArray_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_texture_storage_multisample_2d_array;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTGeometryShader_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_geometry_shader;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTGeometryPointSize_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_geometry_point_size;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTGpuShader5_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_gpu_shader5;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTPrimitiveBoundingBox_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_primitive_bounding_box;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderIoBlocks_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_io_blocks;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTTessellationShader_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_tessellation_shader;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTTessellationPointSize_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_tessellation_point_size;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTTextureBuffer_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_texture_buffer;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTTextureCubeMapArray_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_texture_cube_map_array;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESGeometryShader_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_geometry_shader;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESGeometryPointSize_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_geometry_point_size;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESGpuShader5_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_gpu_shader5;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESPrimitiveBoundingBox_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_primitive_bounding_box;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESShaderIoBlocks_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_shader_io_blocks;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESTessellationShader_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_tessellation_shader;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESTessellationPointSize_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_tessellation_point_size;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESTextureBuffer_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_texture_buffer;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLOESTextureCubeMapArray_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_OES_texture_cube_map_array;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderExplicitArithmeticTypes_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_explicit_arithmetic_types;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderExplicitArithmeticTypesInt8_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_explicit_arithmetic_types_int8;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderExplicitArithmeticTypesInt16_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_explicit_arithmetic_types_int16;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderExplicitArithmeticTypesInt32_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_explicit_arithmetic_types_int32;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderExplicitArithmeticTypesInt64_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_explicit_arithmetic_types_int64;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderExplicitArithmeticTypesFloat16_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_explicit_arithmetic_types_float16;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderExplicitArithmeticTypesFloat32_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_explicit_arithmetic_types_float32;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_eGLEXTShaderExplicitArithmeticTypesFloat64_1get(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)(char *)glslang::E_GL_EXT_shader_explicit_arithmetic_types_float64;
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_aEPGeometryShader_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char **)(char **)glslang::AEP_geometry_shader;
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_numAEPGeometryShader_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)glslang::Num_AEP_geometry_shader;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_aEPGeometryPointSize_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char **)(char **)glslang::AEP_geometry_point_size;
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_numAEPGeometryPointSize_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)glslang::Num_AEP_geometry_point_size;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_aEPGpuShader5_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char **)(char **)glslang::AEP_gpu_shader5;
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_numAEPGpuShader5_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)glslang::Num_AEP_gpu_shader5;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_aEPPrimitiveBoundingBox_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char **)(char **)glslang::AEP_primitive_bounding_box;
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_numAEPPrimitiveBoundingBox_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)glslang::Num_AEP_primitive_bounding_box;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_aEPShaderIoBlocks_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char **)(char **)glslang::AEP_shader_io_blocks;
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_numAEPShaderIoBlocks_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)glslang::Num_AEP_shader_io_blocks;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_aEPTessellationShader_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char **)(char **)glslang::AEP_tessellation_shader;
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_numAEPTessellationShader_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)glslang::Num_AEP_tessellation_shader;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_aEPTessellationPointSize_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char **)(char **)glslang::AEP_tessellation_point_size;
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_numAEPTessellationPointSize_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)glslang::Num_AEP_tessellation_point_size;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_aEPTextureBuffer_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char **)(char **)glslang::AEP_texture_buffer;
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_numAEPTextureBuffer_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)glslang::Num_AEP_texture_buffer;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_aEPTextureCubeMapArray_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char **)(char **)glslang::AEP_texture_cube_map_array;
  *(char ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_numAEPTextureCubeMapArray_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)glslang::Num_AEP_texture_cube_map_array;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_defaultTBuiltInResource_1get(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  TBuiltInResource result;
  
  (void)jenv;
  (void)jcls;
  result = (TBuiltInResource)glslang::DefaultTBuiltInResource;
  *(TBuiltInResource **)&jresult = new TBuiltInResource((const TBuiltInResource &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_getDefaultTBuiltInResourceString(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = glslang::GetDefaultTBuiltInResourceString();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::GetDefaultTBuiltInResourceString()"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_decodeResourceLimits(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  TBuiltInResource *arg1 = (TBuiltInResource *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(TBuiltInResource **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      glslang::DecodeResourceLimits(arg1,arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::DecodeResourceLimits(TBuiltInResource *,char *)"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_getSpirvVersion(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::string *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::string **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return ;
  } 
  {
    try {
      glslang::GetSpirvVersion(*arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::GetSpirvVersion(std::string &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_getSpirvGeneratorVersion(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (int)glslang::GetSpirvGeneratorVersion();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::GetSpirvGeneratorVersion()"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_glslangToSpv_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_, jlong jarg3) {
  glslang::TIntermediate *arg1 = 0 ;
  std::vector< unsigned int > *arg2 = 0 ;
  SpvOptions *arg3 = (SpvOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(glslang::TIntermediate **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TIntermediate const & reference is null");
    return ;
  } 
  arg2 = *(std::vector< unsigned int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > & reference is null");
    return ;
  } 
  arg3 = *(SpvOptions **)&jarg3; 
  {
    try {
      glslang::GlslangToSpv((glslang::TIntermediate const &)*arg1,*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::GlslangToSpv(glslang::TIntermediate const &,std::vector< unsigned int > &,SpvOptions *)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_glslangToSpv_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  glslang::TIntermediate *arg1 = 0 ;
  std::vector< unsigned int > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(glslang::TIntermediate **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TIntermediate const & reference is null");
    return ;
  } 
  arg2 = *(std::vector< unsigned int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > & reference is null");
    return ;
  } 
  {
    try {
      glslang::GlslangToSpv((glslang::TIntermediate const &)*arg1,*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::GlslangToSpv(glslang::TIntermediate const &,std::vector< unsigned int > &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_glslangToSpv_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jlong jarg4) {
  glslang::TIntermediate *arg1 = 0 ;
  std::vector< unsigned int > *arg2 = 0 ;
  spv::SpvBuildLogger *arg3 = (spv::SpvBuildLogger *) 0 ;
  SpvOptions *arg4 = (SpvOptions *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(glslang::TIntermediate **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TIntermediate const & reference is null");
    return ;
  } 
  arg2 = *(std::vector< unsigned int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > & reference is null");
    return ;
  } 
  arg3 = *(spv::SpvBuildLogger **)&jarg3; 
  arg4 = *(SpvOptions **)&jarg4; 
  {
    try {
      glslang::GlslangToSpv((glslang::TIntermediate const &)*arg1,*arg2,arg3,arg4);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::GlslangToSpv(glslang::TIntermediate const &,std::vector< unsigned int > &,spv::SpvBuildLogger *,SpvOptions *)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_glslangToSpv_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_, jlong jarg3) {
  glslang::TIntermediate *arg1 = 0 ;
  std::vector< unsigned int > *arg2 = 0 ;
  spv::SpvBuildLogger *arg3 = (spv::SpvBuildLogger *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(glslang::TIntermediate **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "glslang::TIntermediate const & reference is null");
    return ;
  } 
  arg2 = *(std::vector< unsigned int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > & reference is null");
    return ;
  } 
  arg3 = *(spv::SpvBuildLogger **)&jarg3; 
  {
    try {
      glslang::GlslangToSpv((glslang::TIntermediate const &)*arg1,*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::GlslangToSpv(glslang::TIntermediate const &,std::vector< unsigned int > &,spv::SpvBuildLogger *)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_outputSpvBin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  std::vector< unsigned int > *arg1 = 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & reference is null");
    return ;
  } 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      glslang::OutputSpvBin((std::vector< unsigned int > const &)*arg1,(char const *)arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::OutputSpvBin(std::vector< unsigned int > const &,char const *)"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_outputSpvHex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  std::vector< unsigned int > *arg1 = 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & reference is null");
    return ;
  } 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  {
    try {
      glslang::OutputSpvHex((std::vector< unsigned int > const &)*arg1,(char const *)arg2,(char const *)arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in glslang::OutputSpvHex(std::vector< unsigned int > const &,char const *,char const *)"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_gLSLstd450Version_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)GLSLstd450Version;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_gLSLstd450Revision_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(int)GLSLstd450Revision;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_disassemble(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  std::ostream *arg1 = 0 ;
  std::vector< unsigned int > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = *(std::ostream **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::ostream & reference is null");
    return ;
  } 
  arg2 = *(std::vector< unsigned int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & reference is null");
    return ;
  } 
  {
    try {
      spv::Disassemble(*arg1,(std::vector< unsigned int > const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spv::Disassemble(std::ostream &,std::vector< unsigned int > const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1spirvbin_1base_1t(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  spv::spirvbin_base_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (spv::spirvbin_base_t *)new spv::spirvbin_base_t();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spv::spirvbin_base_t::spirvbin_base_t()"); return 0; 
      };
    }
  }
  *(spv::spirvbin_base_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1spirvbin_1base_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spv::spirvbin_base_t *arg1 = (spv::spirvbin_base_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spv::spirvbin_base_t **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spv::spirvbin_base_t::~spirvbin_base_t()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1spirvbin_1t(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  spv::spirvbin_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  {
    try {
      result = (spv::spirvbin_t *)new spv::spirvbin_t(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spv::spirvbin_t::spirvbin_t(int)"); return 0; 
      };
    }
  }
  *(spv::spirvbin_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_spirvbin_1t_1remap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  spv::spirvbin_t *arg1 = (spv::spirvbin_t *) 0 ;
  std::vector< std::uint32_t > *arg2 = 0 ;
  unsigned int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(spv::spirvbin_t **)&jarg1; 
  arg2 = *(std::vector< std::uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::uint32_t > & reference is null");
    return ;
  } 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      (arg1)->remap(*arg2,arg3);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spv::spirvbin_t::remap(std::vector< std::uint32_t > &,unsigned int)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1spirvbin_1t(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  spv::spirvbin_t *arg1 = (spv::spirvbin_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(spv::spirvbin_t **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in spv::spirvbin_t::~spirvbin_t()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1StringVec_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::string > *)new std::vector< std::string >();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< std::string >::vector()"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1StringVec_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< std::string >::size_type arg1 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< std::string >::size_type)jarg1; 
  {
    try {
      result = (std::vector< std::string > *)new std::vector< std::string >(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< std::string >::vector(std::vector< std::string >::size_type)"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_StringVec_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::string > const *)arg1)->size();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< std::string >::size() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_StringVec_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      result = ((std::vector< std::string > const *)arg1)->capacity();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< std::string >::capacity() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_StringVec_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = (std::vector< std::string >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< std::string >::reserve(std::vector< std::string >::size_type)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_StringVec_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::string > const *)arg1)->empty();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< std::string >::empty() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_StringVec_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< std::string >::clear()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_StringVec_1pushBack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  std::vector< std::string >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::vector< std::string >::value_type arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->push_back((std::vector< std::string >::value_type const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< std::string >::push_back(std::vector< std::string >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_StringVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::vector< std::string >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< std::string >::value_type *) &std_vector_Sl_std_string_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< std::string >::get(int)"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_StringVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  int arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = (int)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::vector< std::string >::value_type arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__set(arg1,arg2,(std::string const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< std::string >::set(int,std::vector< std::string >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1StringVec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::string > *arg1 = (std::vector< std::string > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< std::string >::~vector()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1IntVec_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< uint32_t > *)new std::vector< uint32_t >();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< uint32_t >::vector()"); return 0; 
      };
    }
  }
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1IntVec_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< unsigned int >::size_type arg1 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< unsigned int >::size_type)jarg1; 
  {
    try {
      result = (std::vector< uint32_t > *)new std::vector< uint32_t >(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< uint32_t >::vector(std::vector< unsigned int >::size_type)"); return 0; 
      };
    }
  }
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_IntVec_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  std::vector< unsigned int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try {
      result = ((std::vector< uint32_t > const *)arg1)->size();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< uint32_t >::size() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_IntVec_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  std::vector< unsigned int >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try {
      result = ((std::vector< uint32_t > const *)arg1)->capacity();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< uint32_t >::capacity() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_IntVec_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  std::vector< unsigned int >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = (std::vector< unsigned int >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< uint32_t >::reserve(std::vector< unsigned int >::size_type)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_IntVec_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< uint32_t > const *)arg1)->empty();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< uint32_t >::empty() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_IntVec_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< uint32_t >::clear()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_IntVec_1pushBack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  std::vector< unsigned int >::value_type *arg2 = 0 ;
  std::vector< unsigned int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  temp2 = (std::vector< unsigned int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((std::vector< unsigned int >::value_type const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< uint32_t >::push_back(std::vector< unsigned int >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_IntVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  int arg2 ;
  std::vector< unsigned int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned int >::value_type *) &std_vector_Sl_uint32_t_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< uint32_t >::get(int)"); return 0; 
      };
    }
  }
  jresult = (jlong)*result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_IntVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  int arg2 ;
  std::vector< unsigned int >::value_type *arg3 = 0 ;
  std::vector< unsigned int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (std::vector< unsigned int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_uint32_t_Sg__set(arg1,arg2,(unsigned int const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< uint32_t >::set(int,std::vector< unsigned int >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1IntVec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< uint32_t > *arg1 = (std::vector< uint32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< uint32_t >::~vector()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1ResourceVec_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< spirv_cross::Resource > *)new std::vector< spirv_cross::Resource >();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::Resource >::vector()"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1ResourceVec_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::Resource >::size_type arg1 ;
  std::vector< spirv_cross::Resource > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< spirv_cross::Resource >::size_type)jarg1; 
  {
    try {
      result = (std::vector< spirv_cross::Resource > *)new std::vector< spirv_cross::Resource >(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::Resource >::vector(std::vector< spirv_cross::Resource >::size_type)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::Resource > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ResourceVec_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::Resource > *arg1 = (std::vector< spirv_cross::Resource > *) 0 ;
  std::vector< spirv_cross::Resource >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::Resource > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::Resource > const *)arg1)->size();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::Resource >::size() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ResourceVec_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::Resource > *arg1 = (std::vector< spirv_cross::Resource > *) 0 ;
  std::vector< spirv_cross::Resource >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::Resource > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::Resource > const *)arg1)->capacity();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::Resource >::capacity() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ResourceVec_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< spirv_cross::Resource > *arg1 = (std::vector< spirv_cross::Resource > *) 0 ;
  std::vector< spirv_cross::Resource >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::Resource > **)&jarg1; 
  arg2 = (std::vector< spirv_cross::Resource >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::Resource >::reserve(std::vector< spirv_cross::Resource >::size_type)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ResourceVec_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< spirv_cross::Resource > *arg1 = (std::vector< spirv_cross::Resource > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::Resource > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< spirv_cross::Resource > const *)arg1)->empty();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::Resource >::empty() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ResourceVec_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< spirv_cross::Resource > *arg1 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::Resource > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::Resource >::clear()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ResourceVec_1pushBack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< spirv_cross::Resource > *arg1 = (std::vector< spirv_cross::Resource > *) 0 ;
  std::vector< spirv_cross::Resource >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< spirv_cross::Resource > **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::Resource >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::Resource >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< spirv_cross::Resource >::value_type const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::Resource >::push_back(std::vector< spirv_cross::Resource >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ResourceVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::Resource > *arg1 = (std::vector< spirv_cross::Resource > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::Resource >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::Resource > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< spirv_cross::Resource >::value_type *) &std_vector_Sl_spirv_cross_Resource_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::Resource >::get(int)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::Resource >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_ResourceVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< spirv_cross::Resource > *arg1 = (std::vector< spirv_cross::Resource > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::Resource >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< spirv_cross::Resource > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< spirv_cross::Resource >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::Resource >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_spirv_cross_Resource_Sg__set(arg1,arg2,(spirv_cross::Resource const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::Resource >::set(int,std::vector< spirv_cross::Resource >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1ResourceVec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< spirv_cross::Resource > *arg1 = (std::vector< spirv_cross::Resource > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< spirv_cross::Resource > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::Resource >::~vector()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1BufferRangeVec_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::BufferRange > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< spirv_cross::BufferRange > *)new std::vector< spirv_cross::BufferRange >();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::BufferRange >::vector()"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::BufferRange > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1BufferRangeVec_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::BufferRange >::size_type arg1 ;
  std::vector< spirv_cross::BufferRange > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< spirv_cross::BufferRange >::size_type)jarg1; 
  {
    try {
      result = (std::vector< spirv_cross::BufferRange > *)new std::vector< spirv_cross::BufferRange >(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::BufferRange >::vector(std::vector< spirv_cross::BufferRange >::size_type)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::BufferRange > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRangeVec_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::BufferRange > *arg1 = (std::vector< spirv_cross::BufferRange > *) 0 ;
  std::vector< spirv_cross::BufferRange >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::BufferRange > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::BufferRange > const *)arg1)->size();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::BufferRange >::size() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRangeVec_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::BufferRange > *arg1 = (std::vector< spirv_cross::BufferRange > *) 0 ;
  std::vector< spirv_cross::BufferRange >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::BufferRange > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::BufferRange > const *)arg1)->capacity();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::BufferRange >::capacity() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRangeVec_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< spirv_cross::BufferRange > *arg1 = (std::vector< spirv_cross::BufferRange > *) 0 ;
  std::vector< spirv_cross::BufferRange >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::BufferRange > **)&jarg1; 
  arg2 = (std::vector< spirv_cross::BufferRange >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::BufferRange >::reserve(std::vector< spirv_cross::BufferRange >::size_type)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRangeVec_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< spirv_cross::BufferRange > *arg1 = (std::vector< spirv_cross::BufferRange > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::BufferRange > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< spirv_cross::BufferRange > const *)arg1)->empty();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::BufferRange >::empty() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRangeVec_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< spirv_cross::BufferRange > *arg1 = (std::vector< spirv_cross::BufferRange > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::BufferRange > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::BufferRange >::clear()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRangeVec_1pushBack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< spirv_cross::BufferRange > *arg1 = (std::vector< spirv_cross::BufferRange > *) 0 ;
  std::vector< spirv_cross::BufferRange >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< spirv_cross::BufferRange > **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::BufferRange >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::BufferRange >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< spirv_cross::BufferRange >::value_type const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::BufferRange >::push_back(std::vector< spirv_cross::BufferRange >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRangeVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::BufferRange > *arg1 = (std::vector< spirv_cross::BufferRange > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::BufferRange >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::BufferRange > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< spirv_cross::BufferRange >::value_type *) &std_vector_Sl_spirv_cross_BufferRange_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::BufferRange >::get(int)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::BufferRange >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_BufferRangeVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< spirv_cross::BufferRange > *arg1 = (std::vector< spirv_cross::BufferRange > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::BufferRange >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< spirv_cross::BufferRange > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< spirv_cross::BufferRange >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::BufferRange >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_spirv_cross_BufferRange_Sg__set(arg1,arg2,(spirv_cross::BufferRange const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::BufferRange >::set(int,std::vector< spirv_cross::BufferRange >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1BufferRangeVec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< spirv_cross::BufferRange > *arg1 = (std::vector< spirv_cross::BufferRange > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< spirv_cross::BufferRange > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::BufferRange >::~vector()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CombinedImageSamplerVec_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::CombinedImageSampler > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< spirv_cross::CombinedImageSampler > *)new std::vector< spirv_cross::CombinedImageSampler >();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::CombinedImageSampler >::vector()"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::CombinedImageSampler > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1CombinedImageSamplerVec_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::CombinedImageSampler >::size_type arg1 ;
  std::vector< spirv_cross::CombinedImageSampler > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< spirv_cross::CombinedImageSampler >::size_type)jarg1; 
  {
    try {
      result = (std::vector< spirv_cross::CombinedImageSampler > *)new std::vector< spirv_cross::CombinedImageSampler >(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::CombinedImageSampler >::vector(std::vector< spirv_cross::CombinedImageSampler >::size_type)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::CombinedImageSampler > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSamplerVec_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::CombinedImageSampler > *arg1 = (std::vector< spirv_cross::CombinedImageSampler > *) 0 ;
  std::vector< spirv_cross::CombinedImageSampler >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::CombinedImageSampler > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::CombinedImageSampler > const *)arg1)->size();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::CombinedImageSampler >::size() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSamplerVec_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::CombinedImageSampler > *arg1 = (std::vector< spirv_cross::CombinedImageSampler > *) 0 ;
  std::vector< spirv_cross::CombinedImageSampler >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::CombinedImageSampler > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::CombinedImageSampler > const *)arg1)->capacity();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::CombinedImageSampler >::capacity() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSamplerVec_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< spirv_cross::CombinedImageSampler > *arg1 = (std::vector< spirv_cross::CombinedImageSampler > *) 0 ;
  std::vector< spirv_cross::CombinedImageSampler >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::CombinedImageSampler > **)&jarg1; 
  arg2 = (std::vector< spirv_cross::CombinedImageSampler >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::CombinedImageSampler >::reserve(std::vector< spirv_cross::CombinedImageSampler >::size_type)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSamplerVec_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< spirv_cross::CombinedImageSampler > *arg1 = (std::vector< spirv_cross::CombinedImageSampler > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::CombinedImageSampler > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< spirv_cross::CombinedImageSampler > const *)arg1)->empty();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::CombinedImageSampler >::empty() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSamplerVec_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< spirv_cross::CombinedImageSampler > *arg1 = (std::vector< spirv_cross::CombinedImageSampler > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::CombinedImageSampler > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::CombinedImageSampler >::clear()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSamplerVec_1pushBack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< spirv_cross::CombinedImageSampler > *arg1 = (std::vector< spirv_cross::CombinedImageSampler > *) 0 ;
  std::vector< spirv_cross::CombinedImageSampler >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< spirv_cross::CombinedImageSampler > **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::CombinedImageSampler >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::CombinedImageSampler >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< spirv_cross::CombinedImageSampler >::value_type const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::CombinedImageSampler >::push_back(std::vector< spirv_cross::CombinedImageSampler >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSamplerVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::CombinedImageSampler > *arg1 = (std::vector< spirv_cross::CombinedImageSampler > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::CombinedImageSampler >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::CombinedImageSampler > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< spirv_cross::CombinedImageSampler >::value_type *) &std_vector_Sl_spirv_cross_CombinedImageSampler_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::CombinedImageSampler >::get(int)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::CombinedImageSampler >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CombinedImageSamplerVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< spirv_cross::CombinedImageSampler > *arg1 = (std::vector< spirv_cross::CombinedImageSampler > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::CombinedImageSampler >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< spirv_cross::CombinedImageSampler > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< spirv_cross::CombinedImageSampler >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::CombinedImageSampler >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_spirv_cross_CombinedImageSampler_Sg__set(arg1,arg2,(spirv_cross::CombinedImageSampler const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::CombinedImageSampler >::set(int,std::vector< spirv_cross::CombinedImageSampler >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1CombinedImageSamplerVec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< spirv_cross::CombinedImageSampler > *arg1 = (std::vector< spirv_cross::CombinedImageSampler > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< spirv_cross::CombinedImageSampler > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::CombinedImageSampler >::~vector()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1MSLResourceBindingVec_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::MSLResourceBinding > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< spirv_cross::MSLResourceBinding > *)new std::vector< spirv_cross::MSLResourceBinding >();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLResourceBinding >::vector()"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::MSLResourceBinding > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1MSLResourceBindingVec_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::MSLResourceBinding >::size_type arg1 ;
  std::vector< spirv_cross::MSLResourceBinding > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< spirv_cross::MSLResourceBinding >::size_type)jarg1; 
  {
    try {
      result = (std::vector< spirv_cross::MSLResourceBinding > *)new std::vector< spirv_cross::MSLResourceBinding >(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLResourceBinding >::vector(std::vector< spirv_cross::MSLResourceBinding >::size_type)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::MSLResourceBinding > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBindingVec_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::MSLResourceBinding > *arg1 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  std::vector< spirv_cross::MSLResourceBinding >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::MSLResourceBinding > const *)arg1)->size();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLResourceBinding >::size() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBindingVec_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::MSLResourceBinding > *arg1 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  std::vector< spirv_cross::MSLResourceBinding >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::MSLResourceBinding > const *)arg1)->capacity();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLResourceBinding >::capacity() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBindingVec_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< spirv_cross::MSLResourceBinding > *arg1 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  std::vector< spirv_cross::MSLResourceBinding >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg1; 
  arg2 = (std::vector< spirv_cross::MSLResourceBinding >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLResourceBinding >::reserve(std::vector< spirv_cross::MSLResourceBinding >::size_type)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBindingVec_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< spirv_cross::MSLResourceBinding > *arg1 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< spirv_cross::MSLResourceBinding > const *)arg1)->empty();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLResourceBinding >::empty() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBindingVec_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< spirv_cross::MSLResourceBinding > *arg1 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLResourceBinding >::clear()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBindingVec_1pushBack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< spirv_cross::MSLResourceBinding > *arg1 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  std::vector< spirv_cross::MSLResourceBinding >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::MSLResourceBinding >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::MSLResourceBinding >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< spirv_cross::MSLResourceBinding >::value_type const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLResourceBinding >::push_back(std::vector< spirv_cross::MSLResourceBinding >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBindingVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::MSLResourceBinding > *arg1 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::MSLResourceBinding >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< spirv_cross::MSLResourceBinding >::value_type *) &std_vector_Sl_spirv_cross_MSLResourceBinding_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLResourceBinding >::get(int)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::MSLResourceBinding >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLResourceBindingVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< spirv_cross::MSLResourceBinding > *arg1 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::MSLResourceBinding >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< spirv_cross::MSLResourceBinding >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::MSLResourceBinding >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_spirv_cross_MSLResourceBinding_Sg__set(arg1,arg2,(spirv_cross::MSLResourceBinding const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLResourceBinding >::set(int,std::vector< spirv_cross::MSLResourceBinding >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1MSLResourceBindingVec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< spirv_cross::MSLResourceBinding > *arg1 = (std::vector< spirv_cross::MSLResourceBinding > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< spirv_cross::MSLResourceBinding > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLResourceBinding >::~vector()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1MSLVertexAttrVec_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::MSLVertexAttr > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< spirv_cross::MSLVertexAttr > *)new std::vector< spirv_cross::MSLVertexAttr >();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLVertexAttr >::vector()"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::MSLVertexAttr > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1MSLVertexAttrVec_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::MSLVertexAttr >::size_type arg1 ;
  std::vector< spirv_cross::MSLVertexAttr > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< spirv_cross::MSLVertexAttr >::size_type)jarg1; 
  {
    try {
      result = (std::vector< spirv_cross::MSLVertexAttr > *)new std::vector< spirv_cross::MSLVertexAttr >(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLVertexAttr >::vector(std::vector< spirv_cross::MSLVertexAttr >::size_type)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::MSLVertexAttr > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttrVec_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::MSLVertexAttr > *arg1 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  std::vector< spirv_cross::MSLVertexAttr >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::MSLVertexAttr > const *)arg1)->size();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLVertexAttr >::size() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttrVec_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::MSLVertexAttr > *arg1 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  std::vector< spirv_cross::MSLVertexAttr >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::MSLVertexAttr > const *)arg1)->capacity();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLVertexAttr >::capacity() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttrVec_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< spirv_cross::MSLVertexAttr > *arg1 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  std::vector< spirv_cross::MSLVertexAttr >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg1; 
  arg2 = (std::vector< spirv_cross::MSLVertexAttr >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLVertexAttr >::reserve(std::vector< spirv_cross::MSLVertexAttr >::size_type)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttrVec_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< spirv_cross::MSLVertexAttr > *arg1 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< spirv_cross::MSLVertexAttr > const *)arg1)->empty();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLVertexAttr >::empty() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttrVec_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< spirv_cross::MSLVertexAttr > *arg1 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLVertexAttr >::clear()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttrVec_1pushBack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< spirv_cross::MSLVertexAttr > *arg1 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  std::vector< spirv_cross::MSLVertexAttr >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::MSLVertexAttr >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::MSLVertexAttr >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< spirv_cross::MSLVertexAttr >::value_type const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLVertexAttr >::push_back(std::vector< spirv_cross::MSLVertexAttr >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttrVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::MSLVertexAttr > *arg1 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::MSLVertexAttr >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< spirv_cross::MSLVertexAttr >::value_type *) &std_vector_Sl_spirv_cross_MSLVertexAttr_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLVertexAttr >::get(int)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::MSLVertexAttr >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_MSLVertexAttrVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< spirv_cross::MSLVertexAttr > *arg1 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::MSLVertexAttr >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< spirv_cross::MSLVertexAttr >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::MSLVertexAttr >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_spirv_cross_MSLVertexAttr_Sg__set(arg1,arg2,(spirv_cross::MSLVertexAttr const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLVertexAttr >::set(int,std::vector< spirv_cross::MSLVertexAttr >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1MSLVertexAttrVec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< spirv_cross::MSLVertexAttr > *arg1 = (std::vector< spirv_cross::MSLVertexAttr > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< spirv_cross::MSLVertexAttr > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::MSLVertexAttr >::~vector()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SpecializationConstantVec_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::SpecializationConstant > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< spirv_cross::SpecializationConstant > *)new std::vector< spirv_cross::SpecializationConstant >();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::SpecializationConstant >::vector()"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::SpecializationConstant > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1SpecializationConstantVec_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::SpecializationConstant >::size_type arg1 ;
  std::vector< spirv_cross::SpecializationConstant > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< spirv_cross::SpecializationConstant >::size_type)jarg1; 
  {
    try {
      result = (std::vector< spirv_cross::SpecializationConstant > *)new std::vector< spirv_cross::SpecializationConstant >(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::SpecializationConstant >::vector(std::vector< spirv_cross::SpecializationConstant >::size_type)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::SpecializationConstant > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstantVec_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::SpecializationConstant > *arg1 = (std::vector< spirv_cross::SpecializationConstant > *) 0 ;
  std::vector< spirv_cross::SpecializationConstant >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::SpecializationConstant > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::SpecializationConstant > const *)arg1)->size();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::SpecializationConstant >::size() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstantVec_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::SpecializationConstant > *arg1 = (std::vector< spirv_cross::SpecializationConstant > *) 0 ;
  std::vector< spirv_cross::SpecializationConstant >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::SpecializationConstant > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::SpecializationConstant > const *)arg1)->capacity();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::SpecializationConstant >::capacity() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstantVec_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< spirv_cross::SpecializationConstant > *arg1 = (std::vector< spirv_cross::SpecializationConstant > *) 0 ;
  std::vector< spirv_cross::SpecializationConstant >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::SpecializationConstant > **)&jarg1; 
  arg2 = (std::vector< spirv_cross::SpecializationConstant >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::SpecializationConstant >::reserve(std::vector< spirv_cross::SpecializationConstant >::size_type)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstantVec_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< spirv_cross::SpecializationConstant > *arg1 = (std::vector< spirv_cross::SpecializationConstant > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::SpecializationConstant > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< spirv_cross::SpecializationConstant > const *)arg1)->empty();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::SpecializationConstant >::empty() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstantVec_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< spirv_cross::SpecializationConstant > *arg1 = (std::vector< spirv_cross::SpecializationConstant > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::SpecializationConstant > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::SpecializationConstant >::clear()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstantVec_1pushBack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< spirv_cross::SpecializationConstant > *arg1 = (std::vector< spirv_cross::SpecializationConstant > *) 0 ;
  std::vector< spirv_cross::SpecializationConstant >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< spirv_cross::SpecializationConstant > **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::SpecializationConstant >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::SpecializationConstant >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< spirv_cross::SpecializationConstant >::value_type const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::SpecializationConstant >::push_back(std::vector< spirv_cross::SpecializationConstant >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstantVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::SpecializationConstant > *arg1 = (std::vector< spirv_cross::SpecializationConstant > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::SpecializationConstant >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::SpecializationConstant > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< spirv_cross::SpecializationConstant >::value_type *) &std_vector_Sl_spirv_cross_SpecializationConstant_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::SpecializationConstant >::get(int)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::SpecializationConstant >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_SpecializationConstantVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< spirv_cross::SpecializationConstant > *arg1 = (std::vector< spirv_cross::SpecializationConstant > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::SpecializationConstant >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< spirv_cross::SpecializationConstant > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< spirv_cross::SpecializationConstant >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::SpecializationConstant >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_spirv_cross_SpecializationConstant_Sg__set(arg1,arg2,(spirv_cross::SpecializationConstant const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::SpecializationConstant >::set(int,std::vector< spirv_cross::SpecializationConstant >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1SpecializationConstantVec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< spirv_cross::SpecializationConstant > *arg1 = (std::vector< spirv_cross::SpecializationConstant > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< spirv_cross::SpecializationConstant > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::SpecializationConstant >::~vector()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1PlsRemapVec_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::PlsRemap > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< spirv_cross::PlsRemap > *)new std::vector< spirv_cross::PlsRemap >();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::PlsRemap >::vector()"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::PlsRemap > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_new_1PlsRemapVec_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::PlsRemap >::size_type arg1 ;
  std::vector< spirv_cross::PlsRemap > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (std::vector< spirv_cross::PlsRemap >::size_type)jarg1; 
  {
    try {
      result = (std::vector< spirv_cross::PlsRemap > *)new std::vector< spirv_cross::PlsRemap >(arg1);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::PlsRemap >::vector(std::vector< spirv_cross::PlsRemap >::size_type)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::PlsRemap > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemapVec_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::PlsRemap > *arg1 = (std::vector< spirv_cross::PlsRemap > *) 0 ;
  std::vector< spirv_cross::PlsRemap >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::PlsRemap > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::PlsRemap > const *)arg1)->size();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::PlsRemap >::size() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemapVec_1capacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::PlsRemap > *arg1 = (std::vector< spirv_cross::PlsRemap > *) 0 ;
  std::vector< spirv_cross::PlsRemap >::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::PlsRemap > **)&jarg1; 
  {
    try {
      result = ((std::vector< spirv_cross::PlsRemap > const *)arg1)->capacity();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::PlsRemap >::capacity() const"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemapVec_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< spirv_cross::PlsRemap > *arg1 = (std::vector< spirv_cross::PlsRemap > *) 0 ;
  std::vector< spirv_cross::PlsRemap >::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::PlsRemap > **)&jarg1; 
  arg2 = (std::vector< spirv_cross::PlsRemap >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::PlsRemap >::reserve(std::vector< spirv_cross::PlsRemap >::size_type)"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemapVec_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< spirv_cross::PlsRemap > *arg1 = (std::vector< spirv_cross::PlsRemap > *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::PlsRemap > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< spirv_cross::PlsRemap > const *)arg1)->empty();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::PlsRemap >::empty() const"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemapVec_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< spirv_cross::PlsRemap > *arg1 = (std::vector< spirv_cross::PlsRemap > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::PlsRemap > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::PlsRemap >::clear()"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemapVec_1pushBack(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< spirv_cross::PlsRemap > *arg1 = (std::vector< spirv_cross::PlsRemap > *) 0 ;
  std::vector< spirv_cross::PlsRemap >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< spirv_cross::PlsRemap > **)&jarg1; 
  arg2 = *(std::vector< spirv_cross::PlsRemap >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::PlsRemap >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector< spirv_cross::PlsRemap >::value_type const &)*arg2);
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::PlsRemap >::push_back(std::vector< spirv_cross::PlsRemap >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemapVec_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< spirv_cross::PlsRemap > *arg1 = (std::vector< spirv_cross::PlsRemap > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::PlsRemap >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< spirv_cross::PlsRemap > **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector< spirv_cross::PlsRemap >::value_type *) &std_vector_Sl_spirv_cross_PlsRemap_Sg__get(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::PlsRemap >::get(int)"); return 0; 
      };
    }
  }
  *(std::vector< spirv_cross::PlsRemap >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_PlsRemapVec_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< spirv_cross::PlsRemap > *arg1 = (std::vector< spirv_cross::PlsRemap > *) 0 ;
  int arg2 ;
  std::vector< spirv_cross::PlsRemap >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< spirv_cross::PlsRemap > **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(std::vector< spirv_cross::PlsRemap >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< spirv_cross::PlsRemap >::value_type const & reference is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_spirv_cross_PlsRemap_Sg__set(arg1,arg2,(spirv_cross::PlsRemap const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
      
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::PlsRemap >::set(int,std::vector< spirv_cross::PlsRemap >::value_type const &)"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_delete_1PlsRemapVec(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< spirv_cross::PlsRemap > *arg1 = (std::vector< spirv_cross::PlsRemap > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< spirv_cross::PlsRemap > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch(spirv_cross::CompilerError) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "SPIRV-cross compiler error in std::vector< spirv_cross::PlsRemap >::~vector()"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerGLSL_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(spirv_cross::Compiler **)&baseptr = *(spirv_cross::CompilerGLSL **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerCPP_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(spirv_cross::CompilerGLSL **)&baseptr = *(spirv_cross::CompilerCPP **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerMSL_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(spirv_cross::CompilerGLSL **)&baseptr = *(spirv_cross::CompilerMSL **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_CompilerReflection_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(spirv_cross::CompilerGLSL **)&baseptr = *(spirv_cross::CompilerReflection **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TUniformMap_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(TShHandleBase **)&baseptr = *(TUniformMap **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TCompiler_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(TShHandleBase **)&baseptr = *(TCompiler **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TLinker_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(TShHandleBase **)&baseptr = *(TLinker **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_TShader_1ForbidIncluder_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(glslang::TShader::Includer **)&baseptr = *(glslang::TShader::ForbidIncluder **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_graphics_scenery_spirvcrossj_libspirvcrossjJNI_spirvbin_1t_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(spv::spirvbin_base_t **)&baseptr = *(spv::spirvbin_t **)&jarg1;
    return baseptr;
}

#ifdef __cplusplus
}
#endif

