/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.processor.poet;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.TypeName;
import graphics.glimpse.processor.poet.model.AttributeModel;
import graphics.glimpse.processor.poet.model.ShaderParamsModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001cH\u0002J\u001a\u0010\u001f\u001a\u00020\u001c*\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lgraphics/glimpse/processor/poet/DrawMeshFunPoet;", "", "()V", "COMMENT_CLEANUP", "", "COMMENT_DRAWING", "FUNCTION_NAME_DRAW_MESH", "PARAM_NAME_GL_ADAPTER", "PARAM_NAME_MESH", "STATEMENT_FORMAT_ATTRIBUTE_LOCATION_VAL", "STATEMENT_FORMAT_ATTRIBUTE_POINTER", "STATEMENT_FORMAT_DISABLE_ATTRIBUTE", "STATEMENT_FORMAT_DRAW_ARRAYS", "STATEMENT_FORMAT_ENABLE_ATTRIBUTE", "STATEMENT_FORMAT_GET_ATTRIBUTE_LOCATION", "STATEMENT_FORMAT_USE_MESH_BUFFER", "glimpseAdapterClassName", "Lcom/squareup/kotlinpoet/ClassName;", "meshClassName", "attributeLocation", "Lcom/squareup/kotlinpoet/CodeBlock;", "attribute", "Lgraphics/glimpse/processor/poet/model/AttributeModel;", "generateFun", "Lcom/squareup/kotlinpoet/FunSpec;", "model", "Lgraphics/glimpse/processor/poet/model/ShaderParamsModel;", "addAttributeStatement", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "addEmptyLine", "", "generateStatements", "attributes", "", "processor-kotlin"})
public final class DrawMeshFunPoet {
    @NotNull
    public static final DrawMeshFunPoet INSTANCE = new DrawMeshFunPoet();
    @NotNull
    private static final String FUNCTION_NAME_DRAW_MESH = "drawMesh";
    @NotNull
    private static final String PARAM_NAME_GL_ADAPTER = "gl";
    @NotNull
    private static final String PARAM_NAME_MESH = "mesh";
    @NotNull
    private static final String STATEMENT_FORMAT_GET_ATTRIBUTE_LOCATION = "val %L = getAttributeLocation(gl, %S)";
    @NotNull
    private static final String STATEMENT_FORMAT_ATTRIBUTE_LOCATION_VAL = "%LLocation";
    @NotNull
    private static final String STATEMENT_FORMAT_USE_MESH_BUFFER = "%N.useBuffer(gl, %L)";
    @NotNull
    private static final String STATEMENT_FORMAT_ENABLE_ATTRIBUTE = "gl.glEnableVertexAttribArray(%L)";
    @NotNull
    private static final String STATEMENT_FORMAT_ATTRIBUTE_POINTER = "glVertexAttribPointer(gl, %L, %L)";
    @NotNull
    private static final String STATEMENT_FORMAT_DISABLE_ATTRIBUTE = "gl.glDisableVertexAttribArray(%L)";
    @NotNull
    private static final String STATEMENT_FORMAT_DRAW_ARRAYS = "%N.draw(gl)";
    @NotNull
    private static final String COMMENT_DRAWING = "Drawing vertices:";
    @NotNull
    private static final String COMMENT_CLEANUP = "Disabling arrays:";
    @NotNull
    private static final ClassName glimpseAdapterClassName;
    @NotNull
    private static final ClassName meshClassName;

    private DrawMeshFunPoet() {
    }

    @NotNull
    public final FunSpec generateFun(@NotNull ShaderParamsModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        KModifier[] kModifierArray = new KModifier[]{KModifier.OVERRIDE};
        return this.generateStatements(FunSpec.Companion.builder(FUNCTION_NAME_DRAW_MESH).addModifiers(kModifierArray).addParameter(PARAM_NAME_GL_ADAPTER, (TypeName)glimpseAdapterClassName, new KModifier[0]).addParameter(PARAM_NAME_MESH, (TypeName)meshClassName, new KModifier[0]), model.getAttributes()).build();
    }

    private final FunSpec.Builder generateStatements(FunSpec.Builder $this$generateStatements, List<AttributeModel> attributes) {
        for (AttributeModel attribute : attributes) {
            $this$generateStatements.addComment(attribute.getComment(), new Object[0]);
            this.addAttributeStatement($this$generateStatements, attribute);
            this.addEmptyLine($this$generateStatements);
        }
        $this$generateStatements.addComment(COMMENT_DRAWING, new Object[0]);
        Object[] objectArray = new Object[]{PARAM_NAME_MESH};
        $this$generateStatements.addStatement(STATEMENT_FORMAT_DRAW_ARRAYS, objectArray);
        this.addEmptyLine($this$generateStatements);
        $this$generateStatements.addComment(COMMENT_CLEANUP, new Object[0]);
        for (AttributeModel attribute : attributes) {
            Object[] objectArray2 = new Object[]{this.attributeLocation(attribute)};
            $this$generateStatements.addStatement(STATEMENT_FORMAT_DISABLE_ATTRIBUTE, objectArray2);
        }
        return $this$generateStatements;
    }

    private final FunSpec.Builder addAttributeStatement(FunSpec.Builder $this$addAttributeStatement, AttributeModel attribute) {
        Object[] objectArray = new Object[]{this.attributeLocation(attribute), attribute.getName()};
        $this$addAttributeStatement.addStatement(STATEMENT_FORMAT_GET_ATTRIBUTE_LOCATION, objectArray);
        objectArray = new Object[]{PARAM_NAME_MESH, attribute.getArrayBufferIndex()};
        $this$addAttributeStatement.addStatement(STATEMENT_FORMAT_USE_MESH_BUFFER, objectArray);
        objectArray = new Object[]{this.attributeLocation(attribute)};
        $this$addAttributeStatement.addStatement(STATEMENT_FORMAT_ENABLE_ATTRIBUTE, objectArray);
        objectArray = new Object[]{this.attributeLocation(attribute), attribute.getVectorSize()};
        $this$addAttributeStatement.addStatement(STATEMENT_FORMAT_ATTRIBUTE_POINTER, objectArray);
        return $this$addAttributeStatement;
    }

    private final CodeBlock attributeLocation(AttributeModel attribute) {
        Object[] objectArray = new Object[]{attribute.getName()};
        return CodeBlock.Companion.of(STATEMENT_FORMAT_ATTRIBUTE_LOCATION_VAL, objectArray);
    }

    private final void addEmptyLine(FunSpec.Builder $this$addEmptyLine) {
        $this$addEmptyLine.addCode("\n", new Object[0]);
    }

    static {
        String[] stringArray = new String[]{"GlimpseAdapter"};
        glimpseAdapterClassName = new ClassName("graphics.glimpse", stringArray);
        stringArray = new String[]{"Mesh"};
        meshClassName = new ClassName("graphics.glimpse.meshes", stringArray);
    }
}

