/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud.shaders;

import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.hud.shaders.Hud;
import graphics.glimpse.meshes.Mesh;
import graphics.glimpse.shaders.BaseProgramExecutor;
import graphics.glimpse.shaders.Program;
import graphics.glimpse.shaders.annotations.AttributeRole;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lgraphics/glimpse/hud/shaders/HudProgramExecutor;", "Lgraphics/glimpse/shaders/BaseProgramExecutor;", "Lgraphics/glimpse/hud/shaders/Hud;", "program", "Lgraphics/glimpse/shaders/Program;", "(Lgraphics/glimpse/shaders/Program;)V", "applyParams", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "shaderParams", "drawMesh", "mesh", "Lgraphics/glimpse/meshes/Mesh;", "Companion", "hud"})
public final class HudProgramExecutor
extends BaseProgramExecutor<Hud> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NAME_MVP_MATRIX = "uMVPMat";
    @NotNull
    private static final String NAME_TEXTURE = "uTex";
    @NotNull
    private static final String NAME_POSITIONS = "aPos";
    @NotNull
    private static final String NAME_TEX_COORDS = "aTexCoords";

    public HudProgramExecutor(@NotNull Program program) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        super(program);
    }

    public void applyParams(@NotNull GlimpseAdapter gl, @NotNull Hud shaderParams) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)shaderParams, (String)"shaderParams");
        this.glUniform(gl, NAME_MVP_MATRIX, shaderParams.getMvpMatrix());
        shaderParams.getTexture().useAtIndex(gl, 0);
        this.glUniform(gl, NAME_TEXTURE, 0);
    }

    public void drawMesh(@NotNull GlimpseAdapter gl, @NotNull Mesh mesh) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Intrinsics.checkNotNullParameter((Object)mesh, (String)"mesh");
        int aPosLocation = this.getAttributeLocation(gl, NAME_POSITIONS);
        mesh.useBuffer(gl, AttributeRole.POSITIONS.ordinal());
        gl.glEnableVertexAttribArray(aPosLocation);
        this.glVertexAttribPointer(gl, aPosLocation, 2);
        int aTexCoordsLocation = this.getAttributeLocation(gl, NAME_TEX_COORDS);
        mesh.useBuffer(gl, AttributeRole.TEX_COORDS.ordinal());
        gl.glEnableVertexAttribArray(aTexCoordsLocation);
        this.glVertexAttribPointer(gl, aTexCoordsLocation, 2);
        mesh.draw(gl);
        gl.glDisableVertexAttribArray(aPosLocation);
        gl.glDisableVertexAttribArray(aTexCoordsLocation);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgraphics/glimpse/hud/shaders/HudProgramExecutor$Companion;", "", "()V", "NAME_MVP_MATRIX", "", "NAME_POSITIONS", "NAME_TEXTURE", "NAME_TEX_COORDS", "hud"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

