/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud.layouts;

import graphics.glimpse.hud.BoundingBox;
import graphics.glimpse.hud.HudElement;
import graphics.glimpse.hud.layouts.Alignment;
import graphics.glimpse.hud.layouts.BaseHudLayout;
import graphics.glimpse.types.Vec2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B7\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0016R0\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lgraphics/glimpse/hud/layouts/TableLayout;", "Lgraphics/glimpse/hud/layouts/BaseHudLayout;", "position", "Lgraphics/glimpse/types/Vec2;", "", "columns", "", "Lgraphics/glimpse/hud/layouts/TableLayout$Column;", "columnsSpacing", "rowsSpacing", "(Lgraphics/glimpse/types/Vec2;Ljava/util/List;FF)V", "value", "getColumns", "()Ljava/util/List;", "setColumns", "(Ljava/util/List;)V", "getColumnsSpacing", "()F", "setColumnsSpacing", "(F)V", "getRowsSpacing", "setRowsSpacing", "layoutElements", "", "Column", "hud"})
@SourceDebugExtension(value={"SMAP\nTableLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableLayout.kt\ngraphics/glimpse/hud/layouts/TableLayout\n+ 2 Vec2.kt\ngraphics/glimpse/types/Vec2$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Vec2.kt\ngraphics/glimpse/types/Vec2Kt\n*L\n1#1,135:1\n235#2:136\n1549#3:137\n1620#3,2:138\n1622#3:141\n1549#3:142\n1620#3,3:143\n1#4:140\n402#5:146\n*S KotlinDebug\n*F\n+ 1 TableLayout.kt\ngraphics/glimpse/hud/layouts/TableLayout\n*L\n32#1:136\n84#1:137\n84#1:138,2\n84#1:141\n88#1:142\n88#1:143,3\n105#1:146\n*E\n"})
public final class TableLayout
extends BaseHudLayout {
    @NotNull
    private List<Column> columns;
    private float columnsSpacing;
    private float rowsSpacing;

    public TableLayout(@NotNull Vec2<Float> position, @NotNull List<Column> columns, float columnsSpacing, float rowsSpacing) {
        Intrinsics.checkNotNullParameter(position, (String)"position");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        super(position);
        this.columns = columns;
        this.columnsSpacing = columnsSpacing;
        this.rowsSpacing = rowsSpacing;
    }

    public /* synthetic */ TableLayout(Vec2 vec2, List list, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Vec2.Companion this_$iv = Vec2.Companion;
            boolean $i$f$nullVector = false;
            vec2 = this_$iv.nullVector(Reflection.getOrCreateKotlinClass(Float.class));
        }
        if ((n & 4) != 0) {
            f = 0.0f;
        }
        if ((n & 8) != 0) {
            f2 = 0.0f;
        }
        this((Vec2<Float>)vec2, list, f, f2);
    }

    @NotNull
    public final List<Column> getColumns() {
        return this.columns;
    }

    public final void setColumns(@NotNull List<Column> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.columns = value;
        this.layoutElements();
    }

    public final float getColumnsSpacing() {
        return this.columnsSpacing;
    }

    public final void setColumnsSpacing(float value) {
        this.columnsSpacing = value;
        this.layoutElements();
    }

    public final float getRowsSpacing() {
        return this.rowsSpacing;
    }

    public final void setRowsSpacing(float value) {
        this.rowsSpacing = value;
        this.layoutElements();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void layoutElements() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        super.layoutElements();
        List rows = CollectionsKt.chunked((Iterable)this.getElements(), (int)this.columns.size());
        Iterable $this$map$iv = rows;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void row;
            List list = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Iterator iterator = ((Iterable)row).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            HudElement element = (HudElement)iterator.next();
            boolean bl2 = false;
            float f = element.getBoundingBox().getHeight();
            while (iterator.hasNext()) {
                HudElement element22 = (HudElement)iterator.next();
                $i$a$-maxOf-TableLayout$layoutElements$rowsHeights$1$1 = false;
                float element22 = element22.getBoundingBox().getHeight();
                f = Math.max(f, element22);
            }
            collection.add(Float.valueOf(f));
        }
        List rowsHeights = (List)destination$iv$iv;
        Iterable $this$map$iv2 = this.columns;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void column;
            Column bl = (Column)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(Float.valueOf(column.getWidth()));
        }
        float width = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv2)) + this.columnsSpacing * (float)CollectionsKt.getLastIndex(this.columns);
        float height = CollectionsKt.sumOfFloat((Iterable)rowsHeights) + this.rowsSpacing * (float)CollectionsKt.getLastIndex((List)rows);
        this.setBoundingBox(new BoundingBox(-width / 2.0f, width / 2.0f, -height / 2.0f, height / 2.0f));
        float top = this.getBoundingBox().getTop();
        Iterator iterator = rows.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int rowIndex = n++;
            List row = (List)iterator.next();
            float left = this.getBoundingBox().getLeft();
            float rowHeight = ((Number)rowsHeights.get(rowIndex)).floatValue();
            Iterator iterator2 = row.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                void y$iv;
                void x$iv;
                int columnIndex = n2++;
                HudElement element = (HudElement)iterator2.next();
                float cellWidth = this.columns.get(columnIndex).getWidth();
                Alignment cellAlignment = this.columns.get(columnIndex).getAlignment();
                Number number = Float.valueOf(left + cellWidth / 2.0f + cellAlignment.getX$hud() * (cellWidth - element.getBoundingBox().getWidth()) / 2.0f - element.getBoundingBox().getMidpoint().getX().floatValue());
                Number number2 = Float.valueOf(top + rowHeight / 2.0f + cellAlignment.getY$hud() * (rowHeight - element.getBoundingBox().getHeight()) / 2.0f - element.getBoundingBox().getMidpoint().getY().floatValue());
                boolean $i$f$Vec2 = false;
                element.setPosition((Vec2<Float>)new Vec2((Number)x$iv, (Number)y$iv, Reflection.getOrCreateKotlinClass(Float.class)));
                left += cellWidth + this.columnsSpacing;
            }
            top += rowHeight + this.rowsSpacing;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lgraphics/glimpse/hud/layouts/TableLayout$Column;", "", "width", "", "alignment", "Lgraphics/glimpse/hud/layouts/Alignment;", "(FLgraphics/glimpse/hud/layouts/Alignment;)V", "getAlignment", "()Lgraphics/glimpse/hud/layouts/Alignment;", "getWidth", "()F", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "hud"})
    public static final class Column {
        private final float width;
        @NotNull
        private final Alignment alignment;

        public Column(float width, @NotNull Alignment alignment) {
            Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
            this.width = width;
            this.alignment = alignment;
        }

        public final float getWidth() {
            return this.width;
        }

        @NotNull
        public final Alignment getAlignment() {
            return this.alignment;
        }

        public final float component1() {
            return this.width;
        }

        @NotNull
        public final Alignment component2() {
            return this.alignment;
        }

        @NotNull
        public final Column copy(float width, @NotNull Alignment alignment) {
            Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
            return new Column(width, alignment);
        }

        public static /* synthetic */ Column copy$default(Column column, float f, Alignment alignment, int n, Object object) {
            if ((n & 1) != 0) {
                f = column.width;
            }
            if ((n & 2) != 0) {
                alignment = column.alignment;
            }
            return column.copy(f, alignment);
        }

        @NotNull
        public String toString() {
            return "Column(width=" + this.width + ", alignment=" + this.alignment + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.width);
            result = result * 31 + this.alignment.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Column)) {
                return false;
            }
            Column column = (Column)other;
            if (Float.compare(this.width, column.width) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.alignment, (Object)column.alignment);
        }
    }
}

