/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud;

import graphics.glimpse.hud.BaseHudElementWrapper;
import graphics.glimpse.hud.BoundingBox;
import graphics.glimpse.hud.HudAtom;
import graphics.glimpse.hud.HudElement;
import graphics.glimpse.textures.Texture;
import graphics.glimpse.types.Angle;
import graphics.glimpse.types.Mat;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.NumbersKt;
import graphics.glimpse.types.TransformationMat4Kt;
import graphics.glimpse.types.Vec;
import graphics.glimpse.types.Vec2;
import graphics.glimpse.types.Vec3;
import graphics.glimpse.types.Vec4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001#BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\u0005\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\u000bJ \u0010\u001f\u001a\u00020 2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R0\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lgraphics/glimpse/hud/TransformationWrapper;", "Lgraphics/glimpse/hud/BaseHudElementWrapper;", "element", "Lgraphics/glimpse/hud/HudElement;", "translationProvider", "Lkotlin/Function0;", "Lgraphics/glimpse/types/Vec2;", "", "rotationProvider", "Lgraphics/glimpse/types/Angle;", "scaleProvider", "(Lgraphics/glimpse/hud/HudElement;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "atoms", "", "Lgraphics/glimpse/hud/HudAtom;", "getAtoms", "()Ljava/lang/Iterable;", "boundingBox", "Lgraphics/glimpse/hud/BoundingBox;", "getBoundingBox", "()Lgraphics/glimpse/hud/BoundingBox;", "value", "position", "getPosition", "()Lgraphics/glimpse/types/Vec2;", "setPosition", "(Lgraphics/glimpse/types/Vec2;)V", "transformationMatrix", "Lgraphics/glimpse/types/Mat4;", "getTransformationMatrix", "()Lgraphics/glimpse/types/Mat4;", "handleInputEvent", "", "event", "", "TransformationAtom", "hud"})
@SourceDebugExtension(value={"SMAP\nTransformationWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformationWrapper.kt\ngraphics/glimpse/hud/TransformationWrapper\n+ 2 Vec2.kt\ngraphics/glimpse/types/Vec2Kt\n+ 3 TransformationMat4.kt\ngraphics/glimpse/types/TransformationMat4Kt\n+ 4 Numbers.kt\ngraphics/glimpse/types/NumbersKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n402#2:118\n402#2:119\n402#2:120\n402#2:121\n116#3:122\n152#3:123\n153#3:125\n116#3:135\n152#3:136\n153#3:138\n49#4:124\n49#4:137\n1549#5:126\n1620#5,3:127\n1549#5:131\n1620#5,3:132\n2661#5,7:139\n1#6:130\n*S KotlinDebug\n*F\n+ 1 TransformationWrapper.kt\ngraphics/glimpse/hud/TransformationWrapper\n*L\n67#1:118\n68#1:119\n69#1:120\n70#1:121\n73#1:122\n73#1:123\n73#1:125\n94#1:135\n95#1:136\n95#1:138\n73#1:124\n95#1:137\n74#1:126\n74#1:127,3\n87#1:131\n87#1:132,3\n97#1:139,7\n*E\n"})
public final class TransformationWrapper
extends BaseHudElementWrapper {
    @NotNull
    private final Function0<Vec2<Float>> translationProvider;
    @NotNull
    private final Function0<Angle<Float>> rotationProvider;
    @NotNull
    private final Function0<Vec2<Float>> scaleProvider;

    public TransformationWrapper(@NotNull HudElement element, @NotNull Function0<Vec2<Float>> translationProvider, @NotNull Function0<Angle<Float>> rotationProvider, @NotNull Function0<Vec2<Float>> scaleProvider) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(translationProvider, (String)"translationProvider");
        Intrinsics.checkNotNullParameter(rotationProvider, (String)"rotationProvider");
        Intrinsics.checkNotNullParameter(scaleProvider, (String)"scaleProvider");
        super(element);
        this.translationProvider = translationProvider;
        this.rotationProvider = rotationProvider;
        this.scaleProvider = scaleProvider;
    }

    @Override
    @NotNull
    public Vec2<Float> getPosition() {
        return super.getPosition().plus((Vec2)this.translationProvider.invoke());
    }

    @Override
    public void setPosition(@NotNull Vec2<Float> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        super.setPosition(value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        float f;
        void $this$mapTo$iv$iv;
        void x$iv;
        Number x$iv2;
        BoundingBox originalBoundingBox = super.getBoundingBox();
        Object[] objectArray = new Vec2[4];
        Number number = Float.valueOf(originalBoundingBox.getLeft());
        Number y$iv = Float.valueOf(originalBoundingBox.getTop());
        boolean $i$f$Vec2 = false;
        objectArray[0] = new Vec2(x$iv2, y$iv, Reflection.getOrCreateKotlinClass(Float.class));
        x$iv2 = Float.valueOf(originalBoundingBox.getLeft());
        y$iv = Float.valueOf(originalBoundingBox.getBottom());
        $i$f$Vec2 = false;
        objectArray[1] = new Vec2(x$iv2, y$iv, Reflection.getOrCreateKotlinClass(Float.class));
        x$iv2 = Float.valueOf(originalBoundingBox.getRight());
        y$iv = Float.valueOf(originalBoundingBox.getBottom());
        $i$f$Vec2 = false;
        objectArray[2] = new Vec2(x$iv2, y$iv, Reflection.getOrCreateKotlinClass(Float.class));
        x$iv2 = Float.valueOf(originalBoundingBox.getRight());
        y$iv = Float.valueOf(originalBoundingBox.getTop());
        $i$f$Vec2 = false;
        objectArray[3] = new Vec2(x$iv2, y$iv, Reflection.getOrCreateKotlinClass(Float.class));
        List corners = CollectionsKt.listOf((Object[])objectArray);
        Vec2 scale = (Vec2)this.scaleProvider.invoke();
        Object angle$iv = (Angle)this.rotationProvider.invoke();
        boolean $i$f$rotationZ = false;
        Mat4 mat4 = TransformationMat4Kt.rotationZ((Angle)angle$iv, (KClass)Reflection.getOrCreateKotlinClass(Float.class));
        angle$iv = scale.getX();
        Number y$iv2 = scale.getY();
        boolean $i$f$one22 = false;
        Number z$iv = NumbersKt.one((KClass)Reflection.getOrCreateKotlinClass(Float.class));
        boolean $i$f$scale = false;
        Mat4 originSpaceMatrix = (Mat4)mat4.times((Mat)TransformationMat4Kt.scale((Number)x$iv, (Number)y$iv2, (Number)z$iv, (KClass)Reflection.getOrCreateKotlinClass(Float.class)));
        Iterable $this$map$iv = corners;
        boolean $i$f$map = false;
        Iterable $i$f$one22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void corner;
            Vec2 vec2 = (Vec2)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Vec4)originSpaceMatrix.times((Vec)Vec2.toVec4$default((Vec2)corner, null, (Number)Float.valueOf(1.0f), (int)1, null)));
        }
        List transformedCorners = (List)destination$iv$iv;
        Iterator iterator = ((Iterable)transformedCorners).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p12 = (Vec4)iterator.next();
        boolean bl = false;
        float p12 = p12.getX().floatValue();
        while (iterator.hasNext()) {
            Vec4 p22 = (Vec4)iterator.next();
            $i$a$-minOf-TransformationWrapper$boundingBox$1 = false;
            float p22 = p22.getX().floatValue();
            p12 = Math.min(p12, p22);
        }
        Iterable iterable = transformedCorners;
        float f2 = p12;
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p32 = (Vec4)iterator.next();
        boolean bl2 = false;
        float p32 = p32.getX().floatValue();
        while (iterator.hasNext()) {
            Vec4 p42 = (Vec4)iterator.next();
            $i$a$-maxOf-TransformationWrapper$boundingBox$2 = false;
            float p42 = p42.getX().floatValue();
            p32 = Math.max(p32, p42);
        }
        float f3 = p32;
        iterable = transformedCorners;
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p52 = (Vec4)iterator.next();
        boolean bl3 = false;
        float p52 = p52.getY().floatValue();
        while (iterator.hasNext()) {
            Vec4 p62 = (Vec4)iterator.next();
            $i$a$-minOf-TransformationWrapper$boundingBox$3 = false;
            float p62 = p62.getY().floatValue();
            p52 = Math.min(p52, p62);
        }
        float f4 = p52;
        iterable = transformedCorners;
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p0 = (Vec4)iterator.next();
        boolean bl4 = false;
        float f5 = p0.getY().floatValue();
        while (iterator.hasNext()) {
            Vec4 p02 = (Vec4)iterator.next();
            $i$a$-maxOf-TransformationWrapper$boundingBox$4 = false;
            float f6 = p02.getY().floatValue();
            f5 = Math.max(f5, f6);
        }
        float f7 = f = f5;
        float f8 = f4;
        float f9 = f3;
        float f10 = f2;
        return new BoundingBox(f10, f9, f8, f7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<HudAtom> getAtoms() {
        void $this$mapTo$iv$iv;
        Iterable<HudAtom> $this$map$iv = super.getAtoms();
        boolean $i$f$map = false;
        Iterable<HudAtom> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void atom;
            HudAtom hudAtom = (HudAtom)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TransformationAtom((HudAtom)atom));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Mat4<Float> getTransformationMatrix() {
        void x$iv;
        Vec2 scale = (Vec2)this.scaleProvider.invoke();
        Object[] objectArray = new Mat4[4];
        objectArray[0] = TransformationMat4Kt.translation((Vec3)Vec2.toVec3$default(super.getPosition(), null, (int)1, null).plus(Vec2.toVec3$default((Vec2)((Vec2)this.translationProvider.invoke()), null, (int)1, null)));
        Object angle$iv = (Angle)this.rotationProvider.invoke();
        boolean $i$f$rotationZ = false;
        objectArray[1] = TransformationMat4Kt.rotationZ((Angle)angle$iv, (KClass)Reflection.getOrCreateKotlinClass(Float.class));
        angle$iv = scale.getX();
        Number y$iv = scale.getY();
        boolean $i$f$one2 = false;
        Number z$iv = NumbersKt.one((KClass)Reflection.getOrCreateKotlinClass(Float.class));
        boolean $i$f$scale = false;
        objectArray[2] = TransformationMat4Kt.scale((Number)x$iv, (Number)y$iv, (Number)z$iv, (KClass)Reflection.getOrCreateKotlinClass(Float.class));
        objectArray[3] = TransformationMat4Kt.translation((Vec3)Vec2.toVec3$default(super.getPosition(), null, (int)1, null).unaryMinus());
        Iterable $this$reduce$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            Mat4 $i$f$one2 = (Mat4)iterator$iv.next();
            Mat4 p0 = (Mat4)accumulator$iv;
            boolean bl = false;
            accumulator$iv = (Mat4)p0.times((Mat)p1);
        }
        return (Mat4)accumulator$iv;
    }

    @Override
    public boolean handleInputEvent(@NotNull Vec2<Float> position, @Nullable Object event) {
        Intrinsics.checkNotNullParameter(position, (String)"position");
        return super.handleInputEvent((Vec2<Float>)((Vec4)((Mat4)this.getTransformationMatrix().inverse()).times((Vec)Vec2.toVec4$default(position, null, (Number)Float.valueOf(1.0f), (int)1, null))).toVec2(), event);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lgraphics/glimpse/hud/TransformationWrapper$TransformationAtom;", "Lgraphics/glimpse/hud/HudAtom;", "atom", "(Lgraphics/glimpse/hud/TransformationWrapper;Lgraphics/glimpse/hud/HudAtom;)V", "intrinsicHeight", "", "getIntrinsicHeight", "()F", "intrinsicWidth", "getIntrinsicWidth", "modelMatrix", "Lgraphics/glimpse/types/Mat4;", "getModelMatrix", "()Lgraphics/glimpse/types/Mat4;", "texture", "Lgraphics/glimpse/textures/Texture;", "getTexture", "()Lgraphics/glimpse/textures/Texture;", "hud"})
    private final class TransformationAtom
    implements HudAtom {
        @NotNull
        private final HudAtom atom;

        public TransformationAtom(HudAtom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            this.atom = atom;
        }

        @Override
        public float getIntrinsicHeight() {
            return this.atom.getIntrinsicHeight();
        }

        @Override
        public float getIntrinsicWidth() {
            return this.atom.getIntrinsicWidth();
        }

        @Override
        @NotNull
        public Texture getTexture() {
            return this.atom.getTexture();
        }

        @Override
        @NotNull
        public Mat4<Float> getModelMatrix() {
            return (Mat4)TransformationWrapper.this.getTransformationMatrix().times((Mat)this.atom.getModelMatrix());
        }
    }
}

