/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud;

import graphics.glimpse.BlendingFactorFunction;
import graphics.glimpse.DepthTestFunction;
import graphics.glimpse.DrawingMode;
import graphics.glimpse.GlimpseAdapter;
import graphics.glimpse.GlimpseCallback;
import graphics.glimpse.GlimpseDisposable;
import graphics.glimpse.buffers.Buffer;
import graphics.glimpse.buffers.BufferDataExtensionsKt;
import graphics.glimpse.buffers.FloatBufferData;
import graphics.glimpse.cameras.Camera;
import graphics.glimpse.cameras.FreeCamera;
import graphics.glimpse.hud.HudAtom;
import graphics.glimpse.hud.HudElement;
import graphics.glimpse.hud.shaders.Hud;
import graphics.glimpse.hud.shaders.HudProgramExecutor;
import graphics.glimpse.hud.shaders.HudShaderSourcesProvider;
import graphics.glimpse.lenses.OrthographicLens;
import graphics.glimpse.meshes.Mesh;
import graphics.glimpse.shaders.Program;
import graphics.glimpse.shaders.Shader;
import graphics.glimpse.shaders.ShaderType;
import graphics.glimpse.types.Angle;
import graphics.glimpse.types.Mat;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.Vec2;
import graphics.glimpse.types.Vec3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lgraphics/glimpse/hud/GlimpseHudCallback;", "Lgraphics/glimpse/GlimpseCallback;", "elements", "", "Lgraphics/glimpse/hud/HudElement;", "disposable", "Lgraphics/glimpse/GlimpseDisposable;", "hudShaderSourcesProvider", "Lgraphics/glimpse/hud/shaders/HudShaderSourcesProvider;", "(Ljava/util/List;Lgraphics/glimpse/GlimpseDisposable;Lgraphics/glimpse/hud/shaders/HudShaderSourcesProvider;)V", "lens", "Lgraphics/glimpse/lenses/OrthographicLens;", "", "programExecutor", "Lgraphics/glimpse/hud/shaders/HudProgramExecutor;", "quadMesh", "Lgraphics/glimpse/meshes/Mesh;", "createHudProgramExecutor", "", "gl", "Lgraphics/glimpse/GlimpseAdapter;", "createQuadMesh", "onCreate", "onDestroy", "onInputEvent", "position", "Lgraphics/glimpse/types/Vec2;", "event", "", "onRender", "onResize", "x", "", "y", "width", "height", "Companion", "hud"})
@SourceDebugExtension(value={"SMAP\nGlimpseHudCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlimpseHudCallback.kt\ngraphics/glimpse/hud/GlimpseHudCallback\n+ 2 OrthographicLens.kt\ngraphics/glimpse/lenses/OrthographicLensKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Vec3.kt\ngraphics/glimpse/types/Vec3$Companion\n+ 5 Angle.kt\ngraphics/glimpse/types/Angle$Companion\n*L\n1#1,200:1\n57#2:201\n1360#3:202\n1446#3,5:203\n233#4:208\n176#5:209\n192#5:210\n192#5:211\n*S KotlinDebug\n*F\n+ 1 GlimpseHudCallback.kt\ngraphics/glimpse/hud/GlimpseHudCallback\n*L\n71#1:201\n148#1:202\n148#1:203,5\n193#1:208\n194#1:209\n195#1:210\n196#1:211\n*E\n"})
public final class GlimpseHudCallback
implements GlimpseCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<HudElement> elements;
    @Nullable
    private final GlimpseDisposable disposable;
    @NotNull
    private final HudShaderSourcesProvider hudShaderSourcesProvider;
    private Mesh quadMesh;
    private HudProgramExecutor programExecutor;
    @NotNull
    private OrthographicLens<Float> lens;
    private static final int QUAD_VERTICES = 4;
    @NotNull
    private static final List<Float> quadData;
    @NotNull
    private static final Camera<Float> camera;

    /*
     * WARNING - void declaration
     */
    public GlimpseHudCallback(@NotNull List<? extends HudElement> elements, @Nullable GlimpseDisposable disposable, @NotNull HudShaderSourcesProvider hudShaderSourcesProvider) {
        void near$iv;
        void top$iv;
        void bottom$iv;
        void right$iv;
        void left$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)hudShaderSourcesProvider, (String)"hudShaderSourcesProvider");
        this.elements = elements;
        this.disposable = disposable;
        this.hudShaderSourcesProvider = hudShaderSourcesProvider;
        Number number = Float.valueOf(0.0f);
        Number number2 = Float.valueOf(1.0f);
        Number number3 = Float.valueOf(1.0f);
        Number number4 = Float.valueOf(0.0f);
        Number number5 = Float.valueOf(-1.0f);
        Number far$iv = Float.valueOf(1.0f);
        boolean $i$f$OrthographicLens = false;
        this.lens = new OrthographicLens((Number)left$iv, (Number)right$iv, (Number)bottom$iv, (Number)top$iv, (Number)near$iv, far$iv, Reflection.getOrCreateKotlinClass(Float.class));
    }

    public /* synthetic */ GlimpseHudCallback(List list, GlimpseDisposable glimpseDisposable, HudShaderSourcesProvider hudShaderSourcesProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            glimpseDisposable = null;
        }
        if ((n & 4) != 0) {
            hudShaderSourcesProvider = HudShaderSourcesProvider.Companion.getDEFAULT();
        }
        this(list, glimpseDisposable, hudShaderSourcesProvider);
    }

    public void onCreate(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        gl.glDepthTest(DepthTestFunction.DISABLED);
        gl.glEnableBlending();
        gl.glBlendingFunction(BlendingFactorFunction.SOURCE_ALPHA, BlendingFactorFunction.ONE_MINUS_SOURCE_ALPHA);
        this.createQuadMesh(gl);
        this.createHudProgramExecutor(gl);
    }

    private final void createQuadMesh(GlimpseAdapter gl) {
        FloatBufferData[] floatBufferDataArray = new FloatBufferData[]{BufferDataExtensionsKt.toFloatBufferData((Collection)quadData)};
        Buffer buffer = (Buffer)CollectionsKt.first((List)Buffer.Factory.Companion.newInstance(gl).createArrayBuffers(floatBufferDataArray));
        this.quadMesh = new Mesh(buffer){
            @NotNull
            private final List<Buffer> buffers;
            private final int vertexCount;
            @NotNull
            private final AtomicBoolean disposed;
            final /* synthetic */ Buffer $buffer;
            {
                this.$buffer = $buffer;
                Object[] objectArray = new Buffer[]{$buffer, $buffer};
                this.buffers = CollectionsKt.listOf((Object[])objectArray);
                this.vertexCount = 4;
                this.disposed = new AtomicBoolean(false);
            }

            @NotNull
            public List<Buffer> getBuffers() {
                return this.buffers;
            }

            public int getVertexCount() {
                return this.vertexCount;
            }

            public boolean isDisposed() {
                return this.disposed.get();
            }

            public void useBuffer(@NotNull GlimpseAdapter gl, int bufferIndex) {
                Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
                this.getBuffers().get(bufferIndex).use(gl);
            }

            public void draw(@NotNull GlimpseAdapter gl) {
                Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
                GlimpseAdapter.glDrawArrays$default((GlimpseAdapter)gl, (DrawingMode)DrawingMode.TRIANGLE_FAN, (int)this.getVertexCount(), (int)0, (int)4, null);
            }

            public void dispose(@NotNull GlimpseAdapter gl) {
                Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
                if (!this.disposed.compareAndSet(false, true)) {
                    boolean bl = false;
                    String string = "Mesh is already disposed";
                    throw new IllegalStateException(string.toString());
                }
                this.$buffer.dispose(gl);
            }
        };
    }

    private final void createHudProgramExecutor(GlimpseAdapter gl) {
        String vertexShaderSource = this.hudShaderSourcesProvider.getShaderSource(ShaderType.VERTEX_SHADER);
        String fragmentShaderSource = this.hudShaderSourcesProvider.getShaderSource(ShaderType.FRAGMENT_SHADER);
        Shader.Factory shaderFactory = Shader.Factory.Companion.newInstance(gl);
        Program program = Program.Builder.Companion.newInstance(gl).withVertexShader(shaderFactory.createShader(ShaderType.VERTEX_SHADER, vertexShaderSource)).withFragmentShader(shaderFactory.createShader(ShaderType.FRAGMENT_SHADER, fragmentShaderSource)).build();
        this.programExecutor = new HudProgramExecutor(program);
    }

    public void onResize(@NotNull GlimpseAdapter gl, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        this.lens = OrthographicLens.copy$default(this.lens, (Number)Float.valueOf(x), (Number)Float.valueOf(width), (Number)Float.valueOf(height), (Number)Float.valueOf(y), null, null, null, (int)112, null);
    }

    /*
     * WARNING - void declaration
     */
    public void onRender(@NotNull GlimpseAdapter gl) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        Iterable $this$flatMap$iv = this.elements;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            HudElement p0 = (HudElement)element$iv$iv;
            boolean bl = false;
            Iterable<HudAtom> list$iv$iv = p0.getAtoms();
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        for (HudAtom atom : (List)destination$iv$iv) {
            Hud shaderParams = new Hud((Mat4<Float>)((Mat4)((Mat4)this.lens.getProjectionMatrix().times((Mat)camera.getViewMatrix())).times((Mat)atom.getModelMatrix())), atom.getTexture());
            HudProgramExecutor hudProgramExecutor = this.programExecutor;
            if (hudProgramExecutor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"programExecutor");
                hudProgramExecutor = null;
            }
            HudProgramExecutor $this$onRender_u24lambda_u240 = hudProgramExecutor;
            boolean bl = false;
            $this$onRender_u24lambda_u240.useProgram(gl);
            $this$onRender_u24lambda_u240.applyParams(gl, shaderParams);
            Mesh mesh = this.quadMesh;
            if (mesh == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"quadMesh");
                mesh = null;
            }
            $this$onRender_u24lambda_u240.drawMesh(gl, mesh);
        }
    }

    public void onDestroy(@NotNull GlimpseAdapter gl) {
        Intrinsics.checkNotNullParameter((Object)gl, (String)"gl");
        GlimpseDisposable glimpseDisposable = this.disposable;
        if (glimpseDisposable != null) {
            glimpseDisposable.dispose(gl);
        }
        if (this.programExecutor != null) {
            HudProgramExecutor hudProgramExecutor = this.programExecutor;
            if (hudProgramExecutor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"programExecutor");
                hudProgramExecutor = null;
            }
            hudProgramExecutor.dispose(gl);
        }
        if (this.quadMesh != null) {
            Mesh mesh = this.quadMesh;
            if (mesh == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"quadMesh");
                mesh = null;
            }
            mesh.dispose(gl);
        }
    }

    public final void onInputEvent(@NotNull Vec2<Float> position, @Nullable Object event) {
        HudElement element;
        Intrinsics.checkNotNullParameter(position, (String)"position");
        Iterator iterator = CollectionsKt.reversed((Iterable)this.elements).iterator();
        while (!(!iterator.hasNext() || (element = (HudElement)iterator.next()).getBoundingBox().contains((Vec2<Float>)position.minus(element.getPosition())) && element.handleInputEvent(position, event))) {
        }
    }

    static {
        Object[] objectArray = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f)};
        quadData = CollectionsKt.listOf((Object[])objectArray);
        Vec3.Companion this_$iv = Vec3.Companion;
        boolean $i$f$nullVector = false;
        Vec3 vec3 = this_$iv.nullVector(Reflection.getOrCreateKotlinClass(Float.class));
        this_$iv = Angle.Companion;
        boolean $i$f$nullAngle = false;
        Angle angle = this_$iv.nullAngle(Reflection.getOrCreateKotlinClass(Float.class));
        this_$iv = Angle.Companion;
        boolean $i$f$rightAngle = false;
        Angle angle2 = this_$iv.rightAngle(Reflection.getOrCreateKotlinClass(Float.class)).unaryMinus();
        this_$iv = Angle.Companion;
        $i$f$rightAngle = false;
        camera = (Camera)new FreeCamera(vec3, angle, angle2, this_$iv.rightAngle(Reflection.getOrCreateKotlinClass(Float.class)));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgraphics/glimpse/hud/GlimpseHudCallback$Companion;", "", "()V", "QUAD_VERTICES", "", "camera", "Lgraphics/glimpse/cameras/Camera;", "", "quadData", "", "hud"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

