/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud;

import graphics.glimpse.types.Vec2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0086\u0002J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\t\u00a8\u0006#"}, d2={"Lgraphics/glimpse/hud/BoundingBox;", "", "left", "", "right", "top", "bottom", "(FFFF)V", "getBottom", "()F", "height", "getHeight", "getLeft", "midpoint", "Lgraphics/glimpse/types/Vec2;", "getMidpoint", "()Lgraphics/glimpse/types/Vec2;", "getRight", "getTop", "width", "getWidth", "component1", "component2", "component3", "component4", "contains", "", "point", "copy", "equals", "other", "hashCode", "", "toString", "", "hud"})
@SourceDebugExtension(value={"SMAP\nBoundingBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoundingBox.kt\ngraphics/glimpse/hud/BoundingBox\n+ 2 Vec2.kt\ngraphics/glimpse/types/Vec2Kt\n*L\n1#1,68:1\n402#2:69\n*S KotlinDebug\n*F\n+ 1 BoundingBox.kt\ngraphics/glimpse/hud/BoundingBox\n*L\n60#1:69\n*E\n"})
public final class BoundingBox {
    private final float left;
    private final float right;
    private final float top;
    private final float bottom;
    private final float width;
    private final float height;
    @NotNull
    private final Vec2<Float> midpoint;

    /*
     * WARNING - void declaration
     */
    public BoundingBox(float left, float right, float top, float bottom) {
        void x$iv;
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.width = this.right - this.left;
        this.height = this.bottom - this.top;
        Number number = Float.valueOf((this.left + this.right) / 2.0f);
        Number y$iv = Float.valueOf((this.top + this.bottom) / 2.0f);
        boolean $i$f$Vec2 = false;
        this.midpoint = new Vec2((Number)x$iv, y$iv, Reflection.getOrCreateKotlinClass(Float.class));
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    @NotNull
    public final Vec2<Float> getMidpoint() {
        return this.midpoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean contains(@NotNull Vec2<Float> point) {
        Intrinsics.checkNotNullParameter(point, (String)"point");
        float f = this.left;
        float f2 = this.right;
        float f3 = point.getX().floatValue();
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = this.top;
        f2 = this.bottom;
        f3 = point.getY().floatValue();
        if (!(f <= f3)) return false;
        if (!(f3 <= f2)) return false;
        return true;
    }

    public final float component1() {
        return this.left;
    }

    public final float component2() {
        return this.right;
    }

    public final float component3() {
        return this.top;
    }

    public final float component4() {
        return this.bottom;
    }

    @NotNull
    public final BoundingBox copy(float left, float right, float top, float bottom) {
        return new BoundingBox(left, right, top, bottom);
    }

    public static /* synthetic */ BoundingBox copy$default(BoundingBox boundingBox, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = boundingBox.left;
        }
        if ((n & 2) != 0) {
            f2 = boundingBox.right;
        }
        if ((n & 4) != 0) {
            f3 = boundingBox.top;
        }
        if ((n & 8) != 0) {
            f4 = boundingBox.bottom;
        }
        return boundingBox.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "BoundingBox(left=" + this.left + ", right=" + this.right + ", top=" + this.top + ", bottom=" + this.bottom + ")";
    }

    public int hashCode() {
        int result = Float.hashCode(this.left);
        result = result * 31 + Float.hashCode(this.right);
        result = result * 31 + Float.hashCode(this.top);
        result = result * 31 + Float.hashCode(this.bottom);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BoundingBox)) {
            return false;
        }
        BoundingBox boundingBox = (BoundingBox)other;
        if (Float.compare(this.left, boundingBox.left) != 0) {
            return false;
        }
        if (Float.compare(this.right, boundingBox.right) != 0) {
            return false;
        }
        if (Float.compare(this.top, boundingBox.top) != 0) {
            return false;
        }
        return Float.compare(this.bottom, boundingBox.bottom) == 0;
    }
}

