/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud.shaders;

import graphics.glimpse.hud.shaders.HudShaderSourcesProvider;
import graphics.glimpse.shaders.ShaderType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lgraphics/glimpse/hud/shaders/DefaultHudShaderSourcesProvider;", "Lgraphics/glimpse/hud/shaders/HudShaderSourcesProvider;", "()V", "FRAGMENT_SHADER_SOURCE", "", "VERTEX_SHADER_SOURCE", "getShaderSource", "shaderType", "Lgraphics/glimpse/shaders/ShaderType;", "hud"})
public final class DefaultHudShaderSourcesProvider
implements HudShaderSourcesProvider {
    @NotNull
    public static final DefaultHudShaderSourcesProvider INSTANCE = new DefaultHudShaderSourcesProvider();
    @NotNull
    private static final String VERTEX_SHADER_SOURCE = "\n        #version 100\n        precision lowp float;\n        uniform highp mat4 uMVPMat;\n        attribute highp vec2 aPos;\n        attribute vec2 aTexCoords;\n        varying vec2 vTexCoords;\n        void main() {\n            vTexCoords = aTexCoords;\n            gl_Position = uMVPMat * vec4(aPos, 0.0, 1.0);\n        }\n    ";
    @NotNull
    private static final String FRAGMENT_SHADER_SOURCE = "\n        #version 100\n        precision lowp float;\n        uniform sampler2D uTex;\n        varying vec2 vTexCoords;\n        void main() {\n            gl_FragColor = texture2D(uTex, vTexCoords);\n        }\n    ";

    private DefaultHudShaderSourcesProvider() {
    }

    @Override
    @NotNull
    public String getShaderSource(@NotNull ShaderType shaderType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)shaderType, (String)"shaderType");
        switch (WhenMappings.$EnumSwitchMapping$0[shaderType.ordinal()]) {
            case 1: {
                string = VERTEX_SHADER_SOURCE;
                break;
            }
            case 2: {
                string = FRAGMENT_SHADER_SOURCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShaderType.values().length];
            try {
                nArray[ShaderType.VERTEX_SHADER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShaderType.FRAGMENT_SHADER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

