/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud.layouts;

import graphics.glimpse.hud.BaseHudElement;
import graphics.glimpse.hud.BoundingBox;
import graphics.glimpse.hud.HudAtom;
import graphics.glimpse.hud.HudElement;
import graphics.glimpse.hud.layouts.HudLayout;
import graphics.glimpse.textures.Texture;
import graphics.glimpse.types.Mat;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.TransformationMat4Kt;
import graphics.glimpse.types.Vec2;
import graphics.glimpse.types.Vec3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001)B\u0015\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J \u0010 \u001a\u00020!2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020\u001eH\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006*"}, d2={"Lgraphics/glimpse/hud/layouts/BaseHudLayout;", "Lgraphics/glimpse/hud/BaseHudElement;", "Lgraphics/glimpse/hud/layouts/HudLayout;", "position", "Lgraphics/glimpse/types/Vec2;", "", "(Lgraphics/glimpse/types/Vec2;)V", "atoms", "", "Lgraphics/glimpse/hud/HudAtom;", "getAtoms", "()Ljava/lang/Iterable;", "<set-?>", "Lgraphics/glimpse/hud/BoundingBox;", "boundingBox", "getBoundingBox", "()Lgraphics/glimpse/hud/BoundingBox;", "setBoundingBox", "(Lgraphics/glimpse/hud/BoundingBox;)V", "elements", "", "Lgraphics/glimpse/hud/HudElement;", "getElements", "()Ljava/util/List;", "height", "getHeight", "()F", "width", "getWidth", "addElement", "", "element", "handleInputEvent", "", "event", "", "layoutElements", "removeElement", "removeElementAt", "index", "", "LayoutAtom", "hud"})
@SourceDebugExtension(value={"SMAP\nBaseHudLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseHudLayout.kt\ngraphics/glimpse/hud/layouts/BaseHudLayout\n+ 2 Vec2.kt\ngraphics/glimpse/types/Vec2$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n235#2:124\n766#3:125\n857#3,2:126\n1360#3:128\n1446#3,2:129\n1549#3:131\n1620#3,3:132\n1448#3,3:135\n*S KotlinDebug\n*F\n+ 1 BaseHudLayout.kt\ngraphics/glimpse/hud/layouts/BaseHudLayout\n*L\n35#1:124\n61#1:125\n61#1:126,2\n62#1:128\n62#1:129,2\n62#1:131\n62#1:132,3\n62#1:135,3\n*E\n"})
public abstract class BaseHudLayout
extends BaseHudElement
implements HudLayout {
    @NotNull
    private final List<HudElement> elements;
    @NotNull
    private BoundingBox boundingBox;

    public BaseHudLayout(@NotNull Vec2<Float> position) {
        Intrinsics.checkNotNullParameter(position, (String)"position");
        super(position);
        this.elements = new ArrayList();
        this.boundingBox = new BoundingBox(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public /* synthetic */ BaseHudLayout(Vec2 vec2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Vec2.Companion this_$iv = Vec2.Companion;
            boolean $i$f$nullVector = false;
            vec2 = this_$iv.nullVector(Reflection.getOrCreateKotlinClass(Float.class));
        }
        this((Vec2<Float>)vec2);
    }

    @NotNull
    protected final List<HudElement> getElements() {
        return this.elements;
    }

    @Override
    public float getWidth() {
        return this.getBoundingBox().getWidth();
    }

    @Override
    public float getHeight() {
        return this.getBoundingBox().getHeight();
    }

    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    protected void setBoundingBox(@NotNull BoundingBox boundingBox) {
        Intrinsics.checkNotNullParameter((Object)boundingBox, (String)"<set-?>");
        this.boundingBox = boundingBox;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<HudAtom> getAtoms() {
        Iterable iterable;
        if (this.isVisible()) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.elements;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                HudElement p0 = (HudElement)element$iv$iv;
                boolean bl = false;
                if (!p0.isVisible()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                HudElement element = (HudElement)element$iv$iv;
                boolean bl = false;
                Iterable<HudAtom> $this$map$iv = element.getAtoms();
                boolean $i$f$map = false;
                Iterable<HudAtom> iterable3 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void atom;
                    HudAtom hudAtom = (HudAtom)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(new LayoutAtom((HudAtom)atom));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    @Override
    public void addElement(@NotNull HudElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ((Collection)this.elements).add(element);
        this.layoutElements();
    }

    @Override
    public void removeElement(@NotNull HudElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ((Collection)this.elements).remove(element);
        this.layoutElements();
    }

    @Override
    public void removeElementAt(int index) {
        this.elements.remove(index);
        this.layoutElements();
    }

    @Override
    public void layoutElements() {
        for (HudElement element : this.elements) {
            HudLayout hudLayout = element instanceof HudLayout ? (HudLayout)element : null;
            if (hudLayout == null) continue;
            hudLayout.layoutElements();
        }
    }

    @Override
    public boolean handleInputEvent(@NotNull Vec2<Float> position, @Nullable Object event) {
        Intrinsics.checkNotNullParameter(position, (String)"position");
        if (super.handleInputEvent(position, event)) {
            return true;
        }
        Vec2 relativePosition = position.minus(this.getPosition());
        for (HudElement element : CollectionsKt.reversed((Iterable)this.elements)) {
            if (!element.getBoundingBox().contains((Vec2<Float>)relativePosition.minus(element.getPosition())) || !element.handleInputEvent((Vec2<Float>)relativePosition, event)) continue;
            return true;
        }
        return false;
    }

    public BaseHudLayout() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lgraphics/glimpse/hud/layouts/BaseHudLayout$LayoutAtom;", "Lgraphics/glimpse/hud/HudAtom;", "atom", "(Lgraphics/glimpse/hud/layouts/BaseHudLayout;Lgraphics/glimpse/hud/HudAtom;)V", "intrinsicHeight", "", "getIntrinsicHeight", "()F", "intrinsicWidth", "getIntrinsicWidth", "modelMatrix", "Lgraphics/glimpse/types/Mat4;", "getModelMatrix", "()Lgraphics/glimpse/types/Mat4;", "texture", "Lgraphics/glimpse/textures/Texture;", "getTexture", "()Lgraphics/glimpse/textures/Texture;", "hud"})
    private final class LayoutAtom
    implements HudAtom {
        @NotNull
        private final HudAtom atom;

        public LayoutAtom(HudAtom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            this.atom = atom;
        }

        @Override
        public float getIntrinsicHeight() {
            return this.atom.getIntrinsicHeight();
        }

        @Override
        public float getIntrinsicWidth() {
            return this.atom.getIntrinsicWidth();
        }

        @Override
        @NotNull
        public Texture getTexture() {
            return this.atom.getTexture();
        }

        @Override
        @NotNull
        public Mat4<Float> getModelMatrix() {
            return (Mat4)TransformationMat4Kt.translation((Vec3)Vec2.toVec3$default(BaseHudLayout.this.getPosition(), null, (int)1, null)).times((Mat)this.atom.getModelMatrix());
        }
    }
}

