/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud.text;

import com.jogamp.opengl.GLProfile;
import graphics.glimpse.hud.text.Font;
import graphics.glimpse.logging.GlimpseLogger;
import graphics.glimpse.textures.BufferedImageProvider;
import graphics.glimpse.textures.TextureImageSource;
import graphics.glimpse.types.Vec4;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\bJ\u001a\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u001c\u001a\u00020\b2\b\b\u0002\u0010\u001d\u001a\u00020\bJ.\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u001e\u001a\u00020\b2\b\b\u0002\u0010\u001f\u001a\u00020\b2\b\b\u0002\u0010 \u001a\u00020\b2\b\b\u0002\u0010!\u001a\u00020\bJ\u001a\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lgraphics/glimpse/hud/text/TextTextureImageSourceBuilder;", "", "()V", "color", "Lgraphics/glimpse/types/Vec4;", "font", "Lgraphics/glimpse/hud/text/Font;", "height", "", "logger", "Lgraphics/glimpse/logging/GlimpseLogger;", "paddingBottom", "paddingLeft", "paddingRight", "paddingTop", "text", "", "width", "build", "Lgraphics/glimpse/textures/TextureImageSource;", "buildPrepared", "profile", "Lcom/jogamp/opengl/GLProfile;", "fromText", "withColor", "withFont", "withPadding", "all", "horizontal", "vertical", "left", "top", "right", "bottom", "withSize", "TextBufferedImageProvider", "hud"})
public final class TextTextureImageSourceBuilder {
    @NotNull
    private final GlimpseLogger logger = GlimpseLogger.Companion.create((Object)this);
    @NotNull
    private String text = "";
    @NotNull
    private Font font = Font.Companion.getDEFAULT();
    @NotNull
    private Vec4 color = new Vec4(1.0f, 1.0f, 1.0f, 1.0f);
    private int paddingLeft;
    private int paddingRight;
    private int paddingTop;
    private int paddingBottom;
    private int width;
    private int height;

    @NotNull
    public final TextTextureImageSourceBuilder fromText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.text = text2;
        return this;
    }

    @NotNull
    public final TextTextureImageSourceBuilder withFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.font = font;
        return this;
    }

    @NotNull
    public final TextTextureImageSourceBuilder withColor(@NotNull Vec4 color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.color = color;
        return this;
    }

    @NotNull
    public final TextTextureImageSourceBuilder withPadding(int all) {
        return this.withPadding(all, all, all, all);
    }

    @NotNull
    public final TextTextureImageSourceBuilder withPadding(int horizontal, int vertical) {
        return this.withPadding(horizontal, vertical, horizontal, vertical);
    }

    public static /* synthetic */ TextTextureImageSourceBuilder withPadding$default(TextTextureImageSourceBuilder textTextureImageSourceBuilder, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return textTextureImageSourceBuilder.withPadding(n, n2);
    }

    @NotNull
    public final TextTextureImageSourceBuilder withPadding(int left, int top, int right, int bottom) {
        this.paddingLeft = left;
        this.paddingRight = right;
        this.paddingTop = top;
        this.paddingBottom = bottom;
        return this;
    }

    public static /* synthetic */ TextTextureImageSourceBuilder withPadding$default(TextTextureImageSourceBuilder textTextureImageSourceBuilder, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            n2 = 0;
        }
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return textTextureImageSourceBuilder.withPadding(n, n2, n3, n4);
    }

    @NotNull
    public final TextTextureImageSourceBuilder withSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public static /* synthetic */ TextTextureImageSourceBuilder withSize$default(TextTextureImageSourceBuilder textTextureImageSourceBuilder, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return textTextureImageSourceBuilder.withSize(n, n2);
    }

    @NotNull
    public final TextureImageSource build() {
        return TextureImageSource.Companion.builder().fromBufferedImage((BufferedImageProvider)new TextBufferedImageProvider()).build();
    }

    @NotNull
    public final TextureImageSource buildPrepared(@NotNull GLProfile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return TextureImageSource.Companion.builder().fromBufferedImage((BufferedImageProvider)new TextBufferedImageProvider()).buildPrepared(profile);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgraphics/glimpse/hud/text/TextTextureImageSourceBuilder$TextBufferedImageProvider;", "Lgraphics/glimpse/textures/BufferedImageProvider;", "(Lgraphics/glimpse/hud/text/TextTextureImageSourceBuilder;)V", "calculateTextBounds", "Ljava/awt/Rectangle;", "createBufferedImage", "Ljava/awt/image/BufferedImage;", "hud"})
    private final class TextBufferedImageProvider
    implements BufferedImageProvider {
        @NotNull
        public BufferedImage createBufferedImage() {
            Rectangle textBounds = this.calculateTextBounds();
            int imageWidth = TextTextureImageSourceBuilder.this.width > 0 ? TextTextureImageSourceBuilder.this.width : textBounds.width + TextTextureImageSourceBuilder.this.paddingLeft + TextTextureImageSourceBuilder.this.paddingRight;
            int imageHeight = TextTextureImageSourceBuilder.this.height > 0 ? TextTextureImageSourceBuilder.this.height : textBounds.height + TextTextureImageSourceBuilder.this.paddingTop + TextTextureImageSourceBuilder.this.paddingBottom;
            int textAreaWidth = imageWidth - TextTextureImageSourceBuilder.this.paddingLeft - TextTextureImageSourceBuilder.this.paddingRight;
            int textAreaHeight = imageHeight - TextTextureImageSourceBuilder.this.paddingTop - TextTextureImageSourceBuilder.this.paddingBottom;
            TextTextureImageSourceBuilder.this.logger.debug("Creating texture image for text: '" + TextTextureImageSourceBuilder.this.text + "' of size: " + imageWidth + "x" + imageHeight);
            BufferedImage image = new BufferedImage(imageWidth, imageHeight, 6);
            Graphics2D graphics = image.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setFont(TextTextureImageSourceBuilder.this.font.getAwtFont$hud());
            graphics.setColor(new Color(TextTextureImageSourceBuilder.this.color.getR(), TextTextureImageSourceBuilder.this.color.getG(), TextTextureImageSourceBuilder.this.color.getB(), TextTextureImageSourceBuilder.this.color.getA()));
            graphics.drawString(TextTextureImageSourceBuilder.this.text, TextTextureImageSourceBuilder.this.paddingLeft + (textAreaWidth - textBounds.width) / 2, TextTextureImageSourceBuilder.this.paddingTop + (textAreaHeight - textBounds.height) / 2 + graphics.getFontMetrics().getAscent());
            graphics.dispose();
            return image;
        }

        private final Rectangle calculateTextBounds() {
            BufferedImage image = new BufferedImage(1, 1, 10);
            Graphics2D graphics = image.createGraphics();
            graphics.setFont(TextTextureImageSourceBuilder.this.font.getAwtFont$hud());
            Rectangle2D textBounds = graphics.getFontMetrics().getStringBounds(TextTextureImageSourceBuilder.this.text, graphics);
            graphics.dispose();
            return new Rectangle((int)Math.ceil(textBounds.getWidth()), (int)Math.ceil(textBounds.getHeight()));
        }
    }
}

