/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud.layouts;

import graphics.glimpse.hud.BaseHudElement;
import graphics.glimpse.hud.BoundingBox;
import graphics.glimpse.hud.HudAtom;
import graphics.glimpse.hud.HudElement;
import graphics.glimpse.hud.layouts.HudLayout;
import graphics.glimpse.textures.Texture;
import graphics.glimpse.types.Mat;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.TransformationMat4Kt;
import graphics.glimpse.types.Vec2;
import graphics.glimpse.types.Vec3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001)B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\u001a\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020\u001eH\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006*"}, d2={"Lgraphics/glimpse/hud/layouts/BaseHudLayout;", "Lgraphics/glimpse/hud/BaseHudElement;", "Lgraphics/glimpse/hud/layouts/HudLayout;", "position", "Lgraphics/glimpse/types/Vec2;", "(Lgraphics/glimpse/types/Vec2;)V", "atoms", "", "Lgraphics/glimpse/hud/HudAtom;", "getAtoms", "()Ljava/lang/Iterable;", "<set-?>", "Lgraphics/glimpse/hud/BoundingBox;", "boundingBox", "getBoundingBox", "()Lgraphics/glimpse/hud/BoundingBox;", "setBoundingBox", "(Lgraphics/glimpse/hud/BoundingBox;)V", "elements", "", "Lgraphics/glimpse/hud/HudElement;", "getElements", "()Ljava/util/List;", "height", "", "getHeight", "()F", "width", "getWidth", "addElement", "", "element", "handleInputEvent", "", "event", "", "layoutElements", "removeElement", "removeElementAt", "index", "", "LayoutAtom", "hud"})
public abstract class BaseHudLayout
extends BaseHudElement
implements HudLayout {
    @NotNull
    private final List<HudElement> elements;
    @NotNull
    private BoundingBox boundingBox;

    public BaseHudLayout(@NotNull Vec2 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        super(position);
        this.elements = new ArrayList();
        this.boundingBox = new BoundingBox(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public /* synthetic */ BaseHudLayout(Vec2 vec2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            vec2 = Vec2.Companion.getNullVector();
        }
        this(vec2);
    }

    @NotNull
    protected final List<HudElement> getElements() {
        return this.elements;
    }

    @Override
    public float getWidth() {
        return this.getBoundingBox().getWidth();
    }

    @Override
    public float getHeight() {
        return this.getBoundingBox().getHeight();
    }

    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    protected void setBoundingBox(@NotNull BoundingBox boundingBox) {
        Intrinsics.checkNotNullParameter((Object)boundingBox, (String)"<set-?>");
        this.boundingBox = boundingBox;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<HudAtom> getAtoms() {
        Iterable iterable;
        if (this.isVisible()) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.elements;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                HudElement p0 = (HudElement)element$iv$iv;
                boolean bl = false;
                if (!p0.isVisible()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                HudElement element = (HudElement)element$iv$iv;
                boolean bl = false;
                Iterable<HudAtom> $this$map$iv = element.getAtoms();
                boolean $i$f$map = false;
                Iterable<HudAtom> iterable3 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void atom;
                    HudAtom hudAtom = (HudAtom)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(new LayoutAtom((HudAtom)atom));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    @Override
    public void addElement(@NotNull HudElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ((Collection)this.elements).add(element);
        this.layoutElements();
    }

    @Override
    public void removeElement(@NotNull HudElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ((Collection)this.elements).remove(element);
        this.layoutElements();
    }

    @Override
    public void removeElementAt(int index) {
        this.elements.remove(index);
        this.layoutElements();
    }

    @Override
    public void layoutElements() {
        for (HudElement element : this.elements) {
            HudLayout hudLayout = element instanceof HudLayout ? (HudLayout)element : null;
            if (hudLayout == null) continue;
            hudLayout.layoutElements();
        }
    }

    @Override
    public boolean handleInputEvent(@NotNull Vec2 position, @Nullable Object event) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (super.handleInputEvent(position, event)) {
            return true;
        }
        Vec2 relativePosition = position.minus(this.getPosition());
        for (HudElement element : CollectionsKt.reversed((Iterable)this.elements)) {
            if (!element.getBoundingBox().contains(relativePosition.minus(element.getPosition())) || !element.handleInputEvent(relativePosition, event)) continue;
            return true;
        }
        return false;
    }

    public BaseHudLayout() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lgraphics/glimpse/hud/layouts/BaseHudLayout$LayoutAtom;", "Lgraphics/glimpse/hud/HudAtom;", "atom", "(Lgraphics/glimpse/hud/layouts/BaseHudLayout;Lgraphics/glimpse/hud/HudAtom;)V", "intrinsicHeight", "", "getIntrinsicHeight", "()F", "intrinsicWidth", "getIntrinsicWidth", "modelMatrix", "Lgraphics/glimpse/types/Mat4;", "getModelMatrix", "()Lgraphics/glimpse/types/Mat4;", "texture", "Lgraphics/glimpse/textures/Texture;", "getTexture", "()Lgraphics/glimpse/textures/Texture;", "hud"})
    private final class LayoutAtom
    implements HudAtom {
        @NotNull
        private final HudAtom atom;

        public LayoutAtom(HudAtom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            this.atom = atom;
        }

        @Override
        public float getIntrinsicHeight() {
            return this.atom.getIntrinsicHeight();
        }

        @Override
        public float getIntrinsicWidth() {
            return this.atom.getIntrinsicWidth();
        }

        @Override
        @NotNull
        public Texture getTexture() {
            return this.atom.getTexture();
        }

        @Override
        @NotNull
        public Mat4 getModelMatrix() {
            return (Mat4)TransformationMat4Kt.translation((Vec3)Vec2.toVec3$default((Vec2)BaseHudLayout.this.getPosition(), (float)0.0f, (int)1, null)).times((Mat)this.atom.getModelMatrix());
        }
    }
}

