/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud;

import graphics.glimpse.hud.BaseHudElementWrapper;
import graphics.glimpse.hud.BoundingBox;
import graphics.glimpse.hud.HudAtom;
import graphics.glimpse.hud.HudElement;
import graphics.glimpse.textures.Texture;
import graphics.glimpse.types.Angle;
import graphics.glimpse.types.Mat;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.TransformationMat4Kt;
import graphics.glimpse.types.Vec;
import graphics.glimpse.types.Vec2;
import graphics.glimpse.types.Vec3;
import graphics.glimpse.types.Vec4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lgraphics/glimpse/hud/TransformationWrapper;", "Lgraphics/glimpse/hud/BaseHudElementWrapper;", "element", "Lgraphics/glimpse/hud/HudElement;", "translationProvider", "Lkotlin/Function0;", "Lgraphics/glimpse/types/Vec2;", "rotationProvider", "Lgraphics/glimpse/types/Angle;", "scaleProvider", "(Lgraphics/glimpse/hud/HudElement;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "atoms", "", "Lgraphics/glimpse/hud/HudAtom;", "getAtoms", "()Ljava/lang/Iterable;", "boundingBox", "Lgraphics/glimpse/hud/BoundingBox;", "getBoundingBox", "()Lgraphics/glimpse/hud/BoundingBox;", "value", "position", "getPosition", "()Lgraphics/glimpse/types/Vec2;", "setPosition", "(Lgraphics/glimpse/types/Vec2;)V", "transformationMatrix", "Lgraphics/glimpse/types/Mat4;", "getTransformationMatrix", "()Lgraphics/glimpse/types/Mat4;", "handleInputEvent", "", "event", "", "TransformationAtom", "hud"})
public final class TransformationWrapper
extends BaseHudElementWrapper {
    @NotNull
    private final Function0<Vec2> translationProvider;
    @NotNull
    private final Function0<Angle> rotationProvider;
    @NotNull
    private final Function0<Vec2> scaleProvider;

    public TransformationWrapper(@NotNull HudElement element, @NotNull Function0<Vec2> translationProvider, @NotNull Function0<Angle> rotationProvider, @NotNull Function0<Vec2> scaleProvider) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(translationProvider, (String)"translationProvider");
        Intrinsics.checkNotNullParameter(rotationProvider, (String)"rotationProvider");
        Intrinsics.checkNotNullParameter(scaleProvider, (String)"scaleProvider");
        super(element);
        this.translationProvider = translationProvider;
        this.rotationProvider = rotationProvider;
        this.scaleProvider = scaleProvider;
    }

    @Override
    @NotNull
    public Vec2 getPosition() {
        return super.getPosition().plus((Vec2)this.translationProvider.invoke());
    }

    @Override
    public void setPosition(@NotNull Vec2 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super.setPosition(value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        float f;
        void $this$mapTo$iv$iv;
        BoundingBox originalBoundingBox = super.getBoundingBox();
        Object[] objectArray = new Vec2[]{new Vec2(originalBoundingBox.getLeft(), originalBoundingBox.getTop()), new Vec2(originalBoundingBox.getLeft(), originalBoundingBox.getBottom()), new Vec2(originalBoundingBox.getRight(), originalBoundingBox.getBottom()), new Vec2(originalBoundingBox.getRight(), originalBoundingBox.getTop())};
        List corners = CollectionsKt.listOf((Object[])objectArray);
        Vec2 scale = (Vec2)this.scaleProvider.invoke();
        Mat4 originSpaceMatrix = (Mat4)TransformationMat4Kt.rotationZ((Angle)((Angle)this.rotationProvider.invoke())).times((Mat)TransformationMat4Kt.scale$default((float)scale.getX(), (float)scale.getY(), (float)0.0f, (int)4, null));
        Iterable $this$map$iv = corners;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void corner;
            Vec2 vec2 = (Vec2)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Vec4)originSpaceMatrix.times((Vec)Vec2.toVec4$default((Vec2)corner, (float)0.0f, (float)1.0f, (int)1, null)));
        }
        List transformedCorners = (List)destination$iv$iv;
        Iterator iterator = ((Iterable)transformedCorners).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p12 = (Vec4)iterator.next();
        boolean bl = false;
        float p12 = p12.getX();
        while (iterator.hasNext()) {
            Vec4 p22 = (Vec4)iterator.next();
            $i$a$-minOf-TransformationWrapper$boundingBox$1 = false;
            float p22 = p22.getX();
            p12 = Math.min(p12, p22);
        }
        Iterable iterable2 = transformedCorners;
        float f2 = p12;
        iterator = iterable2.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p32 = (Vec4)iterator.next();
        boolean bl2 = false;
        float p32 = p32.getX();
        while (iterator.hasNext()) {
            Vec4 p42 = (Vec4)iterator.next();
            $i$a$-maxOf-TransformationWrapper$boundingBox$2 = false;
            float p42 = p42.getX();
            p32 = Math.max(p32, p42);
        }
        float f3 = p32;
        iterable2 = transformedCorners;
        iterator = iterable2.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p52 = (Vec4)iterator.next();
        boolean bl3 = false;
        float p52 = p52.getY();
        while (iterator.hasNext()) {
            Vec4 p62 = (Vec4)iterator.next();
            $i$a$-minOf-TransformationWrapper$boundingBox$3 = false;
            float p62 = p62.getY();
            p52 = Math.min(p52, p62);
        }
        float f4 = p52;
        iterable2 = transformedCorners;
        iterator = iterable2.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p0 = (Vec4)iterator.next();
        boolean bl4 = false;
        float f5 = p0.getY();
        while (iterator.hasNext()) {
            Vec4 p02 = (Vec4)iterator.next();
            $i$a$-maxOf-TransformationWrapper$boundingBox$4 = false;
            float f6 = p02.getY();
            f5 = Math.max(f5, f6);
        }
        float f7 = f = f5;
        float f8 = f4;
        float f9 = f3;
        float f10 = f2;
        return new BoundingBox(f10, f9, f8, f7);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<HudAtom> getAtoms() {
        void $this$mapTo$iv$iv;
        Iterable<HudAtom> $this$map$iv = super.getAtoms();
        boolean $i$f$map = false;
        Iterable<HudAtom> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void atom;
            HudAtom hudAtom = (HudAtom)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TransformationAtom((HudAtom)atom));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Mat4 getTransformationMatrix() {
        Vec2 scale = (Vec2)this.scaleProvider.invoke();
        Object[] objectArray = new Mat4[]{TransformationMat4Kt.translation((Vec3)Vec2.toVec3$default((Vec2)super.getPosition(), (float)0.0f, (int)1, null).plus(Vec2.toVec3$default((Vec2)((Vec2)this.translationProvider.invoke()), (float)0.0f, (int)1, null))), TransformationMat4Kt.rotationZ((Angle)((Angle)this.rotationProvider.invoke())), TransformationMat4Kt.scale$default((float)scale.getX(), (float)scale.getY(), (float)0.0f, (int)4, null), TransformationMat4Kt.translation((Vec3)Vec2.toVec3$default((Vec2)super.getPosition(), (float)0.0f, (int)1, null).unaryMinus())};
        Iterable $this$reduce$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            Mat4 mat4 = (Mat4)iterator$iv.next();
            Mat4 p0 = (Mat4)accumulator$iv;
            boolean bl = false;
            accumulator$iv = (Mat4)p0.times((Mat)p1);
        }
        return (Mat4)accumulator$iv;
    }

    @Override
    public boolean handleInputEvent(@NotNull Vec2 position, @Nullable Object event) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return super.handleInputEvent(((Vec4)((Mat4)this.getTransformationMatrix().inverse()).times((Vec)Vec2.toVec4$default((Vec2)position, (float)0.0f, (float)1.0f, (int)1, null))).toVec2(), event);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lgraphics/glimpse/hud/TransformationWrapper$TransformationAtom;", "Lgraphics/glimpse/hud/HudAtom;", "atom", "(Lgraphics/glimpse/hud/TransformationWrapper;Lgraphics/glimpse/hud/HudAtom;)V", "intrinsicHeight", "", "getIntrinsicHeight", "()F", "intrinsicWidth", "getIntrinsicWidth", "modelMatrix", "Lgraphics/glimpse/types/Mat4;", "getModelMatrix", "()Lgraphics/glimpse/types/Mat4;", "texture", "Lgraphics/glimpse/textures/Texture;", "getTexture", "()Lgraphics/glimpse/textures/Texture;", "hud"})
    private final class TransformationAtom
    implements HudAtom {
        @NotNull
        private final HudAtom atom;

        public TransformationAtom(HudAtom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            this.atom = atom;
        }

        @Override
        public float getIntrinsicHeight() {
            return this.atom.getIntrinsicHeight();
        }

        @Override
        public float getIntrinsicWidth() {
            return this.atom.getIntrinsicWidth();
        }

        @Override
        @NotNull
        public Texture getTexture() {
            return this.atom.getTexture();
        }

        @Override
        @NotNull
        public Mat4 getModelMatrix() {
            return (Mat4)TransformationWrapper.this.getTransformationMatrix().times((Mat)this.atom.getModelMatrix());
        }
    }
}

