/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud;

import graphics.glimpse.hud.BaseHudElement;
import graphics.glimpse.hud.BoundingBox;
import graphics.glimpse.hud.HudAtom;
import graphics.glimpse.textures.Texture;
import graphics.glimpse.types.Angle;
import graphics.glimpse.types.Mat;
import graphics.glimpse.types.Mat4;
import graphics.glimpse.types.TransformationMat4Kt;
import graphics.glimpse.types.Vec;
import graphics.glimpse.types.Vec2;
import graphics.glimpse.types.Vec3;
import graphics.glimpse.types.Vec4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0014\"\u0004\b%\u0010\u0016\u00a8\u0006'"}, d2={"Lgraphics/glimpse/hud/Quad;", "Lgraphics/glimpse/hud/BaseHudElement;", "Lgraphics/glimpse/hud/HudAtom;", "texture", "Lgraphics/glimpse/textures/Texture;", "position", "Lgraphics/glimpse/types/Vec2;", "origin", "(Lgraphics/glimpse/textures/Texture;Lgraphics/glimpse/types/Vec2;Lgraphics/glimpse/types/Vec2;)V", "atoms", "", "getAtoms", "()Ljava/lang/Iterable;", "boundingBox", "Lgraphics/glimpse/hud/BoundingBox;", "getBoundingBox", "()Lgraphics/glimpse/hud/BoundingBox;", "height", "", "getHeight", "()F", "setHeight", "(F)V", "modelMatrix", "Lgraphics/glimpse/types/Mat4;", "getModelMatrix", "()Lgraphics/glimpse/types/Mat4;", "rotation", "Lgraphics/glimpse/types/Angle;", "getRotation", "()Lgraphics/glimpse/types/Angle;", "setRotation", "(Lgraphics/glimpse/types/Angle;)V", "getTexture", "()Lgraphics/glimpse/textures/Texture;", "width", "getWidth", "setWidth", "Companion", "hud"})
public final class Quad
extends BaseHudElement
implements HudAtom {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Texture texture;
    @NotNull
    private final Vec2 origin;
    private float width;
    private float height;
    @NotNull
    private Angle rotation;
    @NotNull
    private static final List<Vec2> corners;

    public Quad(@NotNull Texture texture, @NotNull Vec2 position, @NotNull Vec2 origin) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        super(position);
        this.texture = texture;
        this.origin = origin;
        this.width = this.getIntrinsicWidth();
        this.height = this.getIntrinsicHeight();
        this.rotation = Angle.Companion.getNullAngle();
    }

    public /* synthetic */ Quad(Texture texture, Vec2 vec2, Vec2 vec22, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vec2 = Vec2.Companion.getNullVector();
        }
        if ((n & 4) != 0) {
            vec22 = new Vec2(0.5f, 0.5f);
        }
        this(texture, vec2, vec22);
    }

    @Override
    @NotNull
    public Texture getTexture() {
        return this.texture;
    }

    public final float getWidth() {
        return this.width;
    }

    public final void setWidth(float f) {
        this.width = f;
    }

    public final float getHeight() {
        return this.height;
    }

    public final void setHeight(float f) {
        this.height = f;
    }

    @NotNull
    public final Angle getRotation() {
        return this.rotation;
    }

    public final void setRotation(@NotNull Angle angle) {
        Intrinsics.checkNotNullParameter((Object)angle, (String)"<set-?>");
        this.rotation = angle;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Mat4 getModelMatrix() {
        Object[] objectArray = new Mat4[]{TransformationMat4Kt.translation((Vec3)Vec2.toVec3$default((Vec2)this.getPosition(), (float)0.0f, (int)1, null)), TransformationMat4Kt.rotationZ((Angle)this.rotation), TransformationMat4Kt.scale$default((float)this.width, (float)this.height, (float)0.0f, (int)4, null), TransformationMat4Kt.translation((Vec3)Vec2.toVec3$default((Vec2)this.origin, (float)0.0f, (int)1, null).unaryMinus())};
        Iterable $this$reduce$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            Mat4 mat4 = (Mat4)iterator$iv.next();
            Mat4 p0 = (Mat4)accumulator$iv;
            boolean bl = false;
            accumulator$iv = (Mat4)p0.times((Mat)p1);
        }
        return (Mat4)accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BoundingBox getBoundingBox() {
        float f;
        void $this$mapTo$iv$iv;
        Mat4 originSpaceMatrix = (Mat4)((Mat4)TransformationMat4Kt.rotationZ((Angle)this.rotation).times((Mat)TransformationMat4Kt.scale$default((float)this.width, (float)this.height, (float)0.0f, (int)4, null))).times((Mat)TransformationMat4Kt.translation((Vec3)Vec2.toVec3$default((Vec2)this.origin, (float)0.0f, (int)1, null).unaryMinus()));
        Iterable $this$map$iv = corners;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void corner;
            Vec2 vec2 = (Vec2)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Vec4)originSpaceMatrix.times((Vec)Vec2.toVec4$default((Vec2)corner, (float)0.0f, (float)1.0f, (int)1, null)));
        }
        List transformedCorners = (List)destination$iv$iv;
        Iterator iterator = ((Iterable)transformedCorners).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p12 = (Vec4)iterator.next();
        boolean bl = false;
        float p12 = p12.getX();
        while (iterator.hasNext()) {
            Vec4 p22 = (Vec4)iterator.next();
            $i$a$-minOf-Quad$boundingBox$1 = false;
            float p22 = p22.getX();
            p12 = Math.min(p12, p22);
        }
        Iterable iterable2 = transformedCorners;
        float f2 = p12;
        iterator = iterable2.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p32 = (Vec4)iterator.next();
        boolean bl2 = false;
        float p32 = p32.getX();
        while (iterator.hasNext()) {
            Vec4 p42 = (Vec4)iterator.next();
            $i$a$-maxOf-Quad$boundingBox$2 = false;
            float p42 = p42.getX();
            p32 = Math.max(p32, p42);
        }
        float f3 = p32;
        iterable2 = transformedCorners;
        iterator = iterable2.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p52 = (Vec4)iterator.next();
        boolean bl3 = false;
        float p52 = p52.getY();
        while (iterator.hasNext()) {
            Vec4 p62 = (Vec4)iterator.next();
            $i$a$-minOf-Quad$boundingBox$3 = false;
            float p62 = p62.getY();
            p52 = Math.min(p52, p62);
        }
        float f4 = p52;
        iterable2 = transformedCorners;
        iterator = iterable2.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Vec4 p0 = (Vec4)iterator.next();
        boolean bl4 = false;
        float f5 = p0.getY();
        while (iterator.hasNext()) {
            Vec4 p02 = (Vec4)iterator.next();
            $i$a$-maxOf-Quad$boundingBox$4 = false;
            float f6 = p02.getY();
            f5 = Math.max(f5, f6);
        }
        float f7 = f = f5;
        float f8 = f4;
        float f9 = f3;
        float f10 = f2;
        return new BoundingBox(f10, f9, f8, f7);
    }

    @Override
    @NotNull
    public Iterable<HudAtom> getAtoms() {
        return this.isVisible() ? (Iterable)CollectionsKt.listOf((Object)this) : (Iterable)CollectionsKt.emptyList();
    }

    @Override
    public float getIntrinsicWidth() {
        return HudAtom.DefaultImpls.getIntrinsicWidth(this);
    }

    @Override
    public float getIntrinsicHeight() {
        return HudAtom.DefaultImpls.getIntrinsicHeight(this);
    }

    static {
        Object[] objectArray = new Vec2[]{new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f), new Vec2(1.0f, 0.0f)};
        corners = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgraphics/glimpse/hud/Quad$Companion;", "", "()V", "corners", "", "Lgraphics/glimpse/types/Vec2;", "hud"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

