/*
 * Decompiled with CFR 0.152.
 */
package graphics.glimpse.hud;

import graphics.glimpse.hud.HudElement;
import graphics.glimpse.types.Vec2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u001a\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0004\u00a8\u0006\u0017"}, d2={"Lgraphics/glimpse/hud/BaseHudElement;", "Lgraphics/glimpse/hud/HudElement;", "position", "Lgraphics/glimpse/types/Vec2;", "(Lgraphics/glimpse/types/Vec2;)V", "inputEventListeners", "", "Lgraphics/glimpse/hud/HudElement$InputEventListener;", "isVisible", "", "()Z", "setVisible", "(Z)V", "getPosition", "()Lgraphics/glimpse/types/Vec2;", "setPosition", "addInputEventListener", "", "listener", "handleInputEvent", "event", "", "removeInputEventListener", "hud"})
public abstract class BaseHudElement
implements HudElement {
    @NotNull
    private Vec2 position;
    private boolean isVisible;
    @NotNull
    private final List<HudElement.InputEventListener> inputEventListeners;

    public BaseHudElement(@NotNull Vec2 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.position = position;
        this.isVisible = true;
        this.inputEventListeners = new ArrayList();
    }

    @Override
    @NotNull
    public Vec2 getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@NotNull Vec2 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"<set-?>");
        this.position = vec2;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    @Override
    public void addInputEventListener(@NotNull HudElement.InputEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.inputEventListeners).add(listener);
    }

    @Override
    public void removeInputEventListener(@NotNull HudElement.InputEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.inputEventListeners).remove(listener);
    }

    @Override
    public boolean handleInputEvent(@NotNull Vec2 position, @Nullable Object event) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Vec2 relativePosition = position.minus(this.getPosition());
        for (HudElement.InputEventListener listener : this.inputEventListeners) {
            if (!listener.onInputEvent(relativePosition, event)) continue;
            return true;
        }
        return false;
    }
}

