/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector.weighter.local;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.SparseVectorFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.text.term.vector.weighter.local.AbstractLocalTermWeighter;

@PublicationReference(author={"Wikipedia"}, title="tf-idf", type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/tf-idf", year=2009)
public class TermFrequencyLocalTermWeighter
extends AbstractLocalTermWeighter {
    public TermFrequencyLocalTermWeighter() {
        this((VectorFactory<? extends Vector>)SparseVectorFactory.getDefault());
    }

    public TermFrequencyLocalTermWeighter(VectorFactory<? extends Vector> vectorFactory) {
        super(vectorFactory);
    }

    @Override
    public Vector computeLocalWeights(Vector counts) {
        Vector result = this.vectorFactory.copyVector(counts);
        double countSum = counts.norm1();
        if (countSum != 0.0) {
            result.scaleEquals(1.0 / countSum);
        }
        return result;
    }
}

