/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector;

import gov.sandia.cognition.learning.function.distance.CosineDistanceMetric;
import gov.sandia.cognition.math.matrix.VectorSpace;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.text.relation.SimilarityFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

public class CosineSimilarityFunction
extends AbstractCloneableSerializable
implements SimilarityFunction<Vectorizable, Vectorizable> {
    private static CosineSimilarityFunction INSTANCE;

    public static CosineSimilarityFunction getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CosineSimilarityFunction();
        }
        return INSTANCE;
    }

    @Override
    public double evaluate(Vectorizable from, Vectorizable to) {
        return from.convertToVector().cosine((VectorSpace)to.convertToVector());
    }

    public CosineDistanceMetric asDivergence() {
        return CosineDistanceMetric.INSTANCE;
    }
}

