/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.filter;

import gov.sandia.cognition.text.term.Term;
import gov.sandia.cognition.text.term.TermOccurrence;
import gov.sandia.cognition.text.term.filter.AbstractSingleTermFilter;
import java.util.LinkedHashSet;
import java.util.Set;

public class DictionaryFilter
extends AbstractSingleTermFilter {
    protected Set<Term> allowedTerms;

    public DictionaryFilter() {
        this(new LinkedHashSet<Term>());
    }

    public DictionaryFilter(Set<Term> allowedTerms) {
        this.allowedTerms = allowedTerms;
    }

    @Override
    public TermOccurrence filterTerm(TermOccurrence occurrence) {
        if (this.getAllowedTerms().contains(occurrence.getTerm())) {
            return occurrence;
        }
        return null;
    }

    public Set<Term> getAllowedTerms() {
        return this.allowedTerms;
    }

    public void setAllowedTerms(Set<Term> allowedTerms) {
        this.allowedTerms = allowedTerms;
    }
}

