/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term;

import gov.sandia.cognition.text.term.AbstractTerm;
import gov.sandia.cognition.text.term.Term;
import gov.sandia.cognition.text.term.TermNGram;
import java.util.Arrays;
import java.util.List;

public class DefaultTermNGram
extends AbstractTerm
implements TermNGram {
    protected Term[] terms;

    public DefaultTermNGram() {
        this(new Term[0]);
    }

    public DefaultTermNGram(Term ... terms) {
        this.setTerms(terms);
    }

    public DefaultTermNGram clone() {
        DefaultTermNGram clone = (DefaultTermNGram)super.clone();
        clone.terms = this.terms == null ? null : (Term[])this.terms.clone();
        return clone;
    }

    public String getName() {
        StringBuilder result = new StringBuilder();
        result.append("[" + this.getTermCount() + "-gram:");
        for (int i = 0; i < this.terms.length; ++i) {
            Term term;
            if (i > 0) {
                result.append(",");
            }
            if ((term = this.terms[i]) == null) continue;
            result.append(" ");
            result.append(term.getName());
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public int getTermCount() {
        return this.terms.length;
    }

    @Override
    public Term getTerm(int i) {
        return this.terms[i];
    }

    @Override
    public List<Term> getTermList() {
        return Arrays.asList(this.terms);
    }

    public Term[] getTerms() {
        return this.terms;
    }

    public void setTerms(Term ... terms) {
        this.terms = terms;
    }
}

