/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.document;

import gov.sandia.cognition.text.document.Document;
import gov.sandia.cognition.text.document.DocumentReference;
import gov.sandia.cognition.text.document.Field;
import gov.sandia.cognition.util.AbstractNamed;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;

public class AbstractDocument
extends AbstractNamed
implements Document {
    public static final String TITLE_FIELD_NAME = "title";
    public static final String LAST_MODIFIED_DATE_FIELD_NAME = "lastModifiedDate";
    public static final String ACCESSED_DATE_FIELD_NAME = "accessedDate";
    public static final String AUTHOR_FIELD_NAME = "author";
    public static final String BODY_FIELD_NAME = "body";
    protected DocumentReference reference;
    protected HashMap<String, Field> fieldMap;

    public AbstractDocument() {
        this.setFieldMap(new HashMap<String, Field>());
    }

    protected void addField(Field field) {
        this.getFieldMap().put(field.getName(), field);
    }

    protected void removeField(String fieldName) {
        this.getFieldMap().remove(fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.getFieldMap().containsKey(fieldName);
    }

    @Override
    public Field getField(String fieldName) {
        return this.getFieldMap().get(fieldName);
    }

    @Override
    public DocumentReference getReference() {
        return this.reference;
    }

    protected void setReference(DocumentReference reference) {
        this.reference = reference;
    }

    @Override
    public URI getReferenceURI() {
        if (this.getReference() == null) {
            return null;
        }
        return this.getReference().toURI();
    }

    @Override
    public Collection<Field> getFields() {
        return this.getFieldMap().values();
    }

    @Override
    public Field getTitleField() {
        return this.getField(TITLE_FIELD_NAME);
    }

    @Override
    public Field getLastModifiedDateField() {
        return this.getField(LAST_MODIFIED_DATE_FIELD_NAME);
    }

    @Override
    public Field getAccessedDateField() {
        return this.getField(ACCESSED_DATE_FIELD_NAME);
    }

    @Override
    public Field getAuthorField() {
        return this.getField(AUTHOR_FIELD_NAME);
    }

    @Override
    public Field getBodyField() {
        return this.getField(BODY_FIELD_NAME);
    }

    protected HashMap<String, Field> getFieldMap() {
        return this.fieldMap;
    }

    protected void setFieldMap(HashMap<String, Field> fieldMap) {
        this.fieldMap = fieldMap;
    }
}

