/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.algorithm;

import gov.sandia.cognition.learning.algorithm.minimization.matrix.ConjugateGradientMatrixSolver;
import gov.sandia.cognition.learning.algorithm.minimization.matrix.MatrixVectorMultiplier;
import gov.sandia.cognition.learning.algorithm.semisupervised.valence.MultipartiteValenceMatrix;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ValenceSpreader<TermType extends Comparable<TermType>, DocIdType extends Comparable<DocIdType>> {
    private Map<TermType, Pair<Double, Double>> weightedTerms = new HashMap<TermType, Pair<Double, Double>>();
    private Map<DocIdType, Pair<Double, Double>> weightedDocuments = new HashMap<DocIdType, Pair<Double, Double>>();
    private Map<DocIdType, Map<TermType, Double>> documents = new HashMap<DocIdType, Map<TermType, Double>>();
    private double tolerance = 1.0E-5;
    private int numThreads = 2;

    public void setNumThreads(int numThreads) {
        if (numThreads <= 0) {
            throw new IllegalArgumentException("Unable to set the number of threads to less than 1");
        }
        this.numThreads = numThreads;
    }

    public void setIterativeSolverTolerance(double tolerance) {
        if (tolerance <= 0.0) {
            throw new IllegalArgumentException("Unable to set the tolerance to a value less than or equal to zero.");
        }
        this.tolerance = tolerance;
    }

    public void addWeightedTerm(TermType term, double score) {
        this.addWeightedTerm(term, score, 1.0);
    }

    public void addWeightedTerm(TermType term, double score, double trust) {
        if (trust <= 0.0) {
            throw new IllegalArgumentException("Trust must be greater than 0.  Input: " + trust);
        }
        this.weightedTerms.put(term, (Pair<Double, Double>)new DefaultInputOutputPair((Object)score, (Object)trust));
    }

    public void addWeightedDocument(DocIdType documentId, double score) {
        this.addWeightedDocument(documentId, score, 1.0);
    }

    public void addWeightedDocument(DocIdType documentId, double score, double trust) {
        if (trust <= 0.0) {
            throw new IllegalArgumentException("Trust must be greater than 0.  Input: " + trust);
        }
        this.weightedDocuments.put(documentId, (Pair<Double, Double>)new DefaultInputOutputPair((Object)score, (Object)trust));
    }

    public void addDocumentTermOccurrences(DocIdType documentId, Set<TermType> terms) {
        HashMap<Comparable, Double> document = new HashMap<Comparable, Double>(terms.size());
        for (Comparable term : terms) {
            document.put(term, 1.0);
        }
        this.documents.put(documentId, document);
    }

    public void addDocumentTermWeights(DocIdType documentId, Map<TermType, Double> terms) {
        this.documents.put(documentId, new HashMap<TermType, Double>(terms));
    }

    private static <Type> void centerMap(Map<Type, Pair<Double, Double>> m) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (Pair<Double, Double> p : m.values()) {
            min = Math.min((Double)p.getFirst(), min);
            max = Math.max((Double)p.getFirst(), max);
        }
        double mult = 2.0 / (max - min);
        Set<Map.Entry<Type, Pair<Double, Double>>> entries = m.entrySet();
        for (Map.Entry<Type, Pair<Double, Double>> e : entries) {
            m.put(e.getKey(), (Pair<Double, Double>)new DefaultInputOutputPair((Object)(((Double)e.getValue().getFirst() - min) * mult - 1.0), e.getValue().getSecond()));
        }
    }

    public void centerWeightsRange() {
        ValenceSpreader.centerMap(this.weightedTerms);
        ValenceSpreader.centerMap(this.weightedDocuments);
    }

    public Result<TermType, DocIdType> spreadValence() {
        return this.spreadValence(10);
    }

    public Result<TermType, DocIdType> spreadValence(int power) {
        int i;
        Integer idx;
        if (power <= 0) {
            throw new IllegalArgumentException("Unable to work with non-positive power: " + power);
        }
        int numDocs = this.documents.size();
        HashSet<TermType> allTerms = new HashSet<TermType>();
        for (Map<TermType, Double> document : this.documents.values()) {
            allTerms.addAll(document.keySet());
        }
        int numTerms = allTerms.size();
        ArrayList orderedTerms = new ArrayList(allTerms);
        Collections.sort(orderedTerms);
        HashMap reverseLookupTerms = new HashMap(numTerms);
        for (int i2 = 0; i2 < numTerms; ++i2) {
            reverseLookupTerms.put(orderedTerms.get(i2), i2);
        }
        ArrayList<DocIdType> orderedDocumentIds = new ArrayList<DocIdType>(this.documents.keySet());
        Collections.sort(orderedDocumentIds);
        HashMap reverseLookupDocuments = new HashMap(numDocs);
        for (int i3 = 0; i3 < numDocs; ++i3) {
            reverseLookupDocuments.put(orderedDocumentIds.get(i3), i3);
        }
        ArrayList<Integer> sizes = new ArrayList<Integer>(2);
        sizes.add(numTerms);
        sizes.add(numDocs);
        MultipartiteValenceMatrix mvm = new MultipartiteValenceMatrix(sizes, power, this.numThreads);
        for (int i4 = 0; i4 < numDocs; ++i4) {
            for (Map.Entry<TermType, Double> term : this.documents.get(orderedDocumentIds.get(i4)).entrySet()) {
                mvm.addRelationship(0, ((Integer)reverseLookupTerms.get(term.getKey())).intValue(), 1, i4, term.getValue().doubleValue());
            }
        }
        for (Map.Entry<TermType, Pair<Double, Double>> entry : this.weightedTerms.entrySet()) {
            idx = (Integer)reverseLookupTerms.get(entry.getKey());
            if (idx == null) continue;
            mvm.setElementsScore(0, idx.intValue(), ((Double)entry.getValue().getSecond()).doubleValue(), ((Double)entry.getValue().getFirst()).doubleValue());
        }
        for (Map.Entry<Object, Pair<Double, Double>> entry : this.weightedDocuments.entrySet()) {
            idx = (Integer)reverseLookupDocuments.get(entry.getKey());
            mvm.setElementsScore(1, idx.intValue(), ((Double)entry.getValue().getSecond()).doubleValue(), ((Double)entry.getValue().getFirst()).doubleValue());
        }
        Vector rhs = mvm.init();
        ConjugateGradientMatrixSolver conjugateGradientMatrixSolver = new ConjugateGradientMatrixSolver(rhs, rhs, this.tolerance);
        Vector result = (Vector)conjugateGradientMatrixSolver.learn((MatrixVectorMultiplier)mvm).getOutput();
        Result r = new Result();
        r.termWeights = new HashMap(numTerms);
        r.documentWeights = new HashMap(numDocs);
        for (i = 0; i < numTerms; ++i) {
            r.termWeights.put(orderedTerms.get(i), result.getElement(i));
        }
        for (i = 0; i < numDocs; ++i) {
            r.documentWeights.put(orderedDocumentIds.get(i), result.getElement(numTerms + i));
        }
        return r;
    }

    public static class Result<TermType, DocIdType> {
        public Map<TermType, Double> termWeights;
        public Map<DocIdType, Double> documentWeights;
    }
}

