/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.topic;

import gov.sandia.cognition.algorithm.ParallelAlgorithm;
import gov.sandia.cognition.algorithm.ParallelUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.text.topic.LatentDirichletAllocationVectorGibbsSampler;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;

public class ParallelLatentDirichletAllocationVectorGibbsSampler
extends LatentDirichletAllocationVectorGibbsSampler
implements ParallelAlgorithm {
    private transient ThreadPoolExecutor threadPool;

    public ParallelLatentDirichletAllocationVectorGibbsSampler() {
    }

    public ParallelLatentDirichletAllocationVectorGibbsSampler(int topicCount, double alpha, double beta, int maxIterations, int burnInIterations, int iterationsPerSample, Random random) {
        super(topicCount, alpha, beta, maxIterations, burnInIterations, iterationsPerSample, random);
    }

    @Override
    protected boolean step() {
        int document = 0;
        int occurrence = 0;
        ArrayList<DocumentSampleTask> samplingTaskList = new ArrayList<DocumentSampleTask>(this.documentCount);
        for (Vectorizable m : (Collection)this.data) {
            Vector av = m.convertToVector();
            samplingTaskList.add(new DocumentSampleTask(av, document, occurrence));
            ++document;
            occurrence = (int)((double)occurrence + av.norm1());
        }
        try {
            ParallelUtil.executeInParallel(samplingTaskList, (ThreadPoolExecutor)this.getThreadPool());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (this.iteration >= this.burnInIterations && (this.iteration - this.burnInIterations) % this.iterationsPerSample == 0) {
            this.readParameters();
        }
        return true;
    }

    @Override
    protected void cleanupAlgorithm() {
        this.getThreadPool().shutdown();
        super.cleanupAlgorithm();
    }

    public ThreadPoolExecutor getThreadPool() {
        if (this.threadPool == null) {
            this.setThreadPool(ParallelUtil.createThreadPool());
        }
        return this.threadPool;
    }

    public void setThreadPool(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
    }

    public int getNumThreads() {
        return ParallelUtil.getNumThreads((ParallelAlgorithm)this);
    }

    protected class DocumentSampleTask
    extends AbstractCloneableSerializable
    implements Callable<Boolean> {
        Vector vector;
        int document;
        int occurrence;

        public DocumentSampleTask(Vector v, int doc, int occ) {
            this.vector = v;
            this.document = doc;
            this.occurrence = occ;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public Boolean call() throws Exception {
            double[] topicCumulativeProportions = new double[ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicCount];
            Iterator iterator = this.vector.iterator();
            block8: while (iterator.hasNext()) {
                VectorEntry v = (VectorEntry)iterator.next();
                int term = v.getIndex();
                int count = (int)v.getValue();
                int i = 1;
                while (true) {
                    int newTopic;
                    if (i > count) continue block8;
                    int oldTopic = ParallelLatentDirichletAllocationVectorGibbsSampler.this.occurrenceTopicAssignments[this.occurrence];
                    int[] nArray = ParallelLatentDirichletAllocationVectorGibbsSampler.this.documentTopicCount[this.document];
                    int n = oldTopic;
                    nArray[n] = nArray[n] - 1;
                    int n2 = this.document;
                    ParallelLatentDirichletAllocationVectorGibbsSampler.this.documentTopicSum[n2] = ParallelLatentDirichletAllocationVectorGibbsSampler.this.documentTopicSum[n2] - 1;
                    Object object = ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermCount;
                    // MONITORENTER : ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermCount
                    int[] nArray2 = ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermCount[oldTopic];
                    int n3 = term;
                    nArray2[n3] = nArray2[n3] - 1;
                    // MONITOREXIT : object
                    object = ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermSum;
                    // MONITORENTER : ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermSum
                    int n4 = oldTopic;
                    ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermSum[n4] = ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermSum[n4] - 1;
                    // MONITOREXIT : object
                    ParallelLatentDirichletAllocationVectorGibbsSampler.this.occurrenceTopicAssignments[this.occurrence] = newTopic = ParallelLatentDirichletAllocationVectorGibbsSampler.this.sampleTopic(this.document, term, topicCumulativeProportions);
                    int[] nArray3 = ParallelLatentDirichletAllocationVectorGibbsSampler.this.documentTopicCount[this.document];
                    int n5 = newTopic;
                    nArray3[n5] = nArray3[n5] + 1;
                    int n6 = this.document;
                    ParallelLatentDirichletAllocationVectorGibbsSampler.this.documentTopicSum[n6] = ParallelLatentDirichletAllocationVectorGibbsSampler.this.documentTopicSum[n6] + 1;
                    Object object2 = ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermCount;
                    // MONITORENTER : ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermCount
                    int[] nArray4 = ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermCount[newTopic];
                    int n7 = term;
                    nArray4[n7] = nArray4[n7] + 1;
                    // MONITOREXIT : object2
                    object2 = ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermSum;
                    // MONITORENTER : ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermSum
                    int n8 = newTopic;
                    ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermSum[n8] = ParallelLatentDirichletAllocationVectorGibbsSampler.this.topicTermSum[n8] + 1;
                    // MONITOREXIT : object2
                    ++this.occurrence;
                    ++i;
                }
                break;
            }
            return true;
        }
    }
}

