/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector.weighter.local;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.SparseVectorFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.text.term.vector.weighter.local.LogLocalTermWeighter;

@PublicationReference(author={"Erica Chisholm", "Tamara G. Kolda"}, title="New Term Weighting Formulas for the Vector Space Method in Information Retrieval", type=PublicationType.TechnicalReport, url="http://citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.40.3899", year=1999, notes={"We use a slight modification of the formula for normalizing in this paper."})
public class NormalizedLogLocalTermWeighter
extends LogLocalTermWeighter {
    public NormalizedLogLocalTermWeighter() {
        this((VectorFactory<? extends Vector>)SparseVectorFactory.getDefault());
    }

    public NormalizedLogLocalTermWeighter(VectorFactory<? extends Vector> vectorFactory) {
        super(vectorFactory);
    }

    @Override
    public Vector computeLocalWeights(Vector counts) {
        Vector result = super.computeLocalWeights(counts);
        int dimensionality = result.getDimensionality();
        if (dimensionality != 0) {
            double average = counts.norm1() / (double)dimensionality;
            double divisor = Math.log(1.0 + average);
            result.scaleEquals(1.0 / divisor);
        }
        return result;
    }
}

