/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term;

import gov.sandia.cognition.text.term.Term;
import gov.sandia.cognition.text.term.TermCounts;
import gov.sandia.cognition.text.term.Termable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.HashMap;
import java.util.Set;

public class DefaultTermCounts
extends AbstractCloneableSerializable
implements TermCounts {
    protected int totalCount;
    protected HashMap<Term, Integer> termToCountMap;

    public DefaultTermCounts() {
        this.setTotalCount(0);
        this.setTermToCountMap(new HashMap<Term, Integer>());
    }

    public void add(Termable term) {
        this.add(term.asTerm(), 1);
    }

    public void add(Term term, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be non-negative");
        }
        if (count == 0) {
            return;
        }
        int current = this.getCount(term);
        this.termToCountMap.put(term, current += count);
        this.totalCount += count;
    }

    public void addAll(Iterable<? extends Termable> terms) {
        for (Termable termable : terms) {
            this.add(termable);
        }
    }

    @Override
    public int getCount(Term term) {
        Integer result = this.termToCountMap.get(term);
        if (result == null) {
            return 0;
        }
        return result;
    }

    @Override
    public Set<Term> getTerms() {
        return this.termToCountMap.keySet();
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    protected void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    protected HashMap<Term, Integer> getTermToCountMap() {
        return this.termToCountMap;
    }

    protected void setTermToCountMap(HashMap<Term, Integer> termToCountMap) {
        this.termToCountMap = termToCountMap;
    }
}

