/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.spelling;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.AbstractBatchAndIncrementalLearner;
import gov.sandia.cognition.statistics.distribution.DefaultDataDistribution;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@PublicationReference(author={"Peter Norvig"}, title="How to Write a Spelling Corrector", year=2009, type=PublicationType.WebPage, url="http://norvig.com/spell-correct.html")
public class SimpleStatisticalSpellingCorrector
extends AbstractCloneableSerializable
implements Evaluator<String, String> {
    protected DefaultDataDistribution<String> wordCounts;
    protected char[] alphabet;

    public static char[] createDefaultAlphabet() {
        return "abcdefghijklmnopqrstuvwxyz".toCharArray();
    }

    public SimpleStatisticalSpellingCorrector() {
        this(SimpleStatisticalSpellingCorrector.createDefaultAlphabet());
    }

    public SimpleStatisticalSpellingCorrector(char[] alphabet) {
        this((DefaultDataDistribution<String>)new DefaultDataDistribution(), alphabet);
    }

    public SimpleStatisticalSpellingCorrector(DefaultDataDistribution<String> wordCounts, char[] alphabet) {
        this.setWordCounts(wordCounts);
        this.setAlphabet(alphabet);
    }

    public void add(String word) {
        this.wordCounts.increment((Object)word.toLowerCase());
    }

    public void add(String word, int count) {
        this.wordCounts.increment((Object)word, (double)count);
    }

    public String evaluate(String word) {
        if (word == null) {
            return null;
        }
        String input = word.toLowerCase();
        if (input.isEmpty() || this.wordCounts.get((Object)input) > 0.0) {
            return input;
        }
        HashSet<String> oneCharacterEdits = new HashSet<String>();
        this.possibleOneCharacterEdits(input, oneCharacterEdits);
        String result = this.findBest(oneCharacterEdits, null);
        if (result != null) {
            return result;
        }
        Set<String> twoCharacterEdits = this.knownTwoCharacterEdits(oneCharacterEdits);
        result = this.findBest(twoCharacterEdits, input);
        return result;
    }

    public String findBest(Iterable<String> words, String defaultBestWord) {
        String bestWord = defaultBestWord;
        double bestCount = 0.0;
        for (String word : words) {
            double count = this.wordCounts.get((Object)word);
            if (!(count > bestCount)) continue;
            bestWord = word;
            bestCount = count;
        }
        return bestWord;
    }

    protected void possibleOneCharacterEdits(String word, Collection<String> result) {
        int i;
        int wordLength = word.length();
        char[] characters = word.toCharArray();
        String[] prefixes = new String[wordLength + 1];
        String[] suffixes = new String[wordLength + 1];
        for (i = 0; i < wordLength; ++i) {
            prefixes[i] = word.substring(0, i);
            suffixes[i] = word.substring(i);
        }
        prefixes[wordLength] = word;
        suffixes[wordLength] = "";
        for (i = 0; i < wordLength; ++i) {
            result.add(prefixes[i] + suffixes[i + 1]);
        }
        for (i = 0; i < wordLength - 1; ++i) {
            result.add(prefixes[i] + characters[i + 1] + characters[i] + suffixes[i + 2]);
        }
        for (i = 0; i < wordLength; ++i) {
            for (char c : this.alphabet) {
                result.add(prefixes[i] + c + suffixes[i + 1]);
            }
        }
        for (i = 0; i <= wordLength; ++i) {
            for (char c : this.alphabet) {
                result.add(prefixes[i] + c + suffixes[i]);
            }
        }
    }

    protected Set<String> knownTwoCharacterEdits(Iterable<String> oneCharacterEdits) {
        HashSet<String> result = new HashSet<String>();
        HashSet<String> possible = new HashSet<String>();
        for (String word : oneCharacterEdits) {
            possible.clear();
            this.possibleOneCharacterEdits(word, possible);
            for (String editedWord : possible) {
                if (!(this.wordCounts.get((Object)editedWord) > 0.0)) continue;
                result.add(editedWord);
            }
        }
        return result;
    }

    public DefaultDataDistribution<String> getWordCounts() {
        return this.wordCounts;
    }

    public void setWordCounts(DefaultDataDistribution<String> wordCounts) {
        this.wordCounts = wordCounts;
    }

    public char[] getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabet(char[] alphabet) {
        this.alphabet = alphabet;
    }

    public static class Learner
    extends AbstractBatchAndIncrementalLearner<String, SimpleStatisticalSpellingCorrector> {
        protected char[] alphabet;

        public Learner() {
            this(SimpleStatisticalSpellingCorrector.createDefaultAlphabet());
        }

        public Learner(char[] alphabet) {
            this.setAlphabet(alphabet);
        }

        public SimpleStatisticalSpellingCorrector createInitialLearnedObject() {
            return new SimpleStatisticalSpellingCorrector(this.getAlphabet());
        }

        public void update(SimpleStatisticalSpellingCorrector target, String word) {
            target.add(word);
        }

        public char[] getAlphabet() {
            return this.alphabet;
        }

        public void setAlphabet(char[] alphabet) {
            this.alphabet = alphabet;
        }
    }
}

