/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.evaluation;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.text.evaluation.PrecisionRecallPair;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

@PublicationReference(author={"Wikipedia"}, title="Precision and Recall", type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/Precision_and_recall", year=2009)
public class DefaultPrecisionRecallPair
extends AbstractCloneableSerializable
implements PrecisionRecallPair {
    public static final double DEFAULT_PRECISION = 0.0;
    public static final double DEFAULT_RECALL = 0.0;
    private double precision;
    private double recall;

    public DefaultPrecisionRecallPair() {
        this(0.0, 0.0);
    }

    public DefaultPrecisionRecallPair(double precision, double recall) {
        this.setPrecision(precision);
        this.setRecall(recall);
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        if (precision < 0.0 || precision > 1.0) {
            throw new IllegalArgumentException("precision must be between 0.0 and 1.0, inclusive.");
        }
        this.precision = precision;
    }

    @Override
    public double getRecall() {
        return this.recall;
    }

    public void setRecall(double recall) {
        if (recall < 0.0 || recall > 1.0) {
            throw new IllegalArgumentException("recall must be between 0.0 and 1.0, inclusive.");
        }
        this.recall = recall;
    }

    public Double getFirst() {
        return this.getPrecision();
    }

    public Double getSecond() {
        return this.getRecall();
    }

    public String toString() {
        return "[precision = " + this.getPrecision() + ", recall = " + this.getRecall() + "]";
    }
}

