/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector.weighter.global;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.math.matrix.SparseVectorFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorUtil;
import gov.sandia.cognition.text.term.vector.weighter.global.AbstractEntropyBasedGlobalTermWeighter;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReference(author={"Susan T. Dumais"}, title="Improving the retrieval of information from external sources", year=1991, type=PublicationType.Journal, publication="Behavior Research Methods, Instruments, and Computers", pages={229, 236}, url="http://www.google.com/url?sa=t&source=web&ct=res&cd=1&url=http%3A%2F%2Fwww.psychonomic.org%2Fsearch%2Fview.cgi%3Fid%3D5145&ei=o7joSdGEHY-itgPLre3tAQ&usg=AFQjCNEvm6PZEL6_Hk3XThI6DQ-gGx9EnQ&sig2=-gjFzNroJQirwGtwjaJvgQ")
public class EntropyGlobalTermWeighter
extends AbstractEntropyBasedGlobalTermWeighter {
    protected Vector entropy;

    public EntropyGlobalTermWeighter() {
        this((VectorFactory<? extends Vector>)SparseVectorFactory.getDefault());
    }

    public EntropyGlobalTermWeighter(VectorFactory<? extends Vector> vectorFactory) {
        super(vectorFactory);
        this.setEntropy(null);
    }

    @Override
    public EntropyGlobalTermWeighter clone() {
        EntropyGlobalTermWeighter clone = (EntropyGlobalTermWeighter)super.clone();
        clone.entropy = (Vector)ObjectUtil.cloneSafe((CloneableSerializable)this.entropy);
        return clone;
    }

    @Override
    public void add(Vector counts) {
        super.add(counts);
        this.setEntropy(null);
    }

    @Override
    public boolean remove(Vector counts) {
        boolean result = super.remove(counts);
        if (result) {
            this.setEntropy(null);
        }
        return result;
    }

    @Override
    public int getDimensionality() {
        return VectorUtil.safeGetDimensionality((Vector)this.getTermGlobalFrequencies());
    }

    @Override
    public Vector getGlobalWeights() {
        return this.getEntropy();
    }

    public Vector getEntropy() {
        if (this.entropy == null && this.termGlobalFrequencies != null) {
            int dimensionality = this.getDimensionality();
            Vector newEntropy = this.getVectorFactory().createVector(dimensionality);
            double logDocumentCount = Math.log(this.documentCount);
            for (VectorEntry entry : this.termGlobalFrequencies) {
                int index = entry.getIndex();
                double termEntropySum = this.termEntropiesSum.getElement(index);
                double termOccurrences = entry.getValue();
                double value = 1.0;
                if (termOccurrences != 0.0) {
                    value += (termEntropySum / termOccurrences - Math.log(termOccurrences)) / logDocumentCount;
                }
                newEntropy.setElement(index, value);
            }
            this.setEntropy(newEntropy);
        }
        return this.entropy;
    }

    protected void setEntropy(Vector entropy) {
        this.entropy = entropy;
    }
}

