/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.relation;

import gov.sandia.cognition.math.matrix.DimensionalityMismatchException;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.text.relation.RelationNetwork;
import gov.sandia.cognition.text.term.IndexedTerm;
import gov.sandia.cognition.text.term.Term;
import gov.sandia.cognition.text.term.TermIndex;
import gov.sandia.cognition.text.term.relation.IndexedTermSimilarityRelation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class MatrixBasedTermSimilarityNetwork
implements RelationNetwork<IndexedTerm, IndexedTermSimilarityRelation> {
    protected TermIndex termIndex;
    protected Matrix similarities;

    public MatrixBasedTermSimilarityNetwork(TermIndex termIndex, Matrix similarities) {
        if (similarities.getNumRows() != termIndex.getTermCount() || similarities.getNumColumns() != termIndex.getTermCount()) {
            throw new DimensionalityMismatchException("the number of terms in the term index must match the dimensions of the square similarities matrix");
        }
        this.setTermIndex(termIndex);
        this.setSimilarities(similarities);
    }

    public double getSimilarity(Term sourceTerm, Term targetTerm) {
        IndexedTerm source = this.termIndex.getIndexedTerm(sourceTerm);
        IndexedTerm target = this.termIndex.getIndexedTerm(targetTerm);
        if (source == null || target == null) {
            return 0.0;
        }
        return this.getSimilarity(source, target);
    }

    public double getSimilarity(IndexedTerm source, IndexedTerm target) {
        if (source == null || target == null) {
            return 0.0;
        }
        return this.getSimilarity(source.getIndex(), target.getIndex());
    }

    public double getSimilarity(int sourceIndex, int targetIndex) {
        return this.similarities.getElement(sourceIndex, targetIndex);
    }

    @Override
    public int getObjectCount() {
        return this.termIndex.getTermCount();
    }

    @Override
    public Set<IndexedTerm> getObjects() {
        return new LinkedHashSet<IndexedTerm>(this.termIndex.getTerms());
    }

    @Override
    public boolean isObject(Object o) {
        return o != null && o instanceof IndexedTerm && this.termIndex.hasIndexedTerm((IndexedTerm)o);
    }

    @Override
    public boolean hasRelation(IndexedTerm source, IndexedTerm target) {
        return source != null && target != null && this.getSimilarity(source, target) != 0.0;
    }

    @Override
    public IndexedTermSimilarityRelation getRelation(IndexedTerm source, IndexedTerm target) {
        int targetIndex;
        if (source == null || target == null) {
            return null;
        }
        int sourceIndex = source.getIndex();
        double similarity = this.similarities.getElement(sourceIndex, targetIndex = target.getIndex());
        if (similarity != 0.0) {
            return new IndexedTermSimilarityRelation(source, target, similarity);
        }
        return null;
    }

    @Override
    public Set<IndexedTermSimilarityRelation> getAllRelations(IndexedTerm source, IndexedTerm target) {
        IndexedTermSimilarityRelation relation = this.getRelation(source, target);
        if (relation == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(relation);
    }

    @Override
    public IndexedTerm getRelationSource(IndexedTermSimilarityRelation relation) {
        if (relation == null) {
            return null;
        }
        return (IndexedTerm)relation.getSource();
    }

    @Override
    public IndexedTerm getRelationTarget(IndexedTermSimilarityRelation relation) {
        if (relation == null) {
            return null;
        }
        return (IndexedTerm)relation.getTarget();
    }

    @Override
    public Set<IndexedTermSimilarityRelation> relationsOf(IndexedTerm term) {
        LinkedHashSet<IndexedTermSimilarityRelation> result = new LinkedHashSet<IndexedTermSimilarityRelation>();
        result.addAll(this.relationsFrom(term));
        result.addAll(this.relationsTo(term));
        return result;
    }

    @Override
    public Set<IndexedTermSimilarityRelation> relationsFrom(IndexedTerm source) {
        int sourceIndex = source.getIndex();
        LinkedHashSet<IndexedTermSimilarityRelation> result = new LinkedHashSet<IndexedTermSimilarityRelation>();
        for (VectorEntry entry : this.similarities.getRow(sourceIndex)) {
            double similarity = entry.getValue();
            if (similarity == 0.0) continue;
            IndexedTerm target = this.termIndex.getIndexedTerm(entry.getIndex());
            result.add(new IndexedTermSimilarityRelation(source, target, similarity));
        }
        return result;
    }

    @Override
    public Set<IndexedTermSimilarityRelation> relationsTo(IndexedTerm target) {
        int targetIndex = target.getIndex();
        LinkedHashSet<IndexedTermSimilarityRelation> result = new LinkedHashSet<IndexedTermSimilarityRelation>();
        for (VectorEntry entry : this.similarities.getColumn(targetIndex)) {
            double similarity = entry.getValue();
            if (similarity == 0.0) continue;
            IndexedTerm source = this.termIndex.getIndexedTerm(entry.getIndex());
            result.add(new IndexedTermSimilarityRelation(source, target, similarity));
        }
        return result;
    }

    public TermIndex getTermIndex() {
        return this.termIndex;
    }

    protected void setTermIndex(TermIndex termIndex) {
        this.termIndex = termIndex;
    }

    public Matrix getSimilarities() {
        return this.similarities;
    }

    protected void setSimilarities(Matrix similarities) {
        this.similarities = similarities;
    }
}

