/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph.inference;

import gov.sandia.cognition.graph.inference.EnergyFunction;
import gov.sandia.cognition.graph.inference.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class Node<LabelType> {
    private final int id;
    private final Collection<LabelType> labels;
    private final List<Message> messages;
    private final double[] beliefs;

    public Node(int id, Collection<LabelType> labels) {
        this.id = id;
        this.labels = labels;
        this.beliefs = new double[labels.size()];
        this.messages = new ArrayList<Message>();
    }

    public void link(int sourceNode, boolean ensureUniqueEdges) {
        if (ensureUniqueEdges) {
            for (Message msg : this.messages) {
                if (msg.getSourceNode() != sourceNode) continue;
                throw new IllegalArgumentException("Source node " + sourceNode + " to " + this.id + " appears more than once.");
            }
        }
        Message msg = new Message(sourceNode, this.labels.size());
        this.messages.add(msg);
    }

    public void normalizeMessagesForSumProductAlgorithm() {
        for (Message msg : this.messages) {
            msg.normalizeTempValuesForSumProductAlgorithm();
        }
    }

    public double update() {
        double delta = 0.0;
        for (Message msg : this.messages) {
            delta = Math.max(delta, msg.update());
        }
        return delta;
    }

    public void resetToOne() {
        for (Message msg : this.messages) {
            msg.resetToOne();
        }
    }

    public int getId() {
        return this.id;
    }

    public double getLogMessageSum(int nodeLabel, int excludeNode) {
        double v = 0.0;
        for (Message msg : this.messages) {
            if (msg.getSourceNode() == excludeNode) continue;
            v += msg.getLogValue(nodeLabel);
        }
        return v;
    }

    public double getLogMessageSum(int nodeLabel) {
        double v = 0.0;
        for (Message msg : this.messages) {
            v += msg.getLogValue(nodeLabel);
        }
        return v;
    }

    public Message getMessageFromSource(int sourceNode) {
        for (Message msg : this.messages) {
            if (msg.getSourceNode() != sourceNode) continue;
            return msg;
        }
        throw new IllegalArgumentException("Node " + this.id + " does not contain a message from source node " + sourceNode);
    }

    public void computeBeliefsForSumProductAlgorithm(EnergyFunction<LabelType> f) {
        double max = -1.7976931348623157E308;
        Iterator<LabelType> iter = this.labels.iterator();
        for (int i = 0; i < this.labels.size(); ++i) {
            double belief;
            LabelType label = iter.next();
            this.beliefs[i] = belief = -f.getUnaryCost(this.id, label) + this.getLogMessageSum(i);
            max = Math.max(belief, max);
        }
        double total = 0.0;
        for (int i = 0; i < this.labels.size(); ++i) {
            this.beliefs[i] = Math.exp(this.beliefs[i] - max);
            total += this.beliefs[i];
        }
        int label = 0;
        while (label < this.labels.size()) {
            int n = label++;
            this.beliefs[n] = this.beliefs[n] / total;
        }
    }

    public double getBelief(int label) {
        return this.beliefs[label];
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Node ");
        buffer.append(this.id);
        buffer.append(":\r\n");
        for (Message msg : this.messages) {
            buffer.append(msg.toString());
            buffer.append("\r\n");
        }
        return buffer.toString();
    }
}

