/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph.inference;

import gov.sandia.cognition.graph.inference.EnergyFunctionSolver;
import gov.sandia.cognition.graph.inference.NodeNameAwareEnergyFunction;
import gov.sandia.cognition.util.DefaultPair;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EdgeMergingEnergyFunction<LabelType, NodeNameType>
implements NodeNameAwareEnergyFunction<LabelType, NodeNameType> {
    private final NodeNameAwareEnergyFunction<LabelType, NodeNameType> wrapped;
    private final UniqueEdgeMap edgeMap;

    public EdgeMergingEnergyFunction(NodeNameAwareEnergyFunction<LabelType, NodeNameType> wrapMe) {
        this.wrapped = wrapMe;
        this.edgeMap = new UniqueEdgeMap();
        for (int i = 0; i < wrapMe.numEdges(); ++i) {
            Pair<Integer, Integer> edge = wrapMe.getEdge(i);
            this.edgeMap.addEdge((Integer)edge.getFirst(), (Integer)edge.getSecond(), i);
        }
        this.edgeMap.convert();
    }

    @Override
    public void setLabel(NodeNameType node, LabelType label) {
        this.wrapped.setLabel(node, label);
    }

    @Override
    public Map<LabelType, Double> getBeliefs(NodeNameType node, EnergyFunctionSolver<LabelType> bp) {
        return this.wrapped.getBeliefs(node, bp);
    }

    @Override
    public Collection<LabelType> getPossibleLabels(int nodeId) {
        return this.wrapped.getPossibleLabels(nodeId);
    }

    @Override
    public int numEdges() {
        return this.edgeMap.size();
    }

    @Override
    public int numNodes() {
        return this.wrapped.numNodes();
    }

    @Override
    public Pair<Integer, Integer> getEdge(int i) {
        return this.edgeMap.getEdgePair(i);
    }

    @Override
    public double getUnaryPotential(int i, LabelType label) {
        return this.wrapped.getUnaryPotential(i, label);
    }

    @Override
    public double getPairwisePotential(int edgeId, LabelType ilabel, LabelType jlabel) {
        Pair<UniqueEdge, List<EdgeIndex>> edge = this.edgeMap.getEdge(edgeId);
        double ret = 1.0;
        for (EdgeIndex ei : (List)edge.getSecond()) {
            if (ei.wasFlipped) {
                ret *= this.wrapped.getPairwisePotential(ei.internalIdx, jlabel, ilabel);
                continue;
            }
            ret *= this.wrapped.getPairwisePotential(ei.internalIdx, ilabel, jlabel);
        }
        return ret;
    }

    @Override
    public double getUnaryCost(int i, LabelType label) {
        return this.wrapped.getUnaryCost(i, label);
    }

    @Override
    public double getPairwiseCost(int edgeId, LabelType ilabel, LabelType jlabel) {
        return -Math.log(this.getPairwisePotential(edgeId, ilabel, jlabel));
    }

    private static class UniqueEdgeMap {
        private Map<UniqueEdge, List<EdgeIndex>> editableEdgeMap = new HashMap<UniqueEdge, List<EdgeIndex>>();
        private List<Pair<UniqueEdge, List<EdgeIndex>>> listEdgeMap = null;

        public void addEdge(int src, int dst, int wrappedIdx) {
            if (this.editableEdgeMap == null) {
                throw new RuntimeException("Can't addEdges once converted to list");
            }
            UniqueEdge e = new UniqueEdge(src, dst);
            if (!this.editableEdgeMap.containsKey(e)) {
                this.editableEdgeMap.put(e, new ArrayList());
            }
            this.editableEdgeMap.get(e).add(new EdgeIndex(wrappedIdx, e.wasFlipped(src, dst)));
        }

        public void convert() {
            this.listEdgeMap = new ArrayList<Pair<UniqueEdge, List<EdgeIndex>>>(this.editableEdgeMap.size());
            for (Map.Entry<UniqueEdge, List<EdgeIndex>> e : this.editableEdgeMap.entrySet()) {
                this.listEdgeMap.add((Pair<UniqueEdge, List<EdgeIndex>>)new DefaultPair((Object)e.getKey(), e.getValue()));
            }
            this.editableEdgeMap.clear();
            this.editableEdgeMap = null;
        }

        public int size() {
            if (this.editableEdgeMap != null) {
                return this.editableEdgeMap.size();
            }
            return this.listEdgeMap.size();
        }

        public Pair<UniqueEdge, List<EdgeIndex>> getEdge(int i) {
            if (this.listEdgeMap == null) {
                throw new RuntimeException("Edge map not finalized before this call");
            }
            return this.listEdgeMap.get(i);
        }

        public Pair<Integer, Integer> getEdgePair(int i) {
            UniqueEdge e = (UniqueEdge)this.getEdge(i).getFirst();
            return new DefaultPair((Object)e.idxi, (Object)e.idxj);
        }
    }

    private static class EdgeIndex {
        public int internalIdx;
        public boolean wasFlipped;

        public EdgeIndex(int internalIdx, boolean wasFlipped) {
            this.internalIdx = internalIdx;
            this.wasFlipped = wasFlipped;
        }
    }

    private static class UniqueEdge {
        private final int idxi;
        private final int idxj;

        public UniqueEdge(int src, int dst) {
            if (src < dst) {
                this.idxi = src;
                this.idxj = dst;
            } else {
                this.idxi = dst;
                this.idxj = src;
            }
        }

        public boolean wasFlipped(int src, int dst) {
            return src == this.idxj && dst == this.idxi;
        }

        public boolean equals(Object o) {
            if (!(o instanceof UniqueEdge)) {
                return false;
            }
            UniqueEdge e = (UniqueEdge)o;
            if (this.idxi != e.idxi) {
                return false;
            }
            return this.idxj == e.idxj;
        }

        public int hashCode() {
            int ret = 7;
            ret += ret * 5 + this.idxi;
            ret += ret * 5 + this.idxj;
            return ret;
        }
    }
}

