/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph.community;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.DoubleArrayList;
import gov.sandia.cognition.collection.IntArrayList;
import gov.sandia.cognition.graph.DirectedNodeEdgeGraph;
import gov.sandia.cognition.graph.community.YaleFormatWeightedNeighbors;
import gov.sandia.cognition.util.DefaultKeyValuePair;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

@PublicationReference(type=PublicationType.WebPage, title="Personalized PageRank code", author={"dgleich"}, year=2016, url="https://gist.github.com/dgleich/6201856")
public class PersonalizedPageRank<NodeNameType> {
    private final IntArrayList neighbors;
    private final IntArrayList neighborsFirstIdx;
    private final DoubleArrayList neighborsWeights;
    private final DoubleArrayList nodeWeightedDegree;
    private final DirectedNodeEdgeGraph<NodeNameType> graph;
    private final double gVol;
    private Random generator;
    private double pprTolerance;

    public PersonalizedPageRank(DirectedNodeEdgeGraph<NodeNameType> graph) {
        this(graph, 0.01);
    }

    public PersonalizedPageRank(DirectedNodeEdgeGraph<NodeNameType> graph, double tolerance) {
        this.pprTolerance = tolerance;
        YaleFormatWeightedNeighbors<NodeNameType> neigh = new YaleFormatWeightedNeighbors<NodeNameType>(graph, true);
        this.neighbors = neigh.getNeighbors();
        this.neighborsFirstIdx = neigh.getNeighborsFirstIndex();
        this.neighborsWeights = neigh.getNeighborsWeights();
        this.graph = graph;
        this.nodeWeightedDegree = new DoubleArrayList(graph.getNumNodes());
        double tmpgVol = 0.0;
        for (int i = 0; i < graph.getNumNodes(); ++i) {
            this.nodeWeightedDegree.add(0.0);
            for (int j = this.neighborsFirstIdx.get(i); j < this.neighborsFirstIdx.get(i + 1); ++j) {
                this.nodeWeightedDegree.plusEquals(i, this.neighborsWeights.get(j));
                tmpgVol += this.neighborsWeights.get(j);
            }
        }
        this.gVol = tmpgVol;
        this.generator = new Random();
    }

    public void setTolerance(double tolerance) {
        this.pprTolerance = tolerance;
    }

    public void setRandomSet(long seed) {
        this.generator = new Random(seed);
    }

    public DoubleArrayList getScoresForAllNodes(NodeNameType node) {
        return this.getScoresForAllNodesById(this.graph.getNodeId(node));
    }

    public DoubleArrayList getScoresForAllNodesById(int nodeIdx) {
        return this.getScoresForAllNodesByIds(Collections.singletonList(nodeIdx), false);
    }

    public DoubleArrayList getScoresForAllNodes(List<NodeNameType> nodes) {
        return this.getScoresForAllNodesByIds(this.convertToIds(nodes), false);
    }

    public DoubleArrayList getScoresForAllNodes(NodeNameType node, boolean randomized) {
        return this.getScoresForAllNodesById(this.graph.getNodeId(node), randomized);
    }

    public DoubleArrayList getScoresForAllNodesById(int nodeIdx, boolean randomized) {
        return this.getScoresForAllNodesByIds(Collections.singletonList(nodeIdx), randomized);
    }

    public DoubleArrayList getScoresForAllNodes(List<NodeNameType> nodes, boolean randomized) {
        return this.getScoresForAllNodesByIds(this.convertToIds(nodes), randomized);
    }

    public DoubleArrayList getScoresForAllNodesByIds(List<Integer> nodeIdxs) {
        return this.getScoresForAllNodesByIds(nodeIdxs, false);
    }

    public DoubleArrayList getScoresForAllNodesByIds(List<Integer> nodeIdxs, boolean randomized) {
        double ALPHA = 0.99;
        double TOL = this.pprTolerance;
        LinkedList<Integer> fifo = new LinkedList<Integer>();
        DoubleArrayList residual = new DoubleArrayList(this.graph.getNumNodes());
        DoubleArrayList x = new DoubleArrayList(this.graph.getNumNodes());
        for (int i = 0; i < this.graph.getNumNodes(); ++i) {
            residual.add(0.0);
            x.add(0.0);
        }
        double init = 1.0 / (double)nodeIdxs.size();
        for (int n : nodeIdxs) {
            residual.set(n, init);
            fifo.add(n);
        }
        while (!fifo.isEmpty()) {
            int v = (Integer)fifo.remove();
            x.plusEquals(v, 0.010000000000000009 * residual.get(v));
            double mass = 0.99 * residual.get(v) / (2.0 * this.nodeWeightedDegree.get(v));
            IntArrayList range = IntArrayList.range((int)this.neighborsFirstIdx.get(v), (int)this.neighborsFirstIdx.get(v + 1));
            if (randomized) {
                range.randomizeOrder(this.generator);
            }
            for (int m = 0; m < range.size(); ++m) {
                int i = range.get(m);
                int u = this.neighbors.get(i);
                if (u == v) {
                    throw new RuntimeException("This line should be unreachable.");
                }
                if (residual.get(u) < this.nodeWeightedDegree.get(u) * TOL && residual.get(u) + mass * this.neighborsWeights.get(i) >= this.nodeWeightedDegree.get(u) * TOL) {
                    fifo.add(u);
                }
                residual.plusEquals(u, mass * this.neighborsWeights.get(i));
            }
            residual.set(v, mass * this.nodeWeightedDegree.get(v));
            if (!(residual.get(v) >= this.nodeWeightedDegree.get(v) * TOL)) continue;
            fifo.add(v);
        }
        return x;
    }

    public DoubleArrayList getScoresForAllNodesMultirun(NodeNameType node, int numRuns) {
        return this.getScoresForAllNodesByIdMultirun(this.graph.getNodeId(node), numRuns);
    }

    public DoubleArrayList getScoresForAllNodesMultirun(List<NodeNameType> nodes, int numRuns) {
        return this.getScoresForAllNodesByIdMultirun(this.convertToIds(nodes), numRuns);
    }

    public DoubleArrayList getScoresForAllNodesByIdMultirun(int nodeIdx, int numRuns) {
        return this.getScoresForAllNodesByIdMultirun(Collections.singletonList(nodeIdx), numRuns);
    }

    public DoubleArrayList getScoresForAllNodesByIdMultirun(List<Integer> nodeIdxs, int numRuns) {
        int j;
        DoubleArrayList x = DoubleArrayList.zeros((int)this.graph.getNumNodes());
        for (int i = 0; i < numRuns; ++i) {
            DoubleArrayList tmp = this.getScoresForAllNodesByIds(nodeIdxs, true);
            for (j = 0; j < tmp.size(); ++j) {
                x.plusEquals(j, tmp.get(j));
            }
        }
        double scalar = 1.0 / (double)numRuns;
        for (j = 0; j < x.size(); ++j) {
            x.set(j, x.get(j) * scalar);
        }
        return x;
    }

    public Set<Integer> getCommunityForNode(NodeNameType node, int numRunsPpr, int numRunsCut) {
        return this.getCommunityForNodeById(this.graph.getNodeId(node), numRunsPpr, numRunsCut);
    }

    public Set<Integer> getCommunityForNodeById(int nodeIdx, int numRunsPpr, int numRunsCut) {
        return this.getCommunityForNodesById(Collections.singletonList(nodeIdx), numRunsPpr, numRunsCut);
    }

    public Set<Integer> getCommunityForNodes(List<NodeNameType> nodes, int numRunsPpr, int numRunsCut) {
        return this.getCommunityForNodesById(this.convertToIds(nodes), numRunsPpr, numRunsCut);
    }

    private List<Integer> convertToIds(List<NodeNameType> nodes) {
        ArrayList<Integer> nodeIds = new ArrayList<Integer>(nodes.size());
        for (NodeNameType node : nodes) {
            nodeIds.add(this.graph.getNodeId(node));
        }
        return nodeIds;
    }

    public Set<Integer> getCommunityForNodesById(List<Integer> nodeIdxs, int numRunsPpr, int numRunsCut) {
        DoubleArrayList x = this.getScoresForAllNodesByIdMultirun(nodeIdxs, numRunsPpr);
        for (int i = 0; i < this.graph.getNumNodes(); ++i) {
            x.set(i, x.get(i) / this.nodeWeightedDegree.get(i));
        }
        ArrayList<DefaultKeyValuePair> sorted = new ArrayList<DefaultKeyValuePair>(x.size());
        for (int i = 0; i < x.size(); ++i) {
            if (x.get(i) == 0.0) continue;
            sorted.add(new DefaultKeyValuePair((Object)i, (Object)x.get(i)));
        }
        Collections.sort(sorted, new Comparator<Pair<Integer, Double>>(){

            @Override
            public int compare(Pair<Integer, Double> o1, Pair<Integer, Double> o2) {
                return Double.compare((Double)o2.getSecond(), (Double)o1.getSecond());
            }
        });
        double bestCond = Double.MAX_VALUE;
        HashSet bestSet = null;
        for (int r = 0; r < numRunsCut; ++r) {
            double volS = 0.0;
            double cutS = 0.0;
            HashSet<Integer> setToAddTo = new HashSet<Integer>(x.size());
            for (int i = 0; i < sorted.size(); ++i) {
                int idx = (Integer)((Pair)sorted.get(i)).getFirst();
                volS += this.nodeWeightedDegree.get(idx);
                IntArrayList loop = IntArrayList.range((int)this.neighborsFirstIdx.get(idx), (int)this.neighborsFirstIdx.get(idx + 1));
                loop.randomizeOrder(this.generator);
                for (int s = 0; s < loop.size(); ++s) {
                    int j = loop.get(s);
                    if (setToAddTo.contains(this.neighbors.get(j))) {
                        cutS -= this.neighborsWeights.get(j);
                        continue;
                    }
                    cutS += this.neighborsWeights.get(j);
                }
                setToAddTo.add(idx);
                double denom = Math.min(volS, this.gVol - volS);
                double cond = cutS / denom;
                if (Math.abs(denom) < 1.0E-10) {
                    cond = Double.MAX_VALUE;
                }
                if (!(cond < bestCond)) continue;
                bestCond = cond;
                bestSet = new HashSet(setToAddTo);
            }
        }
        return bestSet;
    }
}

