/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph.community;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.DoubleArrayList;
import gov.sandia.cognition.collection.IntArrayList;
import gov.sandia.cognition.graph.DirectedNodeEdgeGraph;
import gov.sandia.cognition.graph.DirectedWeightedNodeEdgeGraph;
import gov.sandia.cognition.graph.community.NodePartitioning;
import gov.sandia.cognition.graph.community.YaleFormatWeightedNeighbors;
import gov.sandia.cognition.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

@PublicationReference(author={"Vincent D Blondel, Jean-Loup Guillaume, Renaud Lambiotte, Etienne Lefebvre"}, title="Fast unfolding of communities in large networks", type=PublicationType.Journal, year=2008, publication="Journal of Statistical Mechanics: Theory and Experiment")
public class Louvain<NodeNameType> {
    private DoubleArrayList weightedNodeDegree;
    private double totalWeight;
    private IntArrayList nodeToCommunity;
    private DoubleArrayList communityTotal;
    private DoubleArrayList communityInternal;
    private DoubleArrayList weightedSelfLoops;
    private int maxNumPasses;
    private double minModularityGain;
    private Map<NodeNameType, Integer> nodeMap;
    private DoubleArrayList neighborCommWeight;
    private IntArrayList neighborCommId;
    private int numNeighborCommunities;
    private IntArrayList neighborsFirstIdx;
    private IntArrayList neighbors;
    private DoubleArrayList wNeighbors;
    private int numNodes;
    private Random generator;
    private LouvainHierarchy<NodeNameType> results;

    public Louvain(DirectedNodeEdgeGraph<NodeNameType> graph) {
        this(graph, 100, 1.0E-4);
    }

    public Louvain(DirectedNodeEdgeGraph<NodeNameType> graph, int maxNumPasses, double minModularityGain) {
        int l;
        int i;
        if (minModularityGain < 0.0) {
            throw new IllegalArgumentException("Minimum modularity gain must be postive.");
        }
        if (maxNumPasses <= 0) {
            throw new IllegalArgumentException("Maximum number of passes per iteration must be postive");
        }
        this.maxNumPasses = maxNumPasses;
        this.minModularityGain = minModularityGain;
        this.numNodes = graph.getNumNodes();
        this.nodeToCommunity = new IntArrayList();
        this.weightedNodeDegree = new DoubleArrayList(this.numNodes);
        this.weightedSelfLoops = new DoubleArrayList(this.numNodes);
        this.neighborCommWeight = new DoubleArrayList(this.numNodes);
        this.neighborCommId = new IntArrayList(this.numNodes);
        this.nodeMap = new HashMap<NodeNameType, Integer>(this.numNodes);
        int neighborsSoFar = 0;
        this.numNeighborCommunities = 0;
        this.totalWeight = 0.0;
        HashMap edges = new HashMap(graph.getNumNodes());
        for (i = 0; i < graph.getNumNodes(); ++i) {
            edges.put(i, new HashMap());
        }
        for (i = 0; i < graph.getNumEdges(); ++i) {
            Pair<Integer, Integer> edge = graph.getEdgeEndpointIds(i);
            l = (Integer)edge.getFirst();
            int r = (Integer)edge.getSecond();
            double w = 1.0;
            if (graph instanceof DirectedWeightedNodeEdgeGraph) {
                w = ((DirectedWeightedNodeEdgeGraph)graph).getEdgeWeight(i);
            }
            if (!((HashMap)edges.get(l)).containsKey(r)) {
                ((HashMap)edges.get(l)).put(r, 0.0);
            }
            ((HashMap)edges.get(l)).put(r, w + (Double)((HashMap)edges.get(l)).get(r));
            if (!((HashMap)edges.get(r)).containsKey(l)) {
                ((HashMap)edges.get(r)).put(l, 0.0);
            }
            ((HashMap)edges.get(r)).put(l, w + (Double)((HashMap)edges.get(r)).get(l));
        }
        for (i = 0; i < graph.getNumNodes(); ++i) {
            this.nodeMap.put(graph.getNode(i), i);
            this.nodeToCommunity.add(i);
            this.neighborCommWeight.add(-1.0);
            this.neighborCommId.add(0);
            this.weightedNodeDegree.add(0.0);
            this.weightedSelfLoops.add(0.0);
            neighborsSoFar += ((HashMap)edges.get(i)).size();
        }
        for (Map.Entry edgeMap : edges.entrySet()) {
            l = (Integer)edgeMap.getKey();
            for (Map.Entry edge : ((HashMap)edgeMap.getValue()).entrySet()) {
                int r = (Integer)edge.getKey();
                double w = (Double)edge.getValue();
                if (l == r) {
                    this.weightedSelfLoops.plusEquals(l, w);
                }
                this.weightedNodeDegree.plusEquals(l, w);
            }
        }
        this.communityTotal = new DoubleArrayList(this.numNodes);
        this.communityInternal = new DoubleArrayList(this.numNodes);
        for (int i2 = 0; i2 < this.numNodes; ++i2) {
            this.communityTotal.add(this.weightedNodeDegree.get(i2));
            this.communityInternal.add(this.weightedSelfLoops.get(i2));
            this.totalWeight += this.weightedNodeDegree.get(i2);
        }
        YaleFormatWeightedNeighbors<NodeNameType> yale = new YaleFormatWeightedNeighbors<NodeNameType>(graph, false);
        this.neighbors = new IntArrayList(yale.getNeighbors());
        this.wNeighbors = new DoubleArrayList(yale.getNeighborsWeights());
        this.neighborsFirstIdx = new IntArrayList(yale.getNeighborsFirstIndex());
        this.generator = new Random();
        this.results = new LouvainHierarchy<NodeNameType>(this.nodeMap);
    }

    public void setRandomSet(long seed) {
        this.generator = new Random(seed);
    }

    public void initialPartition(Map<NodeNameType, Integer> initPart) {
        for (Map.Entry<NodeNameType, Integer> community : initPart.entrySet()) {
            int nodeId = this.nodeMap.get(community.getKey());
            if (nodeId == -1) {
                throw new IllegalArgumentException("There is no node in the graph at " + community.getKey());
            }
            int oldCommunity = this.nodeToCommunity.get(nodeId);
            this.initNeighborCommunity(nodeId);
            this.removeFromCommunity(nodeId, oldCommunity, this.neighborCommWeight.get(oldCommunity));
            boolean found = false;
            for (int i = 0; i < this.numNeighborCommunities; ++i) {
                int bestCommunity = this.neighborCommId.get(i);
                if (bestCommunity != community.getValue()) continue;
                this.insertIntoCommunity(nodeId, bestCommunity, this.neighborCommWeight.get(this.neighborCommId.get(i)));
                found = true;
                break;
            }
            if (found) continue;
            this.insertIntoCommunity(nodeId, community.getValue(), 0.0);
        }
    }

    private void initNeighborCommunity(int nodeId) {
        int i;
        for (i = 0; i < this.numNeighborCommunities; ++i) {
            this.neighborCommWeight.set(this.neighborCommId.get(i), -1.0);
        }
        this.numNeighborCommunities = 0;
        this.neighborCommId.set(0, this.nodeToCommunity.get(nodeId));
        this.neighborCommWeight.set(this.neighborCommId.get(0), 0.0);
        this.numNeighborCommunities = 1;
        for (i = this.neighborsFirstIdx.get(nodeId); i < this.neighborsFirstIdx.get(nodeId + 1); ++i) {
            int neighbor = this.neighbors.get(i);
            int neighborComm = this.nodeToCommunity.get(neighbor);
            double neighborW = this.wNeighbors.get(i);
            if (neighbor == nodeId) continue;
            if (this.neighborCommWeight.get(neighborComm) == -1.0) {
                this.neighborCommId.set(this.numNeighborCommunities, neighborComm);
                this.neighborCommWeight.set(neighborComm, 0.0);
                ++this.numNeighborCommunities;
            }
            this.neighborCommWeight.plusEquals(neighborComm, neighborW);
        }
    }

    public double modularity() {
        double q = 0.0;
        double oneOverM2 = 1.0 / this.totalWeight;
        for (int i = 0; i < this.numNodes; ++i) {
            double cTot = this.communityTotal.get(i);
            if (!(cTot > 0.0)) continue;
            q += this.communityInternal.get(i) * oneOverM2 - cTot * cTot * (oneOverM2 * oneOverM2);
        }
        if (q >= 1.0 || q < -0.5) {
            throw new InternalError("Modularity outside acceptable range [-0.5, 1): " + q);
        }
        return q;
    }

    private void insertIntoCommunity(int nodeId, int communityId, double dNodeComm) {
        this.communityTotal.plusEquals(communityId, this.weightedNodeDegree.get(nodeId));
        this.communityInternal.plusEquals(communityId, 2.0 * dNodeComm + this.weightedSelfLoops.get(nodeId));
        this.nodeToCommunity.set(nodeId, communityId);
    }

    private void removeFromCommunity(int nodeId, int communityId, double dNodeComm) {
        this.communityTotal.plusEquals(communityId, -this.weightedNodeDegree.get(nodeId));
        this.communityInternal.plusEquals(communityId, -(2.0 * dNodeComm + this.weightedSelfLoops.get(nodeId)));
        this.nodeToCommunity.set(nodeId, -1);
    }

    private double modularityGain(int communityId, double dNodeComm, double wDegree) {
        return dNodeComm - this.communityTotal.get(communityId) * wDegree / this.totalWeight;
    }

    private boolean computeOneLevel() {
        double curModularity;
        int numMoves;
        int i;
        boolean improved = false;
        int numPasses = 0;
        double newModularity = this.modularity();
        int n = this.nodeToCommunity.size();
        IntArrayList randomOrder = new IntArrayList(n);
        for (i = 0; i < n; ++i) {
            randomOrder.add(i);
        }
        for (i = 0; i < n; ++i) {
            int randomPositionInRemainingList = this.generator.nextInt(n - i) + i;
            randomOrder.swap(i, randomPositionInRemainingList);
        }
        do {
            curModularity = newModularity;
            numMoves = 0;
            ++numPasses;
            for (i = 0; i < n; ++i) {
                int node = randomOrder.get(i);
                int curCommunity = this.nodeToCommunity.get(node);
                double weightedDegree = this.weightedNodeDegree.get(node);
                this.initNeighborCommunity(node);
                this.removeFromCommunity(node, curCommunity, this.neighborCommWeight.get(curCommunity));
                if (this.communityInternal.get(curCommunity) - this.communityTotal.get(curCommunity) > 1.0E-6) {
                    throw new InternalError("Removed node " + node + " from community " + curCommunity + " and somehow community weights got thrown off");
                }
                int bestCommunity = curCommunity;
                double bestNumLinks = this.neighborCommWeight.get(curCommunity);
                double bestIncrease = 0.0;
                for (int j = 0; j < this.numNeighborCommunities; ++j) {
                    double neighComW;
                    int neighId = this.neighborCommId.get(j);
                    double increase = this.modularityGain(neighId, neighComW = this.neighborCommWeight.get(neighId), weightedDegree);
                    if (!(increase > bestIncrease)) continue;
                    bestCommunity = neighId;
                    bestNumLinks = neighComW;
                    bestIncrease = increase;
                }
                this.insertIntoCommunity(node, bestCommunity, bestNumLinks);
                if (this.communityInternal.get(bestCommunity) - this.communityTotal.get(bestCommunity) > 1.0E-6) {
                    throw new InternalError("Removed node " + node + " from community " + curCommunity + " and somehow community weights got thrown off");
                }
                numMoves += bestCommunity == curCommunity ? 0 : 1;
            }
            newModularity = this.modularity();
            if (numMoves <= 0) continue;
            improved = true;
        } while (numMoves > 0 && newModularity - curModularity > this.minModularityGain && numPasses < this.maxNumPasses);
        return improved;
    }

    private void renumberCommunitesInLevel() {
        HashMap<Integer, Integer> commIds = new HashMap<Integer, Integer>();
        int renumber = 0;
        for (int i = 0; i < this.nodeToCommunity.size(); ++i) {
            int j = this.nodeToCommunity.get(i);
            if (j == -1) {
                throw new InternalError("Node to community map corrupted: -1 at position " + i + " out of " + this.nodeToCommunity.size());
            }
            if (!commIds.keySet().contains(j)) {
                commIds.put(j, renumber);
                ++renumber;
            }
            this.nodeToCommunity.set(i, ((Integer)commIds.get(j)).intValue());
        }
    }

    private void updateForNextLevel() {
        int i;
        int i2;
        double curMod = this.modularity();
        int numCommunities = 0;
        for (int i3 = 0; i3 < this.nodeToCommunity.size(); ++i3) {
            numCommunities = Math.max(numCommunities, this.nodeToCommunity.get(i3));
        }
        HashMap edges = new HashMap(++numCommunities);
        for (i2 = 0; i2 < numCommunities; ++i2) {
            edges.put(i2, new HashSet());
        }
        for (i2 = 0; i2 < this.numNodes; ++i2) {
            int src = this.nodeToCommunity.get(i2);
            for (int j = this.neighborsFirstIdx.get(i2); j < this.neighborsFirstIdx.get(i2 + 1); ++j) {
                ((Set)edges.get(src)).add(this.nodeToCommunity.get(this.neighbors.get(j)));
            }
        }
        IntArrayList commFirstIdx = new IntArrayList(numCommunities + 1);
        int totalEdges = 0;
        commFirstIdx.add(totalEdges);
        for (int i4 = 0; i4 < numCommunities; ++i4) {
            commFirstIdx.add(totalEdges += ((Set)edges.get(i4)).size());
        }
        IntArrayList commNeighbors = new IntArrayList(totalEdges);
        DoubleArrayList commNeighWeights = new DoubleArrayList(totalEdges);
        for (i = 0; i < totalEdges; ++i) {
            commNeighbors.add(-1);
            commNeighWeights.add(0.0);
        }
        for (i = 0; i < this.numNodes; ++i) {
            int src = this.nodeToCommunity.get(i);
            for (int j = this.neighborsFirstIdx.get(i); j < this.neighborsFirstIdx.get(i + 1); ++j) {
                int dst = this.nodeToCommunity.get(this.neighbors.get(j));
                int idx = -1;
                for (int k = commFirstIdx.get(src); k < commFirstIdx.get(src + 1); ++k) {
                    if (commNeighbors.get(k) == dst) {
                        idx = k;
                        break;
                    }
                    if (commNeighbors.get(k) != -1) continue;
                    commNeighbors.set(k, dst);
                    idx = k;
                    break;
                }
                if (idx == -1) {
                    throw new InternalError("Unable to find the new edge's location or an empty place for an edge");
                }
                commNeighWeights.plusEquals(idx, this.wNeighbors.get(j));
            }
        }
        for (i = 0; i < totalEdges; ++i) {
            if (commNeighbors.get(i) != -1) continue;
            throw new InternalError("An edge wasn't set.");
        }
        this.numNodes = numCommunities;
        this.nodeToCommunity.clear();
        this.nodeToCommunity.reserve(this.numNodes);
        this.weightedNodeDegree.clear();
        this.weightedNodeDegree.reserve(this.numNodes);
        this.weightedSelfLoops.clear();
        this.weightedSelfLoops.reserve(this.numNodes);
        this.neighborCommWeight.clear();
        this.neighborCommWeight.reserve(this.numNodes);
        this.neighborCommId.clear();
        this.neighborCommId.reserve(this.numNodes);
        this.numNeighborCommunities = 0;
        this.totalWeight = 0.0;
        for (i = 0; i < this.numNodes; ++i) {
            this.nodeToCommunity.add(i);
            this.neighborCommWeight.add(-1.0);
            this.neighborCommId.add(0);
            this.weightedNodeDegree.add(0.0);
            this.weightedSelfLoops.add(0.0);
        }
        for (i = 0; i < this.numNodes; ++i) {
            for (int j = commFirstIdx.get(i); j < commFirstIdx.get(i + 1); ++j) {
                int l = i;
                int r = commNeighbors.get(j);
                double w = commNeighWeights.get(j);
                if (l == r) {
                    this.weightedSelfLoops.plusEquals(l, w);
                    this.weightedNodeDegree.plusEquals(l, w);
                    continue;
                }
                this.weightedNodeDegree.plusEquals(l, w);
            }
        }
        this.communityTotal.clear();
        this.communityTotal.reserve(this.numNodes);
        this.communityInternal.clear();
        this.communityInternal.reserve(this.numNodes);
        for (i = 0; i < this.numNodes; ++i) {
            this.communityTotal.add(this.weightedNodeDegree.get(i));
            this.communityInternal.add(this.weightedSelfLoops.get(i));
            this.totalWeight += this.weightedNodeDegree.get(i);
        }
        this.neighborsFirstIdx = commFirstIdx;
        this.neighbors = commNeighbors;
        this.wNeighbors = commNeighWeights;
        if (Math.abs(curMod - this.modularity()) > 1.0E-6) {
            throw new InternalError("Modularity should remain the same after this update: " + curMod + " != " + this.modularity());
        }
    }

    public LouvainHierarchy<NodeNameType> solveCommunities() {
        if (this.results.numLevels() != 0) {
            return this.results;
        }
        while (true) {
            boolean improved = this.computeOneLevel();
            this.renumberCommunitesInLevel();
            if (!improved) {
                if (this.results.numLevels() == 0) {
                    this.results.addLevel(this.nodeToCommunity, this.modularity());
                }
                return this.results;
            }
            this.results.addLevel(this.nodeToCommunity, this.modularity());
            this.updateForNextLevel();
        }
    }

    public static class LouvainHierarchy<NodeNameType>
    implements NodePartitioning<NodeNameType> {
        private final IntArrayList communities = new IntArrayList();
        private final IntArrayList levelIndex = new IntArrayList(10);
        private final Map<NodeNameType, Integer> nodeMap;
        private final DoubleArrayList modularities = new DoubleArrayList(10);
        private List<Set<NodeNameType>> topCommunities;

        LouvainHierarchy(Map<NodeNameType, Integer> nodeMap) {
            this.levelIndex.add(this.communities.size());
            this.nodeMap = Collections.unmodifiableMap(nodeMap);
            this.topCommunities = null;
        }

        void addLevel(IntArrayList level, double modularity) {
            for (int i = 0; i < level.size(); ++i) {
                this.communities.add(level.get(i));
            }
            this.levelIndex.add(this.communities.size());
            this.modularities.add(modularity);
        }

        public int numLevels() {
            return this.levelIndex.size() - 1;
        }

        public double getModularity(int level) {
            if (level > this.numLevels() || level < 0) {
                throw new IllegalArgumentException("Unable to return modularity at level " + level + " as levels are only defined in [0 ... " + this.numLevels() + ")");
            }
            return this.modularities.get(level);
        }

        public int getNumCommunitiesAtLevel(int level) {
            if (level > this.numLevels() || level < 0) {
                throw new IllegalArgumentException("Unable to find number of communities at level " + level + " as levels are only defined in [0 ... " + this.numLevels() + ")");
            }
            if (level < this.numLevels() - 1) {
                return this.levelIndex.get(level + 2) - this.levelIndex.get(level + 1);
            }
            int max = 0;
            for (int i = this.levelIndex.get(level); i < this.levelIndex.get(level + 1); ++i) {
                max = Math.max(this.communities.get(i), max);
            }
            return max + 1;
        }

        public int getCommunityForNodeAtLevel(NodeNameType n, int level) {
            Integer nodeId = this.nodeMap.get(n);
            if (nodeId == null) {
                throw new IllegalArgumentException("Input node (" + n.toString() + ") is not in this community graph.");
            }
            return this.getCommunityForNodeAtLevelById(nodeId, level);
        }

        public int getCommunityForNodeAtLevelById(int nodeId, int level) {
            if (level > this.numLevels() || level < 0) {
                throw new IllegalArgumentException("Unable to find communities at level " + level + " as levels are only defined in [0 ... " + this.numLevels() + ")");
            }
            int commId = this.communities.get(nodeId);
            for (int i = 1; i <= level; ++i) {
                commId = this.communities.get(this.levelIndex.get(i) + commId);
            }
            return commId;
        }

        @Override
        public int getPartition(NodeNameType n) {
            return this.getCommunityForNodeAtLevel(n, this.numLevels() - 1);
        }

        @Override
        public int getPartitionById(int nodeId) {
            return this.getCommunityForNodeAtLevelById(nodeId, this.numLevels() - 1);
        }

        @Override
        public int getNumPartitions() {
            return this.getNumCommunitiesAtLevel(this.numLevels() - 1);
        }

        @Override
        public Set<NodeNameType> getPartitionMembers(int i) {
            if (this.topCommunities == null) {
                this.topCommunities = new ArrayList<Set<NodeNameType>>(this.getNumPartitions());
                for (int j = 0; j < this.getNumPartitions(); ++j) {
                    this.topCommunities.add(new HashSet());
                }
                for (NodeNameType member : this.getAllMembers()) {
                    this.topCommunities.get(this.getPartition(member)).add(member);
                }
            }
            return Collections.unmodifiableSet(this.topCommunities.get(i));
        }

        @Override
        public Set<NodeNameType> getAllMembers() {
            return Collections.unmodifiableSet(this.nodeMap.keySet());
        }

        @Override
        public Double getModularity() {
            return this.getModularity(this.numLevels() - 1);
        }
    }
}

