/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph.community;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.graph.DirectedNodeEdgeGraph;
import gov.sandia.cognition.graph.DirectedWeightedNodeEdgeGraph;
import gov.sandia.cognition.graph.GraphMetrics;
import gov.sandia.cognition.graph.community.MutableNodePartitioning;
import gov.sandia.cognition.graph.community.NodePartitioning;
import gov.sandia.cognition.util.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CommunityMetrics {
    private static int[] connections = null;

    public static <NodeNameType> double computeModularity(DirectedNodeEdgeGraph<NodeNameType> graph, Set<Set<NodeNameType>> communities) {
        return CommunityMetrics.computeModularity(communities, new GraphMetrics<NodeNameType>(graph));
    }

    public static <NodeNameType> double computeModularity(Set<Set<NodeNameType>> communities, GraphMetrics<NodeNameType> graphMetrics) {
        double modularity = 0.0;
        for (Set<NodeNameType> community : communities) {
            modularity += CommunityMetrics.modularityPartForCommunity(community, graphMetrics);
        }
        return modularity / (2.0 * (double)graphMetrics.numEdges());
    }

    public static <NodeNameType> double computeModularity(DirectedNodeEdgeGraph<NodeNameType> graph, NodePartitioning<NodeNameType> communities) {
        return CommunityMetrics.computeModularity(communities, new GraphMetrics<NodeNameType>(graph));
    }

    @PublicationReference(author={"Wikipedia"}, title="Modularity (networks)", type=PublicationType.WebPage, year=2016, url="https://en.wikipedia.org/wiki/Modularity_(networks)")
    public static <NodeNameType> double computeModularity(NodePartitioning<NodeNameType> communities, GraphMetrics<NodeNameType> graphMetrics) {
        Double internalMod = communities.getModularity();
        if (internalMod != null) {
            return internalMod;
        }
        double modularity = 0.0;
        for (int i = 0; i < communities.getNumPartitions(); ++i) {
            modularity += CommunityMetrics.modularityPartForCommunity(communities.getPartitionMembers(i), graphMetrics);
        }
        return modularity / (2.0 * (double)graphMetrics.numEdges());
    }

    private static <NodeNameType> double modularityPartForCommunity(Set<NodeNameType> community, GraphMetrics<NodeNameType> graphMetrics) {
        double oneOverTwoM = 1.0 / (2.0 * (double)graphMetrics.numEdges());
        double modularityPart = 0.0;
        for (NodeNameType nodei : community) {
            Set<NodeNameType> neighbors = graphMetrics.neighbors(nodei);
            int degi = graphMetrics.degree(nodei);
            for (NodeNameType nodej : community) {
                if (neighbors.contains(nodej)) {
                    modularityPart += 1.0;
                }
                modularityPart -= (double)(graphMetrics.degree(nodej) * degi) * oneOverTwoM;
            }
        }
        return modularityPart;
    }

    @PublicationReference(author={"Wikipedia"}, title="Conductance (graph)", type=PublicationType.WebPage, year=2016, url="https://en.wikipedia.org/wiki/Conductance_(graph)")
    public static <NodeNameType> double computeConductance(DirectedNodeEdgeGraph<NodeNameType> graph, Set<NodeNameType> community) {
        double edgesCut = 0.0;
        double edgesInside = 0.0;
        double edgesOutside = 0.0;
        boolean isWeighted = graph instanceof DirectedWeightedNodeEdgeGraph;
        for (int i = 0; i < graph.getNumEdges(); ++i) {
            boolean inside_j;
            boolean inside_i;
            Pair<Integer, Integer> edge = graph.getEdgeEndpointIds(i);
            double w = 1.0;
            if (isWeighted) {
                w = ((DirectedWeightedNodeEdgeGraph)graph).getEdgeWeight(i);
            }
            if ((inside_i = community.contains(graph.getNode((Integer)edge.getFirst()))) != (inside_j = community.contains(graph.getNode((Integer)edge.getSecond())))) {
                edgesCut += w;
            }
            if (inside_i) {
                edgesInside += w;
            } else {
                edgesOutside += w;
            }
            if (inside_j) {
                edgesInside += w;
                continue;
            }
            edgesOutside += w;
        }
        return edgesCut / Math.min(edgesInside, edgesOutside);
    }

    private static <NodeNameType> double getSubgraphClusteringCoefficient(GraphMetrics<NodeNameType> metrics, Set<NodeNameType> nodesInSubgraph) {
        int totalNumInternalWedges = 0;
        int totalNumInternalTriangles = 0;
        for (NodeNameType node : nodesInSubgraph) {
            int numInternalNeighbors = 0;
            for (NodeNameType neighbor : metrics.neighbors(node)) {
                numInternalNeighbors += nodesInSubgraph.contains(neighbor) ? 1 : 0;
            }
            totalNumInternalWedges += numInternalNeighbors * (numInternalNeighbors - 1);
            int numInternalTris = 0;
            for (Pair<NodeNameType, NodeNameType> others : metrics.getNodeTriangleEndpoints(node)) {
                numInternalTris += nodesInSubgraph.contains(others.getFirst()) && nodesInSubgraph.contains(others.getSecond()) ? 1 : 0;
            }
            totalNumInternalTriangles += numInternalTris;
        }
        if (totalNumInternalWedges <= 0) {
            return 0.0;
        }
        return (double)totalNumInternalTriangles / (double)totalNumInternalWedges;
    }

    private static <NodeNameType> double getInternalEdgeDensity(GraphMetrics<NodeNameType> metrics, Set<Integer> nodesInSubgraph, Integer nodeId) {
        Object tmp;
        int numInternalNeighbors = 0;
        Set<Integer> smaller = metrics.neighborIds(nodeId.intValue());
        Object larger = nodesInSubgraph;
        if (smaller.size() > larger.size()) {
            tmp = smaller;
            smaller = larger;
            larger = tmp;
        }
        tmp = smaller.iterator();
        while (tmp.hasNext()) {
            int s = (Integer)tmp.next();
            numInternalNeighbors += larger.contains(s) ? 1 : 0;
        }
        int numInternalTriangles = 0;
        for (Pair<Integer, Integer> others : metrics.getNodeTriangleEndpointIds(nodeId.intValue())) {
            numInternalTriangles += nodesInSubgraph.contains(others.getFirst()) && nodesInSubgraph.contains(others.getSecond()) ? 1 : 0;
        }
        if (numInternalNeighbors < 2) {
            return 0.0;
        }
        return (double)numInternalTriangles / ((double)((numInternalNeighbors - 1) * numInternalNeighbors) / 2.0);
    }

    private static <NodeNameType> double getInternalToMaxExternalRatio(GraphMetrics<NodeNameType> metrics, NodePartitioning<NodeNameType> partitions, int nodeId) {
        int nodesPartition = partitions.getPartitionById(nodeId);
        int numPartitions = partitions.getNumPartitions();
        if (connections == null || connections.length < numPartitions) {
            connections = new int[numPartitions];
        }
        Arrays.fill(connections, 0);
        int maxExternal = 1;
        for (int neighbor : metrics.neighborIds(nodeId)) {
            int partId;
            int n = partId = partitions.getPartitionById(neighbor);
            connections[n] = connections[n] + 1;
            if (partId == nodesPartition) continue;
            maxExternal = Math.max(maxExternal, connections[partId]);
        }
        return (double)connections[nodesPartition] / (double)maxExternal;
    }

    @PublicationReference(author={"Tanmoy Chakraborty, Sriram Srinivasan, Niloy Ganguly, Animesh Mukherjee, and Sanjukta Bhowmick"}, title="On the permanence of vertices in network communities", year=2014, type=PublicationType.Conference)
    public static <NodeNameType> double computeOneNodePermanence(GraphMetrics<NodeNameType> metrics, NodePartitioning<NodeNameType> partitions, NodeNameType node, DirectedNodeEdgeGraph<NodeNameType> graph) {
        return CommunityMetrics.computeOneNodePermanenceById(metrics, partitions, graph.getNodeId(node), graph);
    }

    public static <NodeNameType> double computeOneNodePermanenceById(GraphMetrics<NodeNameType> metrics, NodePartitioning<NodeNameType> partitions, int nodeId, DirectedNodeEdgeGraph<NodeNameType> graph) {
        int degree = Math.max(1, metrics.degree(nodeId));
        return CommunityMetrics.getInternalToMaxExternalRatio(metrics, partitions, nodeId) / (double)degree - (1.0 - CommunityMetrics.getInternalEdgeDensity(metrics, CommunityMetrics.getPartitionIds(partitions, nodeId, graph), nodeId));
    }

    private static <NodeNameType> Set<Integer> getPartitionIds(NodePartitioning<NodeNameType> partitioning, int nodeId, DirectedNodeEdgeGraph<NodeNameType> graph) {
        int partition = partitioning.getPartitionById(nodeId);
        if (partitioning instanceof MutableNodePartitioning) {
            Set<Integer> tmp = ((MutableNodePartitioning)partitioning).getPartitionMemberIds(partition);
            return tmp;
        }
        Set<NodeNameType> nodes = partitioning.getPartitionMembers(partition);
        HashSet<Integer> ret = new HashSet<Integer>();
        for (NodeNameType n : nodes) {
            ret.add(graph.getNodeId(n));
        }
        return ret;
    }

    public static <NodeNameType> double computeGraphPermanance(DirectedNodeEdgeGraph<NodeNameType> graph, GraphMetrics<NodeNameType> metrics, NodePartitioning<NodeNameType> partitions) {
        double sum = 0.0;
        for (int i = 0; i < graph.getNumNodes(); ++i) {
            sum += CommunityMetrics.computeOneNodePermanenceById(metrics, partitions, i, graph);
        }
        return sum / (double)metrics.numNodes();
    }
}

