/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.graph.community;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.graph.community.NodePartitioning;
import java.util.HashSet;
import java.util.Set;

@PublicationReference(author={"Nguyen Xuan Vinh, Julien Epps, and James Bailey"}, title="Information Theoretic Measures of Clusterings Comparison: Variants, Properties, Normalization and Correction for Chance", type=PublicationType.Journal, year=2010, publication="Journal of Machine Learning Research", pages={-17})
public class CommunityComparisons<NodeNameType> {
    private final int[][] contingencyTable;
    private final int[] uSums;
    private final int[] vSums;
    private final int n;
    private final int nu;
    private final int nv;
    private double entropyU;
    private double entropyV;
    private double jointEntropy;
    private double condEntropyUGivenV;
    private double condEntropyVGivenU;
    private double mutualInformation;
    private double expectedMutualInformation;

    public CommunityComparisons(NodePartitioning<NodeNameType> u, NodePartitioning<NodeNameType> v) {
        int i;
        Set<NodeNameType> su = u.getAllMembers();
        Set<NodeNameType> sv = v.getAllMembers();
        if (su.size() != sv.size()) {
            throw new IllegalArgumentException("Input partitionings do not contain the same number of members: " + su.size() + " != " + sv.size());
        }
        HashSet<NodeNameType> tmp = new HashSet<NodeNameType>(su);
        tmp.retainAll(sv);
        if (tmp.size() != sv.size()) {
            throw new IllegalArgumentException("Input partitionings don't contain the same set of nodes: original size = " + su.size() + " != intersection size " + tmp.size());
        }
        this.expectedMutualInformation = Double.MAX_VALUE;
        this.mutualInformation = Double.MAX_VALUE;
        this.condEntropyVGivenU = Double.MAX_VALUE;
        this.condEntropyUGivenV = Double.MAX_VALUE;
        this.jointEntropy = Double.MAX_VALUE;
        this.entropyV = Double.MAX_VALUE;
        this.entropyU = Double.MAX_VALUE;
        this.n = sv.size();
        this.nu = u.getNumPartitions();
        this.nv = v.getNumPartitions();
        this.contingencyTable = new int[this.nu][];
        this.uSums = new int[this.nu];
        this.vSums = new int[this.nv];
        for (i = 0; i < this.nu; ++i) {
            this.contingencyTable[i] = new int[this.nv];
            this.uSums[i] = 0;
        }
        for (i = 0; i < this.nv; ++i) {
            this.vSums[i] = 0;
        }
        for (NodeNameType node : su) {
            int i2 = u.getPartition(node);
            int j = v.getPartition(node);
            int[] nArray = this.contingencyTable[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            int n2 = i2;
            this.uSums[n2] = this.uSums[n2] + 1;
            int n3 = j;
            this.vSums[n3] = this.vSums[n3] + 1;
        }
    }

    private static double safeLog(double d) {
        return d == 0.0 ? 0.0 : Math.log(d);
    }

    private static double getEntropy(int N, int[] marginals) {
        double ret = 0.0;
        for (int marginal : marginals) {
            double f = (double)marginal / (double)N;
            ret += f * CommunityComparisons.safeLog(f);
        }
        return -ret;
    }

    public double getEntropyU() {
        if (this.entropyU == Double.MAX_VALUE) {
            this.entropyU = CommunityComparisons.getEntropy(this.n, this.uSums);
        }
        return this.entropyU;
    }

    public double getEntropyV() {
        if (this.entropyV == Double.MAX_VALUE) {
            this.entropyV = CommunityComparisons.getEntropy(this.n, this.vSums);
        }
        return this.entropyV;
    }

    public double getJointEntropy() {
        if (this.jointEntropy == Double.MAX_VALUE) {
            this.jointEntropy = 0.0;
            int[][] nArray = this.contingencyTable;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] row;
                for (int nij : row = nArray[i]) {
                    double f = (double)nij / (double)this.n;
                    this.jointEntropy += f * CommunityComparisons.safeLog(f);
                }
            }
            this.jointEntropy *= -1.0;
        }
        return this.jointEntropy;
    }

    public double getConditionalEntropyUGivenV() {
        if (this.condEntropyUGivenV == Double.MAX_VALUE) {
            this.condEntropyUGivenV = 0.0;
            for (int i = 0; i < this.nu; ++i) {
                for (int j = 0; j < this.nv; ++j) {
                    double numer = (double)this.contingencyTable[i][j] / (double)this.n;
                    double denom = (double)this.vSums[j] / (double)this.n;
                    this.condEntropyUGivenV += numer * CommunityComparisons.safeLog(numer / denom);
                }
            }
            this.condEntropyUGivenV *= -1.0;
        }
        return this.condEntropyUGivenV;
    }

    public double getConditionalEntropyVGivenU() {
        if (this.condEntropyVGivenU == Double.MAX_VALUE) {
            this.condEntropyVGivenU = 0.0;
            for (int i = 0; i < this.nu; ++i) {
                for (int j = 0; j < this.nv; ++j) {
                    double numer = (double)this.contingencyTable[i][j] / (double)this.n;
                    double denom = (double)this.uSums[i] / (double)this.n;
                    this.condEntropyVGivenU += numer * CommunityComparisons.safeLog(numer / denom);
                }
            }
            this.condEntropyVGivenU *= -1.0;
        }
        return this.condEntropyVGivenU;
    }

    public double getMutualInformation() {
        if (this.mutualInformation == Double.MAX_VALUE) {
            this.mutualInformation = 0.0;
            for (int i = 0; i < this.nu; ++i) {
                for (int j = 0; j < this.nv; ++j) {
                    double numer = (double)this.contingencyTable[i][j] / (double)this.n;
                    double denom = (double)this.uSums[i] * (double)this.vSums[j] / (double)(this.n * this.n);
                    this.mutualInformation += numer * CommunityComparisons.safeLog(numer / denom);
                }
            }
        }
        return this.mutualInformation;
    }

    public double getNmiJoint() {
        return this.getMutualInformation() / this.getJointEntropy();
    }

    public double getNmiMax() {
        return this.getMutualInformation() / Math.max(this.getEntropyU(), this.getEntropyV());
    }

    public double getNmiSum() {
        return 2.0 * this.getMutualInformation() / (this.getEntropyU() + this.getEntropyV());
    }

    public double getNmiSqrt() {
        return this.getMutualInformation() / Math.sqrt(this.getEntropyU() * this.getEntropyV());
    }

    public double getNmiMin() {
        return this.getMutualInformation() / Math.min(this.getEntropyU(), this.getEntropyV());
    }

    public double getExpectedMutualInformation() {
        if (this.expectedMutualInformation == Double.MAX_VALUE) {
            this.expectedMutualInformation = 0.0;
            double N = this.n;
            for (int i = 0; i < this.nu; ++i) {
                double ai = this.uSums[i];
                for (int j = 0; j < this.nv; ++j) {
                    double bj = this.vSums[j];
                    this.expectedMutualInformation += ai * bj / (N * N) * Math.log(N * (ai - 1.0) * (bj - 1.0) / ((N - 1.0) * ai * bj) + N / (ai * bj));
                }
            }
        }
        return this.expectedMutualInformation;
    }

    public double getAmiMax() {
        return (this.getMutualInformation() - this.getExpectedMutualInformation()) / (Math.max(this.getEntropyU(), this.getEntropyV()) - this.getExpectedMutualInformation());
    }

    public double getAmiSum() {
        return (this.getMutualInformation() - this.getExpectedMutualInformation()) / (0.5 * (this.getEntropyU() + this.getEntropyV()) - this.getExpectedMutualInformation());
    }

    public double getAmiSqrt() {
        return (this.getMutualInformation() - this.getExpectedMutualInformation()) / (Math.sqrt(this.getEntropyU() * this.getEntropyV()) - this.getExpectedMutualInformation());
    }

    public double getAmiMin() {
        return (this.getMutualInformation() - this.getExpectedMutualInformation()) / (Math.min(this.getEntropyU(), this.getEntropyV()) - this.getExpectedMutualInformation());
    }
}

